/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzComponentFactory;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.custom.PzDialogMaloprodajaPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;

public class PovracajAvansaOdDobavljaca
extends PzDialogAkcija {
    private static final long serialVersionUID = -610221729743683725L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private JLabel lblifraDobavljaa;
    private JLabel lblDatumKnjienja;
    private JLabel lblDatumUplate;
    private PzPanel pnlPromet;
    private PzPanel pnlPovracaj;
    private JLabel lblRaspoloivAvans;
    private PzDoubleField dblRaspolozivAvans;
    private JScrollPane scpPromet;
    private PzTablePorez tblPorezPromet;
    private JLabel lblIznosPovraaja;
    private PzDoubleField dblIznosPovracaja;
    private JScrollPane scpPovracaj;
    private PzNumericOnlyTextField numSifraDobavljaca;
    private PzDateField datDatumKnjizenja;
    private PzDateField datDatumUplate;
    private PzTextField txtNazivDobavljaca;
    private PzTablePorez tblPorezPovracaj;
    private Komitent komitent;
    private Uplata uplata;

    public static void main(String[] args) {
        try {
            PovracajAvansaOdDobavljaca dialog = new PovracajAvansaOdDobavljaca();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PovracajAvansaOdDobavljaca() {
        this.initGUI();
        this.paintPanel();
    }

    public PovracajAvansaOdDobavljaca(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.contentPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.contentPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.contentPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(PovracajAvansaOdDobavljaca.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setOpaque(false);
        this.pnlHeader.setTitle("Knji\u017eenje povra\u0107aja avansa od dobavlja\u010da");
        this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
        this.pnlForm = new PzPanel();
        this.pnlForm.setOpaque(false);
        this.contentPanel.add((Component)this.pnlForm, (Object)"Center");
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 109;
        nArray[1] = 97;
        nArray[2] = 172;
        nArray[3] = 172;
        nArray[4] = 171;
        gbl_pnlForm.columnWidths = nArray;
        gbl_pnlForm.rowHeights = new int[5];
        gbl_pnlForm.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatumKnjienja = new JLabel("Datum knji\u017eenja:");
        GridBagConstraints gbc_lblDatumKnjienja = new GridBagConstraints();
        gbc_lblDatumKnjienja.anchor = 13;
        gbc_lblDatumKnjienja.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumKnjienja.gridx = 0;
        gbc_lblDatumKnjienja.gridy = 0;
        this.pnlForm.add((Component)this.lblDatumKnjienja, (Object)gbc_lblDatumKnjienja);
        this.datDatumKnjizenja = new PzDateField();
        GridBagConstraints gbc_datDatumKnjizenja = new GridBagConstraints();
        gbc_datDatumKnjizenja.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumKnjizenja.fill = 2;
        gbc_datDatumKnjizenja.gridx = 1;
        gbc_datDatumKnjizenja.gridy = 0;
        this.pnlForm.add((Component)this.datDatumKnjizenja, (Object)gbc_datDatumKnjizenja);
        this.lblDatumUplate = new JLabel("Datum uplate:");
        GridBagConstraints gbc_lblDatumUplate = new GridBagConstraints();
        gbc_lblDatumUplate.anchor = 13;
        gbc_lblDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatumUplate.gridx = 0;
        gbc_lblDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.lblDatumUplate, (Object)gbc_lblDatumUplate);
        this.datDatumUplate = new PzDateField();
        GridBagConstraints gbc_datDatumUplate = new GridBagConstraints();
        gbc_datDatumUplate.insets = new Insets(0, 0, 5, 5);
        gbc_datDatumUplate.fill = 2;
        gbc_datDatumUplate.gridx = 1;
        gbc_datDatumUplate.gridy = 1;
        this.pnlForm.add((Component)this.datDatumUplate, (Object)gbc_datDatumUplate);
        this.lblifraDobavljaa = new JLabel("\u0160ifra dobavlja\u010da:");
        GridBagConstraints gbc_lblifraDobavljaa = new GridBagConstraints();
        gbc_lblifraDobavljaa.anchor = 13;
        gbc_lblifraDobavljaa.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraDobavljaa.gridx = 0;
        gbc_lblifraDobavljaa.gridy = 2;
        this.pnlForm.add((Component)this.lblifraDobavljaa, (Object)gbc_lblifraDobavljaa);
        this.numSifraDobavljaca = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraDobavljaca = new GridBagConstraints();
        gbc_numSifraDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraDobavljaca.fill = 2;
        gbc_numSifraDobavljaca.gridx = 1;
        gbc_numSifraDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.numSifraDobavljaca, (Object)gbc_numSifraDobavljaca);
        this.txtNazivDobavljaca = new PzTextField();
        this.txtNazivDobavljaca.setOpaque(false);
        this.txtNazivDobavljaca.setFocusable(false);
        this.txtNazivDobavljaca.setEditable(false);
        GridBagConstraints gbc_txtNazivDobavljaca = new GridBagConstraints();
        gbc_txtNazivDobavljaca.fill = 2;
        gbc_txtNazivDobavljaca.gridwidth = 2;
        gbc_txtNazivDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_txtNazivDobavljaca.gridx = 2;
        gbc_txtNazivDobavljaca.gridy = 2;
        this.pnlForm.add((Component)this.txtNazivDobavljaca, (Object)gbc_txtNazivDobavljaca);
        this.pnlPromet = new PzPanel();
        this.pnlPromet.setOpaque(false);
        this.pnlPromet.setBorder((Border)new TitledBorder(null, "Izvod iz prometa", 4, 2, null, null));
        GridBagConstraints gbc_pnlPromet = new GridBagConstraints();
        gbc_pnlPromet.gridwidth = 3;
        gbc_pnlPromet.insets = new Insets(0, 0, 0, 5);
        gbc_pnlPromet.fill = 1;
        gbc_pnlPromet.gridx = 0;
        gbc_pnlPromet.gridy = 3;
        this.pnlForm.add((Component)this.pnlPromet, (Object)gbc_pnlPromet);
        GridBagLayout gbl_pnlPromet = new GridBagLayout();
        int[] nArray2 = new int[4];
        nArray2[0] = 122;
        nArray2[1] = 125;
        nArray2[2] = 128;
        gbl_pnlPromet.columnWidths = nArray2;
        gbl_pnlPromet.rowHeights = new int[3];
        gbl_pnlPromet.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlPromet.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlPromet.setLayout((LayoutManager)gbl_pnlPromet);
        this.lblRaspoloivAvans = new JLabel("Raspolo\u017eiv avans:");
        GridBagConstraints gbc_lblRaspoloivAvans = new GridBagConstraints();
        gbc_lblRaspoloivAvans.anchor = 17;
        gbc_lblRaspoloivAvans.insets = new Insets(0, 0, 5, 5);
        gbc_lblRaspoloivAvans.gridx = 0;
        gbc_lblRaspoloivAvans.gridy = 0;
        this.pnlPromet.add((Component)this.lblRaspoloivAvans, (Object)gbc_lblRaspoloivAvans);
        this.dblRaspolozivAvans = new PzDoubleField();
        this.dblRaspolozivAvans.setBackground(new Color(173, 216, 230));
        this.dblRaspolozivAvans.setFocusable(false);
        this.dblRaspolozivAvans.setEditable(false);
        GridBagConstraints gbc_dblRaspolozivAvans = new GridBagConstraints();
        gbc_dblRaspolozivAvans.insets = new Insets(0, 0, 5, 5);
        gbc_dblRaspolozivAvans.fill = 2;
        gbc_dblRaspolozivAvans.gridx = 1;
        gbc_dblRaspolozivAvans.gridy = 0;
        this.pnlPromet.add((Component)this.dblRaspolozivAvans, (Object)gbc_dblRaspolozivAvans);
        this.scpPromet = new JScrollPane();
        GridBagConstraints gbc_scpPromet = new GridBagConstraints();
        gbc_scpPromet.gridwidth = 3;
        gbc_scpPromet.insets = new Insets(0, 0, 0, 5);
        gbc_scpPromet.fill = 1;
        gbc_scpPromet.gridx = 0;
        gbc_scpPromet.gridy = 1;
        this.pnlPromet.add((Component)this.scpPromet, (Object)gbc_scpPromet);
        this.tblPorezPromet = PzComponentFactory.createPzTablePorez();
        this.tblPorezPromet.setEnabled(false);
        this.tblPorezPromet.setId("TABLE_PROMET");
        this.tblPorezPromet.setAutoResizeMode(4);
        this.scpPromet.setViewportView((Component)this.tblPorezPromet);
        this.pnlPovracaj = new PzPanel();
        this.pnlPovracaj.setOpaque(false);
        this.pnlPovracaj.setBorder((Border)new TitledBorder(null, "Elementi povra\u0107aja", 4, 2, null, null));
        GridBagConstraints gbc_pnlPovracaj = new GridBagConstraints();
        gbc_pnlPovracaj.gridwidth = 2;
        gbc_pnlPovracaj.fill = 1;
        gbc_pnlPovracaj.gridx = 3;
        gbc_pnlPovracaj.gridy = 3;
        this.pnlForm.add((Component)this.pnlPovracaj, (Object)gbc_pnlPovracaj);
        GridBagLayout gbl_pnlPovracaj = new GridBagLayout();
        int[] nArray3 = new int[4];
        nArray3[0] = 125;
        nArray3[1] = 130;
        nArray3[2] = 105;
        gbl_pnlPovracaj.columnWidths = nArray3;
        gbl_pnlPovracaj.rowHeights = new int[3];
        gbl_pnlPovracaj.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlPovracaj.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlPovracaj.setLayout((LayoutManager)gbl_pnlPovracaj);
        this.lblIznosPovraaja = new JLabel("Iznos povra\u0107aja:");
        GridBagConstraints gbc_lblIznosPovraaja = new GridBagConstraints();
        gbc_lblIznosPovraaja.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosPovraaja.anchor = 17;
        gbc_lblIznosPovraaja.gridx = 0;
        gbc_lblIznosPovraaja.gridy = 0;
        this.pnlPovracaj.add((Component)this.lblIznosPovraaja, (Object)gbc_lblIznosPovraaja);
        this.scpPovracaj = new JScrollPane();
        GridBagConstraints gbc_scpPovracaj = new GridBagConstraints();
        gbc_scpPovracaj.gridwidth = 3;
        gbc_scpPovracaj.insets = new Insets(0, 0, 0, 5);
        gbc_scpPovracaj.fill = 1;
        gbc_scpPovracaj.gridx = 0;
        gbc_scpPovracaj.gridy = 1;
        this.pnlPovracaj.add((Component)this.scpPovracaj, (Object)gbc_scpPovracaj);
        this.tblPorezPovracaj = PzComponentFactory.createPzTablePorez();
        this.tblPorezPovracaj.setDialogClass(PzDialogMaloprodajaPorezIznos.class);
        this.tblPorezPovracaj.setId("TABLE_POVRACAJ");
        this.tblPorezPovracaj.setAutoResizeMode(4);
        this.scpPovracaj.setViewportView((Component)this.tblPorezPovracaj);
        this.dblIznosPovracaja = this.tblPorezPovracaj.createExpresionField("$2$+$3$");
        this.dblIznosPovracaja.setBackground(new Color(173, 216, 230));
        this.dblIznosPovracaja.setFocusable(false);
        this.dblIznosPovracaja.setEditable(false);
        GridBagConstraints gbc_dblIznosPovracaja = new GridBagConstraints();
        gbc_dblIznosPovracaja.fill = 2;
        gbc_dblIznosPovracaja.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosPovracaja.gridx = 1;
        gbc_dblIznosPovracaja.gridy = 0;
        this.pnlPovracaj.add((Component)this.dblIznosPovracaja, (Object)gbc_dblIznosPovracaja);
        this.pack();
        this.setSize(742, 486);
        this.setResizable(false);
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity instanceof Komitent) {
                this.komitent = (Komitent)entity;
                this.numSifraDobavljaca.setVal((Object)this.komitent.getSfrKomitent());
                this.txtNazivDobavljaca.setVal((Object)this.komitent.getNaziv());
                this.dblRaspolozivAvans.setVal((Object)this.getRaspolozivAvans().subtract(this.getPovracaj()).subtract(this.getZatvaranjeAvansom()));
                this.tblPorezPromet.setPorezi(this.getPorezi(), true);
                this.tblPorezPromet.packAll();
                this.tblPorezPovracaj.packAll();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private BigDecimal getRaspolozivAvans() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom - a.pokriveno) FROM Uplata a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private BigDecimal getPovracaj() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom) FROM Uplata a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private BigDecimal getZatvaranjeAvansom() throws Exception {
        BigDecimal val = (BigDecimal)this.getEm().createQuery("SELECT SUM(a.iznosSaPorezom) FROM Uplata a WHERE a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' AND a.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()).getSingleResult();
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val;
    }

    private List<? extends PzTaksaDokument> getPorezi() throws Exception {
        Vector takse1 = PzEntityManager.select((String)("SELECT t FROM Taksaopstidokument t WHERE (t.uplata.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' OR t.uplata.tip='" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' " + "OR t.uplata.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "') AND t.uplata.komitent.sfrKomitent=" + this.komitent.getSfrKomitent()));
        for (PzEntity entity : takse1) {
            Taksaopstidokument taksa = (Taksaopstidokument)entity;
            if (!taksa.getUplata().getTip().equals(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ) && !taksa.getUplata().getTip().equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC)) continue;
            taksa.setIznos(taksa.getIznos().negate());
            taksa.setOsnovica(taksa.getOsnovica().negate());
        }
        return takse1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        this.commit();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatumKnjizenja.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        this.uplata = new Uplata();
        this.uplata.setDatum(this.datDatumUplate.getVal());
        this.uplata.setIznos(this.dblIznosPovracaja.getBigDecimal());
        this.uplata.setKomitent(this.komitent);
        this.uplata.setTaksaopstidokuments(this.tblPorezPovracaj.getPorezi());
        this.uplata.setTip(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ);
        this.uplata.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
        return this.uplata;
    }
}

