/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class FakturaKomitent
extends PzDialog {
    private static final long serialVersionUID = -4959628915374594247L;
    private Class<?> entityClass;
    private PzEntityFilter filter;
    private List<?> list;
    private static Object selectedEntity;
    private PzPanel pnlContent;
    private PzButton btnOK;
    private PzPanelHeader header;
    private JScrollPane scp;
    private JPanel panel;
    private PzTable table;
    private PzButton btnFilter;
    private int filterColumn;
    private String[] columnNames;

    public FakturaKomitent() {
        this.initGUI();
    }

    public FakturaKomitent(PzDialog parent, List<?> list, Class<?> type, int filterColumn, PzEntityFilter filter) {
        this.setId(String.valueOf(parent.getClass().getName()) + ((Object)((Object)this)).getClass().getName());
    }

    public FakturaKomitent(PzDialog parent, List<?> list, String[] columnNames, int filterColumn) {
        super(parent);
        this.filterColumn = filterColumn;
        this.list = list;
        this.columnNames = columnNames;
        this.initGUI();
        this.instantiateTable();
        this.paintPanel();
    }

    private void instantiateTable() {
        if (this.entityClass != null) {
            this.table = new PzTable();
            this.table.setFilter(this.filter);
            this.table.setId(this.entityClass.getName());
            this.table.setData(this.list, this.entityClass);
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 833766127922040169L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    selectedEntity = FakturaKomitent.this.table.getSelectedEntity();
                    FakturaKomitent.this.dispose();
                }
            });
            this.scp.setViewportView((Component)this.table);
        } else {
            this.table = new PzTable();
            Object[][] niz = new Object[this.list.size()][];
            int i = 0;
            while (i < this.list.size()) {
                niz[i] = (Object[])this.list.get(i);
                ++i;
            }
            this.table.setModel((TableModel)new DefaultTableModel(niz, this.columnNames));
            if (this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 833766127922040169L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        selectedEntity = FakturaKomitent.this.getSelectedEntity();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)FakturaKomitent.this), (Throwable)e);
                    }
                    FakturaKomitent.this.dispose();
                }
            });
            this.table.hideColumnByName("ID");
            this.table.hideColumnByName("TIP");
            this.scp.setViewportView((Component)this.table);
        }
    }

    private Object getSelectedEntity() throws Exception {
        Integer iddok = (Integer)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 5);
        String tip = (String)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 6);
        Class<Faktura> dokumentClass = null;
        if (tip.equals("FAKTURA")) {
            dokumentClass = Faktura.class;
        } else if (tip.equals("RACUN_DOBAVLJACA")) {
            dokumentClass = Kalkulacija.class;
        }
        return PzEntityManager.find(dokumentClass, (Object)iddok);
    }

    private void paintPanel() {
        this.pnlContent.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlContent.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlContent.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlContent = new PzPanel();
            GridBagLayout gbl_pnlContent = new GridBagLayout();
            this.pnlContent.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)this.pnlContent, "Center");
            int[] nArray = new int[2];
            nArray[0] = 450;
            gbl_pnlContent.columnWidths = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 20;
            gbl_pnlContent.rowHeights = nArray2;
            gbl_pnlContent.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pnlContent.rowWeights = new double[]{0.0, 0.1, 0.0, Double.MIN_VALUE};
            this.pnlContent.setLayout((LayoutManager)gbl_pnlContent);
            this.scp = new JScrollPane();
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.fill = 1;
            gbc_scp.insets = new Insets(0, 0, 5, 0);
            gbc_scp.gridx = 0;
            gbc_scp.gridy = 0;
            this.pnlContent.add((Component)this.scp, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel = new PzPanel();
            FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
            flowLayout.setAlignment(2);
            GridBagConstraints gbc_panel = new GridBagConstraints();
            gbc_panel.fill = 3;
            gbc_panel.gridx = 0;
            gbc_panel.gridy = 1;
            this.panel.setOpaque(false);
            this.pnlContent.add((Component)this.panel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.btnFilter = new PzButton();
            this.btnFilter.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 3318845716154167778L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FakturaKomitent.this.btnFilteractionPerformed(arg0);
                }
            });
            this.btnFilter.setIcon((Icon)new ImageIcon(FakturaKomitent.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/find.png")));
            this.btnFilter.setText("Filter: samo nepla\u0107eni (F2)");
            this.btnFilter.setActionCommand("samo_neplacene");
            this.btnFilter.setShortcut("F2");
            if (this.filterColumn != -1) {
                this.panel.add((Component)this.btnFilter);
            }
            this.btnOK = new PzButton();
            this.panel.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi (ENTER)");
            this.btnOK.setIcon((Icon)new ImageIcon(FakturaKomitent.class.getResource("/rs/pezar/prostoKnjigovodstvo/resource/img/check.png")));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FakturaKomitent.this.btnOKactionPerformed(arg0);
                }
            });
            this.btnOK.setName("btnOK");
            this.header = new PzPanelHeader();
            this.pnlContent.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setName("header");
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prostoKnjigovodstvo/resource/img/row.png")));
            this.header.setOpaque(false);
            this.setSize(782, 416);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void setHeaderTitle(String title, String subtitle) {
        this.header.setTitle(title);
        this.header.setText(subtitle);
    }

    protected void btnOKactionPerformed(ActionEvent arg0) {
        try {
            try {
                selectedEntity = this.getSelectedEntity();
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
    }

    public static PzEntity showDialog(PzDialog parent, Class<?> type, List<?> list, String title, String text, int filterColumn, PzEntityFilter filter) {
        FakturaKomitent dlg = new FakturaKomitent(parent, list, type, filterColumn, filter);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setId(type.getName());
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity selectedEntity = (PzEntity)FakturaKomitent.selectedEntity;
        FakturaKomitent.selectedEntity = null;
        return selectedEntity;
    }

    public static PzEntity showDialog(PzDialog parent, List<?> list, String title, String text, int filterColumn, String[] columnNames) {
        FakturaKomitent dlg = new FakturaKomitent(parent, list, columnNames, filterColumn);
        dlg.setHeaderTitle(title, text);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setId("FAKTURE_KOMITENTA");
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity selectedEntity = (PzEntity)FakturaKomitent.selectedEntity;
        FakturaKomitent.selectedEntity = null;
        return selectedEntity;
    }

    private RowFilter<Object, Object> getFilter() {
        return new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                BigDecimal val = (BigDecimal)entry.getValue(FakturaKomitent.this.filterColumn);
                return val.doubleValue() > 0.0;
            }
        };
    }

    protected void btnFilteractionPerformed(ActionEvent arg0) {
        if (this.btnFilter.getActionCommand().equals("samo_neplacene")) {
            this.table.setRowFilter(this.getFilter());
            this.btnFilter.setActionCommand("sve");
            this.btnFilter.setText("Prika\u017ei sve (F2)");
        } else {
            this.table.setRowFilter(null);
            this.btnFilter.setActionCommand("samo_neplacene");
            this.btnFilter.setText("Filter: samo nepla\u0107eni (F2)");
        }
    }

    static /* synthetic */ Object access$0() {
        return selectedEntity;
    }
}

