/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.gui.korekcije.PzDialogVratiUPripremu;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class UzmiDokument
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzTable tblTabela;
    private JScrollPane scrollPane;
    private PzToolBarIcon btnSlika;
    private final Komitent komitent;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    protected Kalkulacija selektovanaKalkulacija;

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Izaberite prijemnicu za vra\u0107anje u pripremu");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlika);
            this.btnSlika.setText("Slika|dokumenta|(F2)");
            this.btnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/presentation.png")));
            this.btnSlika.setActionCommand("slika");
            this.btnSlika.addActionListener((ActionListener)((Object)this));
            this.btnSlika.setShortcut("F2");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            this.tblTabela = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblTabela);
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Kalkulacija dok = (Kalkulacija)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos(), dok.getDatum(), dok.getDatValute()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            System.out.println("Komitent je: " + this.komitent);
            q = em.createQuery("SELECT k FROM Kalkulacija k where k.arhiviran=1 and k.dokument.proknjizen=0 and k.komitent.sfrKomitent=:sifra and k.storno=0 AND k.tip='" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "'");
            q.setParameter("sifra", (Object)this.komitent.getSfrKomitent());
            Vector data = (Vector)q.getResultList();
            System.out.println("Nasao je kalkulacija: " + data.size());
            this.tblTabela.setData(data, Kalkulacija.class);
            em.close();
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UzmiDokument.this.tblTabela.getDataSize() > 0) {
                        EntityManager em = PzEntityManager.getEm();
                        try {
                            try {
                                UzmiDokument.this.selektovanaKalkulacija = (Kalkulacija)UzmiDokument.this.tblTabela.getSelectedEntity();
                                ((PzDialogVratiUPripremu)((Object)UzmiDokument.this.getParent())).refreshField(UzmiDokument.this.selektovanaKalkulacija);
                                UzmiDokument.this.dispose();
                            }
                            catch (Exception ex) {
                                PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 450);
            this.setMinimumSize(new Dimension(800, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Kalkulacija k = (Kalkulacija)this.tblTabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)k);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

