/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.dostavnica;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    public static final String CENA_NABAVNA = "Nabavna";
    public static final String CENA_PRODAJNA = "Prodajna";
    private PzPanel mainPanel;
    private PzPanelHeader header;
    private PzPanel pnlFields;
    private JLabel lblCena;
    private PzDoubleField dfKolicinaI;
    private JLabel lblKolicina;
    private JLabel lblCenaU;
    private PzDoubleField dfKolicinaP;
    private JLabel lblKolicinaP;
    private PzDoubleField dfCenaU;
    private PzDoubleField dfKolicinaU;
    private JLabel lblKolicinaU;
    private PzDoubleField dfCenaI;
    private PzPanel pnlUlazniMagacin;
    private PzPanel pnlIzlazniMagacin;
    private PzFieldIndikator indSifra;
    private PzTextField tfNaziv;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzButton btnPotvrdi;
    private PzTable tabela;
    private Interniracun dostavnica;
    private Stanjeartikal artikal;
    protected Stanje stanjeIzlaza;
    private PzRadioGroup<String> panelRBs1;
    protected Stanje stanjeUlaza;
    private Artikalinterniracun art;
    private double prethodnaKolicina;

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.paintPanel();
        this.tfSifra.setParamToPass((Object)this.dostavnica.getIzlaznaRJ());
        this.tfSifra.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifra, this.dostavnica.getIzlaznaRJ()));
        if (!this.dostavnica.getIzlaznaRJ().getgTip().equals("V")) {
            this.panelRBs1.setEnabled(false);
        }
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)"North");
            this.header.setOpaque(false);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFields, (Object)"Center");
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{72, 25, 6, 101, 10, 25, 13, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{41, 90, 140, 25, 230, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.pnlFields.setPreferredSize(new Dimension(640, 344));
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{CENA_PRODAJNA, CENA_NABAVNA});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBsLayout);
            this.pnlFields.add(this.panelRBs1, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Cena koja se preuzima po default-u"));
            if (PzParameter.getParameterValue((String)"DEFAULT_CENA_U_DOST", (String)"prodajna", (EntityManager)PzEntityManager.getEm()).equalsIgnoreCase("prodajna")) {
                this.panelRBs1.setSelectedValue((Object)CENA_PRODAJNA);
            } else {
                this.panelRBs1.setSelectedValue((Object)CENA_NABAVNA);
            }
            this.panelRBs1.setBounds(12, 12, 219, 71);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.setFocusable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 7, 6, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 80, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(144, 36));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra artikla");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (Dodavanje.this.tfSifra.getVal().equals("")) {
                        Dodavanje.this.tfSifra.requestFocus();
                        return false;
                    }
                    if (Dodavanje.this.dostavnica.artikalExists(Dodavanje.this.tfSifra.getVal())) {
                        PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Artikal ve\u0107 postoji na dostavnici");
                        Dodavanje.this.clearFields();
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    Dodavanje.this.stanjeIzlaza = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(Dodavanje.this.artikal.getId().getSfrProizvod(), Dodavanje.this.dostavnica.getIzlaznaRJ()));
                    if (Dodavanje.this.stanjeIzlaza == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Artikal do sada nije imao promet u izlaznoj RJ. Rad nemogu\u0107!");
                        Dodavanje.this.clearFields();
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    if (!Dodavanje.this.dostavnica.getIzlaznaRJ().getgTip().equals("G")) {
                        if (Dodavanje.this.dostavnica.getIzlaznaRJ().getgTip().equals("V") && ((String)Dodavanje.this.panelRBs1.getSelectedValue()).equalsIgnoreCase(Dodavanje.CENA_PRODAJNA)) {
                            if (new BigDecimal(Dodavanje.this.stanjeIzlaza.getProdCena()) == null) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana prodajna cena. Rad NEMOGUC!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            if (Dodavanje.this.stanjeIzlaza.getProdCena() == 0.0) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Cena je 0.0. Ne mo\u017eete nastaviti rad po prodajnoj ceni!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getProdCena());
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0 && Dodavanje.this.dostavnica.getIzlaznaRJ().getMinusKolicine().equals("ZABRANJEN")) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        } else if (Dodavanje.this.dostavnica.getIzlaznaRJ().getgTip().equals("V") && ((String)Dodavanje.this.panelRBs1.getSelectedValue()).equalsIgnoreCase(Dodavanje.CENA_NABAVNA)) {
                            if (Dodavanje.this.stanjeIzlaza.getProsNabCena() == null) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana prosecna nabavna cena. Rad NEMOGUC!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            if (Dodavanje.this.stanjeIzlaza.getProsNabCena().doubleValue() == 0.0) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Cena je 0.0. Ne mo\u017eete nastaviti rad po nabavnoj ceni!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getProsNabCena());
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        } else if (Dodavanje.this.dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                            if (Dodavanje.this.stanjeIzlaza.getProsNabCena() == null) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana prosecna nabavna cena. Rad NEMOGU\u0106!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            if (Dodavanje.this.stanjeIzlaza.getProsNabCena() == null) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Prosecna nabavna cena je 0. Rad NEMOGU\u0106!");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getProsNabCena());
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        } else {
                            if (Dodavanje.this.dostavnica.getIzlaznaRJ().getgTip().equals("S")) {
                                if (new BigDecimal(Dodavanje.this.stanjeIzlaza.getArtikal().getCenaPlanska()) == null) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana planska cena. Rad NEMOGU\u0106!");
                                    Dodavanje.this.clearFields();
                                    field.setState(PzFieldIndikator.STATE_INVALID);
                                    return false;
                                }
                                if (Dodavanje.this.stanjeIzlaza.getArtikal().getCenaPlanska() == 0.0) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Planska cena je 0. Rad NEMOGU\u0106!");
                                    Dodavanje.this.clearFields();
                                    field.setState(PzFieldIndikator.STATE_INVALID);
                                    return false;
                                }
                                Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getArtikal().getCenaPlanska());
                            } else {
                                if (new BigDecimal(Dodavanje.this.stanjeIzlaza.getProdCena()) == null) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana prodajna cena. Rad NEMOGU\u0106!");
                                    Dodavanje.this.clearFields();
                                    field.setState(PzFieldIndikator.STATE_INVALID);
                                    return false;
                                }
                                if (Dodavanje.this.stanjeIzlaza.getProdCena() == 0.0) {
                                    PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Prodajna cena je 0. Rad NEMOGU\u0106!");
                                    Dodavanje.this.clearFields();
                                    field.setState(PzFieldIndikator.STATE_INVALID);
                                    return false;
                                }
                                Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getProdCena());
                            }
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0 && Dodavanje.this.dostavnica.getIzlaznaRJ().getMinusKolicine().equals("ZABRANJEN")) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        }
                    } else {
                        if (new BigDecimal(Dodavanje.this.stanjeIzlaza.getArtikal().getCenaPlanska()) == null) {
                            PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Nije definisana planska cena. Rad NEMOGU\u0106!");
                            Dodavanje.this.clearFields();
                            field.setState(PzFieldIndikator.STATE_INVALID);
                            return false;
                        }
                        Dodavanje.this.dfCenaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getArtikal().getCenaPlanska());
                        if (Dodavanje.this.dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        } else {
                            if (Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina() <= 0.0 && Dodavanje.this.dostavnica.getIzlaznaRJ().getMinusKolicine().equals("ZABRANJEN")) {
                                PzSwingUtility.showErrorMessage((Component)((Object)Dodavanje.this), (String)"Koli\u010dina u magacinu = 0. Zabranjen odlazak u minus.");
                                Dodavanje.this.clearFields();
                                field.setState(PzFieldIndikator.STATE_INVALID);
                                return false;
                            }
                            Dodavanje.this.dfKolicinaI.setVal((Object)Dodavanje.this.stanjeIzlaza.getRaspolozivaKolicina());
                        }
                    }
                    Dodavanje.this.stanjeUlaza = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(Dodavanje.this.artikal.getId().getSfrProizvod(), Dodavanje.this.dostavnica.getUlaznaRJ()));
                    if (Dodavanje.this.stanjeUlaza != null) {
                        if (!Dodavanje.this.dostavnica.getUlaznaRJ().getgTip().equals("G")) {
                            if (Dodavanje.this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                Dodavanje.this.dfCenaU.setVal((Object)(Dodavanje.this.stanjeUlaza.getProsNabCena() != null ? Dodavanje.this.stanjeUlaza.getProsNabCena() : Double.valueOf(0.0)));
                            } else if (Dodavanje.this.dostavnica.getUlaznaRJ().getgTip().equals("S")) {
                                Dodavanje.this.dfCenaU.setVal((Object)(new BigDecimal(Dodavanje.this.stanjeUlaza.getArtikal().getCenaPlanska()) != null ? Dodavanje.this.stanjeUlaza.getArtikal().getCenaPlanska() : 0.0));
                            } else {
                                Dodavanje.this.dfCenaU.setVal((Object)(new BigDecimal(Dodavanje.this.stanjeUlaza.getProdCena()) != null ? Dodavanje.this.stanjeUlaza.getProdCena() : 0.0));
                            }
                        } else {
                            Dodavanje.this.dfCenaU.setVal((Object)(new BigDecimal(Dodavanje.this.stanjeUlaza.getArtikal().getCenaPlanska()) != null ? Dodavanje.this.stanjeUlaza.getArtikal().getCenaPlanska() : 0.0));
                        }
                        Dodavanje.this.dfKolicinaU.setVal((Object)Dodavanje.this.stanjeUlaza.getRaspolozivaKolicina());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dodavanje.this.tfSifra.transferFocus();
                        }
                    });
                    return true;
                }
            });
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setFocusable(false);
            this.tfNaziv.setEditable(false);
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlIzlazniMagacin = new PzPanel();
            GridBagLayout pnlIzlazniMagacinLayout = new GridBagLayout();
            this.pnlFields.add((Component)this.pnlIzlazniMagacin, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlIzlazniMagacin.setBorder((Border)BorderFactory.createTitledBorder("IZLAZNI MAGACIN"));
            pnlIzlazniMagacinLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlIzlazniMagacinLayout.rowHeights = new int[]{7, 25, 25, 7};
            pnlIzlazniMagacinLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlIzlazniMagacinLayout.columnWidths = new int[]{10, 72, 110, 7};
            this.pnlIzlazniMagacin.setLayout((LayoutManager)pnlIzlazniMagacinLayout);
            this.pnlIzlazniMagacin.setOpaque(false);
            this.lblKolicina = new JLabel();
            this.pnlIzlazniMagacin.add((Component)this.lblKolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKolicina.setText("Koli\u010dina");
            this.dfKolicinaI = new PzDoubleField();
            this.pnlIzlazniMagacin.add((Component)this.dfKolicinaI, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfKolicinaI.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.dfKolicinaI.setFocusable(false);
            this.lblCena = new JLabel();
            this.pnlIzlazniMagacin.add((Component)this.lblCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblCena.setText("Cena");
            this.dfCenaI = new PzDoubleField();
            this.pnlIzlazniMagacin.add((Component)this.dfCenaI, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfCenaI.setDecimalFormat(PzFormatFactory.getFakturnaCenaFormat());
            this.dfCenaI.setFocusable(false);
            this.pnlUlazniMagacin = new PzPanel();
            GridBagLayout pnlUlazniMagacinLayout = new GridBagLayout();
            this.pnlFields.add((Component)this.pnlUlazniMagacin, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlUlazniMagacin.setBorder((Border)BorderFactory.createTitledBorder("ULAZNI MAGACIN"));
            pnlUlazniMagacinLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlUlazniMagacinLayout.rowHeights = new int[]{7, 25, 25, 7};
            pnlUlazniMagacinLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlUlazniMagacinLayout.columnWidths = new int[]{10, 73, 110, 7};
            this.pnlUlazniMagacin.setLayout((LayoutManager)pnlUlazniMagacinLayout);
            this.pnlUlazniMagacin.setOpaque(false);
            this.lblKolicinaU = new JLabel();
            this.pnlUlazniMagacin.add((Component)this.lblKolicinaU, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKolicinaU.setText("Koli\u010dina");
            this.dfKolicinaU = new PzDoubleField();
            this.pnlUlazniMagacin.add((Component)this.dfKolicinaU, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfKolicinaU.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.dfKolicinaU.setFocusable(false);
            this.lblCenaU = new JLabel();
            this.pnlUlazniMagacin.add((Component)this.lblCenaU, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblCenaU.setText("Cena");
            this.dfCenaU = new PzDoubleField();
            this.pnlUlazniMagacin.add((Component)this.dfCenaU, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfCenaU.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.dfCenaU.setFocusable(false);
            this.lblKolicinaP = new JLabel();
            this.pnlFields.add((Component)this.lblKolicinaP, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKolicinaP.setText("Koli\u010dina za prenos");
            this.dfKolicinaP = new PzDoubleField();
            this.pnlFields.add((Component)this.dfKolicinaP, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKolicinaP.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(654, 409);
            this.setPreferredSize(new Dimension(654, 409));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            this.artikal = (Stanjeartikal)entity;
            this.tfSifra.setVal((Object)this.artikal.getId().getSfrProizvod());
            this.tfNaziv.setVal((Object)this.artikal.getNaziv());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlFields.validateForm(true)) {
            return;
        }
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        try {
            if (this.dfKolicinaP.getVal() <= 0.0) {
                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Koli\u010dina za prenos mora biti ve\u0107a od 0.");
                this.dfKolicinaP.requestFocus();
                return;
            }
            if (this.stanjeIzlaza.getRaspolozivaKolicina() < this.dfKolicinaP.getVal()) {
                if (this.dostavnica.getIzlaznaRJ().getMinusKolicine().equals("ZABRANJEN")) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Nedovoljna koli\u010dina. ZABRANJEN ulazak u minus.");
                    this.dfKolicinaP.requestFocus();
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Nedovoljna koli\u010dina! Nastavak rada?", (String)"Nedovoljna koli\u010dina", null, (boolean)false);
                if (rez != 0) {
                    this.dfKolicinaP.requestFocus();
                    return;
                }
            }
            try {
                if (actionCommand.equals("insert")) {
                    this.art = new Artikalinterniracun();
                    this.art.init(this.artikal, (PzDokument)this.dostavnica);
                    this.art.setKolicina(this.dfKolicinaP.getVal().doubleValue());
                    this.art.setIzlCena(this.dfCenaI.getVal().doubleValue());
                    if (this.dostavnica.getIzlaznaRJ().getgTip().equals("V") && ((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_PRODAJNA)) {
                        this.art.setIzlProdCena(BDConverter.getProdCena((double)this.stanjeIzlaza.getProdCena()));
                        if (this.stanjeUlaza == null) {
                            this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaI.getVal()).doubleValue());
                            this.art.setUlProdCena(BDConverter.getProdCena((double)0.0));
                        } else {
                            if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaI.getVal()).doubleValue());
                            } else {
                                this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaU.getVal()).doubleValue());
                            }
                            this.art.setUlProdCena(BDConverter.getProdCena((double)this.stanjeUlaza.getProdCena()));
                        }
                    } else if (this.dostavnica.getIzlaznaRJ().getgTip().equals("V") && ((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_NABAVNA)) {
                        this.art.setIzlProdCena(BDConverter.getPlanskaCena((double)this.stanjeIzlaza.getArtikal().getCenaPlanska()));
                        if (this.stanjeUlaza == null) {
                            this.art.setUlProdCena(BDConverter.getPlanskaCena((double)0.0));
                            this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                        } else {
                            if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                            } else {
                                this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaU.getVal()).doubleValue());
                            }
                            this.art.setUlProdCena(BDConverter.getPlanskaCena((double)this.stanjeUlaza.getArtikal().getCenaPlanska()));
                        }
                    } else {
                        if (this.dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                            this.art.setIzlProdCena(BDConverter.getPlanskaCena((double)this.stanjeIzlaza.getArtikal().getCenaPlanska()));
                            if (this.stanjeUlaza == null) {
                                this.art.setUlProdCena(BDConverter.getPlanskaCena((double)0.0));
                                this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                            } else {
                                this.art.setUlProdCena(BDConverter.getPlanskaCena((double)this.stanjeUlaza.getArtikal().getCenaPlanska()));
                                if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                    this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                                } else {
                                    this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaU.getVal()).doubleValue());
                                }
                            }
                        } else if (this.dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRODAJNA")) {
                            this.art.setIzlProdCena(BDConverter.getProdCena((double)this.stanjeIzlaza.getProdCena()));
                            if (this.stanjeUlaza == null) {
                                this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaI.getVal()).doubleValue());
                                this.art.setUlProdCena(BDConverter.getProdCena((double)0.0));
                            } else {
                                if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                    this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                                } else {
                                    this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaU.getVal()).doubleValue());
                                }
                                this.art.setUlProdCena(BDConverter.getProdCena((double)this.stanjeUlaza.getProdCena()));
                            }
                        } else {
                            this.art.setIzlProdCena(BDConverter.getPlanskaCena((double)this.stanjeIzlaza.getArtikal().getCenaPlanska()));
                            if (this.stanjeUlaza == null) {
                                this.art.setUlProdCena(BDConverter.getPlanskaCena((double)0.0));
                                this.art.setUlCena(BDConverter.getPlanskaCena((double)this.dfCenaI.getVal()).doubleValue());
                            } else {
                                this.art.setUlProdCena(BDConverter.getPlanskaCena((double)this.stanjeUlaza.getArtikal().getCenaPlanska()));
                                if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                    this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                                } else {
                                    this.art.setUlCena(BDConverter.getPlanskaCena((double)this.dfCenaU.getVal()).doubleValue());
                                }
                            }
                        }
                        if (this.dostavnica.getIzlaznaRJ().getgTip().equals("V") && this.dostavnica.getUlaznaRJ().getgTip().equals("S") || this.dostavnica.getIzlaznaRJ().getgTip().equals("S") && this.dostavnica.getUlaznaRJ().getgTip().equals("S")) {
                            if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                            }
                        } else if (this.dostavnica.getIzlaznaRJ().getgTip().equals("S") && this.dostavnica.getUlaznaRJ().getgTip().equals("V")) {
                            if (this.stanjeUlaza == null) {
                                if (this.dostavnica.getIzlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                    this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                                } else {
                                    this.art.setUlCena(BDConverter.getPlanskaCena((double)this.dfCenaI.getVal()).doubleValue());
                                }
                            } else if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRNC")) {
                                this.art.setUlCena(BDConverter.getPrnc((double)this.dfCenaI.getVal()).doubleValue());
                            } else if (this.dostavnica.getUlaznaRJ().getNacinVodjenja().equals("PRODAJNA")) {
                                this.art.setUlCena(BDConverter.getProdCena((double)this.dfCenaU.getVal()).doubleValue());
                            }
                        }
                    }
                    this.art.setJm(this.stanjeIzlaza.getArtikal().getJedMere());
                    this.art.setProcRabata(0.0);
                    this.art.setProcMarze(0.0);
                    this.art.setCvProdajnaIznos(this.stanjeIzlaza.getProdCena());
                    this.art.setIzlProsNabCena(this.stanjeIzlaza.getProsNabCena());
                    this.art.setUlProsNabCena(this.stanjeUlaza == null ? new BigDecimal(0.0) : this.stanjeUlaza.getProsNabCena());
                    this.art.setInterniracun(this.dostavnica);
                    if (((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_PRODAJNA)) {
                        this.art.setTemp(0.0);
                    } else {
                        this.art.setTemp(1.0);
                    }
                    this.dostavnica.setVredNaIzlazu(this.dostavnica.getVredNaIzlazu().add(BDConverter.getIznos((double)(this.art.getKolicina() * this.art.getIzlCena()))));
                    this.dostavnica.setVredNaUlazu(this.dostavnica.getVredNaUlazu().add(BDConverter.getIznos((double)(this.art.getKolicina() * this.art.getUlCena()))));
                    Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.dostavnica.getIdDok());
                    intrac.setVredNaIzlazu(this.dostavnica.getVredNaIzlazu());
                    intrac.setVredNaUlazu(this.dostavnica.getVredNaUlazu());
                    if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                        this.stanjeIzlaza.setAlocKolicina(this.stanjeIzlaza.getAlocKolicina() + this.dfKolicinaP.getVal());
                    }
                    em.getTransaction().begin();
                    em.merge((Object)this.dostavnica);
                    em.merge((Object)this.stanjeIzlaza);
                    this.tabela.insert((PzEntity)this.art, em);
                    em.getTransaction().commit();
                    this.tabela.commitInsert();
                } else if (actionCommand.equals("update")) {
                    if (this.dostavnica.getIzlaznaRJ().getgTip().equals("V")) {
                        if (((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_PRODAJNA)) {
                            this.art.setUlCena(BDConverter.getProdCena((double)this.stanjeIzlaza.getProdCena()).doubleValue());
                        } else if (((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_NABAVNA)) {
                            this.art.setUlCena(BDConverter.getPrnc((double)this.stanjeIzlaza.getProsNabCena().doubleValue()).doubleValue());
                        }
                    }
                    this.art.setKolicina(this.dfKolicinaP.getVal().doubleValue());
                    this.art.setCvProdajnaIznos(this.stanjeIzlaza.getProdCena());
                    this.art.setIzlProsNabCena(this.stanjeIzlaza.getProsNabCena());
                    this.art.setUlProsNabCena(this.stanjeUlaza == null ? new BigDecimal(0.0) : this.stanjeUlaza.getProsNabCena());
                    if (((String)this.panelRBs1.getSelectedValue()).equalsIgnoreCase(CENA_PRODAJNA)) {
                        this.art.setTemp(0.0);
                    } else {
                        this.art.setTemp(1.0);
                    }
                    this.dostavnica.setVredNaIzlazu(this.dostavnica.getVredNaIzlazu().add(BDConverter.getIznos((double)((this.art.getKolicina() - this.prethodnaKolicina) * this.art.getIzlCena()))));
                    this.dostavnica.setVredNaUlazu(this.dostavnica.getVredNaUlazu().subtract(BDConverter.getIznos((double)(this.prethodnaKolicina * this.art.getUlCena()))).add(BDConverter.getIznos((double)(this.art.getKolicina() * this.art.getUlCena()))));
                    Interniracun intrac = (Interniracun)em.find(Interniracun.class, (Object)this.dostavnica.getIdDok());
                    intrac.setVredNaIzlazu(this.dostavnica.getVredNaIzlazu());
                    intrac.setVredNaUlazu(this.dostavnica.getVredNaUlazu());
                    if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                        this.stanjeIzlaza.setAlocKolicina(this.stanjeIzlaza.getAlocKolicina() - this.prethodnaKolicina + this.dfKolicinaP.getVal());
                    }
                    em.getTransaction().begin();
                    em.merge((Object)this.stanjeIzlaza);
                    this.tabela.updateSelectedEntity((PzEntity)this.art, em);
                    em.getTransaction().commit();
                    this.tabela.commitUpdate();
                }
                this.dispose();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit.png")));
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_new.png")));
    }

    protected void onUpdate() {
        this.btnPotvrdi.setActionCommand("update");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.dostavnica = (Interniracun)this.getSession().getParameter("dostavnica");
        this.art = (Artikalinterniracun)this.tabela.getSelectedEntity();
        this.tfSifra.setVal((Object)this.art.getSifra());
        this.tfSifra.setEnabled(false);
        this.indSifra.setState(PzFieldIndikator.STATE_VALID);
        this.tfNaziv.setVal((Object)this.art.getNaziv());
        if (this.art.getTemp() == 0.0) {
            this.panelRBs1.setSelectedValue((Object)CENA_PRODAJNA);
        } else {
            this.panelRBs1.setSelectedValue((Object)CENA_NABAVNA);
        }
        this.prethodnaKolicina = this.art.getKolicina();
        this.dfKolicinaP.setVal((Object)this.art.getKolicina());
        this.dfKolicinaP.requestFocusInWindow();
        this.stanjeIzlaza = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(this.art.getId().getSfrProizvod(), this.dostavnica.getIzlaznaRJ()));
        this.stanjeUlaza = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(this.art.getId().getSfrProizvod(), this.dostavnica.getUlaznaRJ()));
    }

    protected void onInsert() {
        this.btnPotvrdi.setActionCommand("insert");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.dostavnica = (Interniracun)this.getSession().getParameter("dostavnica");
        this.tfSifra.requestFocusInWindow();
    }

    private void clearFields() {
        this.tfSifra.setText("");
        this.tfNaziv.setText("");
    }
}

