/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.gradjevinarstvo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzIdGen;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.RadniNalog;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzDateUtility;

public class IzmenaRadnogNaloga
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzPanel pnlTroskovi;
    private PzTextAreaPanel tfOpis;
    private PzTextField fieldInvestitor;
    private PzDateField dfDatum;
    private JLabel lblDatum;
    private JLabel lblOpis;
    private JLabel lblInvestitor;
    private JLabel lblRadniNalog;
    private PzDoubleField dfUkupno;
    private JLabel lblUkupno;
    private JLabel lblAmortizacija;
    private PzDoubleField dfAmortizacija;
    private PzDoubleField dfOstalo;
    private JLabel lblOstalo;
    private PzDoubleField dfEnergija;
    private JLabel lblEnergija;
    private PzDoubleField dfRad;
    private JLabel lblRad;
    private PzDoubleField dfMaterijal;
    private JLabel lblMaterijal;
    private PzPanel pnlRadniNalog;
    private PzTable table;
    private PzButton btnOk;
    private Komitent komitent;

    public IzmenaRadnogNaloga(PzDialog dialog) {
        super(dialog);
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            if (((Boolean)this.getSession().getParameter("update")).booleanValue()) {
                this.setTitle("Izmena radnog naloga");
            } else {
                this.setTitle("Unos radnog naloga");
            }
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{76, 71, 61, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{183, 202, 169, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(694, 270));
            this.pnlRadniNalog = new PzPanel();
            GridBagLayout pnlRadniNalogLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlRadniNalog, (Object)new GridBagConstraints(0, 0, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlRadniNalog.setName("pnlRadniNalog");
            this.pnlRadniNalog.setBorder((Border)BorderFactory.createTitledBorder("Elementi radnog naloga"));
            pnlRadniNalogLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadniNalogLayout.rowHeights = new int[]{15, 25, 28, 113, 7};
            pnlRadniNalogLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlRadniNalogLayout.columnWidths = new int[]{96, 81, 7};
            this.pnlRadniNalog.setLayout((LayoutManager)pnlRadniNalogLayout);
            this.pnlRadniNalog.setOpaque(false);
            this.lblRadniNalog = new JLabel();
            this.pnlRadniNalog.add((Component)this.lblRadniNalog, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblRadniNalog.setText("Investitor");
            this.fieldInvestitor = new PzTextField();
            this.pnlRadniNalog.add((Component)this.fieldInvestitor, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.fieldInvestitor.setFont(new Font("Tahoma", 0, 14));
            this.fieldInvestitor.requestFocus();
            this.fieldInvestitor.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.fieldInvestitor.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    return IzmenaRadnogNaloga.this.komitent != null;
                }
            });
            this.lblInvestitor = new JLabel();
            this.pnlRadniNalog.add((Component)this.lblInvestitor, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblInvestitor.setText("");
            this.tfOpis = new PzTextAreaPanel();
            this.pnlRadniNalog.add((Component)this.tfOpis, (Object)new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOpis.setBorder((Border)BorderFactory.createTitledBorder("Opis"));
            this.tfOpis.setOpaque(false);
            this.lblDatum = new JLabel();
            this.pnlRadniNalog.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblDatum.setText("Datum lansiranja");
            this.dfDatum = new PzDateField();
            this.pnlRadniNalog.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfDatum.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatum.setVerifyInput(true);
            this.pnlTroskovi = new PzPanel();
            GridBagLayout pnlTroskoviLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlTroskovi, (Object)new GridBagConstraints(2, 0, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlTroskovi.setBorder((Border)BorderFactory.createTitledBorder("Indirektni tro\u0161kovi"));
            pnlTroskoviLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlTroskoviLayout.rowHeights = new int[]{15, 25, 25, 25, 25, 25, 25, 20};
            pnlTroskoviLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlTroskoviLayout.columnWidths = new int[]{110, 150, 7};
            this.pnlTroskovi.setLayout((LayoutManager)pnlTroskoviLayout);
            this.pnlTroskovi.setOpaque(false);
            this.lblMaterijal = new JLabel();
            this.pnlTroskovi.add((Component)this.lblMaterijal, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblMaterijal.setText("Materijal");
            this.dfMaterijal = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfMaterijal, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfMaterijal.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfMaterijal.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    IzmenaRadnogNaloga.this.dfUkupno.setVal((Object)IzmenaRadnogNaloga.this.dfMaterijal.getBigDecimal().add(IzmenaRadnogNaloga.this.dfRad.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfEnergija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfAmortizacija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfOstalo.getBigDecimal()));
                    return true;
                }
            });
            this.lblRad = new JLabel();
            this.pnlTroskovi.add((Component)this.lblRad, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblRad.setText("Rad");
            this.dfRad = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfRad, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfRad.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfRad.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    IzmenaRadnogNaloga.this.dfUkupno.setVal((Object)IzmenaRadnogNaloga.this.dfMaterijal.getBigDecimal().add(IzmenaRadnogNaloga.this.dfRad.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfEnergija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfAmortizacija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfOstalo.getBigDecimal()));
                    return true;
                }
            });
            this.lblEnergija = new JLabel();
            this.pnlTroskovi.add((Component)this.lblEnergija, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblEnergija.setText("Energija");
            this.dfEnergija = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfEnergija, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfEnergija.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfEnergija.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    IzmenaRadnogNaloga.this.dfUkupno.setVal((Object)IzmenaRadnogNaloga.this.dfMaterijal.getBigDecimal().add(IzmenaRadnogNaloga.this.dfRad.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfEnergija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfAmortizacija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfOstalo.getBigDecimal()));
                    return true;
                }
            });
            this.lblAmortizacija = new JLabel();
            this.pnlTroskovi.add((Component)this.lblAmortizacija, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblAmortizacija.setText("Amortizacija");
            this.dfAmortizacija = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfAmortizacija, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfAmortizacija.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfAmortizacija.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    IzmenaRadnogNaloga.this.dfUkupno.setVal((Object)IzmenaRadnogNaloga.this.dfMaterijal.getBigDecimal().add(IzmenaRadnogNaloga.this.dfRad.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfEnergija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfAmortizacija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfOstalo.getBigDecimal()));
                    return true;
                }
            });
            this.lblOstalo = new JLabel();
            this.pnlTroskovi.add((Component)this.lblOstalo, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblOstalo.setText("Ostalo");
            this.dfOstalo = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfOstalo, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfOstalo.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfOstalo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    IzmenaRadnogNaloga.this.dfUkupno.setVal((Object)IzmenaRadnogNaloga.this.dfMaterijal.getBigDecimal().add(IzmenaRadnogNaloga.this.dfRad.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfEnergija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfAmortizacija.getBigDecimal()).add(IzmenaRadnogNaloga.this.dfOstalo.getBigDecimal()));
                    return true;
                }
            });
            this.lblUkupno = new JLabel();
            this.pnlTroskovi.add((Component)this.lblUkupno, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblUkupno.setText("Ukupni ind.tro\u0161kovi");
            this.dfUkupno = new PzDoubleField();
            this.pnlTroskovi.add((Component)this.dfUkupno, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfUkupno.setDecimalFormat(PzFormatFactory.getIznosFormat());
            this.dfUkupno.setFocusable(false);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 60, 10, 0), 0, 0));
            this.btnOk.setText("Potvrdi");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnOk.setActionCommand("potvrdi");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setShortcut("ctrl+w");
            this.setSize(708, 306);
            this.paintPanel();
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("insert")) {
            int rbroj = PzIdGen.getNextId((String)"RADNINALOG_ID", (int)1).getIdVal();
            String oznRN = String.valueOf(PzEntityUtil.strZero((String)("" + rbroj), (int)5)) + "-" + PzEntityUtil.strZero((String)this.komitent.getSfrKomitent(), (int)5) + "/" + PzDateUtility.getCurrentYear();
            RadniNalog rn = new RadniNalog(oznRN, this.dfDatum.getVal());
            rn.setOpis(this.tfOpis.getVal());
            rn.setKomitent(this.komitent);
            rn.setIndirektanMaterijal(this.dfMaterijal.getBigDecimal());
            rn.setIndirektanRad(this.dfRad.getBigDecimal());
            rn.setEnergija(this.dfEnergija.getBigDecimal());
            rn.setAmortizacija(this.dfAmortizacija.getBigDecimal());
            rn.setOstalo(this.dfOstalo.getBigDecimal());
            rn.setStatus((short)0);
            this.table.insert((PzEntity)rn, true);
        }
        if (actionCommand.equalsIgnoreCase("update")) {
            RadniNalog rn = (RadniNalog)this.table.getSelectedEntity();
            rn.setOpis(this.tfOpis.getVal());
            rn.setIndirektanMaterijal(this.dfMaterijal.getBigDecimal());
            rn.setIndirektanRad(this.dfRad.getBigDecimal());
            rn.setEnergija(this.dfEnergija.getBigDecimal());
            rn.setAmortizacija(this.dfAmortizacija.getBigDecimal());
            rn.setOstalo(this.dfOstalo.getBigDecimal());
            this.table.updateSelectedEntity((PzEntity)rn, true);
        }
        this.dispose();
    }

    protected void onInsert() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.btnOk.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        RadniNalog nalog = (RadniNalog)this.table.getSelectedEntity();
        this.fieldInvestitor.setVal(nalog.getKomitent() != null ? nalog.getKomitent().getSfrKomitent() : null);
        this.fieldInvestitor.setEnabled(false);
        this.dfDatum.setVal((Object)nalog.getDatumOtvaranja());
        this.lblInvestitor.setText(nalog.getKomitent() != null ? nalog.getKomitent().getNaziv() : null);
        this.dfMaterijal.setVal((Object)nalog.getIndirektanMaterijal());
        this.dfRad.setVal((Object)nalog.getIndirektanRad());
        this.dfEnergija.setVal((Object)nalog.getEnergija());
        this.dfAmortizacija.setVal((Object)nalog.getAmortizacija());
        this.dfOstalo.setVal((Object)nalog.getOstalo());
        this.tfOpis.setVal((Object)nalog.getOpis());
        this.dfUkupno.setVal((Object)nalog.getIndirektanMaterijal().add(nalog.getIndirektanRad()).add(nalog.getEnergija()).add(nalog.getAmortizacija()).add(nalog.getOstalo()));
        this.btnOk.setActionCommand("update");
        this.pnlRadniNalog.updateAllFieldsState();
        this.pnlTroskovi.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        this.komitent = (Komitent)entity;
        if (this.komitent != null) {
            this.fieldInvestitor.setVal((Object)this.komitent.getSfrKomitent());
            this.lblInvestitor.setText(this.komitent.getNaziv());
        }
        this.dfDatum.requestFocus();
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje novog radnog naloga");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena radnog naloga");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/radniNalog_edit.png")));
    }
}

