/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.proizvodnja.gui.prijemnice.troskovi.Dodavanje;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogTroskovi
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JLabel jLabelInt;
    private JLabel jLabelEks;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnBrisiSve;
    private PzToolBarIcon icnIzmena;
    private JPanel pnlIznosi;
    private PzTable table;
    private JScrollPane scp;
    private JPanel jPanel3;
    private PzDoubleField txtCarinaTroskovi;
    private JLabel jLabelCarina;
    private PzDoubleField txtInterniTroskovi;
    private PzDoubleField txtExterniTroskovi;
    private JToolBar toolbar;
    private Kalkulacija kalkulacija;
    private Vector<Trosak> vector;
    private PzPanel mainPanel;

    public PzDialogTroskovi(PzDialog dialog) {
        super(dialog);
        this.kalkulacija = (Kalkulacija)this.getSession().getParameter("kalkulacija");
        this.initGUI();
        this.paintPanel();
        this.vector = (Vector)this.kalkulacija.getTrosaks();
        this.txtExterniTroskovi.setVal((Object)this.calculateExterniTroskovi());
        this.txtInterniTroskovi.setVal((Object)this.calculateInterniTroskovi());
        this.txtCarinaTroskovi.setVal((Object)this.calculateCarinaTroskovi());
        if (this.kalkulacija.getArhiviran() == 1) {
            this.icnDodavanje.setEnabled(false);
            double sumTroskova = this.txtExterniTroskovi.getVal() + this.txtInterniTroskovi.getVal() + this.txtCarinaTroskovi.getVal();
            this.getSession().putParameter("sumaTroskova", (Object)sumTroskova);
        }
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.setTitle("Tro\u0161kovi");
            this.jPanel2 = new JPanel();
            this.jPanel2.setOpaque(false);
            BorderLayout jPanel2Layout = new BorderLayout();
            this.jPanel2.setLayout(jPanel2Layout);
            this.mainPanel.add((Component)this.jPanel2, (Object)"Center");
            this.jPanel2.setPreferredSize(new Dimension(725, 305));
            this.jPanel1 = new JPanel();
            this.jPanel1.setOpaque(false);
            this.jPanel2.add((Component)this.jPanel1, "Center");
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.jPanel1.setPreferredSize(new Dimension(725, 305));
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scp = new JScrollPane();
            this.jPanel1.add((Component)this.scp, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.scp.setBackground(new Color(211, 242, 210));
            this.table = new PzTable(this.kalkulacija.getTrosaks(), Trosak.class);
            this.getSession().putParameter("table_trosak", (Object)this.table);
            this.scp.setViewportView((Component)this.table);
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.toolbar.setOpaque(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope_add.png")));
            this.icnDodavanje.setText("Dodavanje|tro\u0161ka|(INS)");
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.setText("Izmena|tro\u0161ka|(F3)");
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope_delete.png")));
            this.icnBrisanje.setText("Brisanje|tro\u0161ka|(DEL)");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiSve);
            this.icnBrisiSve.setText("Brisanje|svih tro\u0161kova|(CTRL+Q)");
            this.icnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSve.setActionCommand("brisi_sve");
            this.icnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/money_envelope_delete_all.png")));
            this.icnBrisiSve.setShortcut("CTRL+Q");
            this.jPanel3 = new JPanel();
            GridBagLayout jPanel3Layout = new GridBagLayout();
            this.mainPanel.add((Component)this.jPanel3, (Object)"South");
            jPanel3Layout.rowWeights = new double[]{0.1};
            jPanel3Layout.rowHeights = new int[]{7};
            jPanel3Layout.columnWeights = new double[]{0.1};
            jPanel3Layout.columnWidths = new int[]{7};
            this.jPanel3.setLayout(jPanel3Layout);
            this.pnlIznosi = new JPanel();
            this.jPanel3.add((Component)this.pnlIznosi, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jPanel3.setOpaque(false);
            this.pnlIznosi.setOpaque(false);
            GridBagLayout pnlBilansLayout = new GridBagLayout();
            this.pnlIznosi.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Iznosi tro\u0161kova", 4, 0, new Font("Tahoma", 1, 12)));
            pnlBilansLayout.rowWeights = new double[]{0.0};
            pnlBilansLayout.rowHeights = new int[]{30};
            pnlBilansLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlBilansLayout.columnWidths = new int[]{67, 100, 75, 100, 75, 100, 100, 52};
            this.pnlIznosi.setLayout(pnlBilansLayout);
            this.jLabelEks = new JLabel();
            this.pnlIznosi.add((Component)this.jLabelEks, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.jLabelEks.setText("Eksterni:");
            this.jLabelEks.setFont(new Font("Tahoma", 1, 12));
            this.jLabelInt = new JLabel();
            this.pnlIznosi.add((Component)this.jLabelInt, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.jLabelInt.setText("Interni:");
            this.jLabelInt.setFont(new Font("Tahoma", 1, 12));
            this.txtExterniTroskovi = new PzDoubleField();
            this.pnlIznosi.add((Component)this.txtExterniTroskovi, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.txtExterniTroskovi.setEditable(false);
            this.txtExterniTroskovi.setFocusable(false);
            this.txtInterniTroskovi = new PzDoubleField();
            this.pnlIznosi.add((Component)this.txtInterniTroskovi, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.txtInterniTroskovi.setEditable(false);
            this.txtInterniTroskovi.setFocusable(false);
            this.jLabelCarina = new JLabel();
            this.pnlIznosi.add((Component)this.jLabelCarina, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.jLabelCarina.setText("Carina:");
            this.jLabelCarina.setFont(new Font("Tahoma", 1, 12));
            this.txtCarinaTroskovi = new PzDoubleField();
            this.pnlIznosi.add((Component)this.txtCarinaTroskovi, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.txtCarinaTroskovi.setEditable(false);
            this.txtCarinaTroskovi.setFocusable(false);
            this.setSize(800, 600);
            this.setMinimumSize(new Dimension(800, 600));
            this.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        block18: {
            EntityManager em = null;
            try {
                PzButton button = (PzButton)arg0.getSource();
                String actionCommand = button.getActionCommand();
                if (actionCommand.equals("brisanje") && this.table.getSelectedEntity() != null) {
                    em = PzEntityManager.getEm();
                    if (this.kalkulacija.getArhiviran() == 1) {
                        em.getTransaction().begin();
                        Trosak trosak = (Trosak)this.table.getSelectedEntity();
                        this.table.removeSelectedEntity(true, false);
                        this.txtExterniTroskovi.setVal((Object)this.calculateExterniTroskovi());
                        this.txtInterniTroskovi.setVal((Object)this.calculateInterniTroskovi());
                        this.txtCarinaTroskovi.setVal((Object)this.calculateCarinaTroskovi());
                        this.kalkulacija.getTrosaks().remove(trosak);
                        em.merge((Object)this.kalkulacija);
                        em.getTransaction().commit();
                    } else {
                        em.getTransaction().begin();
                        Trosak trosak = (Trosak)this.table.getSelectedEntity();
                        this.table.removeSelectedEntity(true, true);
                        this.txtExterniTroskovi.setVal((Object)this.calculateExterniTroskovi());
                        this.txtInterniTroskovi.setVal((Object)this.calculateInterniTroskovi());
                        this.txtCarinaTroskovi.setVal((Object)this.calculateCarinaTroskovi());
                        this.kalkulacija.getTrosaks().remove(trosak);
                        em.merge((Object)this.kalkulacija);
                        em.getTransaction().commit();
                    }
                    em.clear();
                    break block18;
                }
                if (actionCommand.equalsIgnoreCase("brisi_sve")) {
                    if (this.table.getRowCount() <= 0) break block18;
                    int j = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni da \u017eelite da obri\u0161ete sve tro\u0161kove?", (String)"Brisanje svih tro\u0161kova", null, (boolean)false);
                    if (j == 0) {
                        em = PzEntityManager.getEm();
                        em.getTransaction().begin();
                        int i = 0;
                        while (i < this.table.getRowCount()) {
                            System.out.println(i);
                            this.table.remove(i, false, em);
                            ++i;
                        }
                        IndirectList trosak = new IndirectList();
                        this.kalkulacija.setTrosaks((List)trosak);
                        em.merge((Object)this.kalkulacija);
                        em.getTransaction().commit();
                        this.table.commitRemove();
                        em.clear();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PzDialogTroskovi.this.txtExterniTroskovi.setVal((Object)PzDialogTroskovi.this.calculateExterniTroskovi());
                                PzDialogTroskovi.this.txtInterniTroskovi.setVal((Object)PzDialogTroskovi.this.calculateInterniTroskovi());
                                PzDialogTroskovi.this.txtCarinaTroskovi.setVal((Object)PzDialogTroskovi.this.calculateCarinaTroskovi());
                            }
                        });
                        break block18;
                    }
                    return;
                }
                try {
                    if (actionCommand.equalsIgnoreCase("izmena")) {
                        if (this.table.getSelectedEntity() != null) {
                            this.getSession().putParameter("update", (Object)true);
                            this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                            this.showDialog(Dodavanje.class);
                            this.txtExterniTroskovi.setVal((Object)this.calculateExterniTroskovi());
                            this.txtInterniTroskovi.setVal((Object)this.calculateInterniTroskovi());
                            this.txtCarinaTroskovi.setVal((Object)this.calculateCarinaTroskovi());
                        }
                    } else if (actionCommand.equalsIgnoreCase("dodavanje")) {
                        this.getSession().putParameter("update", (Object)false);
                        this.getSession().putParameter("kalkulacija", (Object)this.kalkulacija);
                        this.showDialog(Dodavanje.class);
                        this.txtExterniTroskovi.setVal((Object)this.calculateExterniTroskovi());
                        this.txtInterniTroskovi.setVal((Object)this.calculateInterniTroskovi());
                        this.txtCarinaTroskovi.setVal((Object)this.calculateCarinaTroskovi());
                    }
                }
                catch (Exception e) {
                    if (em != null && em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
            finally {
                if (em != null) {
                    em.close();
                }
            }
        }
    }

    private BigDecimal calculateExterniTroskovi() {
        BigDecimal suma = new BigDecimal(0.0);
        if (this.vector != null) {
            for (Trosak t : this.vector) {
                if (!t.getPodTip().equalsIgnoreCase("eksterni")) continue;
                suma = suma.add(t.getOsnovica());
                suma = suma.add(t.getBezPrava());
                suma = suma.add(t.getOslobodjeno());
            }
        }
        return suma;
    }

    private BigDecimal calculateInterniTroskovi() {
        BigDecimal suma = new BigDecimal(0.0);
        if (this.vector != null) {
            for (Trosak t : this.vector) {
                if (!t.getPodTip().equalsIgnoreCase("interni")) continue;
                suma = suma.add(t.getOsnovica());
                suma = suma.add(t.getBezPrava());
                suma = suma.add(t.getOslobodjeno());
            }
        }
        return suma;
    }

    private BigDecimal calculateCarinaTroskovi() {
        BigDecimal suma = new BigDecimal(0.0);
        if (this.vector != null) {
            for (Trosak t : this.vector) {
                if (!t.getPodTip().equalsIgnoreCase("carina")) continue;
                suma = suma.add(t.getOsnovica());
                suma = suma.add(t.getBezPrava());
                suma = suma.add(t.getOslobodjeno());
            }
        }
        return suma;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTroskovi(Boolean.FALSE);
    }

    public PzDialogTroskovi(Boolean initGUI) {
    }
}

