/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.sastavnice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.proizvodnja.gui.PzDialogSastavnicaDostavnica;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class OtvaranjeSklopa
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzFieldIndikator indSifra;
    private JLabel lblNaziv;
    private PzTextField tfNazivArtikla;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzButton btnPotvrdi;
    private Artikal artikal;
    private PzTable tabela;
    private PzDialogSastavnicaDostavnica parent;

    public OtvaranjeSklopa(PzDialog dialog) {
        super(dialog);
        this.parent = (PzDialogSastavnicaDostavnica)dialog;
        this.initGUI();
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("OTVARANJE SASTAVNICE");
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(192, 120));
            pnlGlavniLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{7, 53, 36, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{33, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{116, 115, 118, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra sklopa");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfSifra.setFKField(Artikal.class, PzDialogArtikliExtended.class, true, null);
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (OtvaranjeSklopa.this.artikal.getJedMere().equals("GAR")) {
                        PzSwingUtility.showErrorMessage((Component)((Object)OtvaranjeSklopa.this), (String)"Artikal je garnitura! Molim izaberite drugi artikal.");
                        OtvaranjeSklopa.this.tfSifra.setText("");
                        OtvaranjeSklopa.this.tfNazivArtikla.setText("");
                        return false;
                    }
                    if (OtvaranjeSklopa.this.artikal.getGarnitura() == 2) {
                        PzSwingUtility.showErrorMessage((Component)((Object)OtvaranjeSklopa.this), (String)"Artikal je vec uba\u010den u bazu kao sklop artikala");
                        OtvaranjeSklopa.this.tfSifra.setText("");
                        OtvaranjeSklopa.this.tfNazivArtikla.setText("");
                        return false;
                    }
                    return true;
                }
            });
            this.tfNazivArtikla = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivArtikla, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNazivArtikla.setFocusable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.lblNaziv = new JLabel();
            this.pnlFields.add((Component)this.lblNaziv, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblNaziv.setText("Naziv sklopa");
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 2, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(424, 206);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    em.getTransaction().begin();
                    this.artikal.setGarnitura((short)2);
                    em.merge((Object)this.artikal);
                    em.getTransaction().commit();
                    this.tabela.insertGUI((PzEntity)this.artikal);
                    this.dispose();
                    this.parent.ulaz();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            this.artikal = (Artikal)entity;
            this.tfSifra.setVal((Object)this.artikal.getSfrProizvod());
            this.tfNazivArtikla.setVal((Object)this.artikal.getNaziv());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

