/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.trebovanje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class DodavanjeStavke
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanelHeader header;
    private PzButton btnPotvrdi;
    private PzDoubleField dfCena;
    private PzPanel mainPanel;
    private JLabel lblSifraArtikla;
    private PzTextField tfJedMere;
    private PzTextField tfProizvodjac;
    private PzTextField tfRG;
    private PzTextField tfTG;
    private PzDoubleField dfPakovanje;
    private PzDoubleField dfRasKolicina;
    private PzDoubleField dfZadnjaNC;
    private PzDoubleField dfPlanskaCena;
    private PzDoubleField dfProsecnaNC;
    private PzDoubleField dfProdajnaCena;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private PzDoubleField dfKolicina;
    private PzTextField tfSifraArtikla;
    private JLabel lblPrRabata;
    private JLabel lblCena;
    private JLabel lblKolicina;
    private PzPanel plGlavni;
    private Opstidokument trebovanje;
    private Artikalopstidokument arttreb;
    private Artikalopstidokument arttrebStari;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanelPromet;
    private PzPanel jPanel1;
    private boolean izmena;
    private String lokacija;
    private BigDecimal prethodniIznosBezPDV;
    private double prethodniIznosKolicine;
    String naziv;
    String jm;
    Stanjeartikal a;
    Artikal art;

    public DodavanjeStavke(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public DodavanjeStavke(PzDialog dialog) {
        super(dialog);
        this.trebovanje = (Opstidokument)this.getSession().getParameter("trebovanje");
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.tfSifraArtikla.setParamToPass((Object)this.trebovanje.getRadnajedinica());
        this.tfSifraArtikla.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifraArtikla, this.trebovanje.getRadnajedinica()));
        if (this.izmena) {
            this.arttreb = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.arttrebStari = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.a = null;
            try {
                this.a = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(this.tfSifraArtikla.getVal(), this.trebovanje.getRadnajedinica()));
                this.art = (Artikal)PzEntityManager.find(Artikal.class, (Object)this.tfSifraArtikla.getVal());
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            this.naziv = this.a.getNaziv();
            this.jm = this.a.getJedMere();
            this.lokacija = this.a.getStalaza() == null ? "00" : (String.valueOf(this.a.getStalaza()) + this.a.getNivo() == null ? "00" : (String.valueOf(this.a.getNivo()) + this.a.getPaleta() == null ? "00" : this.a.getPaleta()));
            this.setStanje(this.a);
            this.dfKolicina.requestFocus();
            if (this.trebovanje.getRadnajedinica().getgTip().equals("S") && this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA") || this.trebovanje.getRadnajedinica().getgTip().equals("P")) {
                this.dfCena.setVal((Object)this.a.getCenaPlanska());
            } else if (this.a.getProsNabCena() != null) {
                this.dfCena.setVal((Object)this.a.getProsNabCena().doubleValue());
            } else {
                this.dfCena.setVal((Object)0.0);
            }
        } else {
            this.tfSifraArtikla.requestFocus();
        }
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.header = new PzPanelHeader();
            this.mainPanel.add((Component)this.header);
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.header.setOpaque(false);
            this.plGlavni = new PzPanel();
            this.mainPanel.add((Component)this.plGlavni, (Object)"South");
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.plGlavni.setPreferredSize(new Dimension(702, 352));
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{31, 31, 30, 195, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{79, 105, 7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.plGlavni.setOpaque(false);
            this.lblSifraArtikla = new JLabel();
            this.plGlavni.add((Component)this.lblSifraArtikla, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblSifraArtikla.setText("\u0160ifra artikla");
            this.lblKolicina = new JLabel();
            this.plGlavni.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKolicina.setText("Koli\u010dina");
            this.lblCena = new JLabel();
            this.plGlavni.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblCena.setText("Cena");
            this.lblPrRabata = new JLabel();
            this.plGlavni.add((Component)this.lblPrRabata, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 0, 0, 5), 0, 0));
            this.lblPrRabata.setText("% rabata");
            this.lblPrRabata.setVisible(false);
            this.dfCena = new PzDoubleField();
            this.plGlavni.add((Component)this.dfCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.dfCena.setFont(new Font("Tahoma", 0, 14));
            this.dfCena.setPreferredSize(new Dimension(60, 24));
            this.dfCena.setSize(60, 24);
            this.dfCena.setEnabled(false);
            if (((Opstidokument)this.getSession().getParameter("trebovanje")).getRadnajedinica().getgTip().equals("S") && ((Opstidokument)this.getSession().getParameter("trebovanje")).getRadnajedinica().getNacinVodjenja().equals("PLANSKA") || ((Opstidokument)this.getSession().getParameter("trebovanje")).getRadnajedinica().getgTip().equals("P")) {
                this.dfCena.setDecimalFormat(new DecimalFormat(PzParameter.getParameterValue((String)"DEFAULT_DECIMAL_FORMAT", (String)"###,###.00")));
            } else {
                this.dfCena.setDecimalFormat(new DecimalFormat(PzParameter.getParameterValue((String)"PRNC_FORMAT", (String)"###,###.0000")));
            }
            this.tfSifraArtikla = new PzTextField();
            this.plGlavni.add((Component)this.tfSifraArtikla, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.tfSifraArtikla.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraArtikla.setPreferredSize(new Dimension(60, 24));
            this.tfSifraArtikla.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.tfSifraArtikla.setSize(60, 24);
            this.tfSifraArtikla.setCustomInputVerifier(new InputVerifier(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean verify(JComponent input) {
                    try {
                        if (DodavanjeStavke.this.trebovanje.artikalExists(DodavanjeStavke.this.tfSifraArtikla.getVal())) {
                            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal ve\u0107 postoji na trebovanju!");
                            return false;
                        }
                        Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(DodavanjeStavke.this.tfSifraArtikla.getVal(), DodavanjeStavke.this.trebovanje.getRadnajedinica()));
                        if (s == null) {
                            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal nema promet!");
                            return false;
                        }
                        Stanjeartikal a = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(DodavanjeStavke.this.tfSifraArtikla.getVal(), DodavanjeStavke.this.trebovanje.getRadnajedinica()));
                        if (DodavanjeStavke.this.trebovanje.getRadnajedinica().getgTip().equals("S") && DodavanjeStavke.this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                            if (a.getProsNabCena().doubleValue() == 0.0) {
                                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal nema formiranu prose\u010dnu nabavnu cenu!");
                                return false;
                            }
                            DodavanjeStavke.this.dfCena.setVal((Object)a.getProsNabCena().doubleValue());
                        }
                        if (DodavanjeStavke.this.trebovanje.getRadnajedinica().getgTip().equals("P") || DodavanjeStavke.this.trebovanje.getRadnajedinica().getgTip().equals("S") && DodavanjeStavke.this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA")) {
                            if (a.getCenaPlanska() == 0.0) {
                                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal nema formiranu plansku cenu!");
                                return false;
                            }
                            DodavanjeStavke.this.dfCena.setVal((Object)a.getCenaPlanska());
                        }
                        double kolicina = a.getKolicina() - a.getAlocKolicina();
                        if (DodavanjeStavke.this.trebovanje.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN") || !(kolicina <= 0.0)) return true;
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)("Koli\u010dina u magacinu = " + kolicina + ". Rad nemoguc."));
                        return false;
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)SwingUtilities.getRoot(input), (Throwable)e);
                    }
                    return true;
                }
            });
            this.dfKolicina = new PzDoubleField();
            this.plGlavni.add((Component)this.dfKolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.dfKolicina.setFont(new Font("Tahoma", 0, 14));
            this.dfKolicina.setPreferredSize(new Dimension(60, 24));
            this.dfKolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.dfKolicina.setSize(60, 24);
            this.dfKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (DodavanjeStavke.this.dfKolicina.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Koli\u010dina ne mo\u017ee biti 0!", "Informacija", 1);
                        return false;
                    }
                    if (DodavanjeStavke.this.dfKolicina.getVal() > DodavanjeStavke.this.dfRasKolicina.getVal()) {
                        if (DodavanjeStavke.this.trebovanje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") || DodavanjeStavke.this.trebovanje.getRadnajedinica().getgTip().equals("S") && DodavanjeStavke.this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                            JOptionPane.showMessageDialog(null, "Nema dovoljno raspolo\u017eive koli\u010dine!", "Informacija", 1);
                            return false;
                        }
                        int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Nedovoljna koli\u010dina! Nastavak rada?", (String)"Nedovoljna koli\u010dina", null, (boolean)false);
                        if (rez != 0) {
                            DodavanjeStavke.this.dfKolicina.requestFocus();
                            return false;
                        }
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.plGlavni.add((Component)this.getJPanel1(), (Object)new GridBagConstraints(2, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.tfSifraArtikla.requestFocus();
            this.pack();
            this.setSize(530, 490);
            this.setPreferredSize(new Dimension(530, 490));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("insert")) {
            try {
                if (this.dfKolicina.getVal() <= 0.0) {
                    JOptionPane.showMessageDialog(null, "Koli\u010dina ne mo\u017ee biti 0!", "Informacija", 1);
                    return;
                }
                if (this.dfKolicina.getVal() > this.dfRasKolicina.getVal()) {
                    if (this.trebovanje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") || this.trebovanje.getRadnajedinica().getgTip().equals("S") && this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                        JOptionPane.showMessageDialog(null, "Nema dovoljno raspolo\u017eive koli\u010dine!", "Informacija", 1);
                        return;
                    }
                    int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Nedovoljna koli\u010dina! Nastavak rada?", (String)"Nedovoljna koli\u010dina", null, (boolean)false);
                    if (rez != 0) {
                        this.dfKolicina.requestFocus();
                        return;
                    }
                }
                this.arttreb = new Artikalopstidokument();
                this.arttreb.init(this.art, (PzDokument)this.trebovanje);
                this.arttreb.setKolicina(this.dfKolicina.getVal().doubleValue());
                this.arttreb.setNaziv(this.naziv);
                this.arttreb.setCenaBezPoreza(this.dfCena.getVal().doubleValue());
                this.arttreb.setJm(this.jm);
                this.arttreb.setLokacija(this.lokacija);
                this.arttreb.setOpstidokument(this.trebovanje);
                if (this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA")) {
                    this.arttreb.setProdCena(BDConverter.getPlanskaCena((double)this.arttreb.getCenaBezPoreza()));
                    this.arttreb.setProsNabCena(BDConverter.getPrnc((double)this.dfProsecnaNC.getVal()));
                } else if (this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                    this.arttreb.setProdCena(BDConverter.getPlanskaCena((double)this.dfPlanskaCena.getVal()));
                    this.arttreb.setProsNabCena(BDConverter.getPrnc((double)this.arttreb.getCenaBezPoreza()));
                }
                this.trebovanje.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza().add(BDConverter.getIznos((double)(this.arttreb.getKolicina() * this.arttreb.getCenaBezPoreza()))));
                this.trebovanje.setProcRabata(this.trebovanje.getProcRabata() + this.arttreb.getKolicina());
                Opstidokument t = (Opstidokument)em.find(Opstidokument.class, (Object)this.trebovanje.getIdDok());
                t.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza());
                t.setProcRabata(this.trebovanje.getProcRabata());
                em.getTransaction().begin();
                em.merge((Object)this.trebovanje);
                ((PzTable)this.getSession().getParameter("tabela")).insert((PzEntity)this.arttreb, em);
                em.getTransaction().commit();
                ((PzTable)this.getSession().getParameter("tabela")).commitInsert();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                    ((PzTable)this.getSession().getParameter("tabela")).removeSelectedEntity(false, false);
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        } else if (actionCommand.equals("update")) {
            try {
                if (this.dfKolicina.getVal() <= 0.0) {
                    JOptionPane.showMessageDialog(null, "Koli\u010dina ne mo\u017ee biti 0!", "Informacija", 1);
                    return;
                }
                if (this.dfKolicina.getVal() > this.dfRasKolicina.getVal()) {
                    if (this.trebovanje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN") || this.trebovanje.getRadnajedinica().getgTip().equals("S") && this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                        JOptionPane.showMessageDialog(null, "Nema dovoljno raspolo\u017eive koli\u010dine!", "Informacija", 1);
                        return;
                    }
                    int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Nedovoljna koli\u010dina! Nastavak rada?", (String)"Nedovoljna koli\u010dina", null, (boolean)false);
                    if (rez != 0) {
                        this.dfKolicina.requestFocus();
                        return;
                    }
                }
                this.arttreb.setKolicina(this.dfKolicina.getVal().doubleValue());
                this.arttreb.setNaziv(this.naziv);
                this.arttreb.setCenaBezPoreza(this.dfCena.getVal().doubleValue());
                this.arttreb.setJm(this.jm);
                this.arttreb.setLokacija(this.lokacija);
                if (this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA")) {
                    this.arttreb.setProdCena(BDConverter.getPlanskaCena((double)this.arttreb.getCenaBezPoreza()));
                    this.arttreb.setProsNabCena(BDConverter.getPrnc((double)this.dfProsecnaNC.getVal()));
                } else if (this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                    this.arttreb.setProdCena(BDConverter.getPlanskaCena((double)this.dfPlanskaCena.getVal()));
                    this.arttreb.setProsNabCena(BDConverter.getPrnc((double)this.arttreb.getCenaBezPoreza()));
                }
                this.trebovanje.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza().subtract(this.prethodniIznosBezPDV).add(BDConverter.getIznos((double)(this.arttreb.getKolicina() * this.arttreb.getCenaBezPoreza()))));
                this.trebovanje.setProcRabata(this.trebovanje.getProcRabata() - this.prethodniIznosKolicine + this.arttreb.getKolicina());
                Opstidokument t = (Opstidokument)em.find(Opstidokument.class, (Object)this.trebovanje.getIdDok());
                t.setIznosBezPoreza(this.trebovanje.getIznosBezPoreza());
                t.setProcRabata(this.trebovanje.getProcRabata());
                em.getTransaction().begin();
                em.merge((Object)this.trebovanje);
                ((PzTable)this.getSession().getParameter("tabela")).updateSelectedEntity((PzEntity)this.arttreb, em);
                em.getTransaction().commit();
                ((PzTable)this.getSession().getParameter("tabela")).commitUpdate();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                    ((PzTable)this.getSession().getParameter("tabela")).updateSelectedEntity((PzEntity)this.arttrebStari, false);
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        this.dispose();
    }

    protected void onInsert() {
        this.btnPotvrdi.setActionCommand("insert");
        this.jPanel1.setEnabled(true);
    }

    protected void onUpdate() {
        try {
            this.btnPotvrdi.setActionCommand("update");
            Artikalopstidokument arttr = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.tfSifraArtikla.setVal((Object)arttr.getId().getSfrProizvod());
            this.tfSifraArtikla.setEnabled(false);
            this.dfKolicina.setVal((Object)arttr.getKolicina());
            this.dfKolicina.setEnabled(true);
            this.dfCena.setVal((Object)arttr.getCenaBezPoreza());
            this.prethodniIznosBezPDV = BDConverter.getIznos((double)(arttr.getKolicina() * arttr.getCenaBezPoreza()));
            this.prethodniIznosKolicine = arttr.getKolicina();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setStanje(Stanjeartikal a) {
        try {
            this.tfRG.setVal((Object)a.getOznRobGr());
            this.dfPakovanje.setVal((Object)a.getStandPak());
            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(a.getId().getSfrProizvod(), this.trebovanje.getRadnajedinica()));
            this.dfRasKolicina.setVal((Object)(s != null ? s.getKolicina() - s.getAlocKolicina() : 0.0));
            this.dfZadnjaNC.setVal((Object)(s != null ? s.getZadNabCena() : 0.0));
            this.dfProdajnaCena.setVal((Object)(s != null ? s.getProdCena() : 0.0));
            this.dfProsecnaNC.setVal((Object)(s != null ? s.getProsNabCena() : Double.valueOf(0.0)));
            this.dfPlanskaCena.setVal((Object)a.getCenaPlanska());
            this.tfProizvodjac.setVal((Object)(a.getProizvodjac() != null ? a.getSfrProizvodjac() : ""));
            this.tfJedMere.setVal((Object)a.getJedMere());
            this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder("Promet za: " + a.getNaziv()));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.a = (Stanjeartikal)entity;
        this.tfSifraArtikla.setVal((Object)this.a.getId().getSfrProizvod());
        try {
            this.art = (Artikal)PzEntityManager.find(Artikal.class, (Object)this.a.getId().getSfrProizvod());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.naziv = this.a.getNaziv();
        this.jm = this.a.getJedMere();
        String string = this.a.getStalaza() == null ? "00" : (String.valueOf(this.a.getStalaza()) + this.a.getNivo() == null ? "00" : (this.lokacija = String.valueOf(this.a.getNivo()) + this.a.getPaleta() == null ? "00" : this.a.getPaleta()));
        if (this.trebovanje.getRadnajedinica().getgTip().equals("S") && this.trebovanje.getRadnajedinica().getNacinVodjenja().equals("PLANSKA") || this.trebovanje.getRadnajedinica().getgTip().equals("P")) {
            this.dfCena.setVal((Object)this.a.getCenaPlanska());
        } else if (this.a.getProsNabCena() != null) {
            this.dfCena.setVal((Object)this.a.getProsNabCena().doubleValue());
        } else {
            this.dfCena.setVal((Object)0.0);
        }
        this.dfKolicina.requestFocus();
        this.setStanje(this.a);
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/book_blue_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/book_blue_edit.png")));
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeStavke(Boolean.FALSE);
    }

    public DodavanjeStavke(Boolean initGUI) {
    }

    private PzPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new PzPanel();
            this.jPanel1.setOpaque(false);
            this.jPanel1.setVisible(true);
            this.jPanel1.setFocusable(false);
            this.jPanel1.setPreferredSize(new Dimension(359, 320));
            this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder("Promet"));
            this.jPanel1.add((Component)this.getJPanelPromet());
        }
        return this.jPanel1;
    }

    private JPanel getJPanelPromet() {
        if (this.jPanelPromet == null) {
            this.jPanelPromet = new JPanel();
            this.jPanelPromet.setOpaque(false);
            GridBagLayout jPanelPrometLayout = new GridBagLayout();
            this.jPanelPromet.setPreferredSize(new Dimension(359, 235));
            jPanelPrometLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            jPanelPrometLayout.rowHeights = new int[]{7, 20, 20, 20, 20, 20, 20, 7, 7, 7};
            jPanelPrometLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            jPanelPrometLayout.columnWidths = new int[]{163, 100, 20};
            this.jPanelPromet.setLayout(jPanelPrometLayout);
            this.jPanelPromet.setFocusable(false);
            this.jPanelPromet.add((Component)this.getJLabel1(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel2(), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel3(), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel4(), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel5(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel6(), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel7(), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel8(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel9(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel10(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getDfProdajnaCena(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfProsecnaNC(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfPlanskaCena(), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfZadnjaNC(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfRasKolicina(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfPakovanje(), new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfTG(), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfRG(), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfProizvodjac(), new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfJedMere(), new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanelPromet;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Raspolo\u017eiva koli\u010dina");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Proizvo\u0111a\u010d");
        }
        return this.jLabel2;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Jedinica mere");
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Pakovanje");
        }
        return this.jLabel4;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Prodajna cena");
        }
        return this.jLabel5;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Tarifna grupa");
        }
        return this.jLabel6;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Robna grupa");
        }
        return this.jLabel7;
    }

    private JLabel getJLabel8() {
        if (this.jLabel8 == null) {
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("Prose\u010dna nabavna cena");
        }
        return this.jLabel8;
    }

    private JLabel getJLabel9() {
        if (this.jLabel9 == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("Planska cena");
        }
        return this.jLabel9;
    }

    private JLabel getJLabel10() {
        if (this.jLabel10 == null) {
            this.jLabel10 = new JLabel();
            this.jLabel10.setText("Zadnja nabavna cena");
        }
        return this.jLabel10;
    }

    private PzDoubleField getDfProdajnaCena() {
        if (this.dfProdajnaCena == null) {
            this.dfProdajnaCena = new PzDoubleField();
            this.dfProdajnaCena.setFont(new Font("Tahoma", 0, 14));
            this.dfProdajnaCena.setPreferredSize(new Dimension(60, 24));
            this.dfProdajnaCena.setSize(60, 24);
            this.dfProdajnaCena.setFocusable(false);
        }
        return this.dfProdajnaCena;
    }

    private PzDoubleField getDfProsecnaNC() {
        if (this.dfProsecnaNC == null) {
            this.dfProsecnaNC = new PzDoubleField();
            this.dfProsecnaNC.setFont(new Font("Tahoma", 0, 14));
            this.dfProsecnaNC.setPreferredSize(new Dimension(60, 24));
            this.dfProsecnaNC.setSize(60, 24);
            this.dfProsecnaNC.setFocusable(false);
        }
        return this.dfProsecnaNC;
    }

    private PzDoubleField getDfPlanskaCena() {
        if (this.dfPlanskaCena == null) {
            this.dfPlanskaCena = new PzDoubleField();
            this.dfPlanskaCena.setFont(new Font("Tahoma", 0, 14));
            this.dfPlanskaCena.setPreferredSize(new Dimension(60, 24));
            this.dfPlanskaCena.setSize(60, 24);
            this.dfPlanskaCena.setFocusable(false);
        }
        return this.dfPlanskaCena;
    }

    private PzDoubleField getDfZadnjaNC() {
        if (this.dfZadnjaNC == null) {
            this.dfZadnjaNC = new PzDoubleField();
            this.dfZadnjaNC.setFont(new Font("Tahoma", 0, 14));
            this.dfZadnjaNC.setPreferredSize(new Dimension(60, 24));
            this.dfZadnjaNC.setSize(60, 24);
            this.dfZadnjaNC.setFocusable(false);
        }
        return this.dfZadnjaNC;
    }

    private PzDoubleField getDfRasKolicina() {
        if (this.dfRasKolicina == null) {
            this.dfRasKolicina = new PzDoubleField();
            this.dfRasKolicina.setFont(new Font("Tahoma", 0, 14));
            this.dfRasKolicina.setPreferredSize(new Dimension(60, 24));
            this.dfRasKolicina.setSize(60, 24);
            this.dfRasKolicina.setFocusable(false);
            this.dfRasKolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
        }
        return this.dfRasKolicina;
    }

    private PzDoubleField getDfPakovanje() {
        if (this.dfPakovanje == null) {
            this.dfPakovanje = new PzDoubleField();
            this.dfPakovanje.setFont(new Font("Tahoma", 0, 14));
            this.dfPakovanje.setPreferredSize(new Dimension(60, 24));
            this.dfPakovanje.setSize(60, 24);
            this.dfPakovanje.setFocusable(false);
        }
        return this.dfPakovanje;
    }

    private PzTextField getTfTG() {
        if (this.tfTG == null) {
            this.tfTG = new PzTextField();
            this.tfTG.setFont(new Font("Tahoma", 0, 14));
            this.tfTG.setPreferredSize(new Dimension(60, 24));
            this.tfTG.setSize(60, 24);
            this.tfTG.setFocusable(false);
        }
        return this.tfTG;
    }

    private PzTextField getTfRG() {
        if (this.tfRG == null) {
            this.tfRG = new PzTextField();
            this.tfRG.setFont(new Font("Tahoma", 0, 14));
            this.tfRG.setPreferredSize(new Dimension(60, 24));
            this.tfRG.setSize(60, 24);
            this.tfRG.setFocusable(false);
        }
        return this.tfRG;
    }

    private PzTextField getTfProizvodjac() {
        if (this.tfProizvodjac == null) {
            this.tfProizvodjac = new PzTextField();
            this.tfProizvodjac.setFont(new Font("Tahoma", 0, 14));
            this.tfProizvodjac.setPreferredSize(new Dimension(60, 24));
            this.tfProizvodjac.setSize(60, 24);
            this.tfProizvodjac.setFocusable(false);
        }
        return this.tfProizvodjac;
    }

    private PzTextField getTfJedMere() {
        if (this.tfJedMere == null) {
            this.tfJedMere = new PzTextField();
            this.tfJedMere.setFont(new Font("Tahoma", 0, 14));
            this.tfJedMere.setPreferredSize(new Dimension(60, 24));
            this.tfJedMere.setSize(60, 24);
            this.tfJedMere.setFocusable(false);
        }
        return this.tfJedMere;
    }
}

