/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.util;

import java.math.BigDecimal;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;

public class PzProizvodnjaUtil {
    public static BigDecimal getRazlikaUCeni(Kalkulacija k) {
        BigDecimal ukRazlika = new BigDecimal("0.00");
        BigDecimal razlUCeni = null;
        if (k.getArtikalkalkulacijas() == null || k.getArtikalkalkulacijas().size() == 0) {
            return ukRazlika;
        }
        for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
            BigDecimal kolicina = BDConverter.getKolicina((double)ak.getKolicina());
            BigDecimal nabVrednost = ak.calculateNabVrednost();
            if (k.getArtikalkalkulacijas().indexOf(ak) == k.getArtikalkalkulacijas().size() - 1) {
                BigDecimal razl = k.calculateRazlikaTroskova();
                nabVrednost = nabVrednost.add(razl);
            }
            BigDecimal planskaVrednost = BDConverter.getIznos((BigDecimal)(ak.getArtikal().getCenaPlanska() == 0.0 ? new BigDecimal(0.0) : new BigDecimal(ak.getArtikal().getCenaPlanska() * kolicina.doubleValue())));
            razlUCeni = BDConverter.getIznos((BigDecimal)nabVrednost.subtract(planskaVrednost));
            ukRazlika = ukRazlika.add(razlUCeni);
        }
        return ukRazlika;
    }

    public static BigDecimal getNabavnaVrednost(Kalkulacija k) {
        BigDecimal res = new BigDecimal(0);
        if (k.getArtikalkalkulacijas() != null && k.getArtikalkalkulacijas().size() > 0) {
            for (Artikalkalkulacija ak : k.getArtikalkalkulacijas()) {
                BigDecimal nabVrednost = BDConverter.getIznos((BigDecimal)ak.calculateNabCena().multiply(BDConverter.getKolicina((double)ak.getKolicina())));
                res = res.add(nabVrednost);
            }
        }
        return res;
    }
}

