/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.analize.artikli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledPrometa
extends PzDialog {
    public static final String BEZ_OGRANICENJA = "Bez ograni\u010denja";
    public static final String DO_DATUMA = "Do datuma";
    public static final String PREMA_SIFARNIKU = "Prema \u0161ifarniku";
    public static final String PREMA_LAGERU = "Prema lageru";
    public static final String PO_RG = "Po robnoj grupi";
    public static final String CENOVNIK = "cenovnik";
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private JPanel pnlValuta;
    private PzDateField dfKrajnji;
    private PzCalculatedField dfSaldo;
    private PzCalculatedField dfVrednostIzlaza;
    private PzCalculatedField dfVrednostUlaza;
    private JLabel lblSaldo;
    private JLabel lblVrednostIzlaza;
    private JLabel lblVrednostUlaza;
    private JPanel pnlVrednost;
    private PzButton btnOk;
    private PzAbstractTable tblArtikli;
    private JScrollPane scpArtikli;
    private JLabel lblKranji;
    private PzRadioGroup<String> panelRBs;
    private JLabel lblSort;
    private PzPanel pnlIzbor;
    private PzToolBarIcon icnListanje;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;
    private PzComboBox cbValuta;
    private final String parameter;
    private PzTextField tfNazivRg;
    private PzFieldIndikator indRobnaGrupa;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Robnagrupa entRobnaGrupa;

    public PzDialogPregledPrometa(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        this.setEnabledDatum(false);
        if (this.parameter.equals(CENOVNIK)) {
            this.lblVrednostIzlaza.setEnabled(false);
            this.lblVrednostUlaza.setEnabled(false);
            this.lblSaldo.setEnabled(false);
            this.cbValuta.setFocusable(false);
            this.cbValuta.setEnabled(false);
            this.setEnabledRG(false);
        } else {
            this.setEnabledRG(false);
            Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
            Iterator i = q.getResultList().iterator();
            this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
            while (i.hasNext()) {
                Valuta v = (Valuta)i.next();
                this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
            }
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled: PRNC");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{86, 65, 182, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{186, 233, 172, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnListanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnListanje);
            this.icnListanje.setText("Listanje(Alt+S)");
            this.icnListanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_view.png")));
            this.icnListanje.setActionCommand("listanje");
            this.icnListanje.addActionListener((ActionListener)((Object)this));
            this.icnListanje.setShortcut("Alt+S");
            this.pnlIzbor = new PzPanel();
            GridBagLayout pnlIzborLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlIzbor, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlIzborLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlIzborLayout.rowHeights = new int[]{5, 20, 7, 25, 7};
            pnlIzborLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlIzborLayout.columnWidths = new int[]{138, 114, 93, 125, 96, 20, 7};
            this.pnlIzbor.setLayout((LayoutManager)pnlIzborLayout);
            this.lblSort = new JLabel();
            this.pnlIzbor.add((Component)this.lblSort, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSort.setText("Sort: \u0160ifra");
            this.lblSort.setForeground(new Color(0, 0, 255));
            this.lblSort.setFont(new Font("Tahoma", 1, 12));
            this.panelRBs = this.parameter.equals(CENOVNIK) ? new PzRadioGroup((Object[])new String[]{PREMA_SIFARNIKU, PREMA_LAGERU, PO_RG}) : new PzRadioGroup((Object[])new String[]{BEZ_OGRANICENJA, DO_DATUMA});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlIzbor.add(this.panelRBs, (Object)new GridBagConstraints(1, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izbor pregleda"));
            if (this.parameter.equals(CENOVNIK)) {
                this.panelRBs.setSelectedValue((Object)PREMA_SIFARNIKU);
            } else {
                this.panelRBs.setSelectedValue((Object)BEZ_OGRANICENJA);
            }
            this.panelRBs.setOpaque(false);
            this.panelRBs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogPregledPrometa.BEZ_OGRANICENJA)) {
                            PzDialogPregledPrometa.this.setEnabledDatum(false);
                        } else if (evt.getValue().equals(PzDialogPregledPrometa.DO_DATUMA)) {
                            PzDialogPregledPrometa.this.setEnabledDatum(true);
                        } else if (evt.getValue().equals(PzDialogPregledPrometa.PO_RG)) {
                            PzDialogPregledPrometa.this.setEnabledRG(true);
                        } else {
                            PzDialogPregledPrometa.this.setEnabledRG(false);
                        }
                    }
                }
            });
            this.lblKranji = new JLabel();
            this.pnlIzbor.add((Component)this.lblKranji, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblKranji.setText("Krajnji datum");
            this.dfKrajnji = new PzDateField();
            this.pnlIzbor.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.btnOk = new PzButton();
            this.pnlIzbor.add((Component)this.btnOk, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.btnOk.setText("Ok");
            this.btnOk.setActionCommand("ok");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            this.pnlIzbor.add((Component)this.pnlValuta, (Object)new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 0), 0, 0));
            this.pnlValuta.setBorder(BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlValutaLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlValutaLayout.rowHeights = new int[]{15, 27, 7};
            pnlValutaLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlValutaLayout.columnWidths = new int[]{12, 7, 7};
            this.pnlValuta.setLayout(pnlValutaLayout);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblRobnaGrupa = new JLabel();
            this.pnlIzbor.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.lblRobnaGrupa.setName("lblRobnaGrupa");
            this.tfRobnaGrupa = new PzTextField();
            this.pnlIzbor.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.tfRobnaGrupa.setVerifyInput(true);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.pnlIzbor.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.tfNazivRg = new PzTextField();
            this.pnlIzbor.add((Component)this.tfNazivRg, (Object)new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 3, 0), 0, 0));
            this.tfNazivRg.setEditable(false);
            this.tfNazivRg.setFocusable(false);
            this.scpArtikli = new JScrollPane();
            this.mainPanel.add((Component)this.scpArtikli, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.tblArtikli = new PzScrollableTable();
            this.scpArtikli.setViewportView((Component)this.tblArtikli);
            this.pnlVrednost = new PzPanel();
            GridBagLayout pnlVrednostLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlVrednost, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlVrednostLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlVrednostLayout.rowHeights = new int[]{10, 25, 25, 25, 7};
            pnlVrednostLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlVrednostLayout.columnWidths = new int[]{104, 139, 7, 7};
            this.pnlVrednost.setLayout(pnlVrednostLayout);
            this.lblVrednostUlaza = new JLabel();
            this.pnlVrednost.add((Component)this.lblVrednostUlaza, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblVrednostUlaza.setText("Vrednost ulaza");
            this.lblVrednostIzlaza = new JLabel();
            this.pnlVrednost.add((Component)this.lblVrednostIzlaza, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblVrednostIzlaza.setText("Vrednost izlaza");
            this.lblSaldo = new JLabel();
            this.pnlVrednost.add((Component)this.lblSaldo, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSaldo.setText("Saldo");
            this.dfVrednostUlaza = !this.parameter.equals(CENOVNIK) ? this.tblArtikli.createExpresionField("$7$") : new PzCalculatedField();
            this.pnlVrednost.add((Component)this.dfVrednostUlaza, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfVrednostUlaza.setFocusable(false);
            this.dfVrednostUlaza.setEditable(false);
            this.dfVrednostIzlaza = this.parameter.equals(CENOVNIK) ? new PzCalculatedField() : this.tblArtikli.createExpresionField("$8$");
            this.pnlVrednost.add((Component)this.dfVrednostIzlaza, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfVrednostIzlaza.setFocusable(false);
            this.dfVrednostIzlaza.setEditable(false);
            this.dfSaldo = this.parameter.equals(CENOVNIK) ? new PzCalculatedField() : this.tblArtikli.createExpresionField("$9$");
            this.pnlVrednost.add((Component)this.dfSaldo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaldo.setFocusable(false);
            this.dfSaldo.setEditable(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.pack();
            this.setSize(853, 507);
            this.setMinimumSize(new Dimension(745, 507));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("ok")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogPregledPrometa.this.cursor != null) {
                        PzDialogPregledPrometa.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    if (PzDialogPregledPrometa.this.parameter.equals(PzDialogPregledPrometa.CENOVNIK)) {
                        upit = "SELECT DISTINCT s.id.sfrProizvod, a.naziv, a.jedMere, a.robnagrupa.oznRobGr, tg.oznTarGr, CASE WHEN s.radnajedinica.gTip ='V' THEN s.prodCena  ELSE (s.prodCena/(1+tg.stopa/100)) END, CASE WHEN s.radnajedinica.gTip ='V' THEN (s.prodCena*(1+tg.stopa/100)) ELSE s.prodCena  END FROM Stanje s JOIN s.artikal a JOIN s.artikal.tarifnagrupas tg WHERE tg.vrstatg.oznVrstaTG='PDV' and s.radnajedinica=:rj %rgUpit% ORDER BY a.sfrSort";
                        upit = PzDialogPregledPrometa.this.entRobnaGrupa != null ? upit.replace("%rgUpit%", "and a.robnagrupa.oznRobGr='" + PzDialogPregledPrometa.this.entRobnaGrupa.getOznRobGr() + "'") : upit.replace("%rgUpit%", "");
                        q = em.createQuery(upit);
                        q.setParameter("rj", (Object)PzDialogPregledPrometa.this.rj);
                        q.setHint("eclipselink.read-only", (Object)"True");
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    } else {
                        String valuta = PzDialogPregledPrometa.this.cbValuta.getSelectedChoice().getValue().toString();
                        upit = "SELECT a.sfrProizvod, a.naziv, au.jm,rg.oznRobGr, sum(CASE WHEN ((au.vrsta='U' AND d.storno=0) OR (au.vrsta='I' AND d.storno=1))  THEN au.kolicina ELSE 0 END) as ulaznakolicina, sum(CASE WHEN ((au.vrsta='I' AND d.storno=0) OR (au.vrsta='U' AND d.storno=1))  THEN au.kolicina ELSE 0 END) as izlaznakolicina,COALESCE(sum(CASE WHEN ((au.vrsta='U' AND d.storno=0) OR (au.vrsta='I' AND d.storno=1))  THEN au.kolicina ELSE 0 END) - sum(CASE WHEN ((au.vrsta='I' AND d.storno=0) OR (au.vrsta='U' AND d.storno=1))  THEN au.kolicina ELSE 0 END), 0), sum(CASE WHEN ((au.vrsta='U' AND d.storno=0) OR (au.vrsta='I' AND d.storno=1))  THEN (au.kolicina*au.nabCena)%valuta1% ELSE 0 END), sum(CASE WHEN ((au.vrsta='I' AND d.storno=0) OR (au.vrsta='U' AND d.storno=1))  THEN (au.kolicina*au.prodCena)%valuta1% ELSE 0 END), COALESCE(sum(CASE WHEN ((au.vrsta='U' AND d.storno=0) OR (au.vrsta='I' AND d.storno=1))  THEN (au.kolicina*au.nabCena)%valuta1% ELSE 0 END) - sum(CASE WHEN ((au.vrsta='I' AND d.storno=0) OR (au.vrsta='U' AND d.storno=1)) THEN (au.kolicina*au.prodCena)%valuta1% ELSE 0 END), 0) FROM Robnagrupa rg, Radnajedinica rj, (Artikal a LEFT JOIN ArtikalDokument au ON a.sfrProizvod = au.sfrProizvod) LEFT JOIN Dokument d ON au.idDok = d.idDok and d.arhiviran = 1 %valutaF% Where a.oznRobGr = rg.oznRobGr and d.oznRj = rj.oznRj and d.oznOgranak = rj.oznOgranak %valutaW% and rj.oznRj=':oznRj' and rj.oznOgranak=':ogranak' and d.datum >=':datumOd' ";
                        if (((String)PzDialogPregledPrometa.this.panelRBs.getSelectedValue()).equals(PzDialogPregledPrometa.DO_DATUMA)) {
                            upit = String.valueOf(upit) + " and d.datum<=':datumDo'";
                            upit = upit.replace(":datumDo", PzDialogPregledPrometa.this.dfKrajnji.getVal().toString());
                        }
                        upit = String.valueOf(upit) + "GROUP BY a.sfrProizvod, a.naziv, rg.oznRobGr, au.jm ORDER BY CAST(a.sfrProizvod AS NUMERIC)";
                        upit = upit.replace(":datumOd", PzDateUtility.getFirstDayOfCurrentYear().toString());
                        upit = upit.replace(":oznRj", PzDialogPregledPrometa.this.rj.getId().getOznRj());
                        upit = upit.replace(":ogranak", PzDialogPregledPrometa.this.rj.getId().getOznOgranak());
                        upit = upit.replace("%valuta1%", valuta.equals("") ? " " : "/k.srednji/k.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " LEFT JOIN Kurs k ON k.datum = d.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " and k.oznValuta='" + valuta + "'");
                        q = em.createNativeQuery(upit);
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    }
                    PzDialogPregledPrometa.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogPregledPrometa.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            if (PzDialogPregledPrometa.this.cursor != null) {
                                PzDialogPregledPrometa.this.brDok.setText(String.valueOf(PzDialogPregledPrometa.this.cursor.size()));
                                ((PzScrollableTable)PzDialogPregledPrometa.this.tblArtikli).read(PzDialogPregledPrometa.this.cursor, PzDialogPregledPrometa.this.getColumnNames());
                                if (PzDialogPregledPrometa.this.tblArtikli.getRowCount() > 0) {
                                    PzDialogPregledPrometa.this.tblArtikli.setRowSelectionInterval(0, 0);
                                    PzDialogPregledPrometa.this.tblArtikli.requestFocusInWindow();
                                }
                                if (!PzDialogPregledPrometa.this.parameter.equals(PzDialogPregledPrometa.CENOVNIK)) {
                                    PzDialogPregledPrometa.this.tblArtikli.calculateFields();
                                }
                            }
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledPrometa.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                            PzWorkerDialog.hideStatus();
                            em.close();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                        em.close();
                    }
                }
            };
            worker.execute();
            return;
        }
        if (actionCommand.equals("listanje")) {
            try {
                this.showReports();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    public String[] getColumnNames() {
        if (this.parameter.equals(CENOVNIK)) {
            return new String[]{"\u0160ifra", "Naziv", "JM", "Rgr(*)", "Tg", "CenaBP", "CenaSP"};
        }
        return new String[]{"\u0160ifra", "Naziv", "JM", "Rbg(*)", "Koli\u010dina ulaza", "Koli\u010dina izlaza", "Stanje", "Vrednost ulaza", "Vrednost izlaza", "Saldo"};
    }

    private void setEnabledDatum(Boolean enabled) {
        this.lblKranji.setEnabled(enabled);
        this.dfKrajnji.setEditable(enabled.booleanValue());
        this.dfKrajnji.setFocusable(enabled.booleanValue());
    }

    private void setEnabledRG(Boolean enabled) {
        this.lblRobnaGrupa.setEnabled(enabled);
        this.tfRobnaGrupa.setEditable(enabled.booleanValue());
        this.tfRobnaGrupa.setFocusable(enabled.booleanValue());
        this.indRobnaGrupa.setEnabled(enabled.booleanValue());
        if (!enabled.booleanValue()) {
            this.entRobnaGrupa = null;
            this.tfRobnaGrupa.setVal((Object)"");
            this.tfNazivRg.setVal((Object)"");
            this.indRobnaGrupa.setState(PzFieldIndikator.STATE_INVALID);
        }
    }

    private void showReports() throws Exception {
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(this.rj);
        PzTableDataSource ds = new PzTableDataSource(this.tblArtikli, data);
        String title = "";
        String fname = "";
        String valuta = "";
        if (this.parameter.equals(CENOVNIK)) {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.cenovnik.jasper";
            title = "C E N O V N I K";
        } else {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prometa.jasper";
            title = "SPECIFIKACIJA PROMETA ARTIKALA U RJ: " + this.rj.getPunNaziv();
            valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date today = PzDateUtility.getCurrentDate();
        params.put("title", title);
        params.put("datum", today);
        params.put("subtitle", "Sort: \u0160IFRA");
        params.put("reklama", "");
        params.put("valuta", valuta);
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Robnagrupa) {
            this.entRobnaGrupa = (Robnagrupa)entity;
            this.tfRobnaGrupa.setVal((Object)this.entRobnaGrupa.getOznRobGr());
            this.tfNazivRg.setVal((Object)this.entRobnaGrupa.getNaziv());
            this.pnlIzbor.updateAllFieldsState();
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj == null) {
            return false;
        }
        if (this.parameter.equals(CENOVNIK)) {
            this.setTitle("Cenovnik u radnoj jedinici: " + this.rj.getPunNaziv());
        } else {
            this.setTitle("Pregled prometa po artiklima za radnu jedinicu: " + this.rj.getPunNaziv());
        }
        return true;
    }
}

