/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.analize.komitenti;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogPregledPrometaUplata
extends PzDialog {
    public static final String KUPAC = "Kupac";
    public static final String DOBAVLJAC = "Dobavlja\u010d";
    public static final String DETALJAN_PREGLED = "Detaljan pregled";
    public static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private JPanel pnlValuta;
    private PzPanel mainPanel;
    private PzRadioGroup<String> panelRBs1;
    private JButton btnPotvrdi;
    private PzComboBox cbValuta;
    private Radnajedinica rj;
    private final ScrollableCursor cursor = null;
    private String kriterijum;

    public PzDialogPregledPrometaUplata(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled prometa / uplata");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            this.getContentPane().add((Component)this.mainPanel, "Center");
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{20, 84, 11, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0};
            mainPanelLayout.columnWidths = new int[]{100, 121};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(674, 317));
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{KUPAC, DOBAVLJAC});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Grupa"));
            this.panelRBs1.setSelectedValue((Object)KUPAC);
            this.panelRBs1.setOpaque(false);
            this.pnlValuta = new PzPanel();
            this.pnlValuta.setLayout(null);
            this.mainPanel.add((Component)this.pnlValuta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setBorder(BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, "Center");
            this.cbValuta.setBounds(10, 31, 107, 27);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(290, 201);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String upit = "";
        String valuta = this.cbValuta.getSelectedChoice().getValue().toString();
        try {
            if (((String)this.panelRBs1.getSelectedValue()).equals(KUPAC)) {
                upit = "SELECT k.sfrKomitent, k.naziv, SUM((f.iznos-f.stornoIznos)%valuta%), SUM(f.uplata%valuta%), SUM((f.iznos-f.stornoIznos-f.uplata)%valuta%)FROM Komitent k, Radnajedinica rj, Faktura f %valutaF% WHERE %valutaW% f.sfrKomitent=k.sfrKomitent and f.oznRj=rj.oznRj AND f.oznOgranak=rj.oznOgranak and rj.oznRj IN (%listaRj%) and f.arhiviran=1 and f.storno=0 and f.tip IN ('%tipF%','%tipS%', '%tipU%' ) and f.podTip != '%podTip%' ";
                upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
            } else {
                upit = "SELECT k.sfrKomitent, k.naziv, SUM((f.iznos-f.stornoIznos)%valuta%), SUM(f.uplata %valuta%), SUM((f.iznos-f.stornoIznos-f.uplata)%valuta%)FROM Komitent k, Kalkulacija f %valutaF% WHERE %valutaW% f.sfrKomitent=k.sfrKomitent and f.arhiviran=1 and f.storno= 0 and ((f.tip='KALKULACIJA' and (f.podtip='FAKTURA')) or f.tip='TROSAK' or f.tip='RACUN_DOBAVLJACA' or f.tip='ZAPISNIK_OTPREMNICE')";
                upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datum");
            }
            upit = String.valueOf(upit) + "GROUP BY k.sfrKomitent, k.naziv ORDER BY k.sfrKomitent ";
            upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
            upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
            upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
            upit = upit.replace("%tipS%", TipDokumentConfig.get().FAKTURA_SERVISA);
            upit = upit.replace("%tipU%", TipDokumentConfig.get().FAKTURA_USLUGA);
            upit = upit.replace("%podTip%", "POCETNO");
            if (PzDialogRJ.getAvaliableRjString().equals("")) {
                throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
            }
            upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
            String val = this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText();
            this.kriterijum = String.valueOf(upit) + "|" + val;
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            PzWorkerDialog.hideStatus();
        }
    }

    public static String getKriterijum(PzDialog parent) {
        PzDialogPregledPrometaUplata dlg = new PzDialogPregledPrometaUplata(parent);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getKriterijum();
    }

    private String getKriterijum() {
        return this.kriterijum;
    }
}

