/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.garniture;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Garnitura;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogGarnitureIzArhive
extends PzDialog {
    private JToolBar toolbar;
    private PzPanel pnlPretraga;
    private PzButton btnTrazi;
    private PzTextField tfDokument;
    private JLabel lblDokument;
    private PzScrollableTableEntity tabelaGarniture;
    private JScrollPane scrollPane;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnSlikaDok;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;
    private Vector<PzEntity> data;
    private final String parametar;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogGarnitureIzArhive(JFrame frame, String parametar) {
        super(frame);
        this.parametar = parametar;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{99, 66, 166, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{100, 200, 200, 130};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlPretraga = new PzPanel();
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPretraga, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPretragaLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlPretragaLayout.rowHeights = new int[]{17, 26, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{100, 102, 119, 20, 20, 7};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.pnlPretraga.setOpaque(false);
            this.lblDokument = new JLabel();
            this.pnlPretraga.add((Component)this.lblDokument, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.lblDokument.setName("lblDokument");
            this.tfDokument = new PzTextField();
            this.pnlPretraga.add((Component)this.tfDokument, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi = new PzButton();
            this.pnlPretraga.add((Component)this.btnTrazi, (Object)new GridBagConstraints(2, 0, 2, 3, 0.0, 0.0, 10, 3, new Insets(15, 30, 20, 0), 0, 0));
            this.btnTrazi.setText("Tra\u017ei (ENTER)");
            this.btnTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find.png")));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.setBounds(7, 6, 142, 24);
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setShortcut("enter");
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 15), 0, 0));
            this.tabelaGarniture = new PzScrollableTableEntity(Garnitura.class);
            this.scrollPane.setViewportView((Component)this.tabelaGarniture);
            this.tabelaGarniture.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Garnitura dok = (Garnitura)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getIznos()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Dokument", "datum", "Iznos"};
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnSlikaDok = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDok);
            this.icnSlikaDok.setText("Slika|zapisnika(F2)");
            this.icnSlikaDok.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/presentation_chart.png")));
            this.icnSlikaDok.setActionCommand("slika");
            this.icnSlikaDok.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDok.setShortcut("F2");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(664, 630);
            this.setMinimumSize(new Dimension(664, 634));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("trazi")) {
                    if (this.cursor != null) {
                        this.cursor.close();
                    }
                    Query q = null;
                    String upit = "";
                    upit = this.parametar.equals("zapisnik") ? "Select g from Garnitura g Where g.arhiviran=1 and g.radnajedinica=:rj and g.storno=0" : "Select g from Garnitura g Where g.arhiviran=1 and g.radnajedinica=:rj and g.storno=1";
                    if (!this.tfDokument.getVal().equals("")) {
                        upit = String.valueOf(upit) + " and g.oznDokumenta=" + this.tfDokument.getVal();
                    }
                    q = em.createQuery(upit);
                    q.setParameter("rj", (Object)this.rj);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    q.setHint("eclipselink.read-only", (Object)"True");
                    this.cursor = (ScrollableCursor)q.getSingleResult();
                    this.tabelaGarniture.read(this.cursor);
                    this.brDok.setText(Integer.toString(this.cursor.size()));
                    if (this.cursor.size() > 0) {
                        this.tabelaGarniture.setRowSelectionInterval(0, 0);
                        this.tabelaGarniture.requestFocusInWindow();
                    }
                } else if (actionCommand.equals("slika")) {
                    Garnitura zapisnik = (Garnitura)this.tabelaGarniture.getSelectedEntity();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)zapisnik);
                }
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
            if (this.rj != null) {
                if (this.parametar.equals("zapisnik")) {
                    this.setTitle("Pregled zapisnika o formiranju garnitura u RJ: " + this.rj.getId().getOznRj() + " " + this.rj.getNaziv());
                } else {
                    this.setTitle("Pregled zapisnika o demonta\u017ei garnitura u RJ: " + this.rj.getId().getOznRj() + " " + this.rj.getNaziv());
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }
}

