/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.kartica;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;

public class RuleKarticaArtikla {
    public static final byte RULE_DEFAULT = 0;
    public static final byte RULE_1 = 1;
    public static final byte RULE_2 = 2;
    public static final byte RULE_3 = 3;
    public static final int KOLICINA_ULAZ = 1;
    public static final int KOLICINA_IZLAZ = 2;
    public static final int VREDNOST_ULAZ = 3;
    public static final int VREDNOST_IZLAZ = 4;
    public static final int PREMA_PARAMETRU_IZ_BAZE = 5;
    public static final int NERASPOREDJENO = 0;
    public static final int CENA_PROSNABAVNA = 1;
    public static final int CENA_NABAVNA = 2;
    public static final int CENA_NETO = 3;
    public static final int CENA_PRODAJNA = 4;
    public static final int CENA = 5;
    public static final int CENA_NULA = 6;
    private HashMap<String, Integer> rules = new HashMap();
    private HashMap<String, Integer> rulesPrice = new HashMap();
    private Radnajedinica radnaJedinica = null;
    private String tipKartice = null;
    private int tipCenaGlobal = -1;

    public RuleKarticaArtikla(Radnajedinica rj, String tipKartice) throws Exception {
        this.radnaJedinica = rj;
        this.tipKartice = tipKartice;
        this.defaultRule(tipKartice);
        boolean cene = rj.getNacinVodjenja().equals("PRODAJNA");
        this.tipCenaGlobal = !cene ? 1 : 4;
    }

    public RuleKarticaArtikla(Radnajedinica rj, String tipKartice, byte rule) throws Exception {
        this.radnaJedinica = rj;
        this.tipKartice = tipKartice;
        boolean cene = rj.getNacinVodjenja().equals("PRODAJNA");
        this.tipCenaGlobal = !cene ? 1 : 4;
        switch (rule) {
            case 0: {
                this.defaultRule(tipKartice);
                break;
            }
            case 1: {
                this.withOtpremnicaRule(tipKartice);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.defaultRule(tipKartice);
            }
        }
    }

    public HashMap<String, Integer> getRules() {
        return this.rules;
    }

    public HashMap<String, Integer> getPrices() {
        return this.rulesPrice;
    }

    private void defaultRule(String tipCena) {
        this.rules.put(TipDokumentConfig.get().FAKTURA, 2);
        this.rules.put(TipDokumentConfig.get().KALKULACIJA, 1);
        this.rules.put(TipDokumentConfig.get().FISKALNI_RACUN, 2);
        this.rules.put(TipDokumentConfig.get().FAKTURA_SERVISA, 2);
        this.rules.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, 2);
        this.rules.put(TipDokumentConfig.get().UMANJENJE_LAGERA, -1);
        this.rules.put(TipDokumentConfig.get().UVECANJE_LAGERA, 1);
        if (this.radnaJedinica.getTip().startsWith("V") && this.tipKartice.equals("PROSECNA_NABAVNA")) {
            this.rules.put(TipDokumentConfig.get().NIVELACIJA, 0);
            this.rules.put("VREDONOSNA_NIVELACIJA", 0);
        } else {
            this.rules.put(TipDokumentConfig.get().NIVELACIJA, 3);
            this.rules.put("VREDONOSNA_NIVELACIJA", 3);
        }
        this.rules.put(TipDokumentConfig.get().PROMENA_STOPE, 3);
        this.rules.put(TipDokumentConfig.get().INTERNI_NALOG, 5);
        this.rules.put(TipDokumentConfig.get().POVRATNICA, 5);
        this.rules.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, 5);
        this.rules.put(TipDokumentConfig.get().TRANSFER, 5);
        this.rules.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, 5);
        this.rules.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, 5);
        this.rules.put(TipDokumentConfig.get().OTPIS, 2);
        this.rules.put(TipDokumentConfig.get().POPIS, 5);
        this.rules.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, 1);
        this.rules.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, 1);
        this.rules.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, 5);
        this.rules.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, 5);
        this.rules.put(TipDokumentConfig.get().GARNITURA, 5);
        this.rules.put(TipDokumentConfig.get().FISKALNI_IZVESTAJ, 2);
        this.rules.put(TipDokumentConfig.get().DOSTAVNICA, 5);
        this.rules.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, 1);
        this.rules.put(TipDokumentConfig.get().TREBOVANJE, 2);
        this.rules.put(TipDokumentConfig.get().PREDAJNICA, 5);
        this.rules.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, -1);
        this.rules.put(TipDokumentConfig.get().CARINA_PRIJEM, 1);
        this.rules.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, 5);
        this.rules.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, -1);
        if ((this.radnaJedinica.getTip().startsWith("V") || this.radnaJedinica.getTip().startsWith("S")) && this.radnaJedinica.getNacinVodjenja().equals("PRNC")) {
            if (this.tipKartice.equals("PROSECNA_NABAVNA")) {
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_SERVISA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().KALKULACIJA, 2);
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, 1);
                this.rulesPrice.put(TipDokumentConfig.get().INTERNI_NALOG, 1);
                this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().OTPREMNICA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().TRANSFER, 1);
                this.rulesPrice.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, 1);
                this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, 1);
                this.rulesPrice.put(TipDokumentConfig.get().OTPIS, 1);
                this.rulesPrice.put(TipDokumentConfig.get().POPIS, 1);
                this.rulesPrice.put(TipDokumentConfig.get().GARNITURA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().DOSTAVNICA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, 2);
                this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE, 1);
                this.rulesPrice.put(TipDokumentConfig.get().PREDAJNICA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, 1);
                this.rulesPrice.put(TipDokumentConfig.get().CARINA_PRIJEM, 1);
                this.rulesPrice.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, 1);
                this.rulesPrice.put(TipDokumentConfig.get().PROMENA_STOPE, 5);
                this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, 1);
            } else if (this.tipKartice.equals("PRODAJNA")) {
                this.rulesPrice.put(TipDokumentConfig.get().KALKULACIJA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_SERVISA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, 4);
                this.rulesPrice.put(TipDokumentConfig.get().NIVELACIJA, 5);
                this.rulesPrice.put("VREDONOSNA_NIVELACIJA", 6);
                this.rulesPrice.put(TipDokumentConfig.get().INTERNI_NALOG, 4);
                this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().OTPREMNICA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().TRANSFER, 4);
                this.rulesPrice.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, 4);
                this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, 4);
                this.rulesPrice.put(TipDokumentConfig.get().OTPIS, 4);
                this.rulesPrice.put(TipDokumentConfig.get().POPIS, 5);
                this.rulesPrice.put(TipDokumentConfig.get().GARNITURA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().DOSTAVNICA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, 4);
                this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE, 4);
                this.rulesPrice.put(TipDokumentConfig.get().PREDAJNICA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, 4);
                this.rulesPrice.put(TipDokumentConfig.get().CARINA_PRIJEM, 4);
                this.rulesPrice.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, 4);
                this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, 4);
            }
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, 5);
        } else if ((this.radnaJedinica.getTip().startsWith("V") || this.radnaJedinica.getTip().startsWith("S")) && this.radnaJedinica.getNacinVodjenja().equals("PRODAJNA")) {
            this.rulesPrice.put(TipDokumentConfig.get().PROMENA_STOPE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KALKULACIJA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_SERVISA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().UVECANJE_LAGERA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().UMANJENJE_LAGERA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, 4);
            this.rulesPrice.put(TipDokumentConfig.get().NIVELACIJA, 5);
            this.rulesPrice.put("VREDONOSNA_NIVELACIJA", 6);
            this.rulesPrice.put(TipDokumentConfig.get().INTERNI_NALOG, 4);
            this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().OTPREMNICA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().TRANSFER, 4);
            this.rulesPrice.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, 4);
            this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, 4);
            this.rulesPrice.put(TipDokumentConfig.get().OTPIS, 4);
            this.rulesPrice.put(TipDokumentConfig.get().POPIS, 5);
            this.rulesPrice.put(TipDokumentConfig.get().GARNITURA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().DOSTAVNICA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, 4);
            this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE, 4);
            this.rulesPrice.put(TipDokumentConfig.get().PREDAJNICA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, 4);
            this.rulesPrice.put(TipDokumentConfig.get().CARINA_PRIJEM, 4);
            this.rulesPrice.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, 4);
            this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, 4);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, 5);
        } else {
            this.rulesPrice.put(TipDokumentConfig.get().UVECANJE_LAGERA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KALKULACIJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().PROMENA_STOPE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_SERVISA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FISKALNI_RACUN, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_TRANZITA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN, 5);
            this.rulesPrice.put(TipDokumentConfig.get().NIVELACIJA, 5);
            this.rulesPrice.put("VREDONOSNA_NIVELACIJA", 5);
            this.rulesPrice.put(TipDokumentConfig.get().INTERNI_NALOG, 5);
            this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().PRIMO_PREDAJNICA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().OTPIS, 5);
            this.rulesPrice.put(TipDokumentConfig.get().POPIS, 5);
            this.rulesPrice.put(TipDokumentConfig.get().UMANJENJE_LAGERA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().TRANSFER, 5);
            this.rulesPrice.put(TipDokumentConfig.get().OTPREMNICA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().FISKALNI_IZVESTAJ, 5);
            this.rulesPrice.put(TipDokumentConfig.get().DOSTAVNICA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().PRIJEMNICA_REPRO, 5);
            this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().PREDAJNICA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA, 5);
            this.rulesPrice.put(TipDokumentConfig.get().CARINA_PRIJEM, 5);
            this.rulesPrice.put(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE, 5);
            this.rulesPrice.put(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU, 5);
        }
    }

    public Vector<String> getValidDocuments() {
        Vector<String> documents = new Vector<String>();
        Set<String> keys = this.rules.keySet();
        for (String i : keys) {
            if (this.rules.get(i) == 0) continue;
            documents.add(i);
        }
        return documents;
    }

    public String getValidVectorDocumentsString() {
        Vector<String> documents = this.getValidDocuments();
        String temp = "";
        for (String s : documents) {
            temp = String.valueOf(temp) + ",'" + s + "'";
        }
        temp = temp.substring(1, temp.length());
        return temp;
    }

    public static String getDocumentOpis(String documentType, String document, String komitent, Integer redniBroj, Integer storno, Date datumDokumenta, String subtype) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        formatter.format((Object)datumDokumenta);
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_SERVISA)) {
            if (storno != 1) {
                return "Faktura servisa: " + document + ",kupac:" + komitent;
            }
            return "Storno fakture servisa: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_USLUGA)) {
            if (storno != 1) {
                return "Faktura usluga: " + document + ",kupac:" + komitent;
            }
            return "Storno fakture usluga: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA)) {
            if (storno != 1) {
                return "Faktura: " + document + ",kupac:" + komitent;
            }
            return "Storno fakture: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().KALKULACIJA)) {
            if (storno != 1) {
                return "Kalkulacija: " + redniBroj.toString() + ", ra\u010dun: " + document + ", dobav: " + komitent;
            }
            return "Storno kalkulacije: " + redniBroj.toString() + ",dobav: " + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().POPIS)) {
            if (storno != 1) {
                return "Popis: " + document;
            }
            return "Storno popisa: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPIS)) {
            if (storno != 1) {
                return "Otpis: " + document;
            }
            return "Storno otpisa: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_PAZARA)) {
            return "Uplata pazara: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().NIVELACIJA) && !subtype.equals("VREDNOSNA")) {
            return "Nivelacija: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().NIVELACIJA) && subtype.equals("VREDNOSNA")) {
            return "Vrednosna nivelacija: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_PRIHODOM)) {
            return "Zatvori prihodom: " + document + ",komitent:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_RASHODOM)) {
            return "Zatvori rashodom: " + document + ",komitent:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA)) {
            if (storno != 1) {
                return "Knj.zadu\u017e. kupca: " + document + ",kupac: " + komitent;
            }
            return "Storno zadu\u017eenja kupca: " + document + ",kupac: " + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA)) {
            if (storno != 1) {
                return "Knj.odob. kupca: " + document + ",kupac: " + komitent;
            }
            return "Storno odobrenja kupca: " + document + ",kupac: " + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().INTERNI_NALOG)) {
            return "Interni nalog: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PRIMO_PREDAJNICA)) {
            return "Primopredajnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().POVRATNICA)) {
            return "Povratnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().ZADUZENJE_NASE_KONSIGNACIJE)) {
            return "Zadu\u017eeje na\u0161e konsig.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().POVRATNICA_NASE_KONSIGNACIJE)) {
            return "Povratnica na\u0161e konsig.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPREMNICA)) {
            return "Otpremnica: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().OTPIS_POTRAZIVANJA)) {
            return "Otpis potra\u017eivanja: " + document + ", komitent:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_KUPCA)) {
            return "Upl. kupca: " + komitent + ",po dokumentu: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ)) {
            return "Pov. upl.kupca: " + komitent + ",po dokumentu: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN)) {
            if (storno != 1) {
                return "Interni ra\u010dun: " + document;
            }
            return "Storno interni ra\u010dun: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS)) {
            return "Primljen avans,po dok.: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC)) {
            return "Zatvaranje avansom: " + document + ",dobavlja\u010d:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC)) {
            return "Zatvaranje avansom: " + document + ",kupac:" + komitent;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_MALOPRODAJA)) {
            return "Konsignaciona povratnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_POVRATNICA_VELIKOPRODAJA)) {
            return "Konsignaciona povratnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_MALOPRODAJA)) {
            return "Konsignacija prijem: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().KONSIGNACIJA_PRIJEM_VELIKOPRODAJA)) {
            return "Konsignacija prijem: " + document;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_KESH")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ke\u0161: " + document;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ke\u0161: " + document;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_KARTICA")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - kartica: " + document;
            }
            return "Storno Dn. fiskalni izve\u0161taj - kartica: " + document;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_CEK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - \u010dek: " + document;
            }
            return "Storno Dn. fiskalni izve\u0161taj - \u010dek: " + document;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_OSTALO")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ostalo: " + document;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ostalo: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().TRANSFER)) {
            return "Transfer: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().GARNITURA)) {
            return "Garnitura: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ) && storno == 0) {
            return "Fiskalni izve\u0161taj " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ) && storno == 1) {
            return "St.: Fiskalni izve\u0161taj " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().FISKALNI_RACUN) && storno == 0) {
            return "Fiskalni ra\u010dun: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().FISKALNI_RACUN) && storno == 1) {
            return "St:Fiskalni ra\u010dun: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UMANJENJE_LAGERA) && storno == 0) {
            return "Umanjenje lagera: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UMANJENJE_LAGERA) && storno == 1) {
            return "St:Umanjenje lagera: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UVECANJE_LAGERA) && storno == 0) {
            return "Uve\u0107anje lagera: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().UVECANJE_LAGERA) && storno == 1) {
            return "St:Uve\u0107anje lagera: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().DOSTAVNICA) && storno == 0) {
            return "Dostavnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().DOSTAVNICA) && storno == 1) {
            return "St:Dostavnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PRIJEMNICA_REPRO) && storno == 0) {
            return "Prijemnica repromat.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PRIJEMNICA_REPRO) && storno == 1) {
            return "St:Prijemnica repromat.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE) && storno == 0) {
            return "Trebovanje: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE) && storno == 1) {
            return "St.Trebovanje: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PREDAJNICA) && storno == 0) {
            return "Predajnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PREDAJNICA) && storno == 1) {
            return "St.Predajnica: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA) && storno == 0) {
            return "Neispravna isporuka: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().NEISPRAVNA_ISPORUKA) && storno == 1) {
            return "St.Neispravna isporuka: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().CARINA_PRIJEM) && storno == 0) {
            return "Carina prijem: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().CARINA_PRIJEM) && storno == 1) {
            return "St.Carina prijem: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE) && storno == 0) {
            return "Prenosnica sa kons.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().PRENOSNICA_SA_KONSIGNACIJE) && storno == 1) {
            return "St.Prenosnica sa kons.: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU) && storno == 0) {
            return "Trebovanje u gar. roku: " + document;
        }
        if (documentType.equals(TipDokumentConfig.get().TREBOVANJE_U_GARANTNOM_ROKU) && storno == 1) {
            return "St.Trebovanja u gar. roku: " + document;
        }
        return TipDokumentConfig.getNameByValue((String)documentType, null);
    }

    private void withOtpremnicaRule(String tipCena) {
        this.defaultRule(tipCena);
        this.rules.put(TipDokumentConfig.get().OTPREMNICA, 2);
    }
}

