/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista.importListe;

public class ImportUtil {
    public static double similarity(String s1, String s2) {
        int bigLen;
        if (s1.length() < s2.length()) {
            String swap = s1;
            s1 = s2;
            s2 = swap;
        }
        if ((bigLen = s1.length()) == 0) {
            return 1.0;
        }
        return (double)(bigLen - ImportUtil.computeEditDistance(s1, s2)) / (double)bigLen;
    }

    public static int computeEditDistance(String s1, String s2) {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        int[] costs = new int[s2.length() + 1];
        int i = 0;
        while (i <= s1.length()) {
            int lastValue = i;
            int j = 0;
            while (j <= s2.length()) {
                if (i == 0) {
                    costs[j] = j;
                } else if (j > 0) {
                    int newValue = costs[j - 1];
                    if (s1.charAt(i - 1) != s2.charAt(j - 1)) {
                        newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                    }
                    costs[j - 1] = lastValue;
                    lastValue = newValue;
                }
                ++j;
            }
            if (i > 0) {
                costs[s2.length()] = lastValue;
            }
            ++i;
        }
        return costs[s2.length()];
    }

    public static void printDistance(String s1, String s2) {
        System.out.println(String.valueOf(s1) + "-->" + s2 + ": " + ImportUtil.computeEditDistance(s1, s2) + " (" + ImportUtil.similarity(s1, s2) + ")");
    }

    public static void main(String[] args) {
        System.out.println(ImportUtil.similarity("BLATOBRAN 2103 P/L NACALO", "BLATOBRAN 2103 P/L"));
    }
}

