/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista.importListe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogImportLagerListe;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.LagerLista;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.LagerListaStanje;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.component.CriteriaComponent;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PlanImporta
extends PzDialog {
    private static int PARAMETER_OD = -1;
    private static int PARAMETER_DO = -1;
    private static int PARAMETER_STR = -1;
    private JLabel lblStranica;
    private JLabel lblDo;
    private PzPanel pnlPlan;
    private JLabel lblUputstvo;
    private JLabel lblOd;
    private PzPanel pnlGlavni;
    private JPanel pnlButton;
    private JComboBox cbStranica;
    private PzNumericOnlyTextField tfDo;
    private PzNumericOnlyTextField tfOd;
    private PzButton btnPotvrdi;
    boolean comboBox1 = false;
    boolean comboBox2 = false;
    boolean comboBox3 = false;
    boolean comboBox4 = false;
    boolean comboBox5 = false;
    private JScrollPane jspPlanImporta;
    private static PzPanel pnlPlanImporta;
    private JPanel pnlRang;
    private final PzScrollableTableEntity tableLista;
    private FileInputStream inp;
    private File file;
    private POIFSFileSystem fsFileSystem;
    private JPanel pnlUputstvo;
    private Workbook workBook;
    private Artikal al = null;
    private final PzDialogImportLagerListe dlg;
    private CriteriaComponent criteriaPlanImporta;
    private final Radnajedinica rj;
    private static Object[][] niz;

    public PlanImporta(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.rj = (Radnajedinica)this.getSession().getParameter("rj");
        this.tableLista = (PzScrollableTableEntity)this.getSession().getParameter("table_lista");
        this.dlg = (PzDialogImportLagerListe)((Object)this.getSession().getParameter("dlg"));
        niz = this.createCriteriasOpsti();
        this.postInit();
    }

    private void postInit() {
        try {
            this.initParameters();
            this.file = (File)this.getSession().getParameter("file");
            this.workBook = Workbook.getWorkbook((File)this.file);
            int i = 0;
            while (i <= this.workBook.getNumberOfSheets()) {
                if (i == 0) {
                    this.cbStranica.addItem(new PzChoice("", (Object)i));
                } else {
                    this.cbStranica.addItem(new PzChoice(Integer.toString(i), (Object)i));
                }
                ++i;
            }
            i = 1;
            while (i < niz.length) {
                this.criteriaPlanImporta = new CriteriaComponent();
                this.criteriaPlanImporta.setCriterias(this.getCriteriaOpsti(0));
                if (this.getCriteriaOpstiInt(5)[i] == 1) {
                    this.criteriaPlanImporta.setCriteria(this.getCriteriaOpsti(0)[i]);
                    this.criteriaPlanImporta.setEnabled(false);
                }
                pnlPlanImporta.add((Component)((Object)this.criteriaPlanImporta));
                this.criteriaPlanImporta.setPreferredSize(new Dimension(287, 35));
                this.criteriaPlanImporta.setName("criteriaPlanImporta");
                ++i;
            }
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BiffException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Plan uvoza");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{74, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.pnlUputstvo = new JPanel();
            GridBagLayout pnlUputstvoLayout = new GridBagLayout();
            pnlUputstvoLayout.rowWeights = new double[]{0.1};
            pnlUputstvoLayout.rowHeights = new int[]{7};
            pnlUputstvoLayout.columnWeights = new double[]{0.1};
            pnlUputstvoLayout.columnWidths = new int[]{7};
            this.pnlGlavni.add((Component)this.pnlUputstvo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            TitledBorder border = BorderFactory.createTitledBorder("Uputstvo:");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlUputstvo.setBorder(border);
            this.pnlUputstvo.setLayout(pnlUputstvoLayout);
            this.pnlUputstvo.setOpaque(false);
            this.lblUputstvo = new JLabel();
            this.pnlUputstvo.add((Component)this.lblUputstvo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUputstvo.setText("<Html>Dijalog slu\u017ei za definisanje uvoza podataka iz excela.<br>Korisnik iz padaju\u0107e liste bira polje a zatim unosi slovo ili broj kolone u kojoj se podaci za izabrano polje nalaze.<br>Korisnik tako\u0111e bira list i red od kog \u0107e po\u010deti \u010ditanje podataka. Red do kog se podaci \u010ditaju je opcioni.</html>");
            this.lblUputstvo.setForeground(new Color(0, 0, 255));
            this.lblUputstvo.setFont(new Font("Tahoma", 0, 12));
            this.pnlPlan = new PzPanel();
            GridBagLayout pnlPlanLayout = new GridBagLayout();
            pnlPlanLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlPlanLayout.rowHeights = new int[]{108, 31, 20};
            pnlPlanLayout.columnWeights = new double[]{0.1, 0.0};
            pnlPlanLayout.columnWidths = new int[]{7, 7};
            this.pnlGlavni.add((Component)this.pnlPlan, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.pnlPlan.setLayout((LayoutManager)pnlPlanLayout);
            this.pnlPlan.setOpaque(false);
            this.jspPlanImporta = new JScrollPane();
            this.pnlPlan.add((Component)this.jspPlanImporta, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            border = BorderFactory.createTitledBorder("Izbor polja i kolona");
            border.setTitleFont(new Font("Tahoma", 0, 12));
            this.jspPlanImporta.setBorder(border);
            this.jspPlanImporta.setOpaque(false);
            this.jspPlanImporta.setBackground(Color.WHITE);
            pnlPlanImporta = new PzPanel();
            this.jspPlanImporta.setViewportView((Component)pnlPlanImporta);
            pnlPlanImporta.setLayout((LayoutManager)new VerticalLayout());
            pnlPlanImporta.setName("pnlPlanImporta");
            this.pnlRang = new JPanel();
            GridBagLayout pnlRangLayout = new GridBagLayout();
            this.pnlPlan.add((Component)this.pnlRang, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
            pnlRangLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlRangLayout.rowHeights = new int[]{25, 25, 25};
            pnlRangLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlRangLayout.columnWidths = new int[]{58, 40, 44, 45};
            this.pnlRang.setLayout(pnlRangLayout);
            TitledBorder border2 = BorderFactory.createTitledBorder("Izbor lista i rang redova");
            border2.setTitleFont(new Font("Tahoma", 0, 12));
            this.pnlRang.setBorder(border2);
            this.pnlRang.setOpaque(false);
            this.lblOd = new JLabel();
            this.pnlRang.add((Component)this.lblOd, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblOd.setText("Od reda");
            this.tfOd = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfOd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfOd.setVerifyInput(true);
            this.tfOd.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PlanImporta.this.tfOd.getIntVal() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)PlanImporta.this), "Niste unijeli po\u010detni red podataka", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.lblDo = new JLabel();
            this.pnlRang.add((Component)this.lblDo, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblDo.setText("Do reda");
            this.tfDo = new PzNumericOnlyTextField();
            this.pnlRang.add((Component)this.tfDo, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 5), 0, 0));
            this.tfDo.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    return true;
                }
            });
            this.lblStranica = new JLabel();
            this.pnlRang.add((Component)this.lblStranica, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblStranica.setText("List");
            this.cbStranica = new JComboBox();
            this.pnlRang.add((Component)this.cbStranica, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.cbStranica.setVerifyInputWhenFocusTarget(true);
            this.cbStranica.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PlanImporta.this.cbStranica.getSelectedIndex() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)PlanImporta.this), "Molim izaberite stranicu!", "Informacija", 1);
                        return false;
                    }
                    PlanImporta.this.cbItemStateChanged();
                    return true;
                }
            });
            this.pnlButton = new JPanel();
            BorderLayout pnlButtonLayout = new BorderLayout();
            this.pnlButton.setLayout(pnlButtonLayout);
            this.pnlPlan.add((Component)this.pnlButton, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 2, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, "Center");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(128, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setRestorable(false);
            this.setSize(635, 401);
            this.setMinimumSize(new Dimension(635, 401));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        final ArrayList lagerLista = new ArrayList();
        if (actionCommand.equals("potvrdi")) {
            this.initParameters();
            if (this.checkAllFields()) {
                this.setColumnValue(2);
                PzWorkerDialog.showStatus((String)"Uvoz artikala je u toku. Molim sa\u010dekajte.", (PzDialog)this);
                SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        int i = 0;
                        try {
                            em.getTransaction().begin();
                            Sheet sheet = PlanImporta.this.workBook.getSheet(PARAMETER_STR);
                            if (sheet.getRows() != 0) {
                                if (PARAMETER_DO == -1) {
                                    PARAMETER_DO = sheet.getRows();
                                }
                                System.out.println("Parametar do je:" + PARAMETER_DO);
                                int j = PARAMETER_OD;
                                while (j <= PARAMETER_DO) {
                                    if (j != sheet.getRows()) {
                                        Cell[] row = sheet.getRow(j);
                                        if (row.length != 0) {
                                            Artikal a = PlanImporta.this.createArtikal(row, em);
                                            LagerListaStanje stanje = PlanImporta.this.getLagerListaStanje(a.getSfrProizvod(), em);
                                            LagerLista ll = new LagerLista();
                                            ll.setArtikal(a);
                                            ll.setLgStanje(stanje);
                                            lagerLista.add(ll);
                                            ++i;
                                        } else {
                                            int red = j + 1;
                                            throw new PzInfoException("Informacija! Red " + red + " je prazan");
                                        }
                                        ++j;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                throw new PzInfoException("Informacija! List je prazan!");
                            }
                            em.getTransaction().commit();
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            throw e1;
                        }
                        return i;
                    }

                    @Override
                    protected void done() {
                        try {
                            try {
                                Integer cfr_ignored_0 = (Integer)this.get();
                                PlanImporta.this.getSession().putParameter("import", (Object)false);
                                PlanImporta.this.dlg.loadTable(lagerLista);
                                PlanImporta.this.initParameters();
                                PlanImporta.this.dispose();
                            }
                            catch (InterruptedException e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PlanImporta.this), (Throwable)e);
                                em.close();
                                PlanImporta.this.initParameters();
                                PzWorkerDialog.hideStatus();
                            }
                            catch (ExecutionException e) {
                                block9: {
                                    if (e.getCause() instanceof PzInfoException) {
                                        PzSwingUtility.showErrorMessage((Component)((Object)PlanImporta.this), (String)e.getMessage());
                                        break block9;
                                    }
                                    PzMysqlExceptionHandler.handle((Component)((Object)PlanImporta.this), (Throwable)e);
                                }
                                em.close();
                                PlanImporta.this.initParameters();
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            em.close();
                            PlanImporta.this.initParameters();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                };
                sw.execute();
            }
        }
    }

    private LagerListaStanje getLagerListaStanje(String sifra, EntityManager em) {
        LagerListaStanje stanje = null;
        try {
            String upit = "Select s.id.sfrProizvod, s.naziv, s.jedMere, t.oznTarGr, s.oznRobGr, s.kolicina, s.prodCena From Stanjeartikal s,  Artikal a join a.tarifnagrupas t where t.vrstatg.oznVrstaTG='PDV' AND a.sfrProizvod=s.id.sfrProizvod and s.id.oznRj='" + this.rj.getId().getOznRj() + "' and s.id.oznOgranak='" + this.rj.getId().getOznOgranak() + "' " + "and s.id.sfrProizvod = '" + sifra + "' ";
            System.out.println(upit);
            List rez = em.createQuery(upit).getResultList();
            if (rez.size() != 0) {
                int i = 0;
                while (i < rez.size()) {
                    Object[] o = (Object[])rez.get(i);
                    stanje = new LagerListaStanje();
                    stanje.setSfrProizvod((String)o[0]);
                    stanje.setNaziv((String)o[1]);
                    stanje.setJm((String)o[2]);
                    stanje.setOznTarGr((String)o[3]);
                    stanje.setOznRobGr((String)o[4]);
                    stanje.setKolicina(new Double(o[5].toString()));
                    stanje.setCena(new Double(o[6].toString()));
                    ++i;
                }
            }
            return stanje;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean existsArtikal() {
        boolean rez = true;
        try {
            Sheet sheet = this.workBook.getSheet(PARAMETER_STR);
            if (sheet.getRows() == 0) throw new PzInfoException("Informacija! List je prazan!");
            if (PARAMETER_DO == -1) {
                PARAMETER_DO = sheet.getRows();
            }
            System.out.println("Parametar do je:" + PARAMETER_DO);
            int j = PARAMETER_OD;
            while (j <= PARAMETER_DO) {
                if (j == sheet.getRows()) return rez;
                Cell[] row = sheet.getRow(j);
                if (row.length != 0) {
                    int pozicija = this.getPozicija("\u0160ifra");
                    if (this.getCriteriaOpstiInt(2)[pozicija] != -1) {
                        System.out.println("Polje je: " + this.getCriteriaOpsti(0)[pozicija]);
                        System.out.println("Kolona je: " + this.getCriteriaOpstiInt(2)[pozicija]);
                        System.out.println("Vrednost celije je: " + row[this.getCriteriaOpstiInt(2)[pozicija]].getContents());
                        int red = row[this.getCriteriaOpstiInt(2)[pozicija]].getRow() + 1;
                        System.out.println("Red je: " + red);
                        if (this.getCriteriaOpstiInt(2)[pozicija] > row.length) {
                            throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[pozicija] + " nije dobro definisana! ");
                        }
                        if (row[this.getCriteriaOpstiInt(2)[pozicija]].getType() == CellType.EMPTY) {
                            throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[pozicija] + " je prazna. Red " + red + ".");
                        }
                        if (this.getCriteriaOpsti(3)[pozicija].equals("STRING") && row[this.getCriteriaOpstiInt(2)[pozicija]].getContents().length() > this.getCriteriaOpstiInt(4)[pozicija]) {
                            throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[pozicija] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[pozicija] + " ima " + this.getCriteriaOpstiInt(4)[pozicija] + " karaktera");
                        }
                        Artikal a = (Artikal)PzEntityManager.find(Artikal.class, (Object)row[this.getCriteriaOpstiInt(2)[pozicija]].getContents());
                        if (a != null) throw new PzInfoException("Artikal " + row[this.getCriteriaOpstiInt(2)[pozicija]].getContents() + " vec postoji u bazi. Red " + red);
                        rez = false;
                    }
                } else {
                    int red = j + 1;
                    throw new PzInfoException("Informacija! Red " + red + " je prazan");
                }
                ++j;
            }
            return rez;
        }
        catch (PzInfoException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return rez;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return rez;
        }
    }

    private Artikal createArtikal(Cell[] row, EntityManager em) throws PzInfoException, IllegalAccessException, InvocationTargetException {
        this.al = new Artikal();
        this.al.setTarifnagrupas(new ArrayList());
        int j = 1;
        while (j < niz.length) {
            if (this.getCriteriaOpstiInt(2)[j] != -1) {
                if (this.getCriteriaOpstiInt(2)[j] > row.length) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " nije dobro definisana! ");
                }
                int red = row[this.getCriteriaOpstiInt(2)[j]].getRow() + 1;
                if (row[this.getCriteriaOpstiInt(2)[j]].getType() == CellType.EMPTY) {
                    throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[j] + " je prazna. Red " + red + ".");
                }
                if (this.getCriteriaOpsti(3)[j].equals("STRING")) {
                    if (row[this.getCriteriaOpstiInt(2)[j]].getContents().length() > this.getCriteriaOpstiInt(4)[j]) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu je preduga\u010dka. Polje " + this.getCriteriaOpsti(0)[j] + " ima " + this.getCriteriaOpstiInt(4)[j] + " karaktera");
                    }
                    BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)row[this.getCriteriaOpstiInt(2)[j]].getContents());
                } else if (this.getCriteriaOpsti(3)[j].equals("DOUBLE") || this.getCriteriaOpsti(3)[j].equals("BIG_DECIMAL")) {
                    try {
                        double broj = this.getDouble(row[this.getCriteriaOpstiInt(2)[j]].getContents());
                        BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                    }
                    catch (ParseException parseException) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                } else if (this.getCriteriaOpsti(3)[j].equals("INTEGER")) {
                    try {
                        int broj = this.getInteger(row[this.getCriteriaOpstiInt(2)[j]].getContents());
                        BeanUtils.setProperty((Object)this.al, (String)this.getCriteriaOpsti(1)[j], (Object)broj);
                    }
                    catch (ParseException parseException) {
                        throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[j] + " u " + red + ". redu nije broj. ");
                    }
                } else if (this.getCriteriaOpsti(3)[j].equals("OBJECT")) {
                    if (this.getCriteriaOpsti(1)[j].equals("TG")) {
                        String tg = row[this.getCriteriaOpstiInt(2)[j]].getContents();
                        Tarifnagrupa tgr = (Tarifnagrupa)em.find(Tarifnagrupa.class, (Object)tg);
                        if (tgr == null) {
                            throw new PzInfoException("Gre\u0161ka! Tarigna grupa " + row[this.getCriteriaOpstiInt(2)[j]].getContents() + " ne postoji u bazi. Red " + red + ".");
                        }
                        this.al.getTarifnagrupas().add(tgr);
                    }
                    if (this.getCriteriaOpsti(1)[j].equals("RG")) {
                        String rg = row[this.getCriteriaOpstiInt(2)[j]].getContents();
                        Robnagrupa rgr = (Robnagrupa)em.find(Robnagrupa.class, (Object)rg);
                        if (rgr == null) {
                            throw new PzInfoException("Gre\u0161ka! Robna grupa " + row[this.getCriteriaOpstiInt(2)[j]].getContents() + " ne postoji u bazi. Red " + red + ".");
                        }
                        this.al.setRobnagrupa(rgr);
                    }
                }
            }
            ++j;
        }
        Proizvod proizvod = new Proizvod(this.al.getSfrProizvod());
        this.al.setProizvod(proizvod);
        return this.al;
    }

    public static boolean checkComboBox(int index) {
        boolean rez = false;
        boolean prvi = false;
        int len = pnlPlanImporta.getComponents().length;
        CriteriaComponent[] komponente = new CriteriaComponent[len + 1];
        int i = 1;
        while (i <= len) {
            komponente[i] = (CriteriaComponent)((Object)pnlPlanImporta.getComponents()[i - 1]);
            ++i;
        }
        i = 1;
        while (i < komponente.length) {
            System.out.println(komponente[i].getChoice());
            System.out.println(komponente[i].getText());
            if (komponente[i].getChoice() == index) {
                if (prvi) {
                    rez = true;
                } else {
                    prvi = true;
                }
            }
            ++i;
        }
        return rez;
    }

    public static boolean checkTextField(int val, int index) {
        boolean rez = false;
        boolean prvi = false;
        int len = pnlPlanImporta.getComponents().length;
        CriteriaComponent[] komponente = new CriteriaComponent[len + 1];
        int i = 1;
        while (i <= len) {
            komponente[i] = (CriteriaComponent)((Object)pnlPlanImporta.getComponents()[i - 1]);
            ++i;
        }
        i = 1;
        while (i < komponente.length) {
            if (komponente[i].getFieldValue() == val) {
                if (prvi) {
                    rez = true;
                } else {
                    prvi = true;
                }
            }
            ++i;
        }
        return rez;
    }

    private void setColumnValue(int kolona) {
        this.cbItemStateChanged();
        PARAMETER_DO += this.tfDo.getIntVal();
        PARAMETER_OD += this.tfOd.getIntVal();
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            PlanImporta.niz[((CriteriaComponent)((Object)komponente[i])).getChoice()][kolona] = ((CriteriaComponent)((Object)komponente[i])).getFieldValue();
            ++i;
        }
    }

    private boolean checkAllFields() {
        boolean rez = true;
        Component[] komponente = pnlPlanImporta.getComponents();
        int i = 0;
        while (i < komponente.length) {
            if (!((CriteriaComponent)((Object)komponente[i])).isValidComponent()) {
                rez = false;
                JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli sva polja", "Informacija", 1);
                break;
            }
            ++i;
        }
        if (rez && this.cbStranica.getSelectedIndex() == 0) {
            rez = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Niste izabrali list", "Informacija", 1);
        }
        if (rez && this.tfOd.getIntVal() == 0) {
            rez = false;
            JOptionPane.showMessageDialog((Component)((Object)this), "Niste uneli po\u010detni red podataka", "Informacija", 1);
        }
        return rez;
    }

    public String[] getCriteriaOpsti(int x) {
        int len = niz.length;
        Object[][] array = niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = niz.length;
        Object[][] array = niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int getPozicija(String polje) {
        int len = niz.length;
        Object[][] array = niz;
        int pozicija = 0;
        int i = 0;
        while (i < len) {
            if (array[i][0].equals(polje)) {
                pozicija = i;
            }
            ++i;
        }
        return pozicija;
    }

    private Object[][] createCriteriasOpsti() {
        return new Object[][]{{"", "", -1, "", 0, 0}, {"\u0160ifra", "sfrProizvod", -1, "STRING", 255, 1}, {"Naziv", "naziv", -1, "STRING", 255, 1}, {"Jedinica mere", "jedMere", -1, "STRING", 255, 1}, {"Tarifna grupa", "TG", -1, "OBJECT", 255, 1}, {"Robna grupa", "RG", -1, "OBJECT", 255, 1}, {"Koli\u010dina", "kolicina", -1, "BIG_DECIMAL", 0, 1}, {"Cena bazna", "cenaBazna", -1, "DOUBLE", 0, 1}};
    }

    public static void setChoice(int index, int kolona, int val) {
        PlanImporta.niz[index][kolona] = val;
    }

    private void initParameters() {
        PARAMETER_OD = -1;
        PARAMETER_DO = -1;
        PARAMETER_STR = -1;
        int i = 0;
        while (i < niz.length) {
            PlanImporta.setChoice(i, 2, -1);
            ++i;
        }
    }

    private void cbItemStateChanged() {
        PARAMETER_STR = -1;
        PARAMETER_STR += Integer.parseInt(this.cbStranica.getSelectedItem().toString());
    }

    public double getDouble(String input) throws ParseException {
        try {
            double broj = new DecimalFormat("###,###.##").parse(input).doubleValue();
            return broj;
        }
        catch (Exception exception) {
            throw new ParseException("Los format realnog broja: " + input, 0);
        }
    }

    public int getInteger(String input) throws ParseException {
        try {
            int broj = Integer.parseInt(input);
            return broj;
        }
        catch (Exception exception) {
            throw new ParseException("Los format celog broja: " + input, 0);
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
        public static final String T_OBJECT = "OBJECT";
    }
}

