/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.popis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.gui.artikli.popis.PzDialogPopis;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Popis;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzBarcodeParser;
import rs.pezar.util.PzMathUtility;

public class Dodavanje
extends PzDialogInsert {
    private PzPanel mainPanel;
    private PzPanel pnlNorth;
    private JLabel tgSA;
    private JLabel nazivSA;
    private JLabel tgNA;
    private JLabel nazivNA;
    private PzTextField sifraArtikla;
    private PzTextField txtNaziv;
    private JLabel jLabel7;
    private PzButton btnOk;
    private PzDoubleField knjigovodstvenaKol;
    private PzDoubleField knjigovodstvenaCena;
    private PzDoubleField kolicinaPopis;
    private PzDoubleField cenaPopis;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private PzPanel pnlButtons;
    private PzPanelHeader header;
    private Popis popis;
    private Artikalopstidokument artpopis;
    private Artikalopstidokument artpopisStari;
    private Stanjeartikal artikal;
    private Stanje stanjeIzlaz;
    private double prethodnaKolicina;
    private double prethodnaUlCena;
    private double prethodniPDV;
    private boolean izmena;
    private Artikal art;
    private String jedMere;
    private String nacin;
    private PzBarcodeParser barcodeParser;
    private static final String POPIS_NACIN = "POPIS_NACIN";
    private static final String POPIS_NACIN_SIFRA = "SIFRA";
    private static final String POPIS_NACIN_BARKOD = "BARKOD";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.popis = (Popis)this.getSession().getParameter("popis");
        this.sifraArtikla.setParamToPass((Object)this.popis.getRadnajedinica());
        this.izmena = (Boolean)this.getSession().getParameter("update");
        try {
            if (this.popis.getRadnajedinica().getgTip().equals("V") && this.popis.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                this.cenaPopis.setEnabled(false);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void initGUI() {
        try {
            this.setTitle("DODAVANJE");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout pnlMainLayout = new GridBagLayout();
            pnlMainLayout.columnWidths = new int[]{7};
            pnlMainLayout.rowHeights = new int[]{7, 264, 3};
            pnlMainLayout.columnWeights = new double[]{0.1};
            pnlMainLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)pnlMainLayout);
            this.mainPanel.setPreferredSize(new Dimension(439, 371));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setPreferredSize(new Dimension(341, 70));
            this.header.setOpaque(false);
            this.pnlNorth = new PzPanel();
            GridBagLayout pnlNorthLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlNorth, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            pnlNorthLayout.rowWeights = new double[]{0.0, 0.1, 0.0, 0.0, 0.0, 0.0};
            pnlNorthLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            int[] nArray = new int[4];
            nArray[2] = 9;
            nArray[3] = 20;
            pnlNorthLayout.columnWidths = nArray;
            pnlNorthLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
            this.pnlNorth.setLayout((LayoutManager)pnlNorthLayout);
            this.pnlNorth.setOpaque(false);
            this.pnlNorth.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.tgSA = new JLabel();
            this.pnlNorth.add((Component)this.tgSA, (Object)new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.tgSA.setText("");
            this.nazivSA = new JLabel();
            this.pnlNorth.add((Component)this.nazivSA, (Object)new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.nazivSA.setText("");
            this.nazivNA = new JLabel();
            this.pnlNorth.add((Component)this.nazivNA, (Object)new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.nazivNA.setText("");
            this.tgNA = new JLabel();
            this.pnlNorth.add((Component)this.tgNA, (Object)new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.tgNA.setText("");
            this.jLabel10 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel10, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel10.setText("Cena na popisu");
            this.knjigovodstvenaKol = new PzDoubleField();
            this.pnlNorth.add((Component)this.knjigovodstvenaKol, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.knjigovodstvenaKol.setPreferredSize(new Dimension(100, 24));
            this.knjigovodstvenaKol.setEditable(false);
            this.knjigovodstvenaKol.setFocusable(false);
            this.knjigovodstvenaCena = new PzDoubleField();
            this.pnlNorth.add((Component)this.knjigovodstvenaCena, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.knjigovodstvenaCena.setPreferredSize(new Dimension(100, 24));
            this.knjigovodstvenaCena.setEditable(false);
            this.knjigovodstvenaCena.setFocusable(false);
            this.kolicinaPopis = new PzDoubleField();
            this.pnlNorth.add((Component)this.kolicinaPopis, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.kolicinaPopis.setPreferredSize(new Dimension(100, 24));
            this.cenaPopis = new PzDoubleField();
            this.pnlNorth.add((Component)this.cenaPopis, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.cenaPopis.setPreferredSize(new Dimension(100, 24));
            this.jLabel7 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel7, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel7.setText("\u0160ifra");
            this.sifraArtikla = new PzTextField();
            this.pnlNorth.add((Component)this.sifraArtikla, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.sifraArtikla.setPreferredSize(new Dimension(60, 24));
            this.sifraArtikla.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.jLabel1 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel1.setText("Knjigovodstvena koli\u010dina");
            this.jLabel8 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel8, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel8.setText("Knjigovodstvena cena");
            this.jLabel9 = new JLabel();
            this.pnlNorth.add((Component)this.jLabel9, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel9.setText("Koli\u010dina na popisu");
            this.txtNaziv = new PzTextField();
            this.txtNaziv.setEditable(false);
            this.txtNaziv.setFocusable(false);
            this.pnlNorth.add((Component)this.txtNaziv, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.pnlButtons = new PzPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(-60, 0, 0, 0), 0, 0));
            this.pnlButtons.setLayout((LayoutManager)pnlButtonsLayout);
            this.pnlButtons.setOpaque(false);
            this.btnOk = new PzButton();
            this.pnlButtons.add((Component)this.btnOk, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnOk.setSize(100, 40);
            this.btnOk.setPreferredSize(new Dimension(130, 33));
            this.btnOk.addActionListener((ActionListener)((Object)this));
            pnlButtonsLayout.rowWeights = new double[]{0.1};
            pnlButtonsLayout.rowHeights = new int[]{7};
            pnlButtonsLayout.columnWeights = new double[]{0.0};
            pnlButtonsLayout.columnWidths = new int[]{439};
            this.nacin = PzParameter.getParameterValue((String)POPIS_NACIN, (String)POPIS_NACIN_SIFRA);
            this.barcodeParser = new PzBarcodeParser();
            this.barcodeParser.loadSettingsFromDB();
            this.setDependentEntityChecker();
            this.pack();
            this.setRestorable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        PzEntityUtil.currentType = "POPIS";
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("insert")) {
            try {
                Vector vd = PzEntityManager.select((String)("Select a from Artikalopstidokument a where a.id.sfrProizvod='" + this.artikal.getId().getSfrProizvod() + "' and a.id.idDok=" + this.popis.getIdDok()));
                if (vd.size() > 0) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Artikal ve\u0107 postoji na popisu");
                    return;
                }
                try {
                    this.stanjeIzlaz = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(this.artikal.getId().getSfrProizvod(), this.popis.getRadnajedinica()));
                    if (this.stanjeIzlaz == null) {
                        if (this.popis.getRadnajedinica().getgTip().equals("V") && this.popis.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Za tra\u017eeni artikal nije definisana prose\u010dna nabavna cena.");
                            return;
                        }
                    } else if (this.stanjeIzlaz.getProsNabCena().doubleValue() == 0.0 && this.popis.getRadnajedinica().getgTip().equals("V") && this.popis.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Tra\u017eeni artikal NEMA DEFINISANU prose\u010dnu nabavnu cenu.");
                        return;
                    }
                    em.getTransaction().begin();
                    Popis p = (Popis)em.find(Popis.class, (Object)this.popis.getIdDok());
                    Artikalopstidokument artpopis = new Artikalopstidokument();
                    artpopis.init(this.artikal, (PzDokument)this.popis);
                    artpopis.setKolicina(this.kolicinaPopis.getVal().doubleValue());
                    artpopis.setKolicinaBaza(this.knjigovodstvenaKol.getVal().doubleValue());
                    artpopis.setJm(this.jedMere);
                    artpopis.setProcRabata(0.0);
                    artpopis.setCenaBezPoreza(this.knjigovodstvenaCena.getVal().doubleValue());
                    artpopis.setCenaSaPorezom(this.cenaPopis.getVal().doubleValue());
                    ((PzScrollableTableEntity)this.getSession().getParameter("table")).insert((PzEntity)artpopis, em);
                    if (artpopis.getKolicina() - artpopis.getKolicinaBaza() > 0.0) {
                        p.setVisak(p.getVisak().add(PzMathUtility.roundToBigDecimal((double)((artpopis.getKolicina() - artpopis.getKolicinaBaza()) * artpopis.getCenaSaPorezom()))));
                    } else {
                        p.setManjak(p.getManjak().add(PzMathUtility.roundToBigDecimal((double)((artpopis.getKolicinaBaza() - artpopis.getKolicina()) * artpopis.getCenaSaPorezom()))));
                    }
                    p.setVrednostPopisa(p.getVrednostPopisa().add(PzMathUtility.roundToBigDecimal((double)(artpopis.getKolicina() * artpopis.getCenaSaPorezom()))));
                    em.getTransaction().commit();
                    ((PzScrollableTableEntity)this.getSession().getParameter("table")).commitInsert();
                    this.popis.setVisak(p.getVisak());
                    this.popis.setManjak(p.getManjak());
                    this.popis.setVrednostPopisa(p.getVrednostPopisa());
                    this.dispose();
                    ((PzDialogPopis)this.getParentDialog()).runDodavanje();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                return;
            }
            finally {
                em.close();
            }
        }
        if (!actionCommand.equals("update")) return;
        try {
            try {
                Artikalopstidokument at = (Artikalopstidokument)((PzScrollableTableEntity)this.getSession().getParameter("table")).getSelectedEntity();
                BigDecimal prethodniVisak = new BigDecimal(0);
                BigDecimal prethodniManjak = new BigDecimal(0);
                BigDecimal prethodnaVrednost = new BigDecimal(0);
                if (at.getKolicina() - at.getKolicinaBaza() > 0.0) {
                    prethodniVisak = PzMathUtility.roundToBigDecimal((double)((at.getKolicina() - at.getKolicinaBaza()) * at.getCenaSaPorezom()));
                } else {
                    prethodniManjak = PzMathUtility.roundToBigDecimal((double)((at.getKolicinaBaza() - at.getKolicina()) * at.getCenaSaPorezom()));
                }
                prethodnaVrednost = PzMathUtility.roundToBigDecimal((double)(at.getKolicina() * at.getCenaSaPorezom()));
                at.setCenaSaPorezom(this.cenaPopis.getVal().doubleValue());
                at.setKolicina(this.kolicinaPopis.getVal().doubleValue());
                em.getTransaction().begin();
                Popis p = (Popis)em.find(Popis.class, (Object)this.popis.getIdDok());
                p.setVisak(p.getVisak().subtract(prethodniVisak));
                p.setManjak(p.getManjak().subtract(prethodniManjak));
                p.setVrednostPopisa(p.getVrednostPopisa().subtract(prethodnaVrednost));
                at.setCenaSaPorezom(this.cenaPopis.getVal().doubleValue());
                at.setKolicina(this.kolicinaPopis.getVal().doubleValue());
                ((PzScrollableTableEntity)this.getSession().getParameter("table")).updateSelectedEntity((PzEntity)at, em);
                if (at.getKolicina() - at.getKolicinaBaza() > 0.0) {
                    p.setVisak(p.getVisak().add(PzMathUtility.roundToBigDecimal((double)((at.getKolicina() - at.getKolicinaBaza()) * at.getCenaSaPorezom()))));
                } else {
                    p.setManjak(p.getManjak().add(PzMathUtility.roundToBigDecimal((double)((at.getKolicinaBaza() - at.getKolicina()) * at.getCenaSaPorezom()))));
                }
                p.setVrednostPopisa(p.getVrednostPopisa().add(PzMathUtility.roundToBigDecimal((double)(at.getKolicina() * at.getCenaSaPorezom()))));
                em.getTransaction().commit();
                ((PzScrollableTableEntity)this.getSession().getParameter("table")).commitUpdate();
                this.popis.setVisak(p.getVisak());
                this.popis.setManjak(p.getManjak());
                this.popis.setVrednostPopisa(p.getVrednostPopisa());
                this.dispose();
                ((PzDialogPopis)this.getParentDialog()).runDodavanje();
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
            return;
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
        this.btnOk.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.btnOk.setActionCommand("update");
        Artikalopstidokument at = (Artikalopstidokument)((PzScrollableTableEntity)this.getSession().getParameter("table")).getSelectedEntity();
        this.sifraArtikla.setEnabled(false);
        if (this.nacin.equals(POPIS_NACIN_SIFRA)) {
            this.sifraArtikla.setVal((Object)at.getSifra());
        } else if (this.nacin.equals(POPIS_NACIN_BARKOD)) {
            this.sifraArtikla.setVal((Object)at.getArtikal().getBarKod());
        }
        this.txtNaziv.setVal((Object)at.getNaziv());
        this.kolicinaPopis.setVal((Object)at.getKolicina());
        this.kolicinaPopis.requestFocus();
        this.knjigovodstvenaCena.setVal((Object)at.getCenaBezPoreza());
        this.knjigovodstvenaKol.setVal((Object)at.getKolicinaBaza());
        this.cenaPopis.setVal((Object)at.getCenaSaPorezom());
        this.kolicinaPopis.setVal((Object)at.getKolicina());
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.artikal = (Stanjeartikal)entity;
        try {
            Vector v = PzEntityManager.select((String)("Select a from Artikalopstidokument a where a.id.sfrProizvod='" + this.artikal.getId().getSfrProizvod() + "' and a.id.idDok=" + this.popis.getIdDok()));
            if (v.size() > 0) {
                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Artikal ve\u0107 postoji na popisu");
                PzScrollableTableEntity tbl = (PzScrollableTableEntity)this.getSession().getParameter("table");
                boolean found = false;
                int i = 0;
                while (i < tbl.getRowCount() && !found) {
                    if (((Artikalopstidokument)v.get(0)).getId().getSfrProizvod().equals(((Artikalopstidokument)tbl.getEntity(i)).getId().getSfrProizvod())) {
                        tbl.setRowSelectionInterval(i, i);
                        tbl.scrollRowToVisible(i);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) {
                    this.dispose();
                    ((PzDialogPopis)this.getParentDialog()).runIzmena();
                }
                return;
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        PzFieldImpl sfrField = (PzFieldImpl)component;
        if (this.nacin.equals(POPIS_NACIN_SIFRA)) {
            sfrField.setVal((Object)this.artikal.getId().getSfrProizvod());
        } else if (this.nacin.equals(POPIS_NACIN_BARKOD)) {
            if (this.artikal.getBarKod() == null || "".equals(this.artikal.getBarKod())) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izabrani artikal ne mo\u017eete dodati na popis po\u0161to nema pode\u0161en bar kod. Podesite mu bar kod.");
                return;
            }
            sfrField.setVal((Object)this.artikal.getBarKod());
        }
        this.jedMere = this.artikal.getJedMere();
        this.knjigovodstvenaKol.setVal((Object)this.artikal.getKolicina());
        this.knjigovodstvenaCena.setVal((Object)this.artikal.getProdCena());
        this.kolicinaPopis.setVal((Object)this.artikal.getKolicina());
        this.cenaPopis.setVal((Object)this.artikal.getProdCena());
        this.txtNaziv.setVal((Object)this.artikal.getNaziv());
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje artikla");
        this.setHeaderIcon("rs/pezar/analitike/resource/img/product_add.png");
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Ispravka na artiklu");
        this.setHeaderIcon("rs/pezar/analitike/resource/img/product_edit.png");
    }

    void setDependentEntityChecker() {
        if (this.nacin.equals(POPIS_NACIN_BARKOD)) {
            this.jLabel7.setText("Bar kod:");
            this.sifraArtikla.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        if (Dodavanje.this.barcodeParser.isTezinskiBarkod(Dodavanje.this.sifraArtikla.getText())) {
                            String sfr = Dodavanje.this.sifraArtikla.getText();
                            Dodavanje.this.sifraArtikla.setText((String)Dodavanje.this.barcodeParser.getValue(sfr, 1));
                            Dodavanje.this.kolicinaPopis.setVal(Dodavanje.this.barcodeParser.getValue(sfr, 2));
                        }
                        Stanjeartikal a = (Stanjeartikal)PzEntityManager.getList((String)("SELECT a FROM Stanjeartikal a WHERE a.barKod='" + Dodavanje.this.sifraArtikla.getVal() + "' AND a.id.oznRj='" + Dodavanje.this.popis.getRadnajedinica().getId().getOznRj() + "'")).get(0);
                        return a;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)Dodavanje.this), (Throwable)e);
                    }
                    return null;
                }
            });
        } else if (this.nacin.equals(POPIS_NACIN_SIFRA)) {
            this.jLabel7.setText("\u0160ifra:");
            this.sifraArtikla.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.sifraArtikla, ((Popis)this.getSession().getParameter("popis")).getRadnajedinica()));
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        return true;
    }
}

