/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.transfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.analitike.gui.artikli.transfer.Arhiviranje;
import rs.pezar.analitike.gui.artikli.transfer.Dodavanje;
import rs.pezar.analitike.gui.artikli.transfer.PzDialogDokumenti;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.util.PzArtikalTransfer;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogTransfer
extends PzDialogInsert {
    private JScrollPane jScrollPane;
    private PzPanel mainPanel;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private JToolBar jToolBar;
    private PzTable tableInterni;
    private Opstidokument transfer;
    private boolean izmena;
    private PzToolBarIcon icnBrisanje;
    private Radnajedinica ulaznaRJ;
    private PzTable table;
    private List<Artikalopstidokument> arttransfers;
    private PzDialogDokumenti parent;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogTransfer inst = new PzDialogTransfer(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogTransfer(JFrame frame) {
        super(frame);
        this.transfer = new Opstidokument();
    }

    public PzDialogTransfer(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.parent = (PzDialogDokumenti)parent;
        this.tableInterni = (PzTable)data1;
        this.transfer = izmena ? (Opstidokument)this.tableInterni.getSelectedEntity() : new Opstidokument();
        this.izmena = izmena;
        PzEntityUtil.currentType = "TRANSFER";
        this.initGUI();
    }

    protected void initGUI() {
        try {
            this.setPreferredSize(new Dimension(1024, 786));
            if (this.izmena) {
                this.setTitle("TRANSFER KOLI\u010cINA U: " + this.transfer.getRadnajedinica().getId().getOznRj() + "(" + this.transfer.getRadnajedinica().getgTip() + ") " + this.transfer.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 20};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(ins)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnBrisanje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(del)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/box_delete.png")));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/address_book.png")));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.jScrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.jScrollPane.setBounds(12, 0, 984, 548);
            IndirectList arttrans = new IndirectList();
            if (this.transfer.getArtikalopstidokuments() == null) {
                this.transfer.setArtikalopstidokuments((List)new IndirectList());
            } else {
                String cvProdajna = this.transfer.getRadnajedinica().getNacinVodjenja();
                for (Artikalopstidokument aod : this.transfer.getArtikalopstidokuments()) {
                    if (aod.getArtikalopstidokument() == null) continue;
                    PzArtikalTransfer at = new PzArtikalTransfer(aod, cvProdajna);
                    arttrans.add(at);
                }
            }
            this.table = new PzTable((List)arttrans, PzArtikalTransfer.class);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PzDialogTransfer.this.icnDodavanje.doClick();
                }
            });
            this.jScrollPane.setViewportView((Component)this.table);
            this.table.setPreferredSize(new Dimension(966, 594));
            this.setSize(1024, 786);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        try {
            boolean izmena1 = false;
            PzTable data1 = null;
            Opstidokument data2 = null;
            Class<Dodavanje> clazz = Dodavanje.class;
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("Brisanje")) {
                boolean result;
                if (this.table.getSelectedEntity() == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali stavku za brisanje.", "Obave\u0161tenje", 1);
                    return;
                }
                boolean bl = result = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?", "Brisanje", 0) == 0;
                if (!result) {
                    return;
                }
                PzArtikalTransfer at = (PzArtikalTransfer)this.table.getSelectedEntity();
                this.arttransfers = this.transfer.getArtikalopstidokuments();
                this.arttransfers.remove(at.getArtod());
                this.arttransfers.remove(at.getArtod().getArtikalopstidokument());
                this.transfer.setArtikalopstidokuments(this.arttransfers);
                em.getTransaction().begin();
                Artikalopstidokument ad1 = at.getArtod();
                ad1 = (Artikalopstidokument)em.find(Artikalopstidokument.class, (Object)ad1.getId());
                Artikalopstidokument ad2 = ad1.getArtikalopstidokument();
                ad2 = (Artikalopstidokument)em.find(Artikalopstidokument.class, (Object)ad2.getId());
                em.remove((Object)ad1);
                em.flush();
                em.remove((Object)ad2);
                em.getTransaction().commit();
                this.table.removeSelectedEntity(false, false);
                this.table.refreshData();
                return;
            }
            try {
                void var6_10;
                if (actionCommand.equals("Izmena")) {
                    izmena1 = true;
                    actionCommand = "Dodavanje";
                    Class<Dodavanje> clazz2 = Dodavanje.class;
                } else if (actionCommand.equals("Arhiviranje")) {
                    if (this.table.getRowCount() == 0) {
                        JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nije uneta nijedna stavka na transferu.", "Obavestenje", 1);
                        return;
                    }
                    Class<Arhiviranje> clazz3 = Arhiviranje.class;
                }
                data1 = this.table;
                data2 = this.transfer;
                this.showDialog((Class)var6_10, izmena1, data1, data2);
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            return;
        }
        finally {
            em.close();
        }
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public boolean shouldBeShown() {
        if (this.izmena) {
            return true;
        }
        boolean result = false;
        this.ulaznaRJ = PzDialogRJ.getRJ((PzDialog)this);
        if (this.ulaznaRJ != null) {
            result = true;
            this.setTitle("TRANSFER KOLI\u010cINA U: " + this.ulaznaRJ.getId().getOznRj() + "(" + this.ulaznaRJ.getgTip() + ") " + this.ulaznaRJ.getNaziv());
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    if (this.transfer == null) {
                        this.transfer = new Opstidokument();
                    }
                    this.transfer.setStorno(0);
                    this.transfer.setArhiviran((short)0);
                    this.transfer.setTip("TRANSFER");
                    this.transfer.setRadnajedinica(this.ulaznaRJ);
                    short prodajna = 1;
                    if (this.transfer.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                        prodajna = 0;
                    }
                    this.transfer.setCvProdajna(prodajna);
                    em.getTransaction().begin();
                    this.transfer.setDatum(new Date(new java.util.Date().getTime()));
                    this.transfer.setProknjizen((short)0);
                    this.transfer.setProcRabata(0.0);
                    this.transfer.setIznosBezPoreza(new BigDecimal(0));
                    this.transfer.setIznosSaPorezom(new BigDecimal(0));
                    this.transfer.setPdvIznos(new BigDecimal(0));
                    this.transfer.setRjUlaz(this.ulaznaRJ.getPunNaziv());
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)this.transfer, true, null, em);
                    em.getTransaction().commit();
                    this.tableInterni.insert((PzEntity)this.transfer, false);
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTransfer(Boolean.FALSE);
    }

    public PzDialogTransfer(Boolean initGUI) {
    }

    public void finish() {
        this.parent.finish();
        this.dispose();
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        PzEntityUtil.currentType = null;
    }
}

