/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti.obracunKamate;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.obracunKamate.ObracunKamateFaktura;
import rs.pezar.analitike.gui.komitenti.obracunKamate.ObracunKamateFakturaStavka;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Kamatnastopa;

public class ObracunKamate {
    private Vector<PzDokument> dokumenta;
    private Vector<ObracunKamateFaktura> obracunKamateFakture;
    private List<ObracunKamateFakturaStavka> obracunKamateFaktureStavke;
    private Vector<Kamatnastopa> kamStope;
    private Date krajnjiDatum;
    private Date pocetniDatum;
    private Integer metod;
    private BigDecimal ukupnaKamata = BigDecimal.ZERO;

    public ObracunKamate(Vector<PzDokument> dokumenta, Vector<Kamatnastopa> kamStope, Date krajnjiDatum, Date pocetniDatum, Integer metod) throws Exception {
        this.dokumenta = dokumenta;
        this.kamStope = kamStope;
        this.krajnjiDatum = krajnjiDatum;
        this.pocetniDatum = pocetniDatum;
        this.obracunKamateFakture = new Vector();
        this.metod = metod;
        this.stvoriListuFaktura();
        this.popuniListuStavkiZaPrikaz();
    }

    private void stvoriListuFaktura() throws Exception {
        int i = 0;
        while (i < this.dokumenta.size()) {
            PzDokument dokument = this.dokumenta.get(i);
            if (Settings.obracunKamateDokumenta.contains(dokument.getTip())) {
                Vector<PzDokument> uplate = this.uzmiUplateZaFakturu(dokument);
                Date datumDoKogSeRacuna = this.datumKadaJeFakturaZatvorena(dokument, this.dokumenta);
                Date datumOdKogSeRacuna = this.pocetniDatum;
                if (datumDoKogSeRacuna == null || datumDoKogSeRacuna.after(this.krajnjiDatum)) {
                    datumDoKogSeRacuna = this.krajnjiDatum;
                }
                ObracunKamateFaktura obracunKamateFaktura = new ObracunKamateFaktura(dokument, uplate, this.kamStope, datumDoKogSeRacuna, this.metod, datumOdKogSeRacuna);
                this.obracunKamateFakture.add(obracunKamateFaktura);
            }
            ++i;
        }
    }

    private Vector<PzDokument> uzmiUplateZaFakturu(PzDokument faktura) {
        Vector<PzDokument> uplate = new Vector<PzDokument>();
        int i = 0;
        while (i < this.dokumenta.size()) {
            if (this.dokumenta.get(i).getOznDokumenta().equals(faktura.getOznDokumenta()) && Settings.obracunKamateUplateKupac.contains(this.dokumenta.get(i).getTip())) {
                uplate.add(this.dokumenta.get(i));
            }
            ++i;
        }
        return uplate;
    }

    private void popuniListuStavkiZaPrikaz() {
        this.obracunKamateFaktureStavke = new Vector<ObracunKamateFakturaStavka>();
        int i = 0;
        while (i < this.obracunKamateFakture.size()) {
            this.obracunKamateFaktureStavke.addAll(this.obracunKamateFakture.get(i).getListaStavki());
            this.ukupnaKamata = this.ukupnaKamata.add(this.obracunKamateFakture.get(i).getUkupnaKamata());
            ++i;
        }
    }

    private Date datumKadaJeFakturaZatvorena(PzDokument dokument, Vector<PzDokument> dokumentaiUplate) {
        BigDecimal iznos = dokument.getIznos();
        Vector<PzDokument> uplate = this.uzmiUplateZaFakturu(dokument);
        int i = 0;
        while (i < uplate.size()) {
            if ((iznos = iznos.subtract(uplate.get(i).getIznos())).doubleValue() <= 0.0) {
                return uplate.get(i).getDatum();
            }
            ++i;
        }
        return null;
    }

    public List<ObracunKamateFakturaStavka> getListaStavki() {
        return this.obracunKamateFaktureStavke;
    }

    public void printInfo() {
        int i = 0;
        while (i < this.obracunKamateFakture.size()) {
            this.obracunKamateFakture.get(i).printstatus();
            ++i;
        }
    }

    public BigDecimal getUkupnaKamata() {
        return this.ukupnaKamata;
    }

    public void setUkupnaKamata(BigDecimal ukupnaKamata) {
        this.ukupnaKamata = ukupnaKamata;
    }
}

