/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti.obracunKamate;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.GregorianCalendar;
import rs.pezar.db.entity.Kamatnastopa;

public class ObracunKamateFakturaStavka {
    public static final Integer METHOD_KONFORMNI = 0;
    public static final Integer METHOD_PROST_RACUN = 1;
    private String brojFakture = "";
    private BigDecimal iznosFakture = BigDecimal.ZERO;
    private Date datumDospeca;
    private Date datumValute;
    private BigDecimal iznosUplate = BigDecimal.ZERO;
    private Integer mesec;
    private Integer odDana = 1;
    private Integer doDana = 1;
    private Integer brojDana = 0;
    private Integer brojDanaUMesecu = 0;
    private BigDecimal koeficijent;
    private BigDecimal kamata;
    private Double stopa;
    private BigDecimal osnovica = BigDecimal.ZERO;
    private Integer godina;
    private Integer brojDanaUGodini;
    private GregorianCalendar cal;

    public ObracunKamateFakturaStavka() {
    }

    public ObracunKamateFakturaStavka(Kamatnastopa kamatnaStopa) {
        this.mesec = kamatnaStopa.getId().getMesec();
        this.odDana = kamatnaStopa.getId().getPocetni();
        this.doDana = kamatnaStopa.getId().getKrajnji();
        this.godina = kamatnaStopa.getId().getGodina();
        this.brojDana = this.doDana - this.odDana + 1;
        this.stopa = kamatnaStopa.getStopa();
        this.cal = new GregorianCalendar(kamatnaStopa.getId().getGodina(), kamatnaStopa.getId().getMesec() - 1, 1);
        this.brojDanaUGodini = this.cal.getActualMaximum(6);
        this.brojDanaUMesecu = this.cal.getActualMaximum(5);
    }

    public void preracunajKoeficijente(Integer metod) {
        if (metod == METHOD_KONFORMNI) {
            this.koeficijent = this.preracunStopeKonformnaMetoda();
        } else if (metod == METHOD_PROST_RACUN) {
            this.koeficijent = this.preracunStopeProstimRacunom();
        }
    }

    private BigDecimal preracunStopeKonformnaMetoda() {
        Double exponent = Double.valueOf(this.brojDana.intValue()) / Double.valueOf(this.brojDanaUMesecu.intValue());
        Double result = 1.0 + this.stopa / 100.0;
        result = Math.pow(result, exponent);
        result = result - 1.0;
        return new BigDecimal(result);
    }

    private BigDecimal preracunStopeProstimRacunom() {
        Double temp = Double.valueOf(this.brojDana.intValue()) * this.stopa;
        Double result = temp / (double)(100 * this.brojDanaUGodini);
        return new BigDecimal(result);
    }

    public String getBrojFakture() {
        return this.brojFakture;
    }

    public void setBrojFakture(String brojFakture) {
        this.brojFakture = brojFakture;
    }

    public BigDecimal getIznosFakture() {
        return this.iznosFakture;
    }

    public void setIznosFakture(BigDecimal iznosFakture) {
        this.iznosFakture = iznosFakture;
    }

    public Date getDatumDospeca() {
        return this.datumDospeca;
    }

    public void setDatumDospeca(Date datumDospeca) {
        this.datumDospeca = datumDospeca;
    }

    public Date getDatumValute() {
        return this.datumValute;
    }

    public void setDatumValute(Date datumValute) {
        this.datumValute = datumValute;
    }

    public BigDecimal getIznosUplate() {
        return this.iznosUplate;
    }

    public void setIznosUplate(BigDecimal iznosUplate) {
        this.iznosUplate = iznosUplate;
    }

    public Integer getMesec() {
        return this.mesec;
    }

    public void setMesec(Integer mesec) {
        this.mesec = mesec;
    }

    public Integer getOdDana() {
        return this.odDana;
    }

    public void setOdDana(Integer odDana) {
        this.odDana = odDana;
        this.brojDana = this.doDana - this.odDana + 1;
    }

    public Integer getDoDana() {
        return this.doDana;
    }

    public void setDoDana(Integer doDana) {
        this.doDana = doDana;
        this.brojDana = this.doDana - this.odDana + 1;
    }

    public Integer getBrojDana() {
        return this.brojDana;
    }

    public void setBrojDana(Integer brojDana) {
        this.brojDana = brojDana;
    }

    public Integer getBrojDanaUMesecu() {
        return this.brojDanaUMesecu;
    }

    public void setBrojDanaUMesecu(Integer brojDanaUMesecu) {
        this.brojDanaUMesecu = brojDanaUMesecu;
    }

    public BigDecimal getKoeficijent() {
        return this.koeficijent;
    }

    public void setKoeficijent(BigDecimal koeficijent) {
        this.koeficijent = koeficijent;
    }

    public BigDecimal getKamata() {
        return this.kamata;
    }

    public void setKamata(BigDecimal kamata) {
        this.kamata = kamata;
    }

    public Integer getGodina() {
        return this.godina;
    }

    public void setGodina(Integer godina) {
        this.godina = godina;
    }

    public Double getStopa() {
        return this.stopa;
    }

    public void setStopa(Double stopa) {
        this.stopa = stopa;
    }

    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    public static void main(String[] args) {
    }

    public Integer getBrojDanaUGodini() {
        return this.brojDanaUGodini;
    }

    public void setBrojDanaUGodini(Integer brojDanaUGodini) {
        this.brojDanaUGodini = brojDanaUGodini;
    }

    public ObracunKamateFakturaStavka clone() {
        ObracunKamateFakturaStavka temp = new ObracunKamateFakturaStavka();
        temp.setBrojDana(this.getBrojDana());
        temp.setBrojDanaUMesecu(this.getBrojDanaUMesecu());
        temp.setBrojFakture(this.getBrojFakture());
        temp.setDatumDospeca(this.getDatumDospeca());
        temp.setDatumValute(this.getDatumDospeca());
        temp.setDoDana(this.getDoDana());
        temp.setGodina(this.getGodina());
        temp.setIznosFakture(this.getIznosFakture());
        temp.setIznosUplate(this.getIznosUplate());
        temp.setKamata(this.getKamata());
        temp.setKoeficijent(this.getKoeficijent());
        temp.setMesec(this.getMesec());
        temp.setOdDana(this.getOdDana());
        temp.setStopa(this.getStopa());
        temp.setBrojDanaUGodini(this.getBrojDanaUGodini());
        return temp;
    }

    public void printInfoHeader() {
        System.out.println("Br fakture; iznos; datum dospeca; datum valute; iznos Uplate, mesec, godina; oddana; DoDana, brojDana, broj dana u mesecu; koeficijent; kamata; stopa");
    }

    public void printInfo() {
        System.out.print(String.valueOf(this.brojFakture) + "; ");
        System.out.print(this.iznosFakture + "; ");
        System.out.print(this.datumDospeca + "; ");
        System.out.print(this.datumValute + "; ");
        System.out.print(this.iznosUplate + "; ");
        System.out.print(this.mesec + "; ");
        System.out.print(this.godina + "; ");
        System.out.print(this.odDana + "; ");
        System.out.print(this.doDana + "; ");
        System.out.print(this.brojDana + "; ");
        System.out.print(this.brojDanaUMesecu + "; ");
        System.out.print(this.koeficijent + "; ");
        System.out.print(this.kamata + "; ");
        System.out.println(this.stopa);
    }
}

