/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.otvoreneStavke;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.otvoreneStavke.zbirniPregled;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogOtvoreneStavkeFaktura
extends PzDialog {
    private static final String SVE_NEPLACENE = "Sve nepla\u0107ene";
    private static final String PO_DATUMU_VALUTE = "Po datumu valute";
    private static final String KONKRETAN_KOMITENT = "Konkretan komitent";
    private static final String KUPCI_NA_VELIKO_I_MALO = "Kupci na veliko i malo";
    private static final String KUPCI_SAMO_NA_MALO = "Kupci samo na malo";
    private static final String DOMACI_KOMITENTI = "Doma\u0107i komitenti";
    private static final String INOSTRANI_KOMITENTI = "Inostrani komitenti";
    private static final String SVI_KOMITENTI = "Svi komitenti";
    private static final String DETALJNI_PREGLED = "Detaljni pregled";
    private static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private PzPanel pnlGlavni;
    private JPanel pnlFields;
    private PzDateField tfKrajnjiDatum;
    private PzTextField tfNazivKomitenta;
    private JLabel lblKrajnjuDatum;
    private PzFieldIndikator indNazivKomitenta;
    private JPanel pnlButton;
    private PzDateField tfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzTextField tfKomitent;
    private JLabel lblKomitent;
    private PzRadioGroup<String> panelRBs1;
    private PzRadioGroup<String> panelRBs3;
    private PzRadioGroup<String> panelRBs2;
    private PzPanel pnlRadioButtons;
    private PzButton btnPotvrdi;
    private String izbor;
    private ScrollableCursor cursor = null;
    private JCheckBox cbGrupaKom;
    private PzComboBox cbRadnaJedinica;
    private JLabel lblRadnaJedinica;
    private Komitent komitent;
    private String tipFakture;
    private Radnajedinica rj;
    private JLabel lblKorisnik;
    private PzComboBox cbKorisnik;

    public PzDialogOtvoreneStavkeFaktura(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    public PzDialogOtvoreneStavkeFaktura(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        try {
            String upit = "Select rj from Radnajedinica rj where rj.id.oznRj IN (%listaRj%) ";
            if (PzDialogRJ.getAvaliableRjString().equals("")) {
                throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
            }
            upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
            Query q = PzEntityManager.getEm().createQuery(upit);
            Iterator i = q.getResultList().iterator();
            this.cbRadnaJedinica.addItem((Object)new PzChoice("", (Object)""));
            while (i.hasNext()) {
                Radnajedinica rj = (Radnajedinica)i.next();
                this.cbRadnaJedinica.addItem((Object)new PzChoice(rj.getPunNaziv(), (Object)rj.getId().getOznRj()));
            }
            q = PzEntityManager.getEm().createQuery("SELECT u FROM Pzuser u");
            this.cbKorisnik.addItem((Object)new PzChoice("", (Object)""));
            for (Pzuser u : q.getResultList()) {
                this.cbKorisnik.addItem((Object)new PzChoice(u.getFullName(), (Object)u.getPzusername()));
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("OTVORENE STAVKE");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{13, 136, 30, 87, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.pnlRadioButtons = new PzPanel();
            GridBagLayout pnlRadioButtonsLayout1 = new GridBagLayout();
            GridBagLayout pnlRadioButtonsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRadioButtons, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRadioButtonsLayout1.rowWeights = new double[]{0.0, 0.0};
            pnlRadioButtonsLayout1.rowHeights = new int[]{146, 15};
            pnlRadioButtonsLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonsLayout1.columnWidths = new int[]{25, 155, 10, 155, 10, 155, 20};
            this.pnlRadioButtons.setLayout((LayoutManager)pnlRadioButtonsLayout1);
            pnlRadioButtonsLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlRadioButtonsLayout.rowHeights = new int[]{16, 7, 7, 7};
            pnlRadioButtonsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonsLayout.columnWidths = new int[]{22, 155, 8, 150, 8, 7};
            this.pnlRadioButtons.setOpaque(false);
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{SVE_NEPLACENE, PO_DATUMU_VALUTE, KONKRETAN_KOMITENT, KUPCI_NA_VELIKO_I_MALO, KUPCI_SAMO_NA_MALO});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlRadioButtons.add(this.panelRBs1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRBs1.setSelectedValue((Object)SVE_NEPLACENE);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.SVE_NEPLACENE)) {
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableDatum(false);
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableKomitent(false);
                            PzDialogOtvoreneStavkeFaktura.this.clearKomitent();
                        } else if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.PO_DATUMU_VALUTE)) {
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableDatum(true);
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableKomitent(false);
                            PzDialogOtvoreneStavkeFaktura.this.clearKomitent();
                        } else if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.KONKRETAN_KOMITENT)) {
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableKomitent(true);
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableDatum(false);
                        } else if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.KUPCI_NA_VELIKO_I_MALO)) {
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableDatum(false);
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableKomitent(false);
                            PzDialogOtvoreneStavkeFaktura.this.clearKomitent();
                        } else if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.KUPCI_SAMO_NA_MALO)) {
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableDatum(false);
                            PzDialogOtvoreneStavkeFaktura.this.setFocusableKomitent(false);
                            PzDialogOtvoreneStavkeFaktura.this.clearKomitent();
                        }
                    }
                }
            });
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{DOMACI_KOMITENTI, INOSTRANI_KOMITENTI, SVI_KOMITENTI});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlRadioButtons.add(this.panelRBs2, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRBs2.setSelectedValue((Object)DOMACI_KOMITENTI);
            this.panelRBs2.setOpaque(false);
            this.panelRBs3 = new PzRadioGroup((Object[])new String[]{DETALJNI_PREGLED, ZBIRNI_PREGLED});
            BoxLayout panelRBs3Layout = new BoxLayout((Container)this.panelRBs3, 1);
            this.panelRBs3.setLayout((LayoutManager)panelRBs3Layout);
            this.pnlRadioButtons.add(this.panelRBs3, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs3.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRBs3.setSelectedValue((Object)DETALJNI_PREGLED);
            this.panelRBs3.setOpaque(false);
            this.panelRBs3.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogOtvoreneStavkeFaktura.ZBIRNI_PREGLED)) {
                            PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.setEnabled(true);
                        } else {
                            PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.setEnabled(false);
                        }
                    }
                }
            });
            this.pnlFields = new JPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setLayout(pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.pnlFields.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{7, 7, 20, 20, 20, 7};
            pnlFieldsLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.0};
            pnlFieldsLayout.rowHeights = new int[]{7, 7, 7, 7, 20};
            this.lblKomitent = new JLabel();
            this.lblKomitent.setText("Komitent");
            this.pnlFields.add((Component)this.lblKomitent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.tfKomitent = new PzTextField();
            this.tfKomitent.setFont(new Font("Tahoma", 0, 14));
            this.pnlFields.add((Component)this.tfKomitent, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.tfKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.lblPocetniDatum = new JLabel();
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.pnlFields.add((Component)this.lblPocetniDatum, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.tfPocetniDatum = new PzDateField();
            this.tfPocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.pnlFields.add((Component)this.tfPocetniDatum, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.tfPocetniDatum.setName("tfPocetniDatum");
            this.lblKrajnjuDatum = new JLabel();
            this.lblKrajnjuDatum.setText("Krajnji datum");
            this.pnlFields.add((Component)this.lblKrajnjuDatum, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.tfKrajnjiDatum = new PzDateField();
            this.tfKrajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.pnlFields.add((Component)this.tfKrajnjiDatum, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.tfKrajnjiDatum.setName("tfKrajnjiDatum");
            this.tfNazivKomitenta = new PzTextField();
            this.tfNazivKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.pnlFields.add((Component)this.tfNazivKomitenta, new GridBagConstraints(2, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.tfNazivKomitenta.setFocusable(false);
            this.lblRadnaJedinica = new JLabel();
            this.pnlFields.add((Component)this.lblRadnaJedinica, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.lblRadnaJedinica.setName("lblRadnaJedinica");
            this.cbRadnaJedinica = new PzComboBox();
            this.pnlFields.add((Component)this.cbRadnaJedinica, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 3, new Insets(5, 0, 0, 5), 0, 0));
            this.lblKorisnik = new JLabel();
            this.pnlFields.add((Component)this.lblKorisnik, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.lblKorisnik.setName("lblKorisnik");
            this.cbKorisnik = new PzComboBox();
            this.pnlFields.add((Component)this.cbKorisnik, new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 17, 3, new Insets(5, 0, 0, 5), 0, 0));
            this.cbGrupaKom = new JCheckBox();
            this.pnlFields.add((Component)this.cbGrupaKom, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.cbGrupaKom.setName("cbGrupaKom");
            this.cbGrupaKom.setOpaque(false);
            this.cbGrupaKom.setEnabled(false);
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(144, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void clearKomitent() {
        this.tfKomitent.setText("");
        this.tfNazivKomitenta.setText("");
        this.indNazivKomitenta.setState(0);
    }

    private void setFocusableDatum(Boolean focusable) {
        this.tfPocetniDatum.setFocusable(focusable.booleanValue());
        this.tfKrajnjiDatum.setFocusable(focusable.booleanValue());
    }

    private void setFocusableKomitent(Boolean focusable) {
        this.tfKomitent.setFocusable(focusable.booleanValue());
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            if (((String)this.panelRBs1.getSelectedValue()).equals(KONKRETAN_KOMITENT) && ((String)this.panelRBs2.getSelectedValue()).equals(DOMACI_KOMITENTI)) {
                if (this.komitent.getDomaciKomitent() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Komitent ne pripada grupi:\"DOMA\u010aI KOMITENTI\"", "Gre\u0161ka", 0);
                    this.clearKomitent();
                    return;
                }
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(KONKRETAN_KOMITENT) && ((String)this.panelRBs2.getSelectedValue()).equals(INOSTRANI_KOMITENTI) && this.komitent.getDomaciKomitent() == 1) {
                JOptionPane.showMessageDialog(this.getParent(), "Komitent ne pripada grupi:\"INOSTRANI KOMITENTI\"", "Gre\u0161ka", 0);
                this.clearKomitent();
                return;
            }
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogOtvoreneStavkeFaktura.this.cursor != null) {
                        PzDialogOtvoreneStavkeFaktura.this.cursor.close();
                    }
                    String upit = "";
                    if (!PzDialogOtvoreneStavkeFaktura.this.cbRadnaJedinica.getSelectedChoice().getValue().toString().equals("")) {
                        PzDialogOtvoreneStavkeFaktura.this.rj = (Radnajedinica)em.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", PzDialogOtvoreneStavkeFaktura.this.cbRadnaJedinica.getSelectedChoice().getValue().toString()));
                    }
                    Query q = null;
                    if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs3.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.DETALJNI_PREGLED)) {
                        upit = PzDialogOtvoreneStavkeFaktura.this.izbor.equals("Kupci") ? "SELECT CAST(k.sfrKomitent AS INT), k.naziv, f.oznDokumenta, f.datum, f.datValute, f.iznos, f.uplata, f.stornoIznos, f.rbrdok, f.rBroj, f.tip FROM Faktura f, Komitent k, Radnajedinica rj WHERE f.sfrKomitent=k.sfrKomitent and f.oznRj=rj.oznRj AND f.oznOgranak=rj.oznOgranak  and rj.oznRj IN (%listaRj%) and f.arhiviran=1 and f.storno=0 and f.iznos-f.stornoIznos - f.uplata <> 0 and (f.tip='FAKTURA' or f.tip='FAKTURA_IZ_SERVISA' or f.tip='FAKTURA_USLUGA')" : "SELECT CAST(k.sfrKomitent AS INT), k.naziv, f.oznDokumenta, f.datum, f.datValute, f.iznos, f.uplata, f.stornoIznos, f.rbrDok, f.rBroj, f.tip FROM Komitent k, Kalkulacija f %uslovF% WHERE f.sfrKomitent=k.sfrKomitent and f.arhiviran=1 and f.storno= 0 and f.iznos - f.stornoIznos - f.uplata <> 0  %uslovW% and (( (f.tip='KALKULACIJA' OR f.tip='" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "' ) and (f.podtip='" + "FAKTURA" + "' or f.podtip='" + "POCETNO" + "')) or " + "f.tip='" + "TROSAK" + "' or f.tip='" + "RACUN_DOBAVLJACA" + "' or f.tip='" + "ZAPISNIK_OTPREMNICE" + "')";
                    } else {
                        upit = PzDialogOtvoreneStavkeFaktura.this.izbor.equals("Kupci") ? "SELECT CAST(k.sfrKomitent AS INT), k.naziv, SUM(f.iznos-f.stornoIznos), SUM(f.uplata), SUM(f.iznos-f.stornoIznos-f.uplata) %kGrupaS%FROM Faktura f, Radnajedinica rj, \t%kGrupaF% WHERE f.sfrKomitent=k.sfrKomitent and f.oznRj=rj.oznRj AND f.oznOgranak=rj.oznOgranak  and rj.oznRj IN (%listaRj%) and f.arhiviran=1 and f.storno=0 and f.iznos-f.stornoIznos - f.uplata <> 0 and (f.tip='FAKTURA' or f.tip='FAKTURA_IZ_SERVISA' or f.tip='FAKTURA_USLUGA')" : "SELECT CAST(k.sfrKomitent AS INT), k.naziv, SUM(f.iznos-f.stornoIznos), SUM(f.uplata), SUM(f.iznos-f.stornoIznos-f.uplata) %kGrupaS%FROM Kalkulacija f %uslovF%,  %kGrupaF%WHERE f.sfrKomitent=k.sfrKomitent and f.arhiviran=1 and f.storno= 0 and f.iznos - f.stornoIznos - f.uplata <> 0  %uslovW% and (( (f.tip='KALKULACIJA' OR f.tip='" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "' ) and (f.podtip='" + "FAKTURA" + "' or f.podtip='" + "POCETNO" + "')) or " + "f.tip='" + "TROSAK" + "' or f.tip='" + "RACUN_DOBAVLJACA" + "' or f.tip='" + "ZAPISNIK_OTPREMNICE" + "')";
                        upit = upit.replace("%kGrupaS%", PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.isSelected() ? ", kGrupa.idKomitentGrupa, kGrupa.naziv " : " ");
                        upit = upit.replace("%kGrupaF%", PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.isSelected() ? " Komitent k LEFT JOIN  KomitentGrupaLink kGrupaLink ON k.sfrKomitent = kGrupaLink.sfrKomitent LEFT JOIN  Komitentgrupa kGrupa ON kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa " : " Komitent k  ");
                    }
                    if (!PzDialogOtvoreneStavkeFaktura.this.izbor.equals("Kupci")) {
                        upit = upit.replace("%uslovF%", "").replace("%uslovW%", " ");
                    }
                    if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs1.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.SVE_NEPLACENE)) {
                        PzDialogOtvoreneStavkeFaktura.this.izbor.equals("Kupci");
                    }
                    if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs1.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.PO_DATUMU_VALUTE)) {
                        upit = String.valueOf(upit) + " and f.datValute>=':datumOD' and f.datValute<=':datumDO'";
                        upit = upit.replace(":datumOD", PzDialogOtvoreneStavkeFaktura.this.tfPocetniDatum.getVal().toString());
                        upit = upit.replace(":datumDO", PzDialogOtvoreneStavkeFaktura.this.tfKrajnjiDatum.getVal().toString());
                    } else if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs1.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.KONKRETAN_KOMITENT)) {
                        upit = String.valueOf(upit) + " and k.sfrKomitent=':komitent'";
                        upit = upit.replace(":komitent", PzDialogOtvoreneStavkeFaktura.this.tfKomitent.getVal().toString());
                    } else if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs1.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.KUPCI_NA_VELIKO_I_MALO)) {
                        upit = String.valueOf(upit) + " and (rj.gTip='V' OR rj.gTip='E')";
                    } else if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs1.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.KUPCI_SAMO_NA_MALO)) {
                        upit = String.valueOf(upit) + " and rj.gTip='E'";
                    }
                    if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs2.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.DOMACI_KOMITENTI)) {
                        upit = String.valueOf(upit) + " and k.domaciKomitent=1";
                    } else if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs2.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.INOSTRANI_KOMITENTI)) {
                        upit = String.valueOf(upit) + " and k.domaciKomitent=0";
                    }
                    if (!PzDialogOtvoreneStavkeFaktura.this.cbRadnaJedinica.getSelectedChoice().getValue().toString().equals("")) {
                        if (!PzDialogOtvoreneStavkeFaktura.this.izbor.equals("Kupci")) {
                            upit = upit.replace("%uslovF%", ", Radnajedinica rj ").replace("%uslovW%", " and f.oznRj=rj.oznRj AND f.oznOgranak=rj.oznOgranak ");
                        }
                        upit = String.valueOf(upit) + " and rj.oznRj=':rj'";
                        upit = upit.replace(":rj", PzDialogOtvoreneStavkeFaktura.this.cbRadnaJedinica.getSelectedChoice().getValue().toString());
                    }
                    if (!PzDialogOtvoreneStavkeFaktura.this.cbKorisnik.getSelectedChoice().getValue().toString().equals("")) {
                        upit = String.valueOf(upit) + " and f.usernamekraj=':username'";
                        upit = upit.replace(":username", PzDialogOtvoreneStavkeFaktura.this.cbKorisnik.getSelectedChoice().getValue().toString());
                    }
                    if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs3.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.DETALJNI_PREGLED)) {
                        upit = String.valueOf(upit) + " ORDER BY CAST(k.sfrKomitent AS INT), f.datum";
                    } else if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs3.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.ZBIRNI_PREGLED)) {
                        upit = PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.isSelected() ? String.valueOf(upit) + " GROUP BY kGrupa.idKomitentGrupa, kGrupa.naziv, k.sfrKomitent, k.naziv ORDER BY kGrupa.idKomitentGrupa " : String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv ORDER BY CAST(k.sfrKomitent AS INT) ASC";
                    }
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogOtvoreneStavkeFaktura.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogOtvoreneStavkeFaktura.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    block8: {
                        try {
                            this.get();
                            if (PzDialogOtvoreneStavkeFaktura.this.cursor.size() == 0) {
                                JOptionPane.showMessageDialog(PzDialogOtvoreneStavkeFaktura.this.getParent(), "Za tra\u017eeni kriterijum nema nepla\u0107enih faktura", "Informacija", 1);
                                PzWorkerDialog.hideStatus();
                                return;
                            }
                            try {
                                if (((String)PzDialogOtvoreneStavkeFaktura.this.panelRBs3.getSelectedValue()).equals(PzDialogOtvoreneStavkeFaktura.DETALJNI_PREGLED)) {
                                    PzDialogOtvoreneStavkeFaktura.this.showReport();
                                    break block8;
                                }
                                String titleZbirni = PzDialogOtvoreneStavkeFaktura.this.getTitleZbirni();
                                PzDialogOtvoreneStavkeFaktura.this.getSession().putParameter("kursor", (Object)PzDialogOtvoreneStavkeFaktura.this.cursor);
                                PzDialogOtvoreneStavkeFaktura.this.getSession().putParameter("title", (Object)titleZbirni);
                                PzDialogOtvoreneStavkeFaktura.this.getSession().putParameter("izbor", (Object)PzDialogOtvoreneStavkeFaktura.this.tipFakture);
                                PzDialogOtvoreneStavkeFaktura.this.getSession().putParameter("fname", (Object)(PzDialogOtvoreneStavkeFaktura.this.cbGrupaKom.isSelected() ? "rs/pezar/analitike/resource/reports/compiled/otvorene.stavke.zbirno.grupa.jasper" : "rs/pezar/analitike/resource/reports/compiled/otvorene.stavke.zbirno.jasper"));
                                PzDialogOtvoreneStavkeFaktura.this.showDialog(zbirniPregled.class);
                                PzWorkerDialog.hideStatus();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogOtvoreneStavkeFaktura.this), (Throwable)e);
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReport() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String subtitle = "";
        String radnajedinica = "";
        if (((String)this.panelRBs1.getSelectedValue()).equals(PO_DATUMU_VALUTE)) {
            title = "PREGLED FAKTURA KOJE STI\u017dU ZA NAPLATU U PERIODU OD " + PzDateUtility.formatDate((Date)this.tfPocetniDatum.getVal()) + " DO " + PzDateUtility.formatDate((Date)this.tfKrajnjiDatum.getVal());
        } else if (((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_SAMO_NA_MALO)) {
            subtitle = "Kupci na malo";
            title = "PREGLED NEPLA\u0106ENIH FAKTURA";
        } else if (((String)this.panelRBs1.getSelectedValue()).equals(SVE_NEPLACENE)) {
            subtitle = this.izbor.equals("Kupci") ? "Kupci u zemlji bez maloprodajom" : "Dobavlja\u010di u zemlji";
            title = "PREGLED NEPLA\u0106ENIH FAKTURA";
        } else {
            title = "PREGLED NEPLA\u0106ENIH FAKTURA";
        }
        if (!this.cbRadnaJedinica.getSelectedChoice().getValue().toString().equals("")) {
            radnajedinica = "Radna jedinica " + this.rj.getPunNaziv();
        }
        if (((String)this.panelRBs2.getSelectedValue()).equals(INOSTRANI_KOMITENTI) && !((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_SAMO_NA_MALO)) {
            subtitle = this.izbor.equals("Kupci") ? "Kupci u inostranstvu" : "Dobavlja\u010di u inostranstvu";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(DOMACI_KOMITENTI) && !((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_SAMO_NA_MALO) && !((String)this.panelRBs1.getSelectedValue()).equals(SVE_NEPLACENE)) {
            subtitle = this.izbor.equals("Kupci") ? "Kupci u zemlji sa maloprodajom" : "Dobavlja\u010di u zemlji";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(SVI_KOMITENTI) && !((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_SAMO_NA_MALO)) {
            subtitle = this.izbor.equals("Kupci") ? "Svi kupci bez maloprodaje" : "Svi dobavlja\u010di";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("tip", this.tipFakture);
        params.put("subtitle", radnajedinica.equals("") ? subtitle : String.valueOf(subtitle) + "\n" + radnajedinica);
        params.put("reklama", "");
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/otvorene.stavke.faktura.jasper"), params, (String)title);
    }

    public String getTitleZbirni() {
        String uslov = "";
        String grupa = "";
        String tipTitle = "";
        if (((String)this.panelRBs1.getSelectedValue()).equals(PO_DATUMU_VALUTE)) {
            uslov = " Uslov: datum valute od " + this.tfPocetniDatum.getVal().toString() + " do " + this.tfKrajnjiDatum.getVal().toString();
            if (this.izbor.equals("Kupci")) {
                tipTitle = "-na veliko i malo";
            }
        } else if (((String)this.panelRBs1.getSelectedValue()).equals(SVE_NEPLACENE)) {
            if (this.izbor.equals("Kupci")) {
                tipTitle = "(bez maloprodaje)";
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(KONKRETAN_KOMITENT)) {
                uslov = " " + this.komitent.getSfrKomitent() + "/" + this.komitent.getNaziv();
                if (this.izbor.equals("Kupci")) {
                    tipTitle = "-na veliko i malo";
                }
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_NA_VELIKO_I_MALO)) {
                tipTitle = "-na veliko i malo";
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(KUPCI_SAMO_NA_MALO)) {
                tipTitle = "-na malo";
            }
        }
        if (((String)this.panelRBs2.getSelectedValue()).equals(INOSTRANI_KOMITENTI)) {
            if (this.izbor.equals("Kupci")) {
                grupa = "Grupa: INOSTRANI KUPCI";
                tipTitle = "";
            } else {
                grupa = "Grupa: INOSTRANI DOBAVLJA\u010c";
                tipTitle = "";
            }
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(DOMACI_KOMITENTI)) {
            grupa = this.izbor.equals("Kupci") ? "Grupa: DOMA\u0106I KUPCI" : "Grupa: DOMA\u0106I DOBAVLJA\u010c";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(SVI_KOMITENTI)) {
            grupa = this.izbor.equals("Kupci") ? "Grupa: SVI KUPCI" : "Grupa: SVI DOBAVLJA\u010cI";
        }
        return String.valueOf(grupa) + tipTitle + uslov;
    }

    public boolean shouldBeShown() {
        String izborKartice;
        String dobavljaci;
        String kupci;
        block5: {
            Vector<String> skupZaIzbor = new Vector<String>();
            kupci = new String("Kupci");
            dobavljaci = new String("Dobavlja\u010di");
            skupZaIzbor.add(kupci);
            skupZaIzbor.add(dobavljaci);
            try {
                izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
                if (izborKartice != null) break block5;
                return false;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                return false;
            }
        }
        if (izborKartice.equals(dobavljaci)) {
            this.izbor = dobavljaci;
            this.panelRBs1.getComponent(3).setEnabled(false);
            this.panelRBs1.getComponent(4).setEnabled(false);
            this.tipFakture = "kalkulacija";
            this.cbKorisnik.setEnabled(false);
        } else {
            this.izbor = kupci;
            this.tipFakture = "faktura";
        }
        this.setFocusableKomitent(false);
        this.setFocusableDatum(false);
        this.pnlGlavni.updateAllFieldsState();
        return true;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfKomitent.setVal((Object)this.komitent.getSfrKomitent());
            this.tfNazivKomitenta.setVal((Object)this.komitent.getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogOtvoreneStavkeFaktura(Boolean.FALSE);
    }

    public PzDialogOtvoreneStavkeFaktura(Boolean initGUI) {
    }
}

