/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.porez.analitikaUkalkulisanogPDVa.DodajAnalitiku;
import rs.pezar.analitike.gui.porez.analitikaUkalkulisanogPDVa.PodaciAnalitike;
import rs.pezar.analitike.gui.porez.analitikaUkalkulisanogPDVa.PzTableModelAnalitikaUKP;
import rs.pezar.analitike.gui.porez.core.Porez;
import rs.pezar.core.RuleKepu;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogAnalitikaUkalkulisanogPDVa
extends PzDialog {
    private PzPanel plDugmici;
    private PzToolBarIcon btnBrisanje;
    private PzToolBarIcon btnIzmena;
    private PzToolBarIcon btnDodaj;
    private JToolBar toolbar;
    private PzDoubleField dblVisaOsn;
    private JLabel jLabel1;
    private JLabel lblNizaPdv;
    private JLabel lblvisaPdv;
    private JLabel lblVisaOsnovica;
    private PzPanel pzPanel;
    private PzCheckbox chkRadnaJedinica;
    private PzCheckbox chkDatum;
    private JLabel lblRadnaJedinica;
    private JLabel lblOd;
    private PzDateField pzdtfldA;
    private JLabel lblDo;
    private PzDateField pzDateField;
    private PzNumericOnlyTextField nfRJ;
    private Radnajedinica radnaJedinica;
    private JLabel lblNazivRadneJedinice;
    private ScrollableCursor cursor;
    private EntityManager em;
    private List<Radnajedinica> radnejedinice;
    private JScrollPane scrollPane;
    private PzTable pzTable;
    private PzToolBarIcon btnOsvezi;
    private PzToolBarIcon btnStampaj;
    private PzDoubleField dblVisaPdv;
    private PzDoubleField dblNizaOsn;
    private PzDoubleField dblNizaPdv;
    private PzToolBarIcon btnPrikaziDokument;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogAnalitikaUkalkulisanogPDVa inst = new PzDialogAnalitikaUkalkulisanogPDVa(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogAnalitikaUkalkulisanogPDVa(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Analitika ukalkulisanog PDV-a");
            GridBagLayout gridBagLayout = new GridBagLayout();
            int[] nArray = new int[2];
            nArray[0] = 926;
            gridBagLayout.columnWidths = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 93;
            nArray2[1] = 90;
            nArray2[2] = 384;
            gridBagLayout.rowHeights = nArray2;
            gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
            this.getContentPane().setLayout(gridBagLayout);
            this.plDugmici = new PzPanel();
            GridBagLayout plDugmiciLayout = new GridBagLayout();
            GridBagConstraints gbc_plDugmici = new GridBagConstraints();
            gbc_plDugmici.anchor = 11;
            gbc_plDugmici.fill = 2;
            gbc_plDugmici.insets = new Insets(0, 0, 5, 0);
            gbc_plDugmici.gridx = 0;
            gbc_plDugmici.gridy = 0;
            this.getContentPane().add((Component)this.plDugmici, gbc_plDugmici);
            plDugmiciLayout.rowWeights = new double[]{0.1};
            plDugmiciLayout.rowHeights = new int[]{7};
            plDugmiciLayout.columnWeights = new double[]{0.1};
            plDugmiciLayout.columnWidths = new int[]{7};
            this.plDugmici.setLayout((LayoutManager)plDugmiciLayout);
            this.toolbar = new JToolBar();
            this.plDugmici.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.btnOsvezi = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnOsvezi);
            this.btnOsvezi.setText("Osve\u017ei|(ctrl+r)");
            this.btnOsvezi.setShortcut("CTRL+R");
            this.btnOsvezi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/refresh_1.png")));
            this.btnOsvezi.addActionListener((ActionListener)((Object)this));
            this.btnPrikaziDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnPrikaziDokument);
            this.btnPrikaziDokument.setText("Prikaz dokumenta|(f2)");
            this.btnPrikaziDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnPrikaziDokument.addActionListener((ActionListener)((Object)this));
            this.btnPrikaziDokument.setShortcut("f2");
            this.btnDodaj = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnDodaj);
            this.btnDodaj.setText("Dodaj|(Ins)");
            this.btnDodaj.setShortcut("INSERT");
            this.btnDodaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_add.png")));
            this.btnDodaj.addActionListener((ActionListener)((Object)this));
            this.btnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnIzmena);
            this.btnIzmena.setText("Izmena |(F3)");
            this.btnIzmena.setShortcut("F3");
            this.btnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.btnIzmena.addActionListener((ActionListener)((Object)this));
            this.btnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanje);
            this.btnBrisanje.setText("Brisanje |(Del)");
            this.btnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_delete.png")));
            this.btnBrisanje.setShortcut("DELETE");
            this.btnBrisanje.addActionListener((ActionListener)((Object)this));
            this.btnStampaj = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnStampaj);
            this.btnStampaj.setText("\u0160tampaj|(alt+s)");
            this.btnStampaj.setShortcut("ALT+S");
            this.btnStampaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_view.png")));
            this.btnStampaj.addActionListener((ActionListener)((Object)this));
            this.pzPanel = new PzPanel();
            GridBagConstraints gbc_pzPanel = new GridBagConstraints();
            gbc_pzPanel.fill = 1;
            gbc_pzPanel.insets = new Insets(0, 0, 5, 0);
            gbc_pzPanel.gridx = 0;
            gbc_pzPanel.gridy = 1;
            this.getContentPane().add((Component)this.pzPanel, gbc_pzPanel);
            GridBagLayout gbl_pzPanel = new GridBagLayout();
            int[] nArray3 = new int[12];
            nArray3[0] = 37;
            nArray3[1] = 30;
            nArray3[2] = 90;
            nArray3[3] = 32;
            nArray3[4] = 144;
            nArray3[5] = 7;
            nArray3[6] = 49;
            nArray3[7] = 20;
            nArray3[8] = 48;
            nArray3[9] = 20;
            nArray3[10] = 7;
            gbl_pzPanel.columnWidths = nArray3;
            int[] nArray4 = new int[3];
            nArray4[1] = 32;
            gbl_pzPanel.rowHeights = nArray4;
            gbl_pzPanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.1, 0.0, Double.MIN_VALUE};
            gbl_pzPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.pzPanel.setLayout((LayoutManager)gbl_pzPanel);
            this.chkRadnaJedinica = new PzCheckbox();
            GridBagConstraints gbc_chkRadnaJedinica = new GridBagConstraints();
            gbc_chkRadnaJedinica.insets = new Insets(0, 0, 5, 5);
            gbc_chkRadnaJedinica.gridx = 0;
            gbc_chkRadnaJedinica.gridy = 0;
            this.chkRadnaJedinica.addActionListener((ActionListener)((Object)this));
            this.pzPanel.add((Component)this.chkRadnaJedinica, (Object)gbc_chkRadnaJedinica);
            this.lblRadnaJedinica = new JLabel("Radna jedinica:");
            GridBagConstraints gbc_lblRadnaJedinica = new GridBagConstraints();
            gbc_lblRadnaJedinica.anchor = 13;
            gbc_lblRadnaJedinica.insets = new Insets(0, 0, 5, 5);
            gbc_lblRadnaJedinica.gridx = 1;
            gbc_lblRadnaJedinica.gridy = 0;
            this.pzPanel.add((Component)this.lblRadnaJedinica, (Object)gbc_lblRadnaJedinica);
            this.lblNazivRadneJedinice = new JLabel();
            this.lblNazivRadneJedinice.setBackground(new Color(172, 234, 175));
            this.lblNazivRadneJedinice.setOpaque(true);
            this.lblNazivRadneJedinice.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            GridBagConstraints gbc_lblNazivRadneJedinice = new GridBagConstraints();
            gbc_lblNazivRadneJedinice.gridwidth = 3;
            gbc_lblNazivRadneJedinice.anchor = 13;
            gbc_lblNazivRadneJedinice.insets = new Insets(0, 0, 5, 5);
            gbc_lblNazivRadneJedinice.gridx = 3;
            gbc_lblNazivRadneJedinice.gridy = 0;
            this.pzPanel.add((Component)this.lblNazivRadneJedinice, (Object)new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(1, 5, 1, 5), 0, 0));
            this.lblNazivRadneJedinice.setName("lblNazivRadneJedinice");
            this.nfRJ = new PzNumericOnlyTextField();
            GridBagConstraints gbc_nfRJ = new GridBagConstraints();
            gbc_nfRJ.anchor = 13;
            gbc_nfRJ.insets = new Insets(0, 0, 5, 5);
            gbc_nfRJ.gridx = 2;
            gbc_nfRJ.gridy = 0;
            this.pzPanel.add((Component)this.nfRJ, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.nfRJ.setFont(new Font("Tahoma", 0, 14));
            this.nfRJ.setPreferredSize(new Dimension(68, 24));
            this.nfRJ.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        PzDialogAnalitikaUkalkulisanogPDVa.this.doFunc();
                    }
                }
            });
            this.chkDatum = new PzCheckbox();
            GridBagConstraints gbc_chkDatum = new GridBagConstraints();
            gbc_chkDatum.insets = new Insets(0, 0, 0, 5);
            gbc_chkDatum.gridx = 0;
            gbc_chkDatum.gridy = 1;
            this.chkDatum.addActionListener((ActionListener)((Object)this));
            this.pzPanel.add((Component)this.chkDatum, (Object)gbc_chkDatum);
            this.lblOd = new JLabel("od:");
            GridBagConstraints gbc_lblOd = new GridBagConstraints();
            gbc_lblOd.anchor = 13;
            gbc_lblOd.insets = new Insets(0, 0, 0, 5);
            gbc_lblOd.gridx = 1;
            gbc_lblOd.gridy = 1;
            this.pzPanel.add((Component)this.lblOd, (Object)gbc_lblOd);
            this.pzdtfldA = new PzDateField();
            this.pzdtfldA.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            GridBagConstraints gbc_pzdtfldA = new GridBagConstraints();
            gbc_pzdtfldA.insets = new Insets(0, 0, 0, 5);
            gbc_pzdtfldA.fill = 2;
            gbc_pzdtfldA.gridx = 2;
            gbc_pzdtfldA.gridy = 1;
            this.pzPanel.add((Component)this.pzdtfldA, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDo = new JLabel("do:");
            GridBagConstraints gbc_lblDo = new GridBagConstraints();
            gbc_lblDo.anchor = 13;
            gbc_lblDo.insets = new Insets(0, 0, 0, 5);
            gbc_lblDo.gridx = 3;
            gbc_lblDo.gridy = 1;
            this.pzPanel.add((Component)this.lblDo, (Object)gbc_lblDo);
            this.pzDateField = new PzDateField();
            GridBagConstraints gbc_pzDateField = new GridBagConstraints();
            gbc_pzDateField.insets = new Insets(0, 0, 0, 5);
            gbc_pzDateField.fill = 2;
            gbc_pzDateField.gridx = 4;
            gbc_pzDateField.gridy = 1;
            this.pzPanel.add((Component)this.pzDateField, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblVisaOsnovica = new JLabel();
            this.pzPanel.add((Component)this.lblVisaOsnovica, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.lblVisaOsnovica.setName("lblVisaOsnovica");
            this.lblvisaPdv = new JLabel();
            this.pzPanel.add((Component)this.lblvisaPdv, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.lblvisaPdv.setName("lblvisaPdv");
            this.lblNizaPdv = new JLabel();
            this.pzPanel.add((Component)this.lblNizaPdv, (Object)new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.lblNizaPdv.setName("lblNizaPdv");
            this.jLabel1 = new JLabel();
            this.pzPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.dblVisaOsn = new PzDoubleField();
            this.pzPanel.add((Component)this.dblVisaOsn, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 5, 1, 5), 0, 0));
            this.dblVisaOsn.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.dblVisaOsn.setName("dblVisaOsn");
            this.dblVisaPdv = new PzDoubleField();
            this.pzPanel.add((Component)this.dblVisaPdv, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 5, 1, 5), 0, 0));
            this.dblVisaPdv.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.dblVisaPdv.setName("pzDoubleField1");
            this.dblNizaOsn = new PzDoubleField();
            this.pzPanel.add((Component)this.dblNizaOsn, (Object)new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 5, 1, 5), 0, 0));
            this.dblNizaOsn.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.dblNizaOsn.setName("dblNizaOsnovica");
            this.dblNizaPdv = new PzDoubleField();
            this.pzPanel.add((Component)this.dblNizaPdv, (Object)new GridBagConstraints(9, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(1, 5, 1, 5), 0, 0));
            this.dblNizaPdv.setBorder((Border)new LineBorder(new Color(0, 0, 0), 1, false));
            this.dblNizaPdv.setName("dblNizaPdv");
            this.scrollPane = new JScrollPane();
            GridBagConstraints gbc_scrollPane = new GridBagConstraints();
            gbc_scrollPane.fill = 1;
            gbc_scrollPane.gridx = 0;
            gbc_scrollPane.gridy = 2;
            this.getContentPane().add((Component)this.scrollPane, gbc_scrollPane);
            this.pzTable = new PzTable();
            this.scrollPane.setViewportView((Component)this.pzTable);
            this.selectRadnaJedinica(false);
            this.selectDatum(false);
            this.fillInTheInfo();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doFunc() {
        if (this.nfRJ.getText().equals("")) {
            this.radnaJedinica = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
            if (this.radnaJedinica == null) {
                return;
            }
            this.nfRJ.setText(this.radnaJedinica.getId().getOznRj());
            this.lblNazivRadneJedinice.setText(this.radnaJedinica.getPunNaziv());
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.fillInTheInfo();
        } else {
            this.em = PzEntityManager.getEm();
            RadnajedinicaPK pk = new RadnajedinicaPK();
            pk.setOznRj(this.nfRJ.getText());
            pk.setOznOgranak("1");
            this.radnaJedinica = (Radnajedinica)this.em.find(Radnajedinica.class, (Object)pk);
            if (this.radnaJedinica == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Oznaka radne jedinice nije pronadjena medju dozvoljenim oznakama. Ukoliko niste sigurni, obrisite sadr\u017eaj polja i pritisnite enter.");
                return;
            }
            this.lblNazivRadneJedinice.setText(this.radnaJedinica.getPunNaziv());
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.fillInTheInfo();
        }
    }

    private void fillInTheInfo() {
        String pdv = "";
        Radnajedinica rj = new Radnajedinica();
        rj.setTip("E");
        String radnajedinica = "";
        Date datumOd = null;
        Date datumDo = null;
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        RuleKepu rk = new RuleKepu(rj, 1);
        Vector documents = rk.getZaduzenjeValuedDocuments();
        int i = 0;
        while (i < documents.size()) {
            if (documents.get(i) != null) {
                pdv = String.valueOf(pdv) + "'" + (String)documents.get(i) + "',";
            }
            ++i;
        }
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "','" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "' , 'INTERNI', 'Kupac', 'POCETNO'";
        pdv = pdv.substring(0, pdv.length() - 1);
        radnajedinica = this.radnaJedinica == null || !this.chkRadnaJedinica.isSelected() ? "AND ( ((select r.gtip from radnajedinica r where N.RJ  = r.oznrj and N.oznogranak = r.oznogranak) = 'E') OR (N.RJ IS NULL))" : " AND N.rj = '" + this.radnaJedinica.getId().getOznRj() + "' ";
        if (this.chkDatum.isSelected()) {
            datumOd = this.pzdtfldA.getVal();
            datumDo = this.pzDateField.getVal();
        } else {
            datumOd = PzDateUtility.getFirstDayOfCurrentYear();
            datumDo = PzDateUtility.getCurrentDate();
        }
        String que = String.format(Porez.queueUkalkulisaniPorez, pdv, podtip, datumOd, datumDo, radnajedinica);
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        PzTableModelAnalitikaUKP tableModel = new PzTableModelAnalitikaUKP(this.cursor);
        this.pzTable.setModel((TableModel)((Object)tableModel));
        this.scrollPane.setViewportView((Component)this.pzTable);
        this.refreshSum();
    }

    private void refreshSum() {
        BigDecimal nizaOsnovica = BigDecimal.ZERO;
        BigDecimal nizaPdv = BigDecimal.ZERO;
        BigDecimal visaOsnovica = BigDecimal.ZERO;
        BigDecimal visaPdv = BigDecimal.ZERO;
        int i = 0;
        while (i < this.pzTable.getModel().getRowCount()) {
            nizaOsnovica = nizaOsnovica.add((BigDecimal)this.pzTable.getModel().getValueAt(i, 8));
            nizaPdv = nizaPdv.add((BigDecimal)this.pzTable.getModel().getValueAt(i, 9));
            visaOsnovica = visaOsnovica.add((BigDecimal)this.pzTable.getModel().getValueAt(i, 6));
            visaPdv = visaPdv.add((BigDecimal)this.pzTable.getModel().getValueAt(i, 7));
            ++i;
        }
        this.dblVisaOsn.setVal((Object)visaOsnovica);
        this.dblVisaPdv.setVal((Object)visaPdv);
        this.dblNizaOsn.setVal((Object)nizaOsnovica);
        this.dblNizaPdv.setVal((Object)nizaPdv);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.nfRJ)) {
            this.doFunc();
        } else if (e.getSource().equals(this.btnDodaj)) {
            this.onBtnDodaj();
            this.fillInTheInfo();
        } else if (e.getSource().equals(this.btnBrisanje)) {
            this.onBtnBrisanje();
            this.fillInTheInfo();
        } else if (e.getSource().equals(this.btnIzmena)) {
            if (this.pzTable.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
                return;
            }
            this.onBtnIzmena();
            this.fillInTheInfo();
        } else if (e.getSource().equals(this.btnOsvezi)) {
            this.fillInTheInfo();
        } else if (e.getSource().equals(this.btnStampaj)) {
            this.showReport();
        } else if (e.getSource().equals(this.chkDatum)) {
            this.selectDatum(this.chkDatum.isSelected());
        } else if (e.getSource().equals(this.chkRadnaJedinica)) {
            this.selectRadnaJedinica(this.chkRadnaJedinica.isSelected());
        } else if (e.getSource().equals(this.btnPrikaziDokument)) {
            this.onSlikaDokumentaPressed();
        }
    }

    private void onBtnDodaj() {
        PodaciAnalitike podaci = new PodaciAnalitike();
        podaci.setObrisan(2);
        DodajAnalitiku.getDodajAnalitikaDialog(this, podaci, false);
    }

    private void onBtnBrisanje() {
        PodaciAnalitike podaci = this.getData();
        podaci.setObrisan(1);
        int option = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni da \u017eelite obrisati " + podaci.getOznDokumenta() + " dokument?", "Brisanje", 0);
        if (option == 1) {
            return;
        }
        DodajAnalitiku.getDodajAnalitikaDialog(this, podaci, true);
    }

    private void onBtnIzmena() {
        PodaciAnalitike podaci = this.getData();
        podaci.setObrisan(0);
        DodajAnalitiku.getDodajAnalitikaDialog(this, podaci, true);
    }

    private PodaciAnalitike getData() {
        PodaciAnalitike podaci = new PodaciAnalitike();
        podaci.setDatum((Date)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 1));
        podaci.setSfrKomitenta((String)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 2));
        podaci.setIddok((Integer)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 12));
        podaci.setOznDokumenta((String)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 3));
        podaci.setOpis((String)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 4));
        podaci.setOznrj((String)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 0));
        podaci.setNeoporezivo((BigDecimal)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 5));
        podaci.setNizaOsnovica((BigDecimal)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 8));
        podaci.setNizaPdv((BigDecimal)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 9));
        podaci.setVisaOsnovica((BigDecimal)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 6));
        podaci.setVisaPdv((BigDecimal)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 7));
        podaci.setIdpdv((Integer)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 13));
        return podaci;
    }

    private void selectRadnaJedinica(boolean select) {
        this.lblNazivRadneJedinice.setEnabled(select);
        if (select) {
            this.lblNazivRadneJedinice.setBackground(new Color(172, 234, 175));
        } else {
            this.lblNazivRadneJedinice.setBackground(Color.GRAY);
        }
        this.lblRadnaJedinica.setEnabled(select);
        this.nfRJ.setEnabled(select);
    }

    private void selectDatum(boolean select) {
        this.lblDo.setEnabled(select);
        this.lblOd.setEnabled(select);
        this.pzDateField.setEnabled(select);
        this.pzdtfldA.setEnabled(select);
    }

    private void showReport() {
        Firma firma = null;
        String godina = null;
        try {
            firma = PzFirma.getFirma();
            Vector<Object> data = new Vector<Object>();
            try {
                godina = PzParameter.getParameterValue((String)"TEKUCA_GODINA");
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            data.add(firma);
            if (this.radnaJedinica != null) {
                data.add(this.radnaJedinica);
                data.add(this.radnaJedinica.getOgranak());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("TEKUCA_GODINA", godina);
            params.put("OD_DATUMA", this.pzdtfldA.getText());
            params.put("DO_DATUMA", this.pzDateField.getText());
            if (!this.chkRadnaJedinica.isSelected()) {
                params.put("NIVO", "firma");
            } else {
                params.put("NIVO", "");
            }
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.pzTable, data);
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/pregled.pdv.ukalkulisaniPDV.jasper", params, (String)"ukalkulisaniPdv", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onSlikaDokumentaPressed() {
        if (this.pzTable.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = null;
        iddok = (Integer)this.pzTable.getModel().getValueAt(this.pzTable.convertRowIndexToModel(this.pzTable.getSelectedRow()), 12);
        if (iddok == null || iddok == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Izabrani dokument nema sliku iz arhive.", "Info", 1);
            return;
        }
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

