/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.porez.core.Porez;
import rs.pezar.analitike.gui.porez.datasources.AdapterDatAvans;
import rs.pezar.analitike.gui.porez.datasources.AdapterDatAvansStari;
import rs.pezar.analitike.gui.porez.datasources.AdapterIzlazniPDV;
import rs.pezar.analitike.gui.porez.datasources.AdapterPrimljenAvans;
import rs.pezar.analitike.gui.porez.datasources.AdapterUlazniPdv;
import rs.pezar.analitike.gui.porez.datasources.AdapterUlazniPdvStari;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogPregledPdva
extends PzDialog {
    private PzPanel plGlavni;
    private ButtonGroup bgPDV;
    private JRadioButton rbPdvUPrimljenimFakturama;
    private JRadioButton rbPdvUIzdatimFakturama;
    private PzPanelHeader header;
    private PzButtonPanel pnlbtndetaljni;
    private PzButtonPanel pnlbtnFirma;
    private PzButtonPanel pnlbtnKupci;
    private PzButtonPanel pnlbtnpdv;
    private PzNumericOnlyTextField nfSifraKomitenta;
    private PzDateField dfKrajnjiDatum;
    private PzButton btnOdustani;
    private PzButton btnOk;
    private PzDateField dfPocetniDatum;
    private JLabel lblKrajnjiDatum;
    private JLabel lblPocetniDatum;
    private JRadioButton rbZbirniPregled;
    private JRadioButton rbDetaljniPregled;
    private ButtonGroup bgPregled;
    private JLabel lblSifraKomitenta;
    private JRadioButton rbZaRadnuJedinicu;
    private JRadioButton rbNaNivouFirme;
    private ButtonGroup bgFirmaRadnaJedinica;
    private JRadioButton rbUvozUKompletu;
    private JRadioButton rbKonkretanKomitent;
    private JRadioButton rbPdvUPrimljenimAvansima;
    private JRadioButton rbInoKomitenti;
    private JRadioButton rbSamoSaKosova;
    private JRadioButton rbSamoIzSrbije;
    private JRadioButton rbSviDomaciKomitenti;
    private JRadioButton rbSviKomitenti;
    private ButtonGroup bgKomitenti;
    private JRadioButton rbPdvUDatimAvansima;
    private ScrollableCursor cursor;
    private JCheckBox cbStari;
    private PzRadioGroup<PzChoice> grpVrstaPdv;
    private PzTextField textKomitent;
    private PzTextField textRadnaJedinica;
    private EntityManager em;
    private Radnajedinica rj;
    private String report;
    private JRadioButton rbZbirniPregledporj;
    private JRadioButton rbDetaljniPregledporj;
    private Komitent komitent;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPregledPdva inst = new PzDialogPregledPdva(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPregledPdva(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Pregled PDV-a");
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.plGlavni.setLayout(null);
            this.plGlavni.setPreferredSize(new Dimension(842, 347));
            this.lblPocetniDatum = new JLabel();
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.lblPocetniDatum.setBounds(10, 296, 106, 17);
            this.plGlavni.add((Component)this.lblPocetniDatum);
            this.lblPocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.lblPocetniDatum.setName("lblPocetniDatum");
            this.lblKrajnjiDatum = new JLabel();
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.lblKrajnjiDatum.setBounds(214, 288, 106, 33);
            this.plGlavni.add((Component)this.lblKrajnjiDatum);
            this.lblKrajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.lblKrajnjiDatum.setName("lblKrajnjiDatum");
            this.dfPocetniDatum = new PzDateField();
            this.dfPocetniDatum.setBounds(112, 290, 92, 29);
            this.plGlavni.add((Component)this.dfPocetniDatum);
            this.dfPocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.btnOk = new PzButton();
            this.btnOk.setBounds(595, 290, 97, 33);
            this.plGlavni.add((Component)this.btnOk);
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOdustani = new PzButton();
            this.btnOdustani.setBounds(702, 290, 115, 33);
            this.plGlavni.add((Component)this.btnOdustani);
            this.btnOdustani.setText("Odustani");
            this.btnOdustani.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/forbidden.png")));
            this.btnOdustani.addActionListener((ActionListener)((Object)this));
            this.dfKrajnjiDatum = new PzDateField();
            this.dfKrajnjiDatum.setBounds(330, 290, 92, 29);
            this.plGlavni.add((Component)this.dfKrajnjiDatum);
            this.dfKrajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.nfSifraKomitenta = new PzNumericOnlyTextField();
            this.nfSifraKomitenta.setBounds(476, 141, 115, 29);
            this.plGlavni.add((Component)this.nfSifraKomitenta);
            this.nfSifraKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.nfSifraKomitenta.setPreferredSize(new Dimension(100, 24));
            this.nfSifraKomitenta.setVisible(false);
            this.pnlbtnKupci = new PzButtonPanel();
            this.pnlbtnKupci.setBounds(275, 83, 191, 198);
            GridBagLayout pnlbtnKupciLayout = new GridBagLayout();
            this.plGlavni.add((Component)this.pnlbtnKupci);
            pnlbtnKupciLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.0, 0.1};
            int[] nArray = new int[9];
            nArray[0] = 7;
            nArray[1] = 7;
            nArray[2] = 7;
            nArray[3] = 7;
            nArray[4] = 20;
            nArray[5] = 20;
            nArray[6] = 20;
            nArray[8] = 39;
            pnlbtnKupciLayout.rowHeights = nArray;
            pnlbtnKupciLayout.columnWeights = new double[]{0.1};
            pnlbtnKupciLayout.columnWidths = new int[]{7};
            this.pnlbtnKupci.setLayout((LayoutManager)pnlbtnKupciLayout);
            this.pnlbtnKupci.setOpaque(false);
            this.rbSviKomitenti = new JRadioButton();
            this.pnlbtnKupci.add((Component)this.rbSviKomitenti, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbSviKomitenti.setText("Svi komitenti (doma\u0107i i ino)");
            this.rbSviKomitenti.setToolTipText("Celokupan promet, uklju\u010duju\u0107i i maloprodaju i interne ra\u010dune (kod izlaznih ra\u010duna)");
            this.rbSviKomitenti.setFont(new Font("Tahoma", 0, 14));
            this.rbSviKomitenti.setSelected(true);
            this.rbSviKomitenti.setOpaque(false);
            this.rbSviDomaciKomitenti = new JRadioButton();
            this.rbSviDomaciKomitenti.setToolTipText("Doma\u0107i komitenti ne uklju\u010duju\u0107i maloprodaju i interne ra\u010dune");
            this.pnlbtnKupci.add((Component)this.rbSviDomaciKomitenti, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbSviDomaciKomitenti.setText("Svi DOMA\u0106I komitenti");
            this.rbSviDomaciKomitenti.setFont(new Font("Tahoma", 0, 14));
            this.rbSviDomaciKomitenti.setOpaque(false);
            this.rbSamoIzSrbije = new JRadioButton();
            this.rbSamoIzSrbije.setToolTipText("Porez samo prema komitentima iz Srbije, ne uklju\u010duju\u0107i maloprodaju");
            this.pnlbtnKupci.add((Component)this.rbSamoIzSrbije, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbSamoIzSrbije.setText("Samo iz Srbije");
            this.rbSamoIzSrbije.setFont(new Font("Tahoma", 0, 14));
            this.rbSamoIzSrbije.setOpaque(false);
            this.rbSamoSaKosova = new JRadioButton();
            this.rbSamoSaKosova.setToolTipText("Porez samo prema komitentima sa Kosova, ne uklju\u010duju\u0107i maloprodaju");
            this.pnlbtnKupci.add((Component)this.rbSamoSaKosova, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbSamoSaKosova.setText("Samo sa Kosova");
            this.rbSamoSaKosova.setFont(new Font("Tahoma", 0, 14));
            this.rbSamoSaKosova.setOpaque(false);
            this.rbInoKomitenti = new JRadioButton();
            this.rbInoKomitenti.setToolTipText("Izvoz");
            this.pnlbtnKupci.add((Component)this.rbInoKomitenti, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbInoKomitenti.setText("Ino komitenti");
            this.rbInoKomitenti.setFont(new Font("Tahoma", 0, 14));
            this.rbInoKomitenti.setOpaque(false);
            this.rbKonkretanKomitent = new JRadioButton();
            this.rbKonkretanKomitent.setToolTipText("Porez prema komitentu \u010diju \u0161ifru unesete");
            this.pnlbtnKupci.add((Component)this.rbKonkretanKomitent, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbKonkretanKomitent.setText("Konkretan komitent");
            this.rbKonkretanKomitent.setFont(new Font("Tahoma", 0, 14));
            this.rbKonkretanKomitent.setOpaque(false);
            this.rbKonkretanKomitent.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    if (PzDialogPregledPdva.this.rbKonkretanKomitent.isSelected()) {
                        PzDialogPregledPdva.this.textKomitent.setEnabled(true);
                        PzDialogPregledPdva.this.textKomitent.requestFocus();
                    } else if (!PzDialogPregledPdva.this.rbKonkretanKomitent.isSelected()) {
                        PzDialogPregledPdva.this.textKomitent.setEnabled(false);
                    }
                }
            });
            this.rbUvozUKompletu = new JRadioButton();
            this.rbUvozUKompletu.setToolTipText("Ra\u010duni ino dobavlja\u010da, carinski ra\u010duni i tro\u0161kovi prilikom uvoza");
            this.pnlbtnKupci.add((Component)this.rbUvozUKompletu, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.rbUvozUKompletu.setText("Uvoz u kompletu");
            this.rbUvozUKompletu.setOpaque(false);
            this.rbUvozUKompletu.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        PzDialogPregledPdva.this.rbDetaljniPregled.setSelected(true);
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(false);
                    }
                    if (arg0.getStateChange() == 2 && !PzDialogPregledPdva.this.rbPdvUPrimljenimAvansima.isSelected() && !PzDialogPregledPdva.this.rbPdvUDatimAvansima.isSelected()) {
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(true);
                    }
                }
            });
            this.rbUvozUKompletu.setFont(new Font("Tahoma", 0, 14));
            this.lblSifraKomitenta = new JLabel();
            GridBagConstraints gbc_lblSifraKomitenta = new GridBagConstraints();
            gbc_lblSifraKomitenta.insets = new Insets(0, 0, 5, 0);
            gbc_lblSifraKomitenta.gridx = 0;
            gbc_lblSifraKomitenta.gridy = 7;
            this.pnlbtnKupci.add((Component)this.lblSifraKomitenta, (Object)gbc_lblSifraKomitenta);
            this.lblSifraKomitenta.setText("\u0160ifra komitenta");
            this.lblSifraKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.lblSifraKomitenta.setVisible(false);
            this.textKomitent = new PzTextField();
            this.pnlbtnKupci.add((Component)this.textKomitent, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.textKomitent.setEnabled(false);
            this.textKomitent.setSize(150, 26);
            this.textKomitent.setPreferredSize(new Dimension(150, 26));
            try {
                this.textKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pnlbtnpdv = new PzButtonPanel();
            this.pnlbtnpdv.setBounds(10, 83, 255, 78);
            GridBagLayout pnlbtnpdvLayout = new GridBagLayout();
            this.plGlavni.add((Component)this.pnlbtnpdv);
            this.pnlbtnpdv.setLayout((LayoutManager)pnlbtnpdvLayout);
            pnlbtnpdvLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlbtnpdvLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlbtnpdvLayout.columnWeights = new double[]{0.0, 0.1, 0.0};
            pnlbtnpdvLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlbtnpdv.setOpaque(false);
            this.rbPdvUDatimAvansima = new JRadioButton();
            this.pnlbtnpdv.add((Component)this.rbPdvUDatimAvansima, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbPdvUDatimAvansima.setText("PDV u datim avansima");
            this.rbPdvUDatimAvansima.setFont(new Font("Tahoma", 0, 14));
            this.rbPdvUDatimAvansima.setOpaque(false);
            this.rbPdvUDatimAvansima.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        PzDialogPregledPdva.this.rbDetaljniPregled.setSelected(true);
                        PzDialogPregledPdva.this.rbNaNivouFirme.setSelected(true);
                        PzDialogPregledPdva.this.rbZaRadnuJedinicu.setEnabled(false);
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(false);
                    }
                    if (arg0.getStateChange() == 2) {
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(true);
                        PzDialogPregledPdva.this.rbZaRadnuJedinicu.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(true);
                    }
                }
            });
            this.rbPdvUPrimljenimAvansima = new JRadioButton();
            this.pnlbtnpdv.add((Component)this.rbPdvUPrimljenimAvansima, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbPdvUPrimljenimAvansima.setText("PDV u primljenim avansima");
            this.rbPdvUPrimljenimAvansima.setFont(new Font("Tahoma", 0, 14));
            this.rbPdvUPrimljenimAvansima.setOpaque(false);
            this.rbPdvUPrimljenimAvansima.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        PzDialogPregledPdva.this.rbDetaljniPregled.setSelected(true);
                        PzDialogPregledPdva.this.rbNaNivouFirme.setSelected(true);
                        PzDialogPregledPdva.this.rbZaRadnuJedinicu.setEnabled(false);
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(false);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(false);
                    }
                    if (arg0.getStateChange() == 2) {
                        PzDialogPregledPdva.this.rbDetaljniPregledporj.setEnabled(true);
                        PzDialogPregledPdva.this.rbZaRadnuJedinicu.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregled.setEnabled(true);
                        PzDialogPregledPdva.this.rbZbirniPregledporj.setEnabled(true);
                    }
                }
            });
            this.rbPdvUIzdatimFakturama = new JRadioButton();
            this.pnlbtnpdv.add((Component)this.rbPdvUIzdatimFakturama, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbPdvUIzdatimFakturama.setText("PDV u izdatim fakturama");
            this.rbPdvUIzdatimFakturama.setFont(new Font("Tahoma", 0, 14));
            this.rbPdvUIzdatimFakturama.setOpaque(false);
            this.rbPdvUPrimljenimFakturama = new JRadioButton();
            this.pnlbtnpdv.add((Component)this.rbPdvUPrimljenimFakturama, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbPdvUPrimljenimFakturama.setText("PDV u primljenim fakturama");
            this.rbPdvUPrimljenimFakturama.setFont(new Font("Tahoma", 0, 14));
            this.rbPdvUPrimljenimFakturama.setSelected(true);
            this.rbPdvUPrimljenimFakturama.setOpaque(false);
            this.pnlbtnFirma = new PzButtonPanel();
            this.pnlbtnFirma.setBounds(641, 214, 144, 44);
            GridBagLayout pnlbtnFirmaLayout = new GridBagLayout();
            this.plGlavni.add((Component)this.pnlbtnFirma);
            pnlbtnFirmaLayout.rowWeights = new double[]{1.0, 1.0};
            pnlbtnFirmaLayout.rowHeights = new int[]{29, 27};
            pnlbtnFirmaLayout.columnWeights = new double[]{0.1};
            pnlbtnFirmaLayout.columnWidths = new int[]{7};
            this.pnlbtnFirma.setLayout((LayoutManager)pnlbtnFirmaLayout);
            this.pnlbtnFirma.setOpaque(false);
            this.rbNaNivouFirme = new JRadioButton();
            this.pnlbtnFirma.add((Component)this.rbNaNivouFirme, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.rbNaNivouFirme.setText("Na nivou firme");
            this.rbNaNivouFirme.setFont(new Font("Tahoma", 0, 14));
            this.rbNaNivouFirme.setPreferredSize(new Dimension(106, 17));
            this.rbNaNivouFirme.setSelected(true);
            this.rbNaNivouFirme.setOpaque(false);
            this.rbZaRadnuJedinicu = new JRadioButton();
            this.pnlbtnFirma.add((Component)this.rbZaRadnuJedinicu, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rbZaRadnuJedinicu.setText("Za radnu jedinicu");
            this.rbZaRadnuJedinicu.setFont(new Font("Tahoma", 0, 14));
            this.rbZaRadnuJedinicu.setOpaque(false);
            this.rbZaRadnuJedinicu.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (arg0.getStateChange() == 1) {
                        PzDialogPregledPdva.this.textRadnaJedinica.setEnabled(true);
                        PzDialogPregledPdva.this.rj = PzDialogRJ.getRJ((PzDialog)PzDialogPregledPdva.this);
                        if (PzDialogPregledPdva.this.rj != null) {
                            PzDialogPregledPdva.this.textRadnaJedinica.setText(PzDialogPregledPdva.this.rj.getPunNaziv());
                        }
                    } else if (arg0.getStateChange() == 2) {
                        PzDialogPregledPdva.this.textRadnaJedinica.setEnabled(false);
                        PzDialogPregledPdva.this.textRadnaJedinica.setText("");
                        PzDialogPregledPdva.this.rj = null;
                    }
                }
            });
            this.pnlbtndetaljni = new PzButtonPanel();
            this.pnlbtndetaljni.setBounds(629, 83, 165, 86);
            GridBagLayout pnlbtndetaljniLayout = new GridBagLayout();
            this.plGlavni.add((Component)this.pnlbtndetaljni);
            pnlbtndetaljniLayout.rowWeights = new double[]{1.0, 0.1, 1.0, 0.1};
            pnlbtndetaljniLayout.rowHeights = new int[]{7, 20, 7, 20};
            pnlbtndetaljniLayout.columnWeights = new double[]{0.0};
            pnlbtndetaljniLayout.columnWidths = new int[]{150};
            this.pnlbtndetaljni.setLayout((LayoutManager)pnlbtndetaljniLayout);
            this.pnlbtndetaljni.setOpaque(false);
            this.rbZbirniPregled = new JRadioButton();
            this.pnlbtndetaljni.add((Component)this.rbZbirniPregled, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rbZbirniPregled.setText("Zbirni pregled");
            this.rbZbirniPregled.setFont(new Font("Tahoma", 0, 14));
            this.rbZbirniPregled.setOpaque(false);
            this.rbDetaljniPregledporj = new JRadioButton();
            this.pnlbtndetaljni.add((Component)this.rbDetaljniPregledporj, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbDetaljniPregledporj.setText("Detaljni pregled po RJ");
            this.rbDetaljniPregledporj.setFont(new Font("Tahoma", 0, 14));
            this.rbDetaljniPregledporj.setOpaque(false);
            this.rbDetaljniPregled = new JRadioButton();
            this.pnlbtndetaljni.add((Component)this.rbDetaljniPregled, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rbDetaljniPregled.setText("Detaljni pregled");
            this.rbDetaljniPregled.setFont(new Font("Tahoma", 0, 14));
            this.rbDetaljniPregled.setSelected(true);
            this.rbDetaljniPregled.setOpaque(false);
            this.rbZbirniPregledporj = new JRadioButton();
            this.pnlbtndetaljni.add((Component)this.rbZbirniPregledporj, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbZbirniPregledporj.setText("Zbirni pregled po RJ");
            this.rbZbirniPregledporj.setFont(new Font("Tahoma", 0, 14));
            this.rbZbirniPregledporj.setOpaque(false);
            this.header = new PzPanelHeader();
            this.header.setLocation(0, 0);
            this.plGlavni.add((Component)this.header);
            this.header.setSize(842, 72);
            this.header.setPreferredSize(new Dimension(60, 80));
            this.header.setTitle("Pregled poreza na dodatu vrednost");
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/pdv_edit.png")));
            this.textRadnaJedinica = new PzTextField();
            this.textRadnaJedinica.setBounds(552, 175, 265, 33);
            this.plGlavni.add((Component)this.textRadnaJedinica);
            this.textRadnaJedinica.setEnabled(false);
            this.grpVrstaPdv = new PzRadioGroup((Object[])new PzChoice[]{new PzChoice("PDV u kompletu", (Object)""), new PzChoice("Samo sa pravom", (Object)"SA_PRAVOM"), new PzChoice("Samo bez prava", (Object)"BEZ_PRAVA"), new PzChoice("Samo interni obra\u010dun", (Object)"OBRACUNAT_SA_PRAVOM")});
            this.grpVrstaPdv.setOpaque(false);
            this.grpVrstaPdv.setLayoutAxis(1);
            this.grpVrstaPdv.setSelectedIndex(0);
            this.plGlavni.add(this.grpVrstaPdv);
            this.grpVrstaPdv.setBounds(17, 173, 141, 89);
            this.cbStari = new JCheckBox();
            this.cbStari.setText("Stari format");
            this.cbStari.setOpaque(false);
            this.plGlavni.add((Component)this.cbStari);
            this.cbStari.setBounds(17, 266, 187, 17);
            this.pack();
            this.setSize(851, 383);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOk)) {
            if (this.rbZaRadnuJedinicu.isSelected() && this.rj == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate izabrati radnu jedinicu");
                return;
            }
            if (this.rbKonkretanKomitent.isSelected() && this.komitent == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate izabrati komitenta");
                return;
            }
            this.onbtnOk();
        } else if (e.getSource().equals(this.btnOdustani)) {
            this.onbtnOdustani();
        }
    }

    private void onbtnOdustani() {
        this.dispose();
    }

    private void onbtnOk() {
        this.generateFilterFromDialogPDV();
    }

    private String generateFilterFromDialogPregled() {
        if (this.rbZbirniPregled.isSelected()) {
            return "ZBIRNO";
        }
        if (this.rbDetaljniPregled.isSelected()) {
            return "DETALJNO";
        }
        if (this.rbZbirniPregledporj.isSelected()) {
            return "ZBIRNOPORJ";
        }
        if (this.rbDetaljniPregledporj.isSelected()) {
            return "DETALJNOPORJ";
        }
        return "DETALJNO";
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity != null) {
            if (entity instanceof Komitent) {
                this.komitent = (Komitent)entity;
                if (this.komitent != null) {
                    ((PzField)component).setVal((Object)this.komitent.getSfrKomitent());
                }
            } else if (entity instanceof Radnajedinica) {
                ((PzField)component).setVal((Object)((Radnajedinica)entity).getId().getOznRj());
                this.rj = (Radnajedinica)entity;
            }
        }
    }

    private String generateFilterFromDialogKomitent() {
        String komitent = "";
        if (this.rbSviKomitenti.isSelected()) {
            komitent = "";
        } else if (this.rbSviDomaciKomitenti.isSelected()) {
            komitent = "AND ((SELECT k.domacikomitent FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 1)";
        } else if (this.rbSamoIzSrbije.isSelected()) {
            komitent = "AND ((SELECT k.domacikomitent FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 1) AND ((SELECT k.srbija FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 1)";
        } else if (this.rbSamoSaKosova.isSelected()) {
            komitent = "AND ((SELECT k.domacikomitent FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 1) AND ((SELECT k.srbija FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 0)";
        } else if (this.rbInoKomitenti.isSelected()) {
            komitent = "AND ((SELECT k.domacikomitent FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 0)";
        } else if (this.rbKonkretanKomitent.isSelected()) {
            komitent = "AND a.sfrkomitent = '" + this.textKomitent.getText() + "' AND NOT a.sfrkomitent IS NULL";
        } else if (this.rbUvozUKompletu.isSelected()) {
            komitent = "AND ((SELECT k.domacikomitent FROM komitent k WHERE k.sfrkomitent = a.sfrkomitent) = 0)";
        }
        return komitent;
    }

    private String generateFilterFromDialogFirma() {
        if (this.rbNaNivouFirme.isSelected()) {
            return "firma";
        }
        if (this.rbZaRadnuJedinicu.isSelected()) {
            return "rj";
        }
        return null;
    }

    private String generateFilterFromDialogVrstaPDV() {
        if (this.rbPdvUDatimAvansima.isSelected()) {
            if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("SA_PRAVOM")) {
                return String.format(" AND str3='%s'", "SA_PRAVOM", "INO", "SA_PRAVOM");
            }
            if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("BEZ_PRAVA")) {
                return String.format(" AND str3='%s'", "BEZ_PRAVA", "BEZ_PRAVA");
            }
            if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("OBRACUNAT_SA_PRAVOM")) {
                return String.format(" AND str3='%s'", "OBRACUNAT_SA_PRAVOM", "OBRACUNAT_SA_PRAVOM");
            }
            return "";
        }
        if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("SA_PRAVOM")) {
            return String.format(" WHERE pdvkalk='%s' OR pdvkalk='%s' OR pdvodob='%s'", "SA_PRAVOM", "INO", "SA_PRAVOM");
        }
        if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("BEZ_PRAVA")) {
            return String.format(" WHERE pdvkalk='%s' OR pdvodob='%s'", "BEZ_PRAVA", "BEZ_PRAVA");
        }
        if (((PzChoice)this.grpVrstaPdv.getSelectedValue()).getValue().equals("OBRACUNAT_SA_PRAVOM")) {
            return String.format(" WHERE pdvkalk='%s' OR pdvodob='%s'", "OBRACUNAT_SA_PRAVOM", "OBRACUNAT_SA_PRAVOM");
        }
        return "";
    }

    private String generateFilterFromDialogPDV() {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        if (this.rbPdvUPrimljenimFakturama.isSelected() && this.rbSviKomitenti.isSelected()) {
            return this.pdvPrimljeneFaktureSviKomitenti();
        }
        if (this.rbPdvUPrimljenimFakturama.isSelected() && this.rbUvozUKompletu.isSelected()) {
            return this.pdvPrimljeneFaktureUvoz();
        }
        if (this.rbPdvUPrimljenimFakturama.isSelected() && !this.rbUvozUKompletu.isSelected() && !this.rbSviKomitenti.isSelected()) {
            return this.pdvPrimljeneFaktureSviKomitenti();
        }
        if (this.rbPdvUIzdatimFakturama.isSelected() && this.rbSviKomitenti.isSelected()) {
            return this.pdvIzdateFaktureSve();
        }
        if (this.rbPdvUIzdatimFakturama.isSelected() && (this.rbKonkretanKomitent.isSelected() || this.rbInoKomitenti.isSelected() || this.rbSamoSaKosova.isSelected())) {
            return this.pdvIzdateFaktureSve();
        }
        if (this.rbPdvUIzdatimFakturama.isSelected() && (this.rbSviDomaciKomitenti.isSelected() || this.rbSamoIzSrbije.isSelected())) {
            return this.pdvIzdateFaktureSve();
        }
        if (this.rbPdvUDatimAvansima.isSelected()) {
            return this.pdvDatiAvansi();
        }
        if (this.rbPdvUPrimljenimAvansima.isSelected()) {
            return this.pdvPrimljeniAvansi();
        }
        return null;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }

    private String pdvPrimljeneFaktureSviKomitenti() {
        String pdv = "";
        String que = null;
        String komitent = this.generateFilterFromDialogKomitent();
        this.generateFilterFromDialogFirma();
        String pregled = this.generateFilterFromDialogPregled();
        String sort = "";
        String radnajedinica = "";
        if (this.generateFilterFromDialogPregled().equals("DETALJNOPORJ")) {
            sort = "rj,";
        }
        if (this.textRadnaJedinica.getText() != null && !this.textRadnaJedinica.getText().equals("")) {
            radnajedinica = " AND a.oznrj = '" + this.rj.getId().getOznRj() + "'";
        }
        int i = 0;
        while (i < Porez.ulaznaDokumenta.length) {
            if (Porez.ulaznaDokumenta[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.ulaznaDokumenta[i] + "',";
            }
            ++i;
        }
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "','" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "' , 'INTERNI', 'Kupac', 'POCETNO'";
        pdv = pdv.substring(0, pdv.length() - 1);
        que = String.format("SELECT * FROM (SELECT \ta.ozndokumenta, \ta.tip, \ta.podtip, \ta.datPrometa datpor, \ta.sfrkomitent, \ta.storno, \t(SELECT ka.rbroj FROM kalkulacija ka WHERE ka.iddok = a.iddok), \t(SELECT ka.pdv FROM kalkulacija ka WHERE ka.iddok = a.iddok) as pdvkalk, \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK'), \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK'), \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK'), \tk.naziv, \tk.grad, \tk.pib, \tk.srbija, \tk.zemljakomitenta, \tk.domacikomitent, \t(SELECT ka.iznos FROM kalkulacija ka WHERE ka.iddok = a.iddok), \tk.obveznikpdv, \ta.iddok AS grupa, \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT t.osnovica FROM kalkulacija t WHERE a.iddok = t.iddok), \t(SELECT t.bezprava FROM kalkulacija t WHERE a.iddok = t.iddok), \t(SELECT t.oslobodjeno FROM kalkulacija t WHERE a.iddok = t.iddok), \ta.iznos, \t(SELECT p.str1 FROM opstidokument p WHERE a.iddok = p.iddok) as pdvodob, \t(SELECT p.str2 FROM opstidokument p WHERE a.iddok = p.iddok), \tCASE \t\tWHEN a.oznrj IS NULL THEN 'nema' \t\tELSE a.oznrj \tEND AS rj, \ta.oznOgranak,\tk.tip,    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'S1') AND NOT p.tip = 'UK'),\t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'S1') AND NOT p.tip = 'UK') FROM \tdokument a, komitent k WHERE \ta.sfrkomitent = k.sfrkomitent AND \ta.tip IN (%s) AND \t(NOT a.podtip IN (%s) OR a.podtip IS NULL) AND \ta.arhiviran = 1 and not a.rbrdok = -1 \t%s AND \ta.datprometa >= '%s' \tAND a.datprometa <= '%s' \t%s ) as PDV    {where}  ORDER BY\t%s datpor ", pdv, podtip, komitent, this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal(), radnajedinica, sort);
        que = que.replace("{where}", this.generateFilterFromDialogVrstaPDV());
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(PzFirma.getFirma());
            if (this.rj != null) {
                data.add(this.rj);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("NIVO", this.generateFilterFromDialogFirma());
        if (pregled.equals("ZBIRNO")) {
            params.put("naslov", "Pregled pdv-a u ulaznim dokumentima (zbirni pregled)");
        } else {
            params.put("naslov", "Pregled pdv-a u ulaznim dokumentima (detaljni pregled)");
        }
        params.put("TIP", pregled);
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)(!this.cbStari.isSelected() ? new AdapterUlazniPdv(false) : new AdapterUlazniPdvStari(false)));
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)(!this.cbStari.isSelected() ? "rs/pezar/reports/compiled/pregled.pdv.ulaz.filter.jasper" : "rs/pezar/reports/compiled/pregled.pdv.ulaz.jasper"), params, (String)"pregled_pdv_ulaz", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return que;
    }

    private String pdvPrimljeneFaktureUvoz() {
        String pdv = "";
        String que = null;
        this.generateFilterFromDialogKomitent();
        this.generateFilterFromDialogFirma();
        String pregled = this.generateFilterFromDialogPregled();
        pdv = this.getStringFromArray(Porez.ulaznaDokumentaZaUvoz);
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "', 'INTERNI','Kupac','POCETNO'";
        que = String.format(Porez.queuePrimljeneFaktureUvoz, pdv, podtip, this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal());
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(PzFirma.getFirma());
            if (this.rj != null) {
                data.add(this.rj);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("NIVO", this.generateFilterFromDialogFirma());
        if (pregled.equals("ZBIRNO")) {
            params.put("naslov", "Pregled PDV-a u ulaznim dokumentima (zbirni pregled)");
        } else {
            params.put("naslov", "Pregled PDV-a u ulaznim dokumentima (detaljni pregled)");
        }
        params.put("TIP", pregled);
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)new AdapterUlazniPdvStari(true));
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)"rs/pezar/reports/compiled/pregled.pdv.ulaz.uvoz.jasper", params, (String)"pregled_pdv_ulaz_uvoz", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return que;
    }

    private String pdvIzdateFaktureSve() {
        String pdv = "";
        String que = null;
        String komitent = this.generateFilterFromDialogKomitent();
        this.generateFilterFromDialogFirma();
        String pregled = this.generateFilterFromDialogPregled();
        String sort = "";
        String pregl = "";
        String radnajedinica = "";
        if (this.generateFilterFromDialogPregled().equals("DETALJNOPORJ") || this.generateFilterFromDialogPregled().equals("ZBIRNOPORJ")) {
            sort = "rj,";
            pregl = "rs/pezar/reports/compiled/pregled.pdv.izlazne.fakture.detaljno.rj.jasper";
        } else {
            sort = "";
            pregl = "rs/pezar/reports/compiled/pregled.pdv.izlazne.fakture.jasper";
        }
        radnajedinica = this.textRadnaJedinica.getText() != null && !this.textRadnaJedinica.getText().equals("") ? " AND a.oznrj = '" + this.rj.getId().getOznRj() + "'" : "";
        int i = 0;
        while (i < Porez.izlaznaDokumenta.length) {
            if (Porez.izlaznaDokumenta[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.izlaznaDokumenta[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        que = Porez.queueIzdateFakture.replace("{dokumenta}", pdv);
        que = que.replace("{komitent}", komitent);
        que = que.replace("{pocetnidatum}", this.dfPocetniDatum.getVal().toString());
        que = que.replace("{krajnjidatum}", this.dfKrajnjiDatum.getVal().toString());
        que = que.replace("{radnajedinica}", radnajedinica);
        que = que.replace("{sort}", sort);
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(PzFirma.getFirma());
            if (this.rj != null) {
                data.add(this.rj);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("OGRANICENJE", this.getSelectefFilterText());
        params.put("NIVO", this.generateFilterFromDialogFirma());
        if (pregled.equals("ZBIRNO")) {
            params.put("naslov", "Pregled PDV-a u izdatim fakturama (zbirni pregled)");
        } else {
            params.put("naslov", "Pregled PDV-a u izdatim fakturama (detaljni pregled)");
        }
        params.put("TIP", pregled);
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)new AdapterIzlazniPDV());
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)pregl, params, (String)"pregled_pdv_izlaz", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return que;
    }

    private String pdvDatiAvansi() {
        String pdv = "";
        String que = null;
        String komitent = this.generateFilterFromDialogKomitent();
        this.generateFilterFromDialogFirma();
        String pregled = this.generateFilterFromDialogPregled();
        int i = 0;
        while (i < Porez.izdatiAvansi.length) {
            if (Porez.izdatiAvansi[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.izdatiAvansi[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        que = String.format("SELECT a.ozndokumenta, a.tip, a.podtip, a.datum, a.sfrkomitent, a.storno, od.iznosbezporeza, od.str3, (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1')), (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2')), (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1' OR p.ozntargr = 'S1')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3')), k.naziv, k.grad, k.pib, k.srbija, k.zemljakomitenta, k.domacikomitent, od.iznossaporezom, k.obveznikpdv, a.oznrj, a.oznOgranak, (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND p.ozntargr = 'S1') FROM dokument a, opstidokument od, komitent k WHERE a.sfrkomitent = k.sfrkomitent AND a.tip IN (%s) AND (NOT a.podtip = 'POCETNO' OR a.podtip IS NULL) AND od.iddok = a.iddok AND a.arhiviran = 1 %s AND a.datum >= '%s' AND a.datum <= '%s'  {where} ORDER BY a.datum", pdv, komitent, this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal());
        que = que.replace("{where}", this.generateFilterFromDialogVrstaPDV());
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(PzFirma.getFirma());
            if (this.rj != null) {
                data.add(this.rj);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("NIVO", this.generateFilterFromDialogFirma());
        if (pregled.equals("ZBIRNO")) {
            params.put("naslov", "Pregled PDV-a u datim avansima (zbirni pregled)");
        } else {
            params.put("naslov", "Pregled PDV-a u datim avansima (detaljni pregled)");
        }
        params.put("TIP", pregled);
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)(!this.cbStari.isSelected() ? new AdapterDatAvans() : new AdapterDatAvansStari()));
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)(!this.cbStari.isSelected() ? "rs/pezar/reports/compiled/pregled.pdv.ulaz.filter.jasper" : "rs/pezar/reports/compiled/pregled.pdv.ulaz.jasper"), params, (String)"pregled_pdv_dat_avans", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return que;
    }

    private String pdvPrimljeniAvansi() {
        String pdv = "";
        String pdv1 = "";
        String que = null;
        String komitent = this.generateFilterFromDialogKomitent();
        this.generateFilterFromDialogFirma();
        String pregled = this.generateFilterFromDialogPregled();
        int i = 0;
        while (i < Porez.primljeniAvansi.length) {
            if (Porez.primljeniAvansi[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.primljeniAvansi[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        i = 0;
        while (i < Porez.izdatiAvansi.length) {
            if (Porez.izdatiAvansi[i] != null) {
                pdv1 = String.valueOf(pdv1) + "'" + Porez.izdatiAvansi[i] + "',";
            }
            ++i;
        }
        pdv1 = pdv1.substring(0, pdv1.length() - 1);
        que = String.format("SELECT a.ozndokumenta, a.tip, a.podtip, a.datprometa, a.sfrkomitent, a.storno, od.iznossaporezom, od.iznosbezporeza,(select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' OR p.ozntargr = 'T11'  or p.ozntargr = 'U1')), (select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' OR p.ozntargr = 'T11'  or p.ozntargr = 'U1')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), k.naziv, k.grad, k.pib, k.srbija, k.zemljakomitenta, k.domacikomitent, od.str3, a.oznrj, a.oznOgranak,(select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND p.ozntargr = 'S1')  FROM dokument a, opstidokument od, komitent k WHERE a.iddok = od.iddok AND a.sfrkomitent = k.sfrkomitent AND a.tip in (%s) AND (NOT a.podtip = 'POCETNO' OR a.podtip IS NULL) AND a.arhiviran = 1 %s AND a.datprometa >= '%s' AND a.datprometa <= '%s' ORDER BY k.domacikomitent", pdv, komitent, this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal(), pdv1, komitent, this.dfPocetniDatum.getVal(), this.dfKrajnjiDatum.getVal());
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        this.cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(PzFirma.getFirma());
            if (this.rj != null) {
                data.add(this.rj);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("NIVO", this.generateFilterFromDialogFirma());
        if (pregled.equals("ZBIRNO")) {
            params.put("naslov", "Pregled PDV-a u primljenim avansima (zbirni pregled)");
        } else {
            params.put("naslov", "Pregled PDV-a u primljenim avansima (detaljni pregled)");
        }
        params.put("TIP", pregled);
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, this.cursor);
        datasource.setAdapter((PzDataSourceAdapter)new AdapterPrimljenAvans());
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)"rs/pezar/reports/compiled/pregled.pdv.izlazne.fakture.jasper", params, (String)"pregled_pdv_primljeni_avans", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return que;
    }

    private String getStringFromArray(String[] array) {
        String result = "";
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                result = String.valueOf(result) + "'" + array[i] + "',";
            }
            ++i;
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private String getSelectefFilterText() {
        if (this.rbSviDomaciKomitenti.isSelected()) {
            return this.rbSviDomaciKomitenti.getText();
        }
        if (this.rbInoKomitenti.isSelected()) {
            return this.rbInoKomitenti.getText();
        }
        if (this.rbKonkretanKomitent.isSelected()) {
            return this.rbKonkretanKomitent.getText();
        }
        if (this.rbSamoIzSrbije.isSelected()) {
            return this.rbSamoIzSrbije.getText();
        }
        if (this.rbSamoSaKosova.isSelected()) {
            return this.rbSamoSaKosova.getText();
        }
        if (this.rbUvozUKompletu.isSelected()) {
            return this.rbUvozUKompletu.getText();
        }
        if (this.rbSviKomitenti.isSelected()) {
            return this.rbSviKomitenti.getText();
        }
        return "";
    }
}

