/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.porez.core.Porez;
import rs.pezar.analitike.gui.porez.datasources.AdapterIzlazniPdvPoRj;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogSumarniPregledPdvaPoRJ
extends PzDialog {
    private PzPanel plGlavni;
    private JLabel lblPocetniDatum;
    private JLabel lblKrajnjiDatum;
    private PzButton btnOdustani;
    private PzPanelHeader header;
    private PzDateField dfKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private PzButton btnOk;
    private EntityManager em;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogSumarniPregledPdvaPoRJ inst = new PzDialogSumarniPregledPdvaPoRJ(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogSumarniPregledPdvaPoRJ(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Pregled PDV-a");
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            plGlavniLayout.rowHeights = new int[]{20, 7, 7, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{132, 89, 10, 70, 20};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.plGlavni.setPreferredSize(new Dimension(324, 249));
            this.header = new PzPanelHeader();
            this.plGlavni.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setPreferredSize(new Dimension(10, 10));
            this.header.setTitle("Pregled PDV po RJ");
            this.header.setSize(10, 10);
            this.lblPocetniDatum = new JLabel();
            this.plGlavni.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.lblPocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.lblKrajnjiDatum = new JLabel();
            this.plGlavni.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.lblKrajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.btnOk = new PzButton();
            this.plGlavni.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOdustani = new PzButton();
            this.plGlavni.add((Component)this.btnOdustani, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOdustani.setText("Odustani");
            this.btnOdustani.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/forbidden.png")));
            this.btnOdustani.addActionListener((ActionListener)((Object)this));
            this.dfPocetniDatum = new PzDateField();
            this.plGlavni.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPocetniDatum.setFont(new Font("Tahoma", 0, 14));
            this.dfKrajnjiDatum = new PzDateField();
            this.plGlavni.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKrajnjiDatum.setFont(new Font("Tahoma", 0, 14));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOk)) {
            this.onbtnOk();
        } else if (e.getSource().equals(this.btnOdustani)) {
            this.onbtnOdustani();
        }
    }

    private void onbtnOdustani() {
        this.dispose();
    }

    private void onbtnOk() {
        String pdv = "";
        int i = 0;
        while (i < Porez.izlaznaDokumenta.length) {
            if (Porez.izlaznaDokumenta[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.izlaznaDokumenta[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        String que = String.format("SELECT a.ozndokumenta, a.tip, a.podtip, a.datum, a.sfrkomitent, a.storno, f.saporezom, f.sapravomnaodbitak,(select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' or p.ozntargr = 'U1')), (select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' or p.ozntargr = 'U1')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), k.naziv, k.grad, k.pib, k.srbija, k.zemljakomitenta, k.domacikomitent, f.iznosbezporeza, (SELECT r.oznrj FROM  radnajedinica r WHERE r.oznrj = a.oznrj AND r.oznogranak = a.oznogranak) AS rj ,(SELECT r.naziv FROM  radnajedinica r WHERE r.oznrj = a.oznrj AND r.oznogranak = a.oznogranak),(SELECT r.mesto FROM  radnajedinica r WHERE r.oznrj = a.oznrj AND r.oznogranak = a.oznogranak),(SELECT o.oznogranak FROM   ogranak o WHERE o.oznogranak = a.oznogranak) AS ogranak,(SELECT o.naziv FROM   ogranak o WHERE o.oznogranak = a.oznogranak),(SELECT o.mesto FROM   ogranak o WHERE o.oznogranak = a.oznogranak)FROM dokument a, faktura f, komitent k WHERE a.iddok = f.iddok AND a.sfrkomitent = k.sfrkomitent AND a.tip in (%s) AND a.arhiviran = 1 AND a.datum >= '" + this.dfPocetniDatum.getVal() + "' AND a.datum <= '" + this.dfKrajnjiDatum.getVal() + "' " + "ORDER BY rj", pdv);
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(que);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        ScrollableCursor cursor = (ScrollableCursor)q.getSingleResult();
        Vector<Firma> data = new Vector<Firma>();
        try {
            data.add(PzFirma.getFirma());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("OD_DATUMA", this.dfPocetniDatum.getText());
        params.put("DO_DATUMA", this.dfKrajnjiDatum.getText());
        params.put("naslov", "Zbirni pregled izlaznog PDV-a po radnim jedinicama");
        PzDataSourceExtended datasource = new PzDataSourceExtended(data, cursor);
        datasource.setAdapter((PzDataSourceAdapter)new AdapterIzlazniPdvPoRj());
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)datasource, (String)"rs/pezar/reports/compiled/pregled.pdv.zbirni.rj.jasper", params, (String)"pregled_pdv_izlaz_po_rj");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cursor != null) {
            cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
    }
}

