/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledProdaje
extends PzDialog {
    public static final String SVE_ROBNE_GRUPE = "Sve robne grupe";
    public static final String ODREDJENA_ROBNA_GRUPA = "Odre\u0111ena robna grupa";
    public static final String ODREDJENI_KUPAC = "Odre\u0111eni kupac";
    private PzPanel pnlGlavni;
    private JLabel lblInfo;
    private PzDateField dfKrajnjiDatum;
    private PzRadioGroup<String> panelRbs;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzPanel pnlInfo;
    private PzButton btnPotvrdi;
    private JLabel lblKupac;
    private PzComboBox cbValuta;
    private PzPanel pnlValuta;
    private PzTextField tfNazivKupca;
    private PzTextField tfNazivRobneGrupe;
    private PzFieldIndikator indSifraKupca;
    private PzFieldIndikator indRobnaGrupa;
    private PzTextField tfSifra;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private Komitent entKomitent;
    private Robnagrupa entRobnagrupa;
    private ScrollableCursor cursor = null;

    public PzDialogPregledProdaje(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled prodaje");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{85, 100, 103, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(490, 366));
            this.pnlInfo = new PzPanel();
            GridBagLayout pnlInfoLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlInfo, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlInfoLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.rowHeights = new int[]{14, 83, 8, 25, 25, 27, 25, 25, 9, 20};
            pnlInfoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.columnWidths = new int[]{15, 100, 100, 88, 109, 146, 7};
            this.pnlInfo.setLayout((LayoutManager)pnlInfoLayout);
            this.lblInfo = new JLabel();
            this.pnlInfo.add((Component)this.lblInfo, (Object)new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblInfo.setText("<html>Pregled se ne odnosi na:<br>-Maloprodaju<br>-Magacin sirovina<br>-Magacin poluproizvoda<br>-Magacin gotovih proizvoda</html>");
            this.lblInfo.setForeground(new Color(0, 0, 255));
            this.lblInfo.setFont(new Font("Tahoma", 1, 12));
            this.lblInfo.setOpaque(false);
            this.lblPocetniDatum = new JLabel();
            this.pnlInfo.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetniDatum = new PzDateField();
            this.pnlInfo.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.pnlInfo.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlInfo.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panelRbs = new PzRadioGroup((Object[])new String[]{SVE_ROBNE_GRUPE, ODREDJENA_ROBNA_GRUPA, ODREDJENI_KUPAC});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlInfo.add(this.panelRbs, (Object)new GridBagConstraints(1, 5, 2, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRbs.setSelectedValue((Object)SVE_ROBNE_GRUPE);
            this.panelRbs.setOpaque(false);
            this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogPregledProdaje.SVE_ROBNE_GRUPE)) {
                            PzDialogPregledProdaje.this.radioGroupSelectionChanged(PzDialogPregledProdaje.SVE_ROBNE_GRUPE);
                        } else if (evt.getValue().equals(PzDialogPregledProdaje.ODREDJENA_ROBNA_GRUPA)) {
                            PzDialogPregledProdaje.this.radioGroupSelectionChanged(PzDialogPregledProdaje.ODREDJENA_ROBNA_GRUPA);
                        } else if (evt.getValue().equals(PzDialogPregledProdaje.ODREDJENI_KUPAC)) {
                            PzDialogPregledProdaje.this.radioGroupSelectionChanged(PzDialogPregledProdaje.ODREDJENI_KUPAC);
                        }
                    }
                }
            });
            this.lblRobnaGrupa = new JLabel();
            this.pnlInfo.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRobnaGrupa.setText("Robna grupa");
            this.lblRobnaGrupa.setEnabled(false);
            this.tfRobnaGrupa = new PzTextField();
            this.pnlInfo.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.tfRobnaGrupa.setFocusable(false);
            this.tfRobnaGrupa.setEditable(false);
            this.lblKupac = new JLabel();
            this.pnlInfo.add((Component)this.lblKupac, (Object)new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKupac.setText("\u0160ifra kupca");
            this.lblKupac.setEnabled(false);
            this.tfSifra = new PzTextField();
            this.pnlInfo.add((Component)this.tfSifra, (Object)new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfSifra.setFocusable(false);
            this.tfSifra.setEditable(false);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.pnlInfo.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.indSifraKupca = new PzFieldIndikator();
            this.pnlInfo.add((Component)this.indSifraKupca, (Object)new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNazivRobneGrupe = new PzTextField();
            this.pnlInfo.add((Component)this.tfNazivRobneGrupe, (Object)new GridBagConstraints(5, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 10), 0, 0));
            this.tfNazivRobneGrupe.setFocusable(false);
            this.tfNazivRobneGrupe.setEditable(false);
            this.tfNazivKupca = new PzTextField();
            this.pnlInfo.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(5, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 10), 0, 0));
            this.tfNazivKupca.setFocusable(false);
            this.tfNazivKupca.setEditable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlInfo.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.pnlInfo.add((Component)this.pnlValuta, (Object)new GridBagConstraints(3, 2, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 20), 0, 0));
            this.pnlValuta.setLayout(null);
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta);
            this.cbValuta.setBounds(17, 24, 136, 25);
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.tfSifra.setStateIndikator(this.indSifraKupca);
            this.pack();
            this.setSize(750, 377);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setEnabledRobnaGrupa(boolean enabled) {
        this.lblRobnaGrupa.setEnabled(enabled);
        this.tfRobnaGrupa.setEditable(enabled);
        this.tfRobnaGrupa.setFocusable(enabled);
        this.indRobnaGrupa.setEnabled(enabled);
        if (!enabled) {
            this.tfRobnaGrupa.setVal((Object)"");
            this.tfNazivRobneGrupe.setVal((Object)"");
            this.indRobnaGrupa.setState(PzFieldIndikator.STATE_INVALID);
            this.entRobnagrupa = null;
        }
    }

    private void setEnabledKupac(boolean enabled) {
        this.lblKupac.setEnabled(enabled);
        this.tfSifra.setEditable(enabled);
        this.tfSifra.setFocusable(enabled);
        this.indSifraKupca.setEnabled(enabled);
        if (!enabled) {
            this.tfSifra.setVal((Object)"");
            this.tfNazivKupca.setVal((Object)"");
            this.indSifraKupca.setState(PzFieldIndikator.STATE_INVALID);
            this.entKomitent = null;
        }
    }

    private void radioGroupSelectionChanged(String selection) {
        if (selection.equals(SVE_ROBNE_GRUPE)) {
            this.setEnabledRobnaGrupa(false);
            this.setEnabledKupac(false);
        } else if (selection.equals(ODREDJENA_ROBNA_GRUPA)) {
            this.setEnabledRobnaGrupa(true);
            this.setEnabledKupac(false);
        } else if (selection.equals(ODREDJENI_KUPAC)) {
            this.setEnabledRobnaGrupa(false);
            this.setEnabledKupac(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENA_ROBNA_GRUPA) && this.entRobnagrupa == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indRobnaGrupa.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENI_KUPAC) && this.entKomitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indSifraKupca.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogPregledProdaje.this.cursor != null) {
                        PzDialogPregledProdaje.this.cursor.close();
                    }
                    String upit = "";
                    String valuta = PzDialogPregledProdaje.this.cbValuta.getSelectedChoice().getValue().toString();
                    Query q = null;
                    upit = "SELECT k.sfrKomitent, k.naziv, rg.oznRobGr, rg.naziv, sum(CASE WHEN (ad2.kolicina is null) THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE (((ad1.kolicina-ad2.kolicina)*ad1.prodCena)%valuta%) END), sum(CASE WHEN (d1.tip = '%tipF%') THEN (ad1.kolicina*(ad1.prodCena*ad1.procRabata/100))%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%') THEN (ad2.kolicina*(ad2.prodCena*ad2.procRabata/100))%valuta% ELSE 0 END) FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON k.sfrKomitent=d1.sfrKomitent%valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.tip IN ('%tipF%', '%tipFS%') AND d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.gTip NOT IN ('E', 'S', 'P', 'G') AND rj.oznRj IN (%listaRj%) and ad1.sfrProizvod = a.sfrProizvod AND a.oznRobGr = rg.oznRobGr AND d1.storno = 0 and d1.arhiviran = 1 ";
                    if (((String)PzDialogPregledProdaje.this.panelRbs.getSelectedValue()).equals(PzDialogPregledProdaje.ODREDJENA_ROBNA_GRUPA)) {
                        upit = String.valueOf(upit) + " and rg.oznRobGr IN " + PzDialogPregledProdaje.this.entRobnagrupa.getRobnaGrupaListAsString();
                    }
                    if (((String)PzDialogPregledProdaje.this.panelRbs.getSelectedValue()).equals(PzDialogPregledProdaje.ODREDJENI_KUPAC)) {
                        upit = String.valueOf(upit) + " and k.sfrKomitent=':komitent'";
                        upit = upit.replace(":komitent", PzDialogPregledProdaje.this.entKomitent.getSfrKomitent());
                    }
                    upit = upit.replace(":datumOd", PzDialogPregledProdaje.this.dfPocetniDatum.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogPregledProdaje.this.dfKrajnjiDatum.getVal().toString());
                    upit = String.valueOf(upit) + " GROUP BY rg.oznRobGr, k.sfrKomitent, rg.naziv, k.naziv ORDER BY 5 DESC ";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogPregledProdaje.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogPregledProdaje.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogPregledProdaje.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogPregledProdaje.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogPregledProdaje.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledProdaje.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String fname = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        if (((String)this.panelRbs.getSelectedValue()).equals(SVE_ROBNE_GRUPE)) {
            title = "PREGLED PRODAJE PO ROBNIM GRUPAMA I KUPCIMA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.robGr.kupac.jasper";
        } else if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENA_ROBNA_GRUPA)) {
            title = "PREGLED PRODAJE ROBNE GRUPE: [ " + this.entRobnagrupa.getOznRobGr() + " ] " + this.entRobnagrupa.getNaziv() + " PO KUPCIMA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.robGr.kupac.jasper";
        } else if (((String)this.panelRbs.getSelectedValue()).equals(ODREDJENI_KUPAC)) {
            title = "PREGLED PRODAJE PO ROBNIM GRUPAM ZA KUPCA : [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.robGr.konkretan.kupac.jasper";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (this.entKomitent != null) {
                this.tfSifra.setVal((Object)this.entKomitent.getSfrKomitent());
                this.tfNazivKupca.setVal((Object)this.entKomitent.getNaziv());
            }
        } else if (entity instanceof Robnagrupa) {
            this.entRobnagrupa = (Robnagrupa)entity;
            if (this.entRobnagrupa != null) {
                this.tfRobnaGrupa.setVal((Object)this.entRobnagrupa.getOznRobGr());
                this.tfNazivRobneGrupe.setVal((Object)this.entRobnagrupa.getNaziv());
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPregledProdaje(Boolean.FALSE);
    }

    public PzDialogPregledProdaje(Boolean initGUI) {
    }
}

