/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogRucPoKomercijalisti
extends PzDialog {
    private static final String KOMERCIJALISTA = "komercijalista";
    private static final String GRUPA_KOMITENATA = "grupaKomitentata";
    private PzPanel pnlGlavni;
    private PzPanel pnlDatum;
    private PzComboBox cbValute;
    private PzPanel pnlValuta;
    private JLabel lblKrajnji;
    private PzDateField dfKrajnji;
    private PzDateField dfPocetni;
    private JLabel lblPocetni;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;
    private String parameter;

    public PzDialogRucPoKomercijalisti(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("RUC po komercijalistima");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{46, 53, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.1, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{122, 20, 63, 65, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlValuta = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlValuta, (Object)new GridBagConstraints(2, 0, 2, 2, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlValutaLayout.rowWeights = new double[]{0.0, 0.0};
            pnlValutaLayout.rowHeights = new int[]{9, 25};
            pnlValutaLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlValutaLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlValuta.setLayout((LayoutManager)pnlValutaLayout);
            this.cbValute = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValute, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlDatum, (Object)new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{16, 14, 27, 27, 20};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0};
            pnlDatumLayout.columnWidths = new int[]{104, 124};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.lblPocetni = new JLabel();
            this.pnlDatum.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblPocetni.setName("lblPocetni");
            this.dfPocetni = new PzDateField();
            this.pnlDatum.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.dfPocetni.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.dfKrajnji = new PzDateField();
            this.pnlDatum.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKrajnji = new JLabel();
            this.pnlDatum.add((Component)this.lblKrajnji, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
            this.lblKrajnji.setName("lblKrajnji");
            this.btnPotvrdi = new PzButton();
            this.pnlGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(125, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(460, 195);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogRucPoKomercijalisti.this.cursor != null) {
                        PzDialogRucPoKomercijalisti.this.cursor.close();
                    }
                    String upit = "";
                    String valuta = PzDialogRucPoKomercijalisti.this.cbValute.getSelectedChoice().getValue().toString();
                    Query q = null;
                    upit = PzDialogRucPoKomercijalisti.this.parameter.equals(PzDialogRucPoKomercijalisti.KOMERCIJALISTA) ? "SELECT kGrupa.naziv, d1.datPrometa, k.sfrKomitent, k.naziv, d1.oznDokumenta, sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%), sum((ad1.kolicina*ad1.prodCena)%valuta%), sum((ad2.kolicina*ad2.prodCena)%valuta%), sum(CASE WHEN (d1.tip = '%tipF%' or  d1.tip = '%tipFR%') THEN ((ad1.prodCena*ad1.kolicina)*ad1.procRabata/100)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or  d2.tip = '%tipFR%') THEN ((ad2.prodCena*ad2.kolicina)*ad2.procRabata/100)%valuta% ELSE 0 END) FROM Radnajedinica rj,   (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Faktura f ON f.iddok = d1.iddok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent LEFT JOIN  Komitentgrupa kGrupa on kGrupa.tip= 'KOMERC' INNER JOIN KomitentGrupaLink kGrupaLink ON k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.storno = 0 and d1.arhiviran = 1 AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.datPrometa>=':datumOd' AND d1.datPrometa<=':datumDo' and d1.tip  IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%' ) GROUP BY kGrupa.naziv, d1.oznDokumenta, k.sfrKomitent, k.naziv, d1.datPrometa ORDER BY kGrupa.naziv, d1.datPrometa, d1.oznDokumenta" : "SELECT kGrupa.naziv, d1.datPrometa, k.sfrKomitent, k.naziv, d1.oznDokumenta, sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%), sum((ad1.kolicina*ad1.prodCena)%valuta%), sum((ad2.kolicina*ad2.prodCena)%valuta%), sum(CASE WHEN (d1.tip = '%tipF%' or  d1.tip = '%tipFR%') THEN ((ad1.prodCena*ad1.kolicina)*ad1.procRabata/100)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or  d2.tip = '%tipFR%') THEN ((ad2.prodCena*ad2.kolicina)*ad2.procRabata/100)%valuta% ELSE 0 END) FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Faktura f ON f.iddok = d1.iddok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent LEFT JOIN  Komitentgrupa kGrupa on kGrupa.tip is null INNER JOIN KomitentGrupaLink kGrupaLink ON k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.storno = 0 and d1.arhiviran = 1 AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.datPrometa>=':datumOd' AND d1.datPrometa<=':datumDo' and d1.tip  IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%' ) GROUP BY kGrupa.naziv,  d1.oznDokumenta, k.sfrKomitent, k.naziv, d1.datPrometa ORDER BY kGrupa.naziv, d1.datPrometa, d1.oznDokumenta";
                    upit = upit.replace(":datumOd", PzDialogRucPoKomercijalisti.this.dfPocetni.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogRucPoKomercijalisti.this.dfKrajnji.getVal().toString());
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : " /kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogRucPoKomercijalisti.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogRucPoKomercijalisti.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogRucPoKomercijalisti.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogRucPoKomercijalisti.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogRucPoKomercijalisti.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogRucPoKomercijalisti.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", "ORENTACIONA RAZLIKA U CENI PO KOMERCIJALISTIMA");
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        params.put("korisnik", false);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/RUC.komercijalista.jasper"), params, (String)"ORENTACIONA RAZLIKA U CENI PO KOMERCIJALISTIMA");
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogRucPoKomercijalisti(Boolean.FALSE);
    }

    public PzDialogRucPoKomercijalisti(Boolean initGUI) {
    }
}

