/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.zatvoriFakturu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;

public class PzDialogIzborDokumenata
extends PzDialog {
    private JScrollPane jScrollPane1;
    private PzToolBarIcon icoSamoNeplacene;
    private PzToolBar pzToolBar1;
    private PzTable table;
    private Komitent komitent;
    private String oznKomitenta;
    private FetchGroup group;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzborDokumenata inst = new PzDialogIzborDokumenata(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzborDokumenata(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzborDokumenata(PzDialog dialog) {
        super(dialog);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.oznKomitenta = (String)this.getSession().getParameter("oznKomitenta");
        this.initGUI();
        this.setTableData(this.komitent, this.oznKomitenta);
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor dokumenata za komitenta");
            this.jScrollPane1 = new JScrollPane();
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
            this.table = new PzTable();
            this.table.setFilter(new PzEntityFilter(){
                private Faktura f;
                private Fakturausluga fu;
                private Kalkulacija k;

                public Object[] getValues(PzEntity entity) {
                    Object[] o;
                    if (entity instanceof Faktura) {
                        this.f = (Faktura)entity;
                        o = new Object[]{this.f.getIdDok(), this.f.getOznDokumenta(), this.f.getIznos(), this.f.getIznos().subtract(this.f.getStornoIznos()).subtract(this.f.getUplata()), this.f.getDatum(), this.f.getDatValute()};
                    } else {
                        this.k = (Kalkulacija)entity;
                        o = new Object[]{this.k.getIdDok(), this.k.getOznDokumenta(), this.k.getIznos(), this.k.getIznos().subtract(this.k.getStornoIznos()).subtract(this.k.getUplata()), this.k.getDatum(), this.k.getDatValute()};
                    }
                    return o;
                }

                public String[] getColumnNames() {
                    return new String[]{"DokId", "Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                }
            });
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.packAll();
            this.pzToolBar1 = new PzToolBar();
            this.getContentPane().add((Component)this.pzToolBar1, "North");
            this.icoSamoNeplacene = new PzToolBarIcon();
            this.pzToolBar1.add((Component)this.icoSamoNeplacene);
            this.icoSamoNeplacene.setName("icoSamoNeplacene");
            this.icoSamoNeplacene.addActionListener((ActionListener)((Object)this));
            this.icoSamoNeplacene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/currency_dollar.png")));
            this.setSize(541, 452);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.getSamoNeplacene(this.komitent, this.oznKomitenta);
    }

    public void setTableData(Komitent k, String oznKomitenta) {
        EntityManager em = PzEntityManager.getEm();
        Vector data = null;
        if (this.group == null) {
            this.group = new FetchGroup();
            this.group.addAttribute("idDok");
            this.group.addAttribute("oznDokumenta");
            this.group.addAttribute("iznos");
            this.group.addAttribute("stornoIznos");
            this.group.addAttribute("uplata");
            this.group.addAttribute("datum");
            this.group.addAttribute("datValute");
            this.group.addAttribute("komitent.sfrKomitent");
            this.group.addAttribute("arhiviran");
            this.group.addAttribute("storno");
            this.group.addAttribute("tip");
        }
        if (oznKomitenta.equalsIgnoreCase("Kupac")) {
            String query = "SELECT f FROM Faktura f join fetch f.komitent WHERE f.arhiviran=1 AND f.storno=0 AND f.komitent.sfrKomitent='" + k.getSfrKomitent() + "' AND" + " (f.tip = '" + TipDokumentConfig.get().FAKTURA + "' OR f.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR f.tip = '" + TipDokumentConfig.get().FAKTURA_USLUGA + "') ORDER BY f.datValute";
            Query q = em.createQuery(query);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            data = (Vector)q.getResultList();
            this.table.setData(data, PzEntity.class);
        } else {
            ArrayList<String> podTipovi = new ArrayList<String>();
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
            String query = "SELECT k FROM Kalkulacija k join fetch k.komitent WHERE k.arhiviran=1 AND k.storno=0 AND k.komitent.sfrKomitent=:komitent AND (k.podTip NOT IN :podTipovi OR k.podTip IS NULL ) ";
            query = String.valueOf(query) + " ORDER BY k.datValute";
            Query q = em.createQuery(query);
            q.setParameter("komitent", (Object)k.getSfrKomitent()).setParameter("podTipovi", podTipovi);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            data = (Vector)q.getResultList();
            this.table.setData(data, Kalkulacija.class);
        }
        em.clear();
        em.close();
    }

    private void getSamoNeplacene(Komitent k, String oznKomitenta) {
        EntityManager em = PzEntityManager.getEm();
        Vector data = null;
        if (this.group == null) {
            this.group = new FetchGroup();
            this.group.addAttribute("idDok");
            this.group.addAttribute("oznDokumenta");
            this.group.addAttribute("iznos");
            this.group.addAttribute("stornoIznos");
            this.group.addAttribute("uplata");
            this.group.addAttribute("datum");
            this.group.addAttribute("datValute");
            this.group.addAttribute("komitent.sfrKomitent");
            this.group.addAttribute("arhiviran");
            this.group.addAttribute("storno");
            this.group.addAttribute("tip");
        }
        if (oznKomitenta.equalsIgnoreCase("Kupac")) {
            String query = "SELECT f FROM Faktura f join fetch f.komitent WHERE f.arhiviran=1 AND f.storno=0 AND f.komitent.sfrKomitent='" + k.getSfrKomitent() + "' AND" + " (f.tip = '" + TipDokumentConfig.get().FAKTURA + "' OR f.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR f.tip = '" + TipDokumentConfig.get().FAKTURA_USLUGA + "') ORDER BY f.datValute" + "AND f.iznos-f.stornoIznos-f.uplata<>0";
            Query q = em.createQuery(query);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            data = (Vector)q.getResultList();
            this.table.setData(data, PzEntity.class);
        } else {
            ArrayList<String> podTipovi = new ArrayList<String>();
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
            String query = "SELECT k FROM Kalkulacija k join fetch k.komitent WHERE k.arhiviran=1 AND k.storno=0 AND k.komitent.sfrKomitent=:komitent AND (k.podTip NOT IN :podTipovi OR k.podTip IS NULL) AND k.iznos-k.stornoIznos-k.uplata<>0";
            query = String.valueOf(query) + " ORDER BY k.datValute";
            Query q = em.createQuery(query);
            q.setParameter("komitent", (Object)k.getSfrKomitent()).setParameter("podTipovi", podTipovi);
            q.setHint("eclipselink.fetch-group", (Object)this.group);
            data = (Vector)q.getResultList();
            this.table.setData(data, Kalkulacija.class);
        }
        em.clear();
        em.close();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzborDokumenata(Boolean.FALSE);
    }

    public PzDialogIzborDokumenata(Boolean initGUI) {
    }
}

