/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.zatvoriFakturu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.zatvoriFakturu.PzDialogSelektovanje;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Brojac;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.PrihodRashod;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzFileUtility;

public class PzDialogPrihodRashod
extends PzDialog {
    private JToolBar toolBar;
    private PzPanel pnlPretraga;
    private JScrollPane jScrollPane1;
    private JLabel jLabel5;
    private PzDoubleField txtSelektovano;
    private JLabel jLabel4;
    private PzToolBarIcon icoDatum;
    private PzToolBarIcon icoKomitent;
    private PzToolBarIcon icoDokument;
    private PzTextField txtNazivKomitent;
    private PzTextField txtKomitent;
    private PzTextField txtDokument;
    private PzDateField txtKrajDat;
    private PzDateField txtPocDat;
    private PzButton btnTrazi;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JRadioButton rbtnDobavljac;
    private JRadioButton rbtnKupac;
    private PzButtonPanel btnPanel;
    private PzPanel panel;
    private PzPanel mainPanel;
    private PzToolBarIcon icoArhiviraj;
    private JSeparator jSeparator1;
    private PzTable table;
    private PrihodRashod prihodRashod;
    private boolean arhivirajMarker;
    private Brojac brojac;
    private Vector<PrihodRashod> prihodRashodVector;
    private PrihodRashod pr;
    private FetchGroup group;
    private double selektovano;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPrihodRashod inst = new PzDialogPrihodRashod(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPrihodRashod(JFrame frame) {
        super(frame);
        this.initGUI();
        this.arhivirajMarker = false;
        this.txtDokument.setEnabled(false);
        this.txtKomitent.setEnabled(false);
        this.txtNazivKomitent.setEditable(false);
        this.txtNazivKomitent.setFocusable(false);
        this.txtPocDat.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
        this.selektovano = 0.0;
    }

    private void initGUI() {
        try {
            this.setTitle("Zatvori prihodom/rashodom");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 143, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolBar = new PzToolBar();
            this.mainPanel.add((Component)this.toolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.toolBar.setOpaque(false);
            this.jSeparator1 = new JSeparator();
            this.toolBar.add(this.jSeparator1);
            this.icoDokument = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoDokument);
            this.icoDokument.setName("icoKalkulacija");
            this.icoDokument.addActionListener((ActionListener)((Object)this));
            this.icoDokument.setActionCommand("trazi_dokument");
            this.icoDokument.setShortcut("F6");
            this.icoDokument.setText("Tra\u017ei dokument | (F6)");
            this.icoDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documentsearch.png")));
            this.icoKomitent = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoKomitent);
            this.icoKomitent.setName("icoKomitent");
            this.icoKomitent.addActionListener((ActionListener)((Object)this));
            this.icoKomitent.setActionCommand("trazi_komitenta");
            this.icoKomitent.setShortcut("F8");
            this.icoKomitent.setText("Tra\u017ei po komitentu | (F8)");
            this.icoKomitent.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/businessman_search.png")));
            this.icoDatum = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoDatum);
            this.icoDatum.setName("icoDatum");
            this.icoDatum.addActionListener((ActionListener)((Object)this));
            this.icoDatum.setActionCommand("trazi_datum");
            this.icoDatum.setShortcut("F9");
            this.icoDatum.setText("Tra\u017ei po datumu | (F9)");
            this.icoDatum.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/date_search.png")));
            this.icoArhiviraj = new PzToolBarIcon();
            this.toolBar.add((Component)this.icoArhiviraj);
            this.icoArhiviraj.setName("icoArhiviraj");
            this.icoArhiviraj.addActionListener((ActionListener)((Object)this));
            this.icoArhiviraj.setActionCommand("arhiviraj");
            this.icoArhiviraj.setShortcut("CTRL+W");
            this.icoArhiviraj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.panel = new PzPanel();
            this.mainPanel.add((Component)this.panel, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelLayout.rowHeights = new int[]{7, 7, 7, 7};
            panelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.panel.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            this.pnlPretraga = new PzPanel();
            this.panel.add((Component)this.pnlPretraga, (Object)new GridBagConstraints(0, 0, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            pnlPretragaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlPretragaLayout.rowHeights = new int[]{7, 7, 7, 7, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{131, 105, 192, 126, 49, 7};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.btnPanel = new PzButtonPanel();
            GridBagLayout btnPanelLayout = new GridBagLayout();
            this.pnlPretraga.add((Component)this.btnPanel, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            btnPanelLayout.rowWeights = new double[]{0.1};
            btnPanelLayout.rowHeights = new int[]{7};
            btnPanelLayout.columnWeights = new double[]{0.1, 0.1};
            btnPanelLayout.columnWidths = new int[]{7, 7};
            this.btnPanel.setLayout((LayoutManager)btnPanelLayout);
            this.btnPanel.setOpaque(false);
            this.rbtnKupac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnKupac, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnKupac.setName("rbtnKupac");
            this.rbtnKupac.setSelected(true);
            this.rbtnKupac.setText("Kupac");
            this.rbtnKupac.setActionCommand("Kupac");
            this.rbtnKupac.setOpaque(false);
            this.rbtnDobavljac = new JRadioButton();
            this.btnPanel.add((Component)this.rbtnDobavljac, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbtnDobavljac.setName("rbtnDobavljac");
            this.rbtnDobavljac.setText("Dobavlja\u010d");
            this.rbtnDobavljac.setActionCommand("Dobavljac");
            this.rbtnDobavljac.setOpaque(false);
            this.jLabel1 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel1.setText("Dokument:");
            this.jLabel2 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel2.setText("Komitent:");
            this.jLabel3 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.jLabel3.setText("Po\u010detni datum:");
            this.jLabel4 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel4, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setName("jLabel4");
            this.jLabel4.setText("Krajnji datum:");
            this.btnTrazi = new PzButton();
            this.pnlPretraga.add((Component)this.btnTrazi, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi.setName("btnTazi");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.setText("Tra\u017ei");
            this.btnTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find.png")));
            this.txtPocDat = new PzDateField();
            this.pnlPretraga.add((Component)this.txtPocDat, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtPocDat.setName("txtPocDat");
            this.txtKrajDat = new PzDateField();
            this.pnlPretraga.add((Component)this.txtKrajDat, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKrajDat.setName("txtKrajDat");
            this.txtDokument = new PzTextField();
            this.txtDokument.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    String query = null;
                    if (PzDialogPrihodRashod.this.rbtnKupac.isSelected()) {
                        query = "SELECT f FROM Faktura f WHERE f.oznDokumenta= :oznDok AND f.arhiviran = 1 AND f.storno = 0 AND NOT f.radnajedinica.gTip = 'E'";
                    } else if (PzDialogPrihodRashod.this.rbtnDobavljac.isSelected()) {
                        query = "SELECT k FROM Kalkulacija k WHERE k.oznDokumenta= :oznDok AND k.arhiviran = 1 AND k.storno = 0 AND ((k.tip = '" + TipDokumentConfig.get().KALKULACIJA + "' AND k.podTip='" + TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA + "') OR k.tip='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "')";
                    }
                    EntityManager em = PzEntityManager.getEm();
                    Query q = em.createQuery(query).setParameter("oznDok", (Object)PzDialogPrihodRashod.this.txtDokument.getVal());
                    em.clear();
                    em.close();
                    return (PzEntity)q.getSingleResult();
                }
            });
            this.pnlPretraga.add((Component)this.txtDokument, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKomitent = new PzTextField();
            this.pnlPretraga.add((Component)this.txtKomitent, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.txtNazivKomitent = new PzTextField();
            this.pnlPretraga.add((Component)this.txtNazivKomitent, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel5 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel5, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel5.setName("jLabel5");
            this.txtSelektovano = new PzDoubleField();
            this.pnlPretraga.add((Component)this.txtSelektovano, (Object)new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.txtSelektovano.setPreferredSize(new Dimension(142, 26));
            this.txtSelektovano.setSize(142, 26);
            this.txtSelektovano.setEnabled(false);
            this.jScrollPane1 = new JScrollPane();
            this.mainPanel.add((Component)this.jScrollPane1, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.setFilter(new PzEntityFilter(){
                private Faktura f;
                private Kalkulacija k;
                private Object[] o;

                public Object[] getValues(PzEntity entity) {
                    if (entity instanceof Faktura) {
                        this.f = (Faktura)entity;
                        this.o = new Object[]{this.f.getKomitent().getSfrKomitent(), this.f.getOznDokumenta(), this.f.getDatValute(), this.f.getIznos().subtract(this.f.getStornoIznos()), this.f.getUplata(), this.f.getIznos().subtract(this.f.getStornoIznos()).subtract(this.f.getUplata()), this.f.getZatvaranje(), this.f.getKomitent().getNaziv()};
                    } else if (entity instanceof Kalkulacija) {
                        this.k = (Kalkulacija)entity;
                        this.o = new Object[]{this.k.getKomitent().getSfrKomitent(), this.k.getOznDokumenta(), this.k.getDatValute(), this.k.getIznos().subtract(this.k.getStornoIznos()), this.k.getUplata(), this.k.getIznos().subtract(this.k.getStornoIznos()).subtract(this.k.getUplata()), this.k.getZatvaranje(), this.k.getKomitent().getNaziv()};
                    }
                    return this.o;
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra komitenta", "Oznaka", "Datum valute", "Iznos", "Uplate", "Dug", "Zatvaranje", "Naziv komitenta"};
                }
            });
            this.table.setAutoResizeMode(4);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogPrihodRashod.this.getSession().putParameter("tablePrihodRashod", (Object)PzDialogPrihodRashod.this.table);
                    if (PzDialogPrihodRashod.this.rbtnKupac.isSelected()) {
                        PzDialogPrihodRashod.this.getSession().putParameter("oznKomitenta", (Object)PzDialogPrihodRashod.this.rbtnKupac.getActionCommand());
                    } else if (PzDialogPrihodRashod.this.rbtnDobavljac.isSelected()) {
                        PzDialogPrihodRashod.this.getSession().putParameter("oznKomitenta", (Object)PzDialogPrihodRashod.this.rbtnDobavljac.getActionCommand());
                    }
                    if (PzDialogPrihodRashod.this.table.getSelectedEntity() instanceof Faktura) {
                        if (((Faktura)PzDialogPrihodRashod.this.table.getSelectedEntity()).getZatvaranje() != 0.0) {
                            PzDialogPrihodRashod.this.getSession().putParameter("update", (Object)true);
                            PzDialogPrihodRashod.this.txtSelektovano.setVal((Object)(PzDialogPrihodRashod.this.txtSelektovano.getVal() - ((Faktura)PzDialogPrihodRashod.this.table.getSelectedEntity()).getZatvaranje()));
                        } else {
                            PzDialogPrihodRashod.this.getSession().putParameter("update", (Object)false);
                        }
                    }
                    if (PzDialogPrihodRashod.this.table.getSelectedEntity() instanceof Kalkulacija) {
                        if (!((Kalkulacija)PzDialogPrihodRashod.this.table.getSelectedEntity()).getZatvaranje().equals(new BigDecimal(0.0))) {
                            PzDialogPrihodRashod.this.getSession().putParameter("update", (Object)true);
                            PzDialogPrihodRashod.this.txtSelektovano.setVal((Object)(PzDialogPrihodRashod.this.txtSelektovano.getVal() - ((Kalkulacija)PzDialogPrihodRashod.this.table.getSelectedEntity()).getZatvaranje().doubleValue()));
                        } else {
                            PzDialogPrihodRashod.this.getSession().putParameter("update", (Object)false);
                        }
                    }
                    PzDialogPrihodRashod.this.getSession().putParameter("prihodRashod", (Object)PzDialogPrihodRashod.this.prihodRashod);
                    PzDialogPrihodRashod.this.showDialog(PzDialogSelektovanje.class);
                }
            });
            this.getRootPane().setDefaultButton((JButton)this.btnTrazi);
            this.setSize(800, 632);
            this.setMinimumSize(new Dimension(818, 585));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("arhiviraj")) {
            if (this.table.getSelectedEntity() instanceof Faktura) {
                this.arhivirajDokumentKupac();
            } else {
                this.arhivirajDokumentDobavljac();
            }
            if (this.prihodRashodVector != null || this.prihodRashodVector.size() != 0) {
                this.showReport();
            }
            this.dispose();
        } else {
            if (actionCommand.equalsIgnoreCase("trazi_dokument")) {
                this.txtDokument.setEnabled(true);
                this.txtKomitent.setEnabled(false);
                this.txtKrajDat.setEnabled(false);
                this.txtPocDat.setEnabled(false);
                this.setFirstComponentInFocus((Component)this.txtDokument);
                return;
            }
            if (actionCommand.equalsIgnoreCase("trazi_komitenta")) {
                this.txtDokument.setEnabled(false);
                this.txtKomitent.setEnabled(true);
                this.txtKrajDat.setEnabled(false);
                this.txtPocDat.setEnabled(false);
                this.setFirstComponentInFocus((Component)this.txtKomitent);
                return;
            }
            if (actionCommand.equalsIgnoreCase("trazi_datum")) {
                this.txtDokument.setEnabled(false);
                this.txtKomitent.setEnabled(false);
                this.txtKrajDat.setEnabled(true);
                this.txtPocDat.setEnabled(true);
                this.txtPocDat.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
                this.txtKrajDat.setVal((Object)PzDateUtility.getCurrentDate());
                this.setFirstComponentInFocus((Component)this.txtPocDat);
                return;
            }
            if (actionCommand.equalsIgnoreCase("trazi")) {
                String query = this.createQuery();
                if (this.txtDokument.isEnabled() && !this.txtDokument.getVal().equals("")) {
                    query = String.valueOf(query) + " AND d.oznDokumenta = '" + this.txtDokument.getVal() + "'";
                }
                if (this.txtKomitent.isEnabled() && !this.txtKomitent.getVal().equals("")) {
                    query = String.valueOf(query) + " AND d.komitent.sfrKomitent = '" + this.txtKomitent.getVal() + "'";
                }
                if (this.txtPocDat.isEnabled() && !this.txtPocDat.getVal().equals("")) {
                    query = String.valueOf(query) + " AND d.datum>='" + this.txtPocDat.getVal() + "' AND d.datum<='" + this.txtKrajDat.getVal() + "'";
                }
                if (this.group == null) {
                    this.group = new FetchGroup();
                    this.group.addAttribute("idDok");
                    this.group.addAttribute("oznDokumenta");
                    this.group.addAttribute("datValute");
                    this.group.addAttribute("iznos");
                    this.group.addAttribute("tip");
                    this.group.addAttribute("stornoIznos");
                    this.group.addAttribute("uplata");
                    this.group.addAttribute("storno");
                    this.group.addAttribute("arhiviran");
                    this.group.addAttribute("komitent.sfrKomitent");
                    this.group.addAttribute("komitent.naziv");
                }
                EntityManager emp = PzEntityManager.getEm();
                Query jpaQuery = emp.createQuery(query);
                if (this.rbtnDobavljac.isSelected()) {
                    ArrayList<String> podTipovi = new ArrayList<String>();
                    podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
                    podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
                    jpaQuery.setParameter("podTipovi", podTipovi);
                }
                jpaQuery.setHint("eclipselink.fetch-group", (Object)this.group);
                Vector tableData = (Vector)jpaQuery.getResultList();
                if (this.rbtnKupac.isSelected()) {
                    this.table.setData(tableData, Faktura.class);
                } else if (this.rbtnDobavljac.isSelected()) {
                    this.table.setData(tableData, Kalkulacija.class);
                }
                this.setFirstComponentInFocus((Component)this.table);
                emp.close();
                return;
            }
        }
    }

    private String createQuery() {
        String query = null;
        if (this.rbtnKupac.isSelected()) {
            query = "Select d from Faktura d join fetch d.komitent WHERE d.arhiviran=1 AND (d.tip = 'FAKTURA' OR d.tip = 'FAKTURA_USLUGA' OR d.tip = 'FAKTURA_IZ_SERVISA') AND d.storno=0AND (d.iznos-d.stornoIznos-d.uplata)<>0 AND NOT d.radnajedinica.gTip = 'E'";
        } else if (this.rbtnDobavljac.isSelected()) {
            query = "Select d FROM Kalkulacija d join fetch d.komitent WHERE d.arhiviran=1 AND d.storno=0 AND (d.iznos-d.stornoIznos-d.uplata)<>0 AND (d.podTip NOT IN :podTipovi OR d.podTip IS NULL)";
        }
        return query;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity != null) {
            Komitent k = (Komitent)entity;
            ((PzTextField)component).setVal((Object)k.getSfrKomitent());
            this.txtNazivKomitent.setVal((Object)k.getNaziv());
        }
    }

    public void arhivirajDokumentKupac() {
        EntityManager emk = PzEntityManager.getEm();
        try {
            try {
                emk.getTransaction().begin();
                this.prihodRashodVector = new Vector();
                this.brojac = null;
                int pomocniInt = 0;
                int i = 0;
                while (i < this.table.getRowCount()) {
                    this.pr = null;
                    if (((Faktura)this.table.getEntity(i)).getZatvaranje().compareTo(0.0) != 0) {
                        this.pr = new PrihodRashod();
                        if (++pomocniInt == 1) {
                            this.brojac = this.setBrojac(emk);
                        }
                        this.pr.setArhiviran((short)1);
                        this.pr.setPoDokumentu(this.brojac.getrBroj());
                        this.pr.setTip(TipDokumentConfig.get().ZATVARANJE_PRIHODOM);
                        this.pr.setDatum(PzDateUtility.getCurrentDate());
                        this.pr.setDatArh(PzDateUtility.getCurrentDate());
                        this.pr.setRadnajedinica(((Faktura)this.table.getEntity(i)).getRadnajedinica());
                        this.pr.setIznos(new BigDecimal(((Faktura)this.table.getEntity(i)).getZatvaranje()));
                        this.pr.setKalkulacijaId(((Faktura)this.table.getEntity(i)).getIdDok());
                        this.pr.setKomitent(((Faktura)this.table.getEntity(i)).getKomitent());
                        this.pr.setOznDokumenta(((Faktura)this.table.getEntity(i)).getOznDokumenta());
                        this.pr.setOznPoDokumentu(((Faktura)this.table.getEntity(i)).getOznDokumenta());
                        this.prihodRashodVector.add(this.pr);
                        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.pr, true, null, emk);
                        this.setFakturaData(this.pr, emk);
                    }
                    ++i;
                }
                emk.getTransaction().commit();
            }
            catch (Exception e) {
                if (emk.getTransaction().isActive()) {
                    emk.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this.table, (Throwable)e);
                this.pr = null;
                this.prihodRashodVector.clear();
                if (emk.isOpen()) {
                    emk.close();
                }
                return;
            }
        }
        finally {
            if (emk.isOpen()) {
                emk.close();
            }
        }
    }

    public void arhivirajDokumentDobavljac() {
        EntityManager emd = PzEntityManager.getEm();
        try {
            try {
                emd.getTransaction().begin();
                this.prihodRashodVector = new Vector();
                this.brojac = null;
                int pomocniInt = 0;
                int i = 0;
                while (i < this.table.getRowCount()) {
                    this.pr = null;
                    if (((Kalkulacija)this.table.getEntity(i)).getZatvaranje().compareTo(new BigDecimal(0)) != 0) {
                        this.pr = new PrihodRashod();
                        if (++pomocniInt == 1) {
                            this.brojac = this.setBrojac(emd);
                        }
                        this.pr.setArhiviran((short)1);
                        this.pr.setPoDokumentu(this.brojac.getrBroj());
                        this.pr.setTip(TipDokumentConfig.get().ZATVARANJE_RASHODOM);
                        this.pr.setDatum(PzDateUtility.getCurrentDate());
                        this.pr.setDatArh(PzDateUtility.getCurrentDate());
                        this.pr.setRadnajedinica(((Kalkulacija)this.table.getEntity(i)).getRadnajedinica());
                        this.pr.setIznos(((Kalkulacija)this.table.getEntity(i)).getZatvaranje().multiply(new BigDecimal(-1)));
                        this.pr.setKalkulacijaId(((Kalkulacija)this.table.getEntity(i)).getIdDok());
                        this.pr.setKomitent(((Kalkulacija)this.table.getEntity(i)).getKomitent());
                        this.pr.setOznDokumenta(((Kalkulacija)this.table.getEntity(i)).getOznDokumenta());
                        this.pr.setOznPoDokumentu(((Kalkulacija)this.table.getEntity(i)).getOznDokumenta());
                        this.prihodRashodVector.add(this.pr);
                        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.pr, true, null, emd);
                        this.setKalkulacijaData(this.pr, emd);
                    }
                    ++i;
                }
                emd.getTransaction().commit();
            }
            catch (Exception e) {
                if (emd.getTransaction().isActive()) {
                    emd.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this.table, (Throwable)e);
                this.pr = null;
                this.prihodRashodVector.clear();
                if (emd.isOpen()) {
                    emd.close();
                }
                return;
            }
        }
        finally {
            if (emd.isOpen()) {
                emd.close();
            }
        }
    }

    private void setFakturaData(PrihodRashod pr, EntityManager em) {
        Faktura fakt = null;
        fakt = (Faktura)em.find(Faktura.class, (Object)pr.getKalkulacijaId());
        fakt.setStornoIznos(fakt.getStornoIznos().add(pr.getIznos()));
    }

    private void setKalkulacijaData(PrihodRashod pr, EntityManager em) {
        Kalkulacija kalk = null;
        kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)pr.getKalkulacijaId());
        kalk.setStornoIznos(kalk.getStornoIznos().add(pr.getIznos().multiply(new BigDecimal(-1))));
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (!this.arhivirajMarker && this.prihodRashod != null) {
            EntityManager e = PzEntityManager.getEm();
            try {
                e.getTransaction().begin();
                PrihodRashod pr = (PrihodRashod)e.find(PrihodRashod.class, (Object)this.prihodRashod.getIdDok());
                e.remove((Object)pr);
                e.getTransaction().commit();
                e.clear();
                e.close();
            }
            catch (Exception e1) {
                if (e.getTransaction().isActive()) {
                    e.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            Vector<PrihodRashod> d = new Vector<PrihodRashod>();
            Vector s = new Vector();
            String title = null;
            String fname = null;
            String title2red = null;
            if (this.table.getSelectedEntity() instanceof Faktura) {
                title = "ZAPISNIK O ZATVARANJU FAKTURA KUPACA prihodom";
                title2red = "broj zapisnika: " + this.prihodRashodVector.get(0).getPoDokumentu();
                fname = "rs/pezar/reports/compiled/prihodrashod.kupci.jasper";
                d.addAll(this.prihodRashodVector);
                params.put("datum", PzDateUtility.getCurrentDate());
            } else {
                title = "ZAPISNIK O ZATVARANJU FAKTURA DOBAVLJA\u010cA rashodom";
                title2red = "broj zapisnika: " + this.brojac.getrBroj();
                fname = "rs/pezar/reports/compiled/prihodrashod.dobavljaci.jasper";
                d.addAll(this.prihodRashodVector);
                params.put("datum", PzDateUtility.getCurrentDate());
            }
            params.put("title", title);
            params.put("title2red", title2red);
            params.put("headerStandardSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
            params.put("reklama", "");
            s.add(data.get(0));
            PzDataSourceExtended dse = new PzDataSourceExtended(s, d);
            dse.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)dse, (String)fname, params, (String)title, (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Brojac setBrojac(EntityManager em) {
        Brojac brojac = null;
        brojac = (Brojac)em.find(Brojac.class, (Object)"PRIHOD_RASHOD");
        if (brojac == null) {
            brojac = new Brojac();
            brojac.setTip("PRIHOD_RASHOD");
            brojac.setrBroj(0);
            em.persist((Object)brojac);
        } else {
            brojac.setrBroj(brojac.getrBroj() + 1);
        }
        return brojac;
    }

    public void setSelektovano(Double value) {
        this.txtSelektovano.setVal((Object)(this.txtSelektovano.getVal() + value));
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPrihodRashod(Boolean.FALSE);
    }

    public PzDialogPrihodRashod(Boolean initGUI) {
    }
}

