/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.themes.basic.BasicCombiner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class SplitCombiner
extends BasicCombiner {
    @Override
    public CombinerTarget prepare(CombinerSource source, boolean force) {
        double newSpace;
        double oldSpace;
        if (source.isMouseOverTitle() || !(source.getParent() instanceof ScreenDockStation)) {
            return super.prepare(source, force);
        }
        Dimension size = source.getSize();
        Point position = source.getMousePosition();
        if (size == null || position == null) {
            return super.prepare(source, force);
        }
        if (this.isCentered(size.width, size.height, position.x, position.y)) {
            return super.prepare(source, force);
        }
        boolean topLeft = SplitNode.above(0.0, size.height, size.width, 0.0, position.x, position.y);
        boolean topRight = SplitNode.above(0.0, 0.0, size.width, size.height, position.x, position.y);
        SplitDockPathProperty.Location put = topLeft && topRight ? SplitDockPathProperty.Location.TOP : (topLeft && !topRight ? SplitDockPathProperty.Location.LEFT : (!topLeft && topRight ? SplitDockPathProperty.Location.RIGHT : SplitDockPathProperty.Location.BOTTOM));
        Dimension newSize = source.getNew().getComponent().getSize();
        if (put == SplitDockPathProperty.Location.LEFT || put == SplitDockPathProperty.Location.RIGHT) {
            oldSpace = size.width;
            newSpace = newSize.width;
        } else {
            oldSpace = size.height;
            newSpace = newSize.height;
        }
        if (newSpace < 10.0) {
            newSpace = 10.0;
        }
        if (newSpace + 10.0 > oldSpace) {
            newSpace = oldSpace - 10.0;
        }
        double space = newSpace < 10.0 ? 0.5 : newSpace / oldSpace;
        return new Target(source.getParent(), put, space);
    }

    protected boolean isCentered(int width, int height, int x, int y) {
        if (x < width / 3 || x > width * 2 / 3) {
            return false;
        }
        return y >= height / 3 && y <= height * 2 / 3;
    }

    @Override
    public Dockable combine(CombinerSource source, CombinerTarget target) {
        if (target instanceof Target) {
            DockStation parent = source.getParent();
            PlaceholderMap placeholders = source.getPlaceholders();
            SplitDockStation split = new SplitDockStation(){

                @Override
                protected ListeningDockAction createFullScreenAction() {
                    return null;
                }
            };
            split.setController(parent.getController());
            split.updateTheme();
            if (placeholders != null) {
                split.setPlaceholders(placeholders);
            }
            split.drop(source.getOld());
            Target splitTarget = (Target)target;
            SplitDockPathProperty location = new SplitDockPathProperty();
            location.add(splitTarget.side, splitTarget.space, -1L);
            split.drop(source.getNew(), location);
            return split;
        }
        return super.combine(source, target);
    }

    private static class Target
    implements CombinerTarget {
        private DockStation station;
        private SplitDockPathProperty.Location side;
        private double space;

        public Target(DockStation station, SplitDockPathProperty.Location side, double space) {
            this.station = station;
            this.side = side;
            this.space = space;
        }

        @Override
        public void paint(Graphics g, Component component, StationPaint paint, Rectangle stationBounds, Rectangle dockableBounds) {
            Rectangle destination = new Rectangle(dockableBounds);
            switch (this.side) {
                case TOP: {
                    destination.height = (int)((double)destination.height * this.space);
                    break;
                }
                case BOTTOM: {
                    destination.height = (int)((double)destination.height * this.space);
                    destination.y += dockableBounds.height - destination.height;
                    break;
                }
                case LEFT: {
                    destination.width = (int)((double)destination.width * this.space);
                    break;
                }
                case RIGHT: {
                    destination.width = (int)((double)destination.width * this.space);
                    destination.x += dockableBounds.width - destination.width;
                }
            }
            paint.drawInsertion(g, this.station, dockableBounds, destination);
        }
    }
}

