/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseMenu;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerBackgroundComponent;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class EclipseDockableDisplayer
extends EclipseTabPane
implements DockableDisplayer {
    private DockStation station;
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private TitleBarObserver observer;
    private StackDockComponentRepresentative representative;
    private PropertyValue<TabPlacement> tabPlacement = new PropertyValue<TabPlacement>(StackDockStation.TAB_PLACEMENT){

        @Override
        protected void valueChanged(TabPlacement oldValue, TabPlacement newValue) {
            EclipseDockableDisplayer.this.setTabPlacement(newValue);
        }
    };
    private PropertyValue<TabContentFilter> filter = new PropertyValue<TabContentFilter>(StackDockStation.TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter oldValue, TabContentFilter newValue) {
            if (oldValue != null) {
                oldValue.uninstall(EclipseDockableDisplayer.this);
                oldValue.removeListener(EclipseDockableDisplayer.this.filterListener);
            }
            if (newValue != null) {
                newValue.install(EclipseDockableDisplayer.this);
                newValue.addListener(EclipseDockableDisplayer.this.filterListener);
            }
            EclipseDockableDisplayer.this.updateTabContent();
        }
    };
    private DockableListener dockableListener = new DockableAdapter(){

        @Override
        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        @Override
        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        @Override
        public void titleToolTipChanged(Dockable dockable, String oldTooltip, String newTooltip) {
            EclipseDockableDisplayer.this.updateTabContent();
        }
    };
    private TabContentFilterListener filterListener = new TabContentFilterListener(){

        @Override
        public void contentChanged() {
            EclipseDockableDisplayer.this.updateTabContent();
        }

        @Override
        public void contentChanged(StackDockComponent component) {
            if (component == EclipseDockableDisplayer.this) {
                EclipseDockableDisplayer.this.updateTabContent();
            }
        }

        @Override
        public void contentChanged(StackDockStation station) {
        }

        @Override
        public void contentChanged(Dockable dockable) {
            if (dockable == EclipseDockableDisplayer.this.dockable) {
                EclipseDockableDisplayer.this.updateTabContent();
            }
        }
    };

    public EclipseDockableDisplayer(EclipseTheme theme, DockStation station, Dockable dockable) {
        super(theme, station);
        this.observer = new TitleBarObserver(station, dockable, EclipseThemeConnector.TitleBar.ECLIPSE){

            @Override
            protected void invalidated() {
                DockableDisplayerListener[] dockableDisplayerListenerArray = EclipseDockableDisplayer.this.displayerListeners();
                int n = dockableDisplayerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableDisplayerListener listener = dockableDisplayerListenerArray[n2];
                    listener.discard(EclipseDockableDisplayer.this);
                    ++n2;
                }
            }
        };
        this.station = station;
        this.representative = new StackDockComponentRepresentative();
        this.representative.setComponent(this);
        this.setDockable(dockable);
        ((Container)this.getComponent()).setFocusCycleRoot(true);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.dockable == null) {
            return new Dimension(10, 10);
        }
        return this.dockable.getComponent().getMinimumSize();
    }

    @Override
    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
    }

    protected DockableDisplayerListener[] displayerListeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    @Override
    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.removeAll();
            this.dockable.removeDockableListener(this.dockableListener);
        }
        this.dockable = dockable;
        if (dockable != null) {
            TabContent content = new TabContent(dockable.getTitleIcon(), dockable.getTitleText(), dockable.getTitleToolTip());
            TabContentFilter contentFilter = this.filter.getValue();
            if (contentFilter != null) {
                content = contentFilter.filter(content, this, dockable);
            }
            if (content == null) {
                this.addTab(null, null, dockable.getComponent(), dockable);
                this.setTooltipAt(0, null);
            } else {
                this.addTab(content.getTitle(), content.getIcon(), dockable.getComponent(), dockable);
                this.setTooltipAt(0, content.getTooltip());
            }
            dockable.addDockableListener(this.dockableListener);
        }
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        this.representative.setTarget(dockable);
        this.revalidate();
    }

    private void updateTabContent() {
        if (this.dockable != null && this.getTabCount() == 1) {
            TabContent content = new TabContent(this.dockable.getTitleIcon(), this.dockable.getTitleText(), this.dockable.getTitleToolTip());
            TabContentFilter contentFilter = this.filter.getValue();
            if (contentFilter != null) {
                content = contentFilter.filter(content, this, this.dockable);
            }
            if (content == null) {
                this.setTitleAt(0, null);
                this.setIconAt(0, null);
                this.setTooltipAt(0, null);
            } else {
                this.setTitleAt(0, content.getTitle());
                this.setIconAt(0, content.getIcon());
                this.setTooltipAt(0, content.getTooltip());
            }
        }
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        if (this.observer != null) {
            this.observer.setController(controller);
        }
        this.tabPlacement.setProperties(controller);
        this.filter.setProperties(controller);
        this.representative.setController(controller);
    }

    @Override
    public boolean titleContains(int x, int y) {
        Point point = new Point(x, y);
        int i = 0;
        int n = this.getTabCount();
        while (i < n) {
            Rectangle bounds = this.getBoundsAt(i);
            if (bounds.contains(point)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected BackgroundAlgorithm createBackground(CombinedStackDockComponent<EclipseTab, EclipseMenu, EclipseTabInfo> self) {
        return new Background((EclipseDockableDisplayer)self);
    }

    @Override
    public Insets getDockableInsets() {
        return this.getContentInsets();
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public DockTitle getTitle() {
        return this.title;
    }

    @Override
    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    @Override
    public void setStation(DockStation station) {
        this.station = station;
    }

    @Override
    public void setTitle(DockTitle title) {
        this.title = title;
    }

    @Override
    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }

    @Override
    protected BorderForwarder createBorderModifier(JComponent target) {
        return new DisplayerBorder(target, "eclipse");
    }

    @Override
    protected BorderForwarder createContentBorderModifier(Dockable dockable, JComponent target) {
        return new DisplayerBorder(target, "eclipse.content");
    }

    private static class Background
    extends BackgroundAlgorithm
    implements DisplayerBackgroundComponent {
        private EclipseDockableDisplayer displayer;

        public Background(EclipseDockableDisplayer displayer) {
            super(DisplayerBackgroundComponent.KIND, "dock.background.displayer");
            this.displayer = displayer;
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return this.displayer;
        }

        @Override
        public Component getComponent() {
            return this.getDisplayer().getComponent();
        }
    }

    private class DisplayerBorder
    extends BorderForwarder
    implements DisplayerDockBorder {
        public DisplayerBorder(JComponent target, String suffix) {
            super(DisplayerDockBorder.KIND, "dock.border.displayer." + suffix, target);
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return EclipseDockableDisplayer.this;
        }
    }
}

