/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.RoundRectButton;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.TabMenuDockIcon;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import javax.swing.Icon;

public class EclipseMenu
extends AbstractCombinedMenu {
    private EclipseTabPane pane;
    private RoundRectButton button;
    private TabMenuDockIcon icon;
    private Icon currentIcon;

    public EclipseMenu(EclipseTabPane pane) {
        super(pane, pane.getMenuHandler());
        this.pane = pane;
        this.icon = new TabMenuDockIcon("overflow.menu", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                EclipseMenu.this.currentIcon = newValue;
                if (EclipseMenu.this.button != null) {
                    EclipseMenu.this.button.getModel().setIcon(newValue);
                }
            }
        };
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        if (controller == null) {
            this.icon.setManager(null);
        } else {
            this.icon.setManager(controller.getIcons());
        }
    }

    @Override
    protected void backgroundChanged(BackgroundPaint paint) {
        if (this.button != null) {
            this.button.getModel().setBackground(paint, this.getBackground());
        }
    }

    @Override
    protected Component createComponent() {
        BasicTrigger trigger = new BasicTrigger(){

            @Override
            public void triggered() {
                EclipseMenu.this.open();
            }
        };
        this.button = new RoundRectButton(trigger, null);
        this.button.getModel().setIcon(this.currentIcon);
        return this.button;
    }

    @Override
    protected void ensureComponent() {
        boolean set = this.button == null;
        super.ensureComponent();
        if (set) {
            BackgroundAlgorithm background = this.getBackground();
            this.button.getModel().setBackground(background.getPaint(), background);
        }
    }

    @Override
    protected void selected(Dockable dockable) {
        this.pane.setSelectedDockable(dockable);
    }
}

