/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.event.CDockableLocationEvent;
import bibliothek.gui.dock.common.event.CDockableLocationListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.dockable.DockableStateEvent;
import bibliothek.gui.dock.dockable.DockableStateListener;
import java.awt.EventQueue;

public class CDockableLocationListenerManager {
    private CDockable dockable;
    private CDockableLocationListener listener;
    private CLocation location;
    private boolean visible;
    private boolean delayed = false;
    private DockableStateListener dockableListener = new DockableStateListener(){

        @Override
        public void changed(DockableStateEvent event) {
            CDockableLocationListenerManager.this.check();
        }
    };

    public CDockableLocationListenerManager(CDockable dockable) {
        this.dockable = dockable;
    }

    public void setListener(CDockableLocationListener listener) {
        if (this.listener == null) {
            this.dockable.intern().removeDockableStateListener(this.dockableListener);
        }
        this.listener = null;
        if (listener != null) {
            this.check();
            this.listener = listener;
            this.dockable.intern().addDockableStateListener(this.dockableListener);
        }
    }

    private void check() {
        if (!this.delayed) {
            this.delayed = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CDockableLocationListenerManager.this.delayed = false;
                    CDockableLocationListenerManager.this.checkNow();
                }
            });
        }
    }

    private void checkNow() {
        boolean newVisible = this.dockable.isDockableVisible();
        CLocation newLocation = this.dockable.getBaseLocation();
        boolean oldVisible = this.visible;
        CLocation oldLocation = this.location;
        this.visible = newVisible;
        this.location = newLocation;
        boolean locationEvent = false;
        if (!(newLocation == null && oldLocation == null || newLocation != null && newLocation.equals(oldLocation))) {
            locationEvent = true;
        }
        if ((locationEvent || newVisible != oldVisible) && this.listener != null) {
            CDockableLocationEvent event = new CDockableLocationEvent(this.dockable, oldVisible, newVisible, oldLocation, newLocation);
            this.listener.changed(event);
        }
    }
}

