/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import java.awt.Rectangle;

public class CLockedResizeLayoutManager
extends LockedResizeLayoutManager<RequestDimension> {
    private CControl control;

    public CLockedResizeLayoutManager() {
    }

    public CLockedResizeLayoutManager(CControl control) {
        this.control = control;
    }

    public CLockedResizeLayoutManager(SplitLayoutManager delegate) {
        super(delegate);
    }

    public void setControl(CControl control) {
        this.control = control;
    }

    @Override
    public ConflictResolver<RequestDimension> getConflictResolver() {
        if (this.control != null) {
            return this.control.getProperty(CControl.RESIZE_LOCK_CONFLICT_RESOLVER);
        }
        return super.getConflictResolver();
    }

    @Override
    public ResizeRequest getRequest(RequestDimension size, Leaf leaf) {
        if (size != null) {
            Rectangle modified = leaf.getCurrentBounds();
            double deltaWidth = (double)size.getWidth() + 0.001 - (double)modified.width;
            double deltaHeight = (double)size.getHeight() + 0.001 - (double)modified.height;
            Root root = leaf.getRoot();
            return new ResizeRequest(deltaWidth /= root.getWidthFactor(), deltaHeight /= root.getHeightFactor(), size.isWidthSet() ? 1 : -1, size.isHeightSet() ? 1 : -1);
        }
        return null;
    }

    @Override
    public RequestDimension prepareResize(Leaf leaf) {
        double height;
        double width;
        boolean lockedWidth = this.isLockedHorizontally(leaf.getDockable());
        boolean lockedHeight = this.isLockedVertically(leaf.getDockable());
        if (!lockedWidth && !lockedHeight) {
            return null;
        }
        RequestDimension request = new RequestDimension();
        Rectangle bounds = leaf.getCurrentBounds();
        if (lockedWidth && (width = leaf.getWidth()) > 0.0) {
            request.setWidth(bounds.width);
        }
        if (lockedHeight && (height = leaf.getHeight()) > 0.0) {
            request.setHeight(bounds.height);
        }
        return request;
    }

    private boolean isLockedVertically(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            CDockable cdock = ((CommonDockable)dockable).getDockable();
            return cdock.isResizeLockedVertically();
        }
        if (dockable != null && dockable.asDockStation() instanceof StackDockStation) {
            StackDockStation station = (StackDockStation)dockable.asDockStation();
            int i = 0;
            int n = station.getDockableCount();
            while (i < n) {
                if (this.isLockedVertically(station.getDockable(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isLockedHorizontally(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            CDockable cdock = ((CommonDockable)dockable).getDockable();
            return cdock.isResizeLockedHorizontally();
        }
        if (dockable != null && dockable.asDockStation() instanceof StackDockStation) {
            StackDockStation station = (StackDockStation)dockable.asDockStation();
            int i = 0;
            int n = station.getDockableCount();
            while (i < n) {
                if (this.isLockedHorizontally(station.getDockable(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

