/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.menu;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.event.DockFrontendAdapter;
import bibliothek.gui.dock.facile.menu.CloseableDockableMenuPiece;

public class SingleCDockableListMenuPiece
extends CloseableDockableMenuPiece {
    private CControl control;
    private CloseableListenerManager closeableManager = new CloseableListenerManager();

    public SingleCDockableListMenuPiece(CControl control) {
        this.setControl(control);
    }

    public void setControl(CControl control) {
        if (this.control != control) {
            this.control = control;
            if (control == null) {
                this.setFrontend(null);
            } else {
                this.setFrontend(control.intern());
            }
        }
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            this.closeableManager.bind();
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            this.closeableManager.unbind();
        }
    }

    @Override
    public void setFrontend(DockFrontend frontend) {
        super.setFrontend(frontend);
        this.closeableManager.setFrontend(frontend);
    }

    @Override
    protected void show(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setVisible(true);
        } else {
            super.show(dockable);
        }
    }

    @Override
    protected void hide(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setVisible(false);
        } else {
            super.hide(dockable);
        }
    }

    @Override
    protected boolean include(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().isCloseable();
        }
        return super.include(dockable);
    }

    private class CloseableListener
    extends CDockableAdapter {
        private CloseableListener() {
        }

        @Override
        public void closeableChanged(CDockable dockable) {
            SingleCDockableListMenuPiece.this.check(dockable.intern());
        }
    }

    private class CloseableListenerManager
    extends DockFrontendAdapter {
        private CloseableListener listener;
        private DockFrontend frontend;

        private CloseableListenerManager() {
            this.listener = new CloseableListener();
        }

        public void setFrontend(DockFrontend frontend) {
            if (this.frontend != frontend) {
                if (SingleCDockableListMenuPiece.this.isBound() && this.frontend != null) {
                    this.frontend.removeFrontendListener(this);
                    for (Dockable dockable : frontend.listDockables()) {
                        this.removed(this.frontend, dockable);
                    }
                }
                this.frontend = frontend;
                if (SingleCDockableListMenuPiece.this.isBound() && this.frontend != null) {
                    this.frontend.addFrontendListener(this);
                    for (Dockable dockable : frontend.listDockables()) {
                        this.added(this.frontend, dockable);
                    }
                }
            }
        }

        public void bind() {
            if (this.frontend != null) {
                this.frontend.addFrontendListener(this);
                for (Dockable dockable : this.frontend.listDockables()) {
                    this.added(this.frontend, dockable);
                }
            }
        }

        public void unbind() {
            if (this.frontend != null) {
                this.frontend.removeFrontendListener(this);
                for (Dockable dockable : this.frontend.listDockables()) {
                    this.removed(this.frontend, dockable);
                }
            }
        }

        @Override
        public void added(DockFrontend frontend, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
            }
        }

        @Override
        public void removed(DockFrontend frontend, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
            }
        }
    }
}

