/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.perspective.CContentPerspective;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.ShrinkablePerspectiveStation;
import bibliothek.gui.dock.common.perspective.mode.LocationModeManagerPerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class CPerspective {
    private Map<String, CStationPerspective> roots = new HashMap<String, CStationPerspective>();
    private LocationModeManagerPerspective locationModeManager;

    public CPerspective(CControlAccess control) {
        this.initLocations(control);
    }

    private void initLocations(CControlAccess control) {
        this.locationModeManager = new LocationModeManagerPerspective(this, control);
        CLocationModeManager manager = control.getLocationManager();
        for (CLocationMode mode : manager.modes()) {
            this.locationModeManager.addMode(mode.createPerspective());
        }
    }

    public LocationModeManagerPerspective getLocationManager() {
        return this.locationModeManager;
    }

    public void storeLocations() {
        Iterator<PerspectiveElement> elements = this.elements();
        while (elements.hasNext()) {
            CDockablePerspective cdockable;
            PerspectiveElement dockable = elements.next();
            if (!(dockable instanceof CommonElementPerspective) || (cdockable = ((CommonElementPerspective)dockable).getElement().asDockable()) == null) continue;
            this.storeLocation(cdockable);
        }
    }

    public Location storeLocation(CDockablePerspective dockable) {
        Location location = this.getLocationManager().getLocation(dockable);
        if (location != null) {
            dockable.getLocationHistory().add(this.getLocationManager().getMode(location.getMode()), location);
        }
        return location;
    }

    public void addRoot(CStationPerspective station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.roots.put(station.getUniqueId(), station);
        station.setPerspective(this);
    }

    public CStationPerspective getRoot(String id) {
        return this.roots.get(id);
    }

    public String[] getRootKeys() {
        return this.roots.keySet().toArray(new String[this.roots.size()]);
    }

    public CContentPerspective getContentArea() {
        return this.getContentArea("ccontrol");
    }

    public CContentPerspective getContentArea(String id) {
        String center = CContentArea.getCenterIdentifier(id);
        String north = CContentArea.getNorthIdentifier(id);
        String south = CContentArea.getSouthIdentifier(id);
        String east = CContentArea.getEastIdentifier(id);
        String west = CContentArea.getWestIdentifier(id);
        this.ensureType(center, CGridPerspective.class);
        this.ensureType(north, CMinimizePerspective.class);
        this.ensureType(south, CMinimizePerspective.class);
        this.ensureType(east, CMinimizePerspective.class);
        this.ensureType(west, CMinimizePerspective.class);
        if (this.getRoot(center) == null) {
            this.addRoot(new CGridPerspective(center, CContentArea.TYPE_ID_CENTER, false));
        }
        if (this.getRoot(north) == null) {
            this.addRoot(new CMinimizePerspective(north, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (this.getRoot(south) == null) {
            this.addRoot(new CMinimizePerspective(south, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (this.getRoot(east) == null) {
            this.addRoot(new CMinimizePerspective(east, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (this.getRoot(west) == null) {
            this.addRoot(new CMinimizePerspective(west, CContentArea.TYPE_ID_MINIMIZE));
        }
        return new CContentPerspective(this, id);
    }

    private void ensureType(String id, Class<?> type) {
        CStationPerspective station = this.getRoot(id);
        if (station != null && station.getClass() != type) {
            throw new IllegalStateException("present root station '" + id + "' is of type '" + station.getClass() + "' but should be of type '" + type + "'");
        }
    }

    public void shrink() {
        ArrayList<ShrinkablePerspectiveStation> elements = new ArrayList<ShrinkablePerspectiveStation>();
        Iterator<PerspectiveElement> iter = this.elements();
        while (iter.hasNext()) {
            PerspectiveElement next = iter.next();
            if (!(next instanceof ShrinkablePerspectiveStation)) continue;
            elements.add((ShrinkablePerspectiveStation)next);
        }
        for (ShrinkablePerspectiveStation station : elements) {
            station.shrink();
        }
    }

    public Iterator<PerspectiveElement> elements() {
        return new ElementIterator();
    }

    private static class ElementFrame {
        public PerspectiveElement[] items;
        public int offset;

        public ElementFrame(PerspectiveElement[] items) {
            this.items = items;
        }
    }

    private class ElementIterator
    implements Iterator<PerspectiveElement> {
        private LinkedList<ElementFrame> stack = new LinkedList();

        public ElementIterator() {
            ArrayList<CommonElementPerspective> items = new ArrayList<CommonElementPerspective>();
            for (CStationPerspective station : CPerspective.this.roots.values()) {
                if (station.asDockable() != null && station.asDockable().getParent() != null) continue;
                items.add(station.intern());
            }
            this.stack.addFirst(new ElementFrame(items.toArray(new PerspectiveElement[items.size()])));
        }

        @Override
        public boolean hasNext() {
            for (ElementFrame frame : this.stack) {
                if (frame.offset >= frame.items.length) continue;
                return true;
            }
            return false;
        }

        @Override
        public PerspectiveElement next() {
            while (this.stack.size() > 0) {
                ElementFrame top = this.stack.peek();
                if (top.offset < top.items.length) {
                    PerspectiveElement result;
                    PerspectiveStation station;
                    if ((station = (result = top.items[top.offset++]).asStation()) != null) {
                        PerspectiveElement[] children = new PerspectiveElement[station.getDockableCount()];
                        int i = 0;
                        while (i < children.length) {
                            children[i] = station.getDockable(i);
                            ++i;
                        }
                        this.stack.addFirst(new ElementFrame(children));
                    }
                    return result;
                }
                this.stack.poll();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

