/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.screen.ScreenDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockFullScreenPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPathPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PropertyTransformer {
    private Map<String, DockablePropertyFactory> factories = new HashMap<String, DockablePropertyFactory>();

    public PropertyTransformer() {
        this(SplitDockPropertyFactory.FACTORY, SplitDockPathPropertyFactory.FACTORY, SplitDockPlaceholderPropertyFactory.FACTORY, SplitDockFullScreenPropertyFactory.FACTORY, StackDockPropertyFactory.FACTORY, FlapDockPropertyFactory.FACTORY, ScreenDockPropertyFactory.FACTORY);
    }

    public PropertyTransformer(DockablePropertyFactory ... factories) {
        DockablePropertyFactory[] dockablePropertyFactoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            DockablePropertyFactory factory = dockablePropertyFactoryArray[n2];
            this.factories.put(factory.getID(), factory);
            ++n2;
        }
    }

    public void addFactory(DockablePropertyFactory factory) {
        this.factories.put(factory.getID(), factory);
    }

    public void write(DockableProperty property, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        int count = 0;
        DockableProperty successor = property;
        while (successor != null) {
            ++count;
            successor = successor.getSuccessor();
        }
        out.writeInt(count);
        while (property != null) {
            out.writeUTF(property.getFactoryID());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream datas = new DataOutputStream(bytes);
            property.store(datas);
            datas.close();
            byte[] written = bytes.toByteArray();
            out.writeInt(written.length);
            out.write(written);
            property = property.getSuccessor();
        }
    }

    public DockableProperty read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        int count = in.readInt();
        DockableProperty property = null;
        DockableProperty base = null;
        int i = 0;
        while (i < count) {
            String id = in.readUTF();
            DockablePropertyFactory factory = this.factories.get(id);
            if (factory == null) {
                throw new IOException("Unknown factory-id: " + id);
            }
            DockableProperty temp = factory.createProperty();
            int length = in.readInt();
            byte[] data = new byte[length];
            int index = 0;
            while (index < length) {
                int read = in.read(data, index, length - index);
                if (read < 0) {
                    throw new EOFException();
                }
                index += read;
            }
            DataInputStream datas = new DataInputStream(new ByteArrayInputStream(data));
            temp.load(datas);
            datas.close();
            if (base == null) {
                base = temp;
                property = temp;
            } else {
                property.setSuccessor(temp);
                property = temp;
            }
            ++i;
        }
        return base;
    }

    public void writeXML(DockableProperty property, XElement element) {
        while (property != null) {
            XElement xnode = element.addElement("property");
            xnode.addString("factory", property.getFactoryID());
            property.store(xnode);
            property = property.getSuccessor();
        }
    }

    public DockableProperty readXML(XElement element) {
        DockableProperty base = null;
        DockableProperty property = null;
        XElement[] xElementArray = element.getElements("property");
        int n = xElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            XElement xnode = xElementArray[n2];
            DockablePropertyFactory factory = this.factories.get(xnode.getString("factory"));
            if (factory == null) {
                throw new IllegalArgumentException("Missing factory: " + xnode.getString("factory"));
            }
            DockableProperty next = factory.createProperty();
            next.load(xnode);
            if (property == null) {
                property = next;
                base = next;
            } else {
                property.setSuccessor(next);
                property = next;
            }
            ++n2;
        }
        return base;
    }
}

