/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import java.io.IOException;

public abstract class AbstractDockStation
implements DockStation {
    private DockController controller;
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    @Override
    public void addDockStationListener(DockStationListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeDockStationListener(DockStationListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return true;
    }

    @Override
    public boolean accept(Dockable child) {
        return true;
    }

    @Override
    public boolean canCompare(DockStation station) {
        return false;
    }

    @Override
    public int compare(DockStation station) {
        return 0;
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new DockTitleEvent(this, dockable, active));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest request) {
    }
}

