/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractSplitDockGrid<D> {
    private List<Node<D>> nodes = new ArrayList<Node<D>>();
    private List<Line> lines = new ArrayList<Line>();

    public AbstractSplitDockGrid() {
    }

    public AbstractSplitDockGrid(String layout, Map<Character, D[]> dockables) {
        String[] lines = layout.split("\n");
        HashSet<Character> chars = new HashSet<Character>();
        int i = 0;
        int n = layout.length();
        while (i < n) {
            chars.add(Character.valueOf(layout.charAt(i)));
            ++i;
        }
        for (Character c : chars) {
            D[] list = dockables.get(c);
            if (list == null) continue;
            int minx = Integer.MAX_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxx = Integer.MIN_VALUE;
            int maxy = Integer.MIN_VALUE;
            int y = 0;
            while (y < lines.length) {
                int x = 0;
                int n2 = lines[y].length();
                while (x < n2) {
                    if (lines[y].charAt(x) == c.charValue()) {
                        minx = Math.min(minx, x);
                        maxx = Math.max(maxx, x);
                        miny = Math.min(miny, y);
                        maxy = Math.max(maxy, y);
                    }
                    ++x;
                }
                ++y;
            }
            this.addDockable(minx, miny, maxx - minx, maxy - miny, list);
        }
    }

    protected abstract D[] array(int var1);

    public void addDockable(double x, double y, double width, double height, D ... dockables) {
        if (dockables == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (dockables.length == 0) {
            throw new IllegalArgumentException("Dockables must at least have one element");
        }
        D[] DArray = dockables;
        int n = dockables.length;
        int n2 = 0;
        while (n2 < n) {
            D dockable = DArray[n2];
            if (dockable == null) {
                throw new IllegalArgumentException("Entry of dockables-array is null");
            }
            ++n2;
        }
        if (width < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        Node<D> node = this.nodeAt(x, y, width, height);
        int insert = 0;
        if (node.dockables == null) {
            node.dockables = this.array(dockables.length);
        } else {
            D[] oldDockables = node.dockables;
            insert = oldDockables.length;
            node.dockables = this.array(oldDockables.length + dockables.length);
            System.arraycopy(oldDockables, 0, node.dockables, 0, oldDockables.length);
        }
        System.arraycopy(dockables, 0, node.dockables, insert, dockables.length);
    }

    public void addPlaceholders(double x, double y, double width, double height, Path ... placeholders) {
        if (placeholders == null) {
            throw new IllegalArgumentException("Placeholders must not be null");
        }
        if (placeholders.length == 0) {
            throw new IllegalArgumentException("Placeholders must at least have one element");
        }
        Path[] pathArray = placeholders;
        int n = placeholders.length;
        int n2 = 0;
        while (n2 < n) {
            Path placeholder = pathArray[n2];
            if (placeholder == null) {
                throw new IllegalArgumentException("Entry of placeholders-array is null");
            }
            ++n2;
        }
        if (width < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        Node<D> node = this.nodeAt(x, y, width, height);
        int insert = 0;
        if (node.placeholders == null) {
            node.placeholders = new Path[placeholders.length];
        } else {
            Path[] oldPlaceholders = node.placeholders;
            insert = oldPlaceholders.length;
            node.placeholders = new Path[oldPlaceholders.length + placeholders.length];
            System.arraycopy(oldPlaceholders, 0, node.placeholders, 0, placeholders.length);
        }
        System.arraycopy(placeholders, 0, node.placeholders, insert, placeholders.length);
    }

    public void setPlaceholderMap(double x, double y, double width, double height, PlaceholderMap map) {
        for (Node<D> node : this.nodes) {
            if (node.x != x || node.y != y || node.width != width || node.height != height) continue;
            node.placeholderMap = map;
            return;
        }
        throw new IllegalArgumentException("there are no dockables registered with the given coordinates");
    }

    private Node<D> nodeAt(double x, double y, double width, double height) {
        for (Node<D> existingNode : this.nodes) {
            if (existingNode.x != x || existingNode.y != y || existingNode.width != width || existingNode.height != height) continue;
            return existingNode;
        }
        Node node = new Node();
        node.x = x;
        node.y = y;
        node.width = width;
        node.height = height;
        this.nodes.add(node);
        return node;
    }

    public void setSelected(double x, double y, double width, double height, D dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        if (width < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        for (Node<D> node : this.nodes) {
            if (node.x != x || node.y != y || node.width != width || node.height != height) continue;
            D[] DArray = node.dockables;
            int n = node.dockables.length;
            int n2 = 0;
            while (n2 < n) {
                Object check = DArray[n2];
                if (check == dockable) {
                    node.selected = dockable;
                    return;
                }
                ++n2;
            }
            throw new IllegalArgumentException("dockable is not in the described stack");
        }
        throw new IllegalArgumentException("there are no dockables registered with the given coordinates");
    }

    public void addVerticalDivider(double x, double y1, double y2) {
        Line line = new Line();
        line.horizontal = false;
        line.alpha = x;
        line.betaMin = Math.min(y1, y2);
        line.betaMax = Math.max(y1, y2);
        this.lines.add(line);
    }

    public void addHorizontalDivider(double x1, double x2, double y) {
        Line line = new Line();
        line.horizontal = true;
        line.alpha = y;
        line.betaMin = Math.min(x1, x2);
        line.betaMax = Math.max(x1, x2);
        this.lines.add(line);
    }

    protected void fillTree(SplitDockTree<D> tree) {
        Node<D> root = this.tree();
        if (root != null) {
            SplitDockTree.Key key = root.put(tree);
            tree.root(key);
        }
    }

    protected List<Line> getLines() {
        return this.lines;
    }

    protected List<Node<D>> getNodes() {
        return this.nodes;
    }

    /*
     * Unable to fully structure code
     */
    protected Node<D> tree() {
        nodes = new ArrayList<Node<D>>(this.nodes);
        if (!nodes.isEmpty()) ** GOTO lbl24
        return null;
lbl-1000:
        // 1 sources

        {
            size = nodes.size();
            bestA = 0;
            bestB = 0;
            bestDiff = 1.7976931348623157E308;
            i = 0;
            while (i < size) {
                j = i + 1;
                while (j < size) {
                    diff = this.diff((Node)nodes.get(i), (Node)nodes.get(j));
                    if (diff < bestDiff) {
                        bestDiff = diff;
                        bestA = i;
                        bestB = j;
                    }
                    ++j;
                }
                ++i;
            }
            node = this.combine((Node)nodes.remove(bestB), (Node)nodes.remove(bestA));
            nodes.add(node);
lbl24:
            // 2 sources

            ** while (nodes.size() > 1)
        }
lbl25:
        // 1 sources

        return (Node)nodes.get(0);
    }

    protected Node<D> combine(Node<D> a, Node<D> b) {
        double x = Math.min(a.x, b.x);
        double y = Math.min(a.y, b.y);
        double w = Math.max(a.x + a.width, b.x + b.width) - x;
        double h = Math.max(a.y + a.height, b.y + b.height) - y;
        double max = a.x + a.width / 2.0;
        double may = a.y + a.height / 2.0;
        double mbx = b.x + b.width / 2.0;
        double mby = b.y + b.height / 2.0;
        double dmx = (max - mbx) * h;
        double dmy = (may - mby) * w;
        Node node = new Node();
        if (Math.abs(dmx) > Math.abs(dmy)) {
            node.horizontal = true;
            if (dmx > 0.0) {
                node.childA = b;
                node.childB = a;
            } else {
                node.childA = a;
                node.childB = b;
            }
            double split = ((node.childA.x + node.childA.width + node.childB.x) / 2.0 - x) / w;
            Line line = this.bestFittingLine(x, y, w, h, false, split);
            node.divider = line == null ? split : (line.alpha - x) / w;
        } else {
            node.horizontal = false;
            if (dmy > 0.0) {
                node.childA = b;
                node.childB = a;
            } else {
                node.childA = a;
                node.childB = b;
            }
            double split = ((node.childA.y + node.childA.height + node.childB.y) / 2.0 - y) / h;
            Line line = this.bestFittingLine(x, y, w, h, true, split);
            node.divider = line == null ? split : (line.alpha - y) / h;
        }
        node.x = x;
        node.y = y;
        node.width = w;
        node.height = h;
        return node;
    }

    protected double diff(Node<D> a, Node<D> b) {
        double x = Math.min(a.x, b.x);
        double y = Math.min(a.y, b.y);
        double w = Math.max(a.x + a.width, b.x + b.width) - x;
        double h = Math.max(a.y + a.height, b.y + b.height) - y;
        double sizeA = a.width * a.height;
        double sizeB = b.width * b.height;
        double size = w * h;
        double diff = (size - sizeA - sizeB) / size;
        for (Line line : this.lines) {
            diff += this.penalty(x, y, w, h, line);
        }
        return diff;
    }

    protected Line bestFittingLine(double x, double y, double w, double h, boolean horizontal, double split) {
        Line bestLine = null;
        double best = Double.MAX_VALUE;
        for (Line line : this.lines) {
            double penalty;
            double diff;
            double max;
            double min;
            if (line.horizontal != horizontal) continue;
            if (line.horizontal) {
                if (y > line.alpha || y + h < line.alpha || x + w < line.betaMin || x > line.betaMax) continue;
                min = Math.min(x, line.betaMin);
                max = Math.max(x + w, line.betaMax);
                diff = max - min - Math.min(line.betaMax - line.betaMin, w);
                penalty = diff / (max - min);
                penalty *= 1.0 + Math.abs(split - line.alpha) / h;
            } else {
                if (x > line.alpha || x + w < line.alpha || y + h < line.betaMin || y > line.betaMax) continue;
                min = Math.min(y, line.betaMin);
                max = Math.max(y + h, line.betaMax);
                diff = max - min - Math.min(line.betaMax - line.betaMin, h);
                penalty = diff / (max - min);
                penalty *= 1.0 + Math.abs(split - line.alpha) / w;
            }
            if (!(penalty < 0.25) || !(penalty < best)) continue;
            best = penalty;
            bestLine = line;
        }
        return bestLine;
    }

    protected double penalty(double x, double y, double w, double h, Line line) {
        double diff;
        double max;
        double min;
        if (line.horizontal) {
            if (y > line.alpha || y + h < line.alpha) {
                return 0.0;
            }
            if (x + w < line.betaMin || x > line.betaMax) {
                return 0.0;
            }
            min = Math.min(x, line.betaMin);
            max = Math.max(x + w, line.betaMax);
            diff = max - min - Math.min(line.betaMax - line.betaMin, w);
        } else {
            if (x > line.alpha || x + w < line.alpha) {
                return 0.0;
            }
            if (y + h < line.betaMin || y > line.betaMax) {
                return 0.0;
            }
            min = Math.min(y, line.betaMin);
            max = Math.max(y + h, line.betaMax);
            diff = max - min - Math.min(line.betaMax - line.betaMin, h);
        }
        return diff / (max - min);
    }

    protected static class Line {
        public boolean horizontal;
        public double alpha;
        public double betaMin;
        public double betaMax;

        protected Line() {
        }
    }

    protected static class Node<D> {
        public double x;
        public double y;
        public double width;
        public double height;
        public Node<D> childA;
        public Node<D> childB;
        public double divider;
        public boolean horizontal;
        public D[] dockables;
        public D selected;
        public Path[] placeholders;
        public PlaceholderMap placeholderMap;

        protected Node() {
        }

        public SplitDockTree.Key put(SplitDockTree<D> tree) {
            if (this.dockables != null || this.childA == null || this.childB == null) {
                return tree.put(this.dockables, this.selected, this.placeholders, this.placeholderMap, -1L);
            }
            if (this.horizontal) {
                return tree.horizontal(this.childA.put(tree), this.childB.put(tree), this.divider, this.placeholders, this.placeholderMap, -1L);
            }
            return tree.vertical(this.childA.put(tree), this.childB.put(tree), this.divider, this.placeholders, this.placeholderMap, -1L);
        }
    }
}

