/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class SplitDockCombinerSource
implements CombinerSource {
    private PutInfo info;
    private Dockable old;
    private SplitDockStation station;
    private Point mouse;

    public SplitDockCombinerSource(PutInfo info, SplitDockStation station, Point mouseOnStation) {
        if (!(info.getNode() instanceof Leaf)) {
            throw new IllegalArgumentException("info is not available for a combination");
        }
        this.info = info;
        this.station = station;
        this.mouse = mouseOnStation;
        this.old = this.getLeaf().getDockable();
        if (this.old == null) {
            throw new IllegalArgumentException("old Dockable is null");
        }
    }

    @Override
    public Point getMousePosition() {
        if (this.mouse == null) {
            return null;
        }
        Point mouse = new Point(this.mouse);
        return SwingUtilities.convertPoint(this.station.getComponent(), mouse, this.getOld().getComponent());
    }

    private Leaf getLeaf() {
        return (Leaf)this.info.getNode();
    }

    @Override
    public Dockable getNew() {
        return this.info.getDockable();
    }

    @Override
    public Dockable getOld() {
        return this.old;
    }

    @Override
    public DockStation getParent() {
        return this.station;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.getLeaf().getPlaceholderMap();
    }

    @Override
    public Dimension getSize() {
        return this.getOld().getComponent().getSize();
    }

    @Override
    public boolean isMouseOverTitle() {
        return this.info.getPut() == PutInfo.Put.TITLE;
    }
}

