/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitDockProperty
extends AbstractDockableProperty {
    public static final SplitDockProperty EAST = new SplitDockProperty(0.75, 0.0, 0.25, 1.0);
    public static final SplitDockProperty WEST = new SplitDockProperty(0.0, 0.0, 0.25, 1.0);
    public static final SplitDockProperty NORTH = new SplitDockProperty(0.0, 0.0, 1.0, 0.25);
    public static final SplitDockProperty SOUTH = new SplitDockProperty(0.0, 0.75, 1.0, 0.25);
    private double x;
    private double y;
    private double width;
    private double height;

    public SplitDockProperty() {
    }

    public SplitDockProperty(double x, double y, double width, double height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public DockableProperty copy() {
        SplitDockProperty copy = new SplitDockProperty(this.x, this.y, this.width, this.height);
        this.copy(copy);
        return copy;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPropertyFactory";
    }

    @Override
    public void store(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.width);
        out.writeDouble(this.height);
    }

    @Override
    public void store(XElement element) {
        element.addElement("x").setDouble(this.x);
        element.addElement("y").setDouble(this.y);
        element.addElement("width").setDouble(this.width);
        element.addElement("height").setDouble(this.height);
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.width = in.readDouble();
        this.height = in.readDouble();
    }

    @Override
    public void load(XElement element) {
        this.x = element.getElement("x").getDouble();
        this.y = element.getElement("y").getDouble();
        this.width = element.getElement("width").getDouble();
        this.height = element.getElement("height").getDouble();
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SplitDockProperty)) {
            return false;
        }
        SplitDockProperty other = (SplitDockProperty)obj;
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

