/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupCombinedMenuContent
implements CombinedMenuContent {
    private JPopupMenu menu;
    private List<CombinedMenuContentListener> listeners = new ArrayList<CombinedMenuContentListener>();

    @Override
    public void addCombinedMenuContentListener(CombinedMenuContentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCombinedMenuContentListener(CombinedMenuContentListener listener) {
        this.listeners.remove(listener);
    }

    protected CombinedMenuContentListener[] listeners() {
        return this.listeners.toArray(new CombinedMenuContentListener[this.listeners.size()]);
    }

    @Override
    public void open(DockController controller, Component parent, int x, int y, CombinedMenuContent.Item[] content) {
        this.cancel();
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopupCombinedMenuContent.this.cancel();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        Object[] objectArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedMenuContent.Item item = objectArray[n2];
            this.menu.add(new ItemAction(item));
            ++n2;
        }
        this.menu.show(parent, x, y);
        objectArray = this.listeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            listener.opened(this);
            ++n2;
        }
    }

    @Override
    public void cancel() {
        if (this.menu != null) {
            JPopupMenu menu = this.menu;
            this.menu = null;
            menu.setVisible(false);
            CombinedMenuContentListener[] combinedMenuContentListenerArray = this.listeners();
            int n = combinedMenuContentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedMenuContentListener listener = combinedMenuContentListenerArray[n2];
                listener.canceled(this);
                ++n2;
            }
        }
    }

    public void select(Dockable dockable) {
        if (this.menu != null) {
            JPopupMenu menu = this.menu;
            this.menu = null;
            menu.setVisible(false);
            CombinedMenuContentListener[] combinedMenuContentListenerArray = this.listeners();
            int n = combinedMenuContentListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CombinedMenuContentListener listener = combinedMenuContentListenerArray[n2];
                listener.selected(this, dockable);
                ++n2;
            }
        }
    }

    private class ItemAction
    extends AbstractAction {
        private Dockable dockable;

        public ItemAction(CombinedMenuContent.Item content) {
            this.dockable = content.getDockable();
            this.putValue("Name", content.getText());
            this.putValue("ShortDescription", content.getToolTip());
            this.putValue("SmallIcon", content.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopupCombinedMenuContent.this.select(this.dockable);
        }
    }
}

