/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractTabLayoutManager<I extends PaneInfo>
implements TabLayoutManager {
    private List<I> infos = new ArrayList<I>();

    @Override
    public void install(TabPane pane) {
        I info = this.createInfoFor(pane);
        pane.addTabPaneListener((TabPaneListener)info);
        this.infos.add(info);
    }

    @Override
    public void uninstall(TabPane pane) {
        ListIterator<I> iterator = this.infos.listIterator();
        while (iterator.hasNext()) {
            PaneInfo next = (PaneInfo)iterator.next();
            if (next.getPane() != pane) continue;
            iterator.remove();
            pane.removeTabPaneListener(next);
            this.destroy(next);
        }
    }

    protected abstract I createInfoFor(TabPane var1);

    protected abstract void destroy(I var1);

    public I getInfo(TabPane pane) {
        for (PaneInfo check : this.infos) {
            if (check.getPane() != pane) continue;
            return (I)check;
        }
        return null;
    }

    protected static class PaneInfo
    implements TabPaneListener {
        private TabPane pane;

        public PaneInfo(TabPane pane) {
            if (pane == null) {
                throw new IllegalStateException("pane must not be null");
            }
            this.pane = pane;
        }

        public TabPane getPane() {
            return this.pane;
        }

        @Override
        public void added(TabPane pane, Dockable dockable) {
        }

        @Override
        public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
        }

        @Override
        public void removed(TabPane pane, Dockable dockable) {
        }

        @Override
        public void selectionChanged(TabPane pane) {
        }
    }
}

