/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;

public class RowLayout
implements TabLayoutManager {
    @Override
    public Dimension getMinimumSize(TabPane pane) {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getPreferredSize(TabPane pane) {
        return new Dimension(10, 10);
    }

    private AxisConversion getConversion(TabPane pane) {
        return new DefaultAxisConversion(pane.getAvailableArea(), pane.getTabPlacement());
    }

    @Override
    public void layout(TabPane pane) {
        AxisConversion conversion = this.getConversion(pane);
        TabPlacement orientation = pane.getTabPlacement();
        Rectangle available = conversion.viewToModel(pane.getAvailableArea());
        int maxwidth = available.width;
        Dockable[] dockables = pane.getDockables();
        Tab[] tabs = new Tab[dockables.length];
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = pane.putOnTab(dockables[i]);
            tabs[i].setOrientation(orientation);
            ++i;
        }
        Dimension required = conversion.viewToModel(this.getPreferredSize(tabs, pane));
        if (required.height < available.height) {
            pane.setSelectedBounds(conversion.modelToView(new Rectangle(0, required.height, available.width, available.height - required.height)));
        } else {
            pane.setSelectedBounds(conversion.modelToView(new Rectangle(0, 0, available.width, 0)));
        }
        int dx = 0;
        int dy = 0;
        int x = 0;
        int y = 0;
        int maxRowHeight = -1;
        int rowCount = 0;
        int i2 = 0;
        while (i2 < tabs.length) {
            Dimension size = conversion.viewToModel(tabs[i2].getPreferredSize());
            if (x + size.width > maxwidth && rowCount > 0) {
                rowCount = 0;
                y += maxRowHeight;
                x = 0;
                maxRowHeight = -1;
            }
            if (maxRowHeight == -1) {
                maxRowHeight = 0;
                int tx = x;
                int j = i2;
                while (j < tabs.length) {
                    Dimension tsize = conversion.viewToModel(tabs[j].getPreferredSize());
                    if (tx + tsize.width > maxwidth && rowCount > 0) {
                        rowCount = 0;
                        break;
                    }
                    tx += tsize.width;
                    maxRowHeight = Math.max(maxRowHeight, tsize.height);
                    ++rowCount;
                    ++j;
                }
            }
            tabs[i2].setBounds(conversion.modelToView(new Rectangle(x + dx, y + dy - size.height + maxRowHeight, size.width, size.height)));
            x += size.width;
            ++rowCount;
            ++i2;
        }
    }

    private Dimension getPreferredSize(Tab[] tabs, TabPane pane) {
        AxisConversion conversion = this.getConversion(pane);
        int width = pane == null ? Integer.MAX_VALUE : conversion.viewToModel((Rectangle)pane.getAvailableArea()).width;
        int maxWidth = 0;
        int currentWidth = 0;
        int currentHeight = 0;
        int left = 0;
        int height = 0;
        Tab[] tabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            Dimension preferred = conversion.viewToModel(tab.getPreferredSize());
            if (left == 0 || currentWidth + preferred.width <= width) {
                currentWidth += preferred.width;
                currentHeight = Math.max(currentHeight, preferred.height);
                ++left;
            } else {
                height += currentHeight;
                maxWidth = Math.max(maxWidth, currentWidth);
                left = 0;
                currentWidth = preferred.width;
                currentHeight = preferred.height;
                ++left;
            }
            ++n2;
        }
        maxWidth = Math.max(maxWidth, currentWidth);
        return conversion.modelToView(new Dimension(maxWidth, height += currentHeight));
    }

    @Override
    public void install(TabPane pane) {
    }

    @Override
    public void uninstall(TabPane pane) {
    }
}

