/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.color.StationPaintColor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;

public class BasicStationPaint
implements StationPaint {
    private StationPaintColor color = new StationPaintColor("", (StationPaint)this, (Color)SystemColor.textHighlight){

        @Override
        protected void changed(Color oldColor, Color newColor) {
        }
    };

    @Deprecated
    public Color getColor() {
        return (Color)this.color.value();
    }

    @Deprecated
    public void setColor(Color color) {
        this.color.setValue(color);
    }

    @Override
    public void drawDivider(Graphics g, DockStation station, Rectangle bounds) {
        this.color.setId("paint.divider");
        this.color.connect(station.getController());
        g.setColor((Color)this.color.value());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        this.color.connect(null);
    }

    @Override
    public void drawInsertion(Graphics g, DockStation station, Rectangle stationBounds, Rectangle dockableBounds) {
        this.color.setId("paint.insertion");
        this.color.connect(station.getController());
        g.setColor((Color)this.color.value());
        Graphics2D g2 = (Graphics2D)g;
        Composite old = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.33f));
        int x = dockableBounds.x + 1;
        int y = dockableBounds.y + 1;
        int w = dockableBounds.width - 3;
        int h = dockableBounds.height - 3;
        g2.fillRect(x, y, w, h);
        g2.setComposite(old);
        this.drawInsertionLine(g, station, x, y, x + w, y, false);
        this.drawInsertionLine(g, station, x, y, x, y + h, false);
        this.drawInsertionLine(g, station, x + w, y + h, x, y + h, false);
        this.drawInsertionLine(g, station, x + w, y + h, x + w, y, false);
        this.color.connect(null);
    }

    @Override
    public void drawInsertionLine(Graphics g, DockStation station, int x1, int x2, int y1, int y2) {
        this.drawInsertionLine(g, station, x1, x2, y1, y2, true);
    }

    private void drawInsertionLine(Graphics g, DockStation station, int x1, int x2, int y1, int y2, boolean newColor) {
        if (newColor) {
            this.color.setId("paint.line");
            this.color.connect(station.getController());
        }
        g.setColor((Color)this.color.value());
        Graphics2D g2 = (Graphics2D)g;
        Stroke old = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(x1, x2, y1, y2);
        g2.setStroke(old);
        if (newColor) {
            this.color.connect(null);
        }
    }
}

