/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.AbstractBasicHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JComponent;

public abstract class BasicHandler<D extends StandardDockAction>
extends AbstractBasicHandler<D, BasicButtonModel>
implements BasicTrigger,
BasicTitleViewItem<JComponent> {
    private Listener listener;

    public BasicHandler(D action, Dockable dockable) {
        super(action, dockable);
    }

    @Override
    public JComponent getItem() {
        return ((BasicButtonModel)this.getModel()).getOwner();
    }

    @Override
    public void setBackground(Color background) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setBackground(background);
        }
    }

    @Override
    public void setForeground(Color foreground) {
        JComponent item = this.getItem();
        if (item != null) {
            ((Component)item).setForeground(foreground);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        ((BasicButtonModel)this.getModel()).setOrientation(orientation);
    }

    @Override
    public abstract void triggered();

    @Override
    public void bind() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        this.listener.updateTooltip();
        Object model = this.getModel();
        StandardDockAction action = (StandardDockAction)this.getAction();
        Dockable dockable = this.getDockable();
        ((BasicButtonModel)model).setIcon(action.getIcon(dockable));
        ((BasicButtonModel)model).setDisabledIcon(action.getDisabledIcon(dockable));
        ((BasicButtonModel)model).setEnabled(action.isEnabled(dockable));
        ((BasicButtonModel)model).setDockableRepresentative(action.getDockableRepresentation(dockable));
        action.addDockActionListener(this.listener);
        super.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        ((BasicButtonModel)this.getModel()).setDockableRepresentative(null);
        ((StandardDockAction)this.getAction()).removeDockActionListener(this.listener);
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected class Listener
    implements StandardDockActionListener {
        protected Listener() {
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setDisabledIcon(action.getDisabledIcon(dockable));
            }
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setEnabled(action.isEnabled(dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setIcon(action.getIcon(dockable));
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                this.updateTooltip();
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                this.updateTooltip();
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            Dockable dockable = BasicHandler.this.getDockable();
            if (dockables.contains(dockable)) {
                ((BasicButtonModel)BasicHandler.this.getModel()).setDockableRepresentative(action.getDockableRepresentation(dockable));
            }
        }

        private void updateTooltip() {
            Dockable dockable = BasicHandler.this.getDockable();
            StandardDockAction action = (StandardDockAction)BasicHandler.this.getAction();
            String tooltip = action.getTooltipText(dockable);
            if (tooltip == null || tooltip.length() == 0) {
                tooltip = action.getText(dockable);
            }
            ((BasicButtonModel)BasicHandler.this.getModel()).setToolTipText(tooltip);
        }
    }
}

