/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractMenuHandler<I extends JMenuItem, D extends StandardDockAction>
implements MenuViewItem<JComponent> {
    protected I item;
    protected Dockable dockable;
    protected D action;
    private Listener listener;

    public AbstractMenuHandler(D action, Dockable dockable, I item) {
        this.action = action;
        this.dockable = dockable;
        this.item = item;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public D getAction() {
        return this.action;
    }

    @Override
    public JMenuItem getItem() {
        return this.item;
    }

    @Override
    public void bind() {
        if (this.action != null) {
            if (this.listener == null) {
                this.action.bind(this.dockable);
                this.listener = new Listener();
                this.action.addDockActionListener(this.listener);
                ((JMenuItem)this.item).setEnabled(this.action.isEnabled(this.dockable));
                ((AbstractButton)this.item).setIcon(this.action.getIcon(this.dockable));
                ((AbstractButton)this.item).setDisabledIcon(this.action.getDisabledIcon(this.dockable));
                ((AbstractButton)this.item).setText(this.action.getText(this.dockable));
                ((JComponent)this.item).setToolTipText(this.action.getTooltipText(this.dockable));
            } else {
                throw new IllegalStateException("Handler is already bound");
            }
        }
    }

    @Override
    public void unbind() {
        if (this.action != null) {
            if (this.listener != null) {
                this.action.unbind(this.dockable);
                this.action.removeDockActionListener(this.listener);
                this.listener = null;
            } else {
                throw new IllegalStateException("Handler is already unbound");
            }
        }
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            ((JMenuItem)AbstractMenuHandler.this.item).setEnabled(action.isEnabled(AbstractMenuHandler.this.dockable));
        }

        @Override
        public void actionIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            ((AbstractButton)AbstractMenuHandler.this.item).setIcon(action.getIcon(AbstractMenuHandler.this.dockable));
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            ((AbstractButton)AbstractMenuHandler.this.item).setDisabledIcon(action.getDisabledIcon(AbstractMenuHandler.this.dockable));
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            ((AbstractButton)AbstractMenuHandler.this.item).setText(action.getText(AbstractMenuHandler.this.dockable));
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            ((JComponent)AbstractMenuHandler.this.item).setToolTipText(action.getTooltipText(AbstractMenuHandler.this.dockable));
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
        }
    }
}

