/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xBaseJ.DBF;
import org.xBaseJ.DBTFile;
import org.xBaseJ.DBT_fpt;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class PictureField
extends Field {
    private static final long serialVersionUID = 1L;
    private DBT_fpt dbtobj;
    private int originalSize;
    private String value;
    private byte[] byteValue;

    public PictureField() {
    }

    public void setDBTObj(DBTFile indbtobj) {
        this.dbtobj = (DBT_fpt)indbtobj;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            PictureField tField = new PictureField(this.Name, null, null);
            return tField;
        }
        catch (xBaseJException xBaseJException2) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public PictureField(String Name, ByteBuffer inBuffer, DBTFile indbtobj) throws xBaseJException, IOException {
        super.setField(Name, 10, inBuffer);
        this.dbtobj = (DBT_fpt)indbtobj;
        this.value = new String("");
    }

    public PictureField(String iName) throws xBaseJException, IOException {
        super.setField(iName, 10, null);
        this.dbtobj = null;
        this.originalSize = 0;
        this.buffer = new byte[10];
        int i = 0;
        while (i < 10) {
            this.buffer[i] = 48;
            ++i;
        }
        this.value = new String("");
    }

    @Override
    public char getType() {
        return 'P';
    }

    @Override
    public String get() {
        if (this.byteValue == null) {
            return "";
        }
        try {
            return new String(this.byteValue, DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.byteValue);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.byteValue;
    }

    @Override
    public void read() throws IOException, xBaseJException {
        super.read();
        this.byteValue = this.dbtobj.readBytes(this.buffer);
        this.originalSize = this.byteValue == null ? 0 : this.value.length();
    }

    @Override
    public void put(String invalue) throws xBaseJException {
        throw new xBaseJException("use put(Bytes[])");
    }

    @Override
    public void put(byte[] inBytes) throws xBaseJException {
        this.byteValue = inBytes;
    }

    @Override
    public void write() throws IOException, xBaseJException {
        this.buffer = this.dbtobj.write(this.byteValue, this.originalSize, true, this.buffer);
        super.write();
    }

    @Override
    public void update() throws IOException, xBaseJException {
        this.buffer = this.dbtobj.write(this.byteValue, this.originalSize, false, this.buffer);
        super.write();
    }
}

