/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.faktureUsluga.ArhivaFaktureZaUsluge;
import rs.pezar.prodaja.gui.faktureUsluga.DodavanjeStavke;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzDialogIzradaFaktureSpedicije
extends PzDialog {
    private static final long serialVersionUID = -3616633163888871953L;
    private PzPanel plDonjiTabela;
    private PzPanel pnlGlavni;
    private JSeparator jSeparator;
    private PzToolBarIcon icnIzmena;
    private PzButton btnZaglavlje;
    private PzToolBarIcon btnIzlaz;
    private PzTable table;
    private JScrollPane scPane;
    private PzDateField dfDatumValute;
    private PzNumericOnlyTextField nfValuta;
    private PzDoubleField dfUkupnaVrednost;
    private PzTextField tfSifraKomitenta;
    private PzDateField dfDatumIzrade;
    private JLabel lblDatumValute;
    private JLabel lblValuta;
    private JLabel lblUkupnaVrednost;
    private JLabel lblSifraKupca;
    private JLabel lblDatumIzrade;
    private PzToolBarIcon btnDodavanje;
    private PzToolBarIcon btnBrisanje;
    private PzToolBarIcon btnBrisiSve;
    private PzToolBarIcon btnArhiviranje;
    private JToolBar toolbar;
    private PzPanel plLabele;
    private Radnajedinica rj;
    private Fakturausluga fakturaUPripremi = null;
    private PzTextField tfNazivKomitenta;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Komitent komitent;

    public PzDialogIzradaFaktureSpedicije(JFrame frame) {
        super(frame);
    }

    private void getFaktura() {
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("SELECT f FROM Fakturausluga f where f.userKraj=:user and f.arhiviran = 0 and f.tip=:tip and f.podTip=:podtip and f.radnajedinica=:rj");
        q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
        q.setParameter("tip", (Object)"FAKTURA_USLUGA");
        q.setParameter("podtip", (Object)"FAKTURA_SPEDICIJE");
        q.setParameter("rj", (Object)this.rj);
        if (q.getResultList().size() > 0) {
            this.fakturaUPripremi = (Fakturausluga)q.getSingleResult();
        }
        em.close();
    }

    private void postInit() {
        if (this.fakturaUPripremi != null) {
            this.nfValuta.setVal((Object)PzDateUtility.subtract((Date)this.fakturaUPripremi.getDatValute(), (Date)this.fakturaUPripremi.getDatum()));
            this.dfDatumIzrade.setVal((Object)this.fakturaUPripremi.getDatum());
            this.dfDatumValute.setVal((Object)this.fakturaUPripremi.getDatValute());
            this.tfSifraKomitenta.setVal((Object)this.fakturaUPripremi.getKomitent().getSfrKomitent());
            this.tfNazivKomitenta.setVal((Object)this.fakturaUPripremi.getKomitent().getNaziv());
            this.dfUkupnaVrednost.setVal((Object)this.fakturaUPripremi.getIznosFaktureSpedicije());
            this.setUkupanIznos();
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Faktura \u0161pedicije");
            BorderLayout plGlavniLayout = new BorderLayout();
            this.getContentPane().setLayout(plGlavniLayout);
            this.pnlGlavni = new PzPanel();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{111, 151, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.plDonjiTabela = new PzPanel();
            this.pnlGlavni.add((Component)this.plDonjiTabela, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout plDonjiTabelaLayout = new GridBagLayout();
            plDonjiTabelaLayout.rowWeights = new double[]{0.1};
            plDonjiTabelaLayout.rowHeights = new int[]{7};
            plDonjiTabelaLayout.columnWeights = new double[]{0.1};
            plDonjiTabelaLayout.columnWidths = new int[]{7};
            this.plDonjiTabela.setLayout((LayoutManager)plDonjiTabelaLayout);
            this.plDonjiTabela.setOpaque(false);
            this.scPane = new JScrollPane();
            this.plDonjiTabela.add((Component)this.scPane, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.table = this.fakturaUPripremi == null ? new PzTable(new Vector(), Stavkafaktureusl.class) : new PzTable(this.fakturaUPripremi.getStavkafaktureusls(), Stavkafaktureusl.class);
            this.scPane.setViewportView((Component)this.table);
            this.plLabele = new PzPanel();
            this.pnlGlavni.add((Component)this.plLabele, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout plLabeleLayout = new GridBagLayout();
            plLabeleLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            plLabeleLayout.rowHeights = new int[]{28, 25, 46, 31};
            plLabeleLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plLabeleLayout.columnWidths = new int[]{35, 95, 100, 65, 95, 100, 100, 50};
            this.plLabele.setLayout((LayoutManager)plLabeleLayout);
            this.plLabele.setOpaque(false);
            this.lblDatumIzrade = new JLabel();
            this.plLabele.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.lblSifraKupca = new JLabel();
            this.plLabele.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.lblUkupnaVrednost = new JLabel();
            this.plLabele.add((Component)this.lblUkupnaVrednost, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblUkupnaVrednost.setText("Ukupna vrednost");
            this.lblValuta = new JLabel();
            this.plLabele.add((Component)this.lblValuta, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblValuta.setText("Valuta");
            this.lblDatumValute = new JLabel();
            this.plLabele.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumValute.setText("Datum valute");
            this.dfDatumIzrade = new PzDateField();
            this.plLabele.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.tfSifraKomitenta = new PzTextField();
            this.plLabele.add((Component)this.tfSifraKomitenta, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfSifraKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, "Komitent sa unetom \u0161ifrom ne postoji.");
            this.tfSifraKomitenta.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogIzradaFaktureSpedicije.this.komitent == null) {
                        return false;
                    }
                    return PzProdajaUtil.grupeKomitenata(PzDialogIzradaFaktureSpedicije.this, PzApplication.getApplication().getSession().getLoggedUser(), PzDialogIzradaFaktureSpedicije.this.komitent);
                }
            });
            this.tfNazivKomitenta = new PzTextField();
            this.plLabele.add((Component)this.tfNazivKomitenta, (Object)new GridBagConstraints(3, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 1, 0), 0, 0));
            this.tfNazivKomitenta.setForeground(new Color(255, 0, 0));
            this.tfNazivKomitenta.setEditable(false);
            this.tfNazivKomitenta.setFocusable(false);
            this.dfUkupnaVrednost = new PzDoubleField();
            this.plLabele.add((Component)this.dfUkupnaVrednost, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 0, 3, 0), 0, 0));
            this.dfUkupnaVrednost.setFont(new Font("Tahoma", 0, 14));
            this.dfUkupnaVrednost.setFocusable(false);
            this.nfValuta = new PzNumericOnlyTextField();
            this.plLabele.add((Component)this.nfValuta, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 0, 1, 0), 0, 0));
            this.nfValuta.setFont(new Font("Tahoma", 0, 14));
            this.nfValuta.setMaxLength(4);
            this.nfValuta.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzDialogIzradaFaktureSpedicije.this.keyRel(evt);
                }
            });
            this.dfDatumValute = new PzDateField();
            this.plLabele.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 0, 1, 0), 0, 0));
            this.dfDatumValute.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumValute.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumValute.setCustomInputVerifier(this.getInputVerifier());
            this.btnZaglavlje = new PzButton();
            this.plLabele.add((Component)this.btnZaglavlje, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 3, new Insets(2, 0, 0, 0), 0, 0));
            this.btnZaglavlje.setText("Snimi|zaglavlje");
            this.btnZaglavlje.setActionCommand("snimiZaglavlje");
            this.btnZaglavlje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnZaglavlje.setBounds(286, 167, 149, 33);
            this.btnZaglavlje.addActionListener((ActionListener)((Object)this));
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setFloatable(false);
            this.toolbar.setOpaque(false);
            this.btnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnDodavanje);
            this.btnDodavanje.setText("Dodavanje|(Ins)");
            this.btnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_add.png")));
            this.btnDodavanje.setActionCommand("insert");
            this.btnDodavanje.addActionListener((ActionListener)((Object)this));
            this.btnDodavanje.setShortcut("insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|PDV-a (F3)");
            this.icnIzmena.setActionCommand("update");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.btnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisanje);
            this.btnBrisanje.setText("Brisanje| (Del)");
            this.btnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_delete.png")));
            this.btnBrisanje.setActionCommand("brisanje");
            this.btnBrisanje.addActionListener((ActionListener)((Object)this));
            this.btnBrisanje.setShortcut("delete");
            this.jSeparator = new JSeparator();
            this.toolbar.add(this.jSeparator);
            this.jSeparator.setOrientation(1);
            this.jSeparator.setPreferredSize(new Dimension(8, 75));
            this.btnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnBrisiSve);
            this.btnBrisiSve.setText("Bri\u0161i sve| (Ctrl+Q)");
            this.btnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_delete.png")));
            this.btnBrisiSve.setActionCommand("brisiSve");
            this.btnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.btnBrisiSve.setShortcut("ctrl+q");
            this.btnArhiviranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnArhiviranje);
            this.btnArhiviranje.setText("Arhiviranje |(Ctrl+W)");
            this.btnArhiviranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.btnArhiviranje.setActionCommand("arhiviranje");
            this.btnArhiviranje.addActionListener((ActionListener)((Object)this));
            this.btnArhiviranje.setShortcut("ctrl+w");
            this.btnIzlaz = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnIzlaz);
            this.btnIzlaz.setText("Izlaz bez|arhive (ALT+Q)");
            this.btnIzlaz.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/exit.png")));
            this.btnIzlaz.setActionCommand("izlaz");
            this.btnIzlaz.addActionListener((ActionListener)((Object)this));
            this.btnIzlaz.setShortcut("alt+q");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(740, 668);
            this.setMinimumSize(new Dimension(740, 668));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        this.getSession().putParameter("fakturaU", (Object)this.fakturaUPripremi);
        try {
            em.getTransaction().begin();
            PzButton button = (PzButton)e.getSource();
            String ac = button.getActionCommand();
            if (this.fakturaUPripremi == null && !ac.equals("snimiZaglavlje")) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Niste snimili zaglavlje dokumenta!", "Gre\u0161ka!", 2);
                return;
            }
            if (ac.equals("insert")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("tabela", (Object)this.table);
                this.showDialog(DodavanjeStavke.class);
            }
            if (ac.equals("update")) {
                if (this.table.getSelectedRow() != -1) {
                    this.getSession().putParameter("update", (Object)true);
                    this.getSession().putParameter("tabela", (Object)this.table);
                    this.showDialog(DodavanjeStavke.class);
                }
            } else if (ac.equals("brisanje")) {
                if (this.table.removeSelectedEntity(true, em)) {
                    em.getTransaction().commit();
                    this.table.commitRemove();
                    this.setUkupanIznos();
                    if (this.table.getDataSize() > 0) {
                        this.table.requestFocusInWindow();
                    }
                }
                if (em.getTransaction().isActive()) {
                    em.getTransaction().commit();
                }
            } else if (ac.equals("arhiviranje")) {
                if (this.fakturaUPripremi.getStavkafaktureusls().size() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Nema podataka za arhiviranje!", "Informacija", 1);
                    return;
                }
                if (!PzProdajaUtil.grupeKomitenataArhiva(this, (Faktura)this.fakturaUPripremi)) {
                    return;
                }
                this.showDialog(ArhivaFaktureZaUsluge.class);
            } else if (ac.equals("brisiSve")) {
                if (this.delete(em)) {
                    this.dispose();
                }
            } else if (ac.equals("snimiZaglavlje")) {
                this.saveOrUpdate(em);
                this.table.requestFocusInWindow();
                if (this.table.getDataSize() > 0) {
                    this.table.setRowSelectionInterval(0, 0);
                }
            } else if (ac.equals("izlaz")) {
                this.saveOrUpdate(em);
                this.dispose();
            }
            if (!em.getTransaction().isActive()) return;
            em.getTransaction().commit();
            return;
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            if (!em.getTransaction().isActive()) return;
            em.getTransaction().rollback();
            return;
        }
        finally {
            em.close();
        }
    }

    private boolean delete(EntityManager em) {
        try {
            int rez = JOptionPane.showConfirmDialog((Component)((Object)this), "Da li ste sigurni?");
            if (rez == 0) {
                PzEntityManager.delete(Fakturausluga.class, (Object)this.fakturaUPripremi.getIdDok(), (EntityManager)em);
                return true;
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return false;
    }

    public void setUkupanIznos() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaFaktureSpedicije.this.dfUkupnaVrednost.setVal((Object)PzDialogIzradaFaktureSpedicije.this.fakturaUPripremi.getIznosFaktureSpedicije());
                PzDialogIzradaFaktureSpedicije.this.brDok.setText(Integer.toString(PzDialogIzradaFaktureSpedicije.this.fakturaUPripremi.getStavkafaktureusls().size()));
            }
        });
    }

    private void saveOrUpdate(EntityManager em) throws Exception {
        if (this.fakturaUPripremi == null) {
            this.fakturaUPripremi = new Fakturausluga();
            this.fakturaUPripremi.setTip("FAKTURA_USLUGA");
            this.fakturaUPripremi.setPodTip("FAKTURA_SPEDICIJE");
            this.fakturaUPripremi.setDatum(this.dfDatumIzrade.getVal());
            this.fakturaUPripremi.setDatPrometa(this.dfDatumIzrade.getVal());
            this.fakturaUPripremi.setDatValute(this.dfDatumValute.getVal());
            this.fakturaUPripremi.setKomitent((Komitent)PzEntityManager.find(Komitent.class, (Object)this.tfSifraKomitenta.getVal()));
            this.fakturaUPripremi.setRadnajedinica(this.rj);
            this.fakturaUPripremi.setIznos(new BigDecimal(0));
            this.fakturaUPripremi.setSaPorezom(1);
            PzDokumentManager.getInstance().snimiDokument((PzDokument)this.fakturaUPripremi, true, null, em);
            this.table = new PzTable(this.fakturaUPripremi.getStavkafaktureusls(), Stavkafaktureusl.class);
            this.scPane.setViewportView((Component)this.table);
        } else {
            this.fakturaUPripremi.setDatum(this.dfDatumIzrade.getVal());
            this.fakturaUPripremi.setDatValute(this.dfDatumValute.getVal());
            this.fakturaUPripremi.setDatPrometa(this.dfDatumIzrade.getVal());
            this.fakturaUPripremi.setKomitent((Komitent)PzEntityManager.find(Komitent.class, (Object)this.tfSifraKomitenta.getVal(), (EntityManager)em));
            this.fakturaUPripremi.setIznos(PzMathUtility.roundToBigDecimal((double)this.dfUkupnaVrednost.getVal()));
            PzEntityManager.update((Object)this.fakturaUPripremi, (EntityManager)em);
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Date date1 = this.dfDatumIzrade.getVal();
            int val = this.nfValuta.getIntVal();
            this.dfDatumValute.setVal((Object)PzDateUtility.add((Date)date1, (int)val));
        }
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                Date datIzrade = PzDialogIzradaFaktureSpedicije.this.dfDatumIzrade.getVal();
                Date datValute = PzDialogIzradaFaktureSpedicije.this.dfDatumValute.getVal();
                int razlika = PzDateUtility.subtract((Date)datValute, (Date)datIzrade);
                PzDialogIzradaFaktureSpedicije.this.nfValuta.setVal((Object)razlika);
                return true;
            }
        };
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfSifraKomitenta.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.tfNazivKomitenta.setVal((Object)((Komitent)entity).getNaziv());
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        List stavke = this.table.getAllEntities();
        super.thisWindowClosing(evt);
        System.out.println(stavke.size());
        try {
            if (this.fakturaUPripremi != null) {
                this.fakturaUPripremi.setDatum(this.dfDatumIzrade.getVal());
                this.fakturaUPripremi.setDatValute(this.dfDatumValute.getVal());
                this.fakturaUPripremi.setDatPrometa(this.dfDatumIzrade.getVal());
                this.fakturaUPripremi.setKomitent((Komitent)PzEntityManager.find(Komitent.class, (Object)this.tfSifraKomitenta.getVal()));
                this.fakturaUPripremi.setIznos(PzMathUtility.roundToBigDecimal((double)this.dfUkupnaVrednost.getVal()));
                PzEntityManager.update((Object)this.fakturaUPripremi);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzradaFaktureSpedicije(Boolean.FALSE);
    }

    public PzDialogIzradaFaktureSpedicije(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0))});
        if (this.rj != null) {
            this.getFaktura();
            this.initGUI();
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(ProdajaGradientUtil.FAKTURA_USLUGA_GRADIENT);
            this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.FAKTURA_USLUGA_GRADIENT);
            this.postInit();
            this.setFirstComponentInFocus((Component)this.dfDatumIzrade);
            this.setTitle("Faktura \u0161pedicije za radnu jedinicu " + this.rj.getPunNaziv());
            this.setVisible(false);
            return true;
        }
        this.setVisible(false);
        return false;
    }
}

