/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.avansniRacun;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UzmiDokument;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class BrisanjeAvansnogRacuna
extends PzDialog {
    private PzDoubleField dfDug;
    private JLabel lblDug;
    private PzDoubleField dfUplate;
    private PzDoubleField dfIznosFakture;
    private PzTextField tfOznakaFakture;
    private PzNumericOnlyTextField nfSifraKupca;
    private JLabel lblUpate;
    private JLabel lblIznosFakture;
    private JLabel lblOznakaFakture;
    private JLabel lblSifraKupca;
    private JSeparator jSeparator;
    private PzFieldIndikator indOznakaFakture;
    private PzFieldIndikator indSifraKupca;
    private PzTextField tfKomitentText;
    private PzPanel plLabele;
    private PzButton btnPotvrdi;
    private Faktura faktura;
    private Komitent komitent;

    public BrisanjeAvansnogRacuna(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Brisanje avansnog ra\u010duna");
            this.plLabele = new PzPanel();
            this.plLabele.setPaintGradient(true);
            this.plLabele.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
            GridBagLayout plLabeleLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plLabele, "Center");
            plLabeleLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            plLabeleLayout.rowHeights = new int[]{10, 25, 25, 17, 25, 25, 25, 35, 10};
            plLabeleLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            plLabeleLayout.columnWidths = new int[]{155, 102, 7, 101};
            this.plLabele.setLayout((LayoutManager)plLabeleLayout);
            this.plLabele.setSize(0, 0);
            this.plLabele.setPreferredSize(new Dimension(582, 244));
            this.lblSifraKupca = new JLabel();
            this.plLabele.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.lblOznakaFakture = new JLabel();
            this.plLabele.add((Component)this.lblOznakaFakture, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblOznakaFakture.setText("Broj avansnog ra\u010duna");
            this.lblIznosFakture = new JLabel();
            this.plLabele.add((Component)this.lblIznosFakture, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblIznosFakture.setText("Iznos avansnog ra\u010duna");
            this.lblIznosFakture.setEnabled(false);
            this.lblUpate = new JLabel();
            this.plLabele.add((Component)this.lblUpate, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblUpate.setText("Uplate");
            this.lblUpate.setEnabled(false);
            this.nfSifraKupca = new PzNumericOnlyTextField();
            this.plLabele.add((Component)this.nfSifraKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.nfSifraKupca.setFont(new Font("Tahoma", 0, 14));
            this.nfSifraKupca.setPreferredSize(new Dimension(75, 24));
            this.nfSifraKupca.setEnabled(true);
            this.nfSifraKupca.requestFocusInWindow();
            this.nfSifraKupca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfOznakaFakture = new PzTextField();
            this.plLabele.add((Component)this.tfOznakaFakture, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfOznakaFakture.setFont(new Font("Tahoma", 0, 14));
            this.tfOznakaFakture.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (BrisanjeAvansnogRacuna.this.tfOznakaFakture.getVal().equals("")) {
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    return true;
                }
            });
            this.tfOznakaFakture.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    BrisanjeAvansnogRacuna.this.keyRel(evt);
                }
            });
            this.dfIznosFakture = new PzDoubleField();
            this.plLabele.add((Component)this.dfIznosFakture, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfIznosFakture.setFont(new Font("Tahoma", 0, 14));
            this.dfIznosFakture.setEnabled(false);
            this.dfIznosFakture.setFocusable(false);
            this.dfUplate = new PzDoubleField();
            this.plLabele.add((Component)this.dfUplate, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfUplate.setFont(new Font("Tahoma", 0, 14));
            this.dfUplate.setEnabled(false);
            this.dfUplate.setFocusable(false);
            this.lblDug = new JLabel();
            this.plLabele.add((Component)this.lblDug, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDug.setText("DUG");
            this.lblDug.setEnabled(false);
            this.dfDug = new PzDoubleField();
            this.plLabele.add((Component)this.dfDug, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDug.setFont(new Font("Tahoma", 0, 14));
            this.dfDug.setEnabled(false);
            this.dfDug.setFocusable(false);
            this.tfKomitentText = new PzTextField();
            this.plLabele.add((Component)this.tfKomitentText, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 2, 2), 0, 0));
            this.tfKomitentText.setFont(new Font("Tahoma", 0, 14));
            this.tfKomitentText.setEditable(false);
            this.tfKomitentText.setFocusable(false);
            this.indSifraKupca = new PzFieldIndikator();
            this.plLabele.add((Component)this.indSifraKupca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.indOznakaFakture = new PzFieldIndikator();
            this.plLabele.add((Component)this.indOznakaFakture, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indOznakaFakture.setState(PzFieldIndikator.STATE_INVALID);
            System.out.println("OznakaFakture: " + this.tfOznakaFakture.getState());
            this.jSeparator = new JSeparator();
            this.plLabele.add((Component)this.jSeparator, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.plLabele.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.setBounds(94, 9, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(117, 31));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.nfSifraKupca.setStateIndikator(this.indSifraKupca);
            this.tfOznakaFakture.setStateIndikator(this.indOznakaFakture);
            this.pack();
            this.setSize(580, 240);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("OznakaFakture: " + this.tfOznakaFakture.getState());
        if (!this.plLabele.validateForm(true)) {
            return;
        }
        try {
            int rez;
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            if (actionCommand.equals("potvrdi") && (rez = PzSwingUtility.daNeDijalog((Component)this.jSeparator, (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false)) == 0) {
                PzDokumentManager.getInstance().deleteDokument((PzDokument)this.faktura, null);
                this.nfSifraKupca.requestFocus();
                this.nfSifraKupca.setVal((Object)"");
                this.tfKomitentText.setVal((Object)"");
                this.setEnabledComponents(false);
                this.tfOznakaFakture.setVal((Object)"");
                this.setDefaultDfValue();
                this.indOznakaFakture.setState(0);
                this.indSifraKupca.setState(0);
            }
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    private void setEnabledComponents(boolean arg) {
        this.dfIznosFakture.setEnabled(arg);
        this.lblIznosFakture.setEnabled(arg);
        this.dfUplate.setEnabled(arg);
        this.lblUpate.setEnabled(arg);
        this.dfDug.setEnabled(arg);
        this.lblDug.setEnabled(arg);
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.faktura = null;
            this.indOznakaFakture.setState(PzFieldIndikator.STATE_INVALID);
            if (this.tfOznakaFakture.getVal().equals("")) {
                this.getSession().putParameter("tipDokumenta", (Object)"AVANSNI_RACUN");
                this.getSession().putParameter("komitent", (Object)this.komitent);
                this.showDialog(UzmiDokument.class);
                if (this.faktura == null) {
                    JOptionPane.showMessageDialog(this.jSeparator, "Nije odabran nijedan avansni ra\u010dun izabranog komitenta!", "Informacija ", 1);
                    this.nfSifraKupca.requestFocusInWindow();
                    return;
                }
            } else {
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = em.createQuery("SELECT f FROM Faktura f where f.tip=:tip and f.arhiviran = 1 and f.proknjizen = 0 and f.komitent=:komitent  and f.oznDokumenta=:ozn");
                q.setParameter("tip", (Object)"AVANSNI_RACUN");
                q.setParameter("komitent", (Object)this.komitent);
                q.setParameter("ozn", (Object)this.tfOznakaFakture.getVal());
                Vector data = (Vector)q.getResultList();
                if (data.size() == 1) {
                    this.faktura = (Faktura)q.getSingleResult();
                    this.refreshField(this.faktura);
                } else {
                    JOptionPane.showMessageDialog(this.jSeparator, "Nijedna faktura izabranog komitenta sa unetom oznakom ne zadovaljava neophodne uslove pretrage!", "Informacija ", 1);
                    this.faktura = null;
                    return;
                }
            }
            this.indOznakaFakture.setState(PzFieldIndikator.STATE_VALID);
        }
    }

    public void refreshField(Faktura f) {
        this.faktura = f;
        if (f == null) {
            JOptionPane.showMessageDialog(this.jSeparator, "Nije odabran nijedan avansni ra\u010dun izabranog komitenta!", "Informacija ", 1);
            this.nfSifraKupca.requestFocusInWindow();
            return;
        }
        this.tfOznakaFakture.setVal((Object)f.getOznDokumenta());
        this.lblIznosFakture.setEnabled(true);
        this.dfIznosFakture.setEnabled(true);
        this.dfIznosFakture.setVal((Object)f.getIznos());
        this.lblDug.setEnabled(true);
        this.dfDug.setEnabled(true);
        this.dfDug.setVal((Object)this.faktura.getIznos().subtract(this.faktura.getUplata()));
        this.lblUpate.setEnabled(true);
        this.dfUplate.setEnabled(true);
        this.dfUplate.setVal((Object)this.faktura.getUplata());
        this.plLabele.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.faktura = null;
            this.indOznakaFakture.setState(PzFieldIndikator.STATE_INVALID);
            this.nfSifraKupca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.tfKomitentText.setVal((Object)((Komitent)entity).getNaziv());
            this.tfOznakaFakture.setText("");
            this.setEnabledComponents(false);
            this.setDefaultDfValue();
        }
    }

    public void setDefaultDfValue() {
        this.dfIznosFakture.setVal((Object)0.0);
        this.dfUplate.setVal((Object)0.0);
        this.dfDug.setVal((Object)0.0);
    }

    public static Object getGUIBuilderInstance() {
        return new BrisanjeAvansnogRacuna(Boolean.FALSE);
    }

    public BrisanjeAvansnogRacuna(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.plLabele.setPaintGradient(true);
        this.plLabele.setGradient(ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        return true;
    }
}

