/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.dnevniFiskalniIzvestaj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.FiskalniIzvestaj;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.gui.PzDialogRegistrovanjeIzvestaja;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UzmiDokument;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;

public class IspravkaIzvestaja
extends PzDialog {
    private PzPanelHeader phIzborDFIzvestaja;
    private JLabel lblBrojIzvestaja;
    private PzTextField tfBrojIzvestaja;
    private PzPanel pnlGlavni;
    private PzPanel pnlField;
    private static Radnajedinica radnaJedinica;
    public static FiskalniIzvestaj izvestaj;

    static {
        izvestaj = null;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                IspravkaIzvestaja inst = new IspravkaIzvestaja(frame);
                inst.setVisible(true);
            }
        });
    }

    public IspravkaIzvestaja(JFrame frame) {
        super(frame);
        this.initGUI();
        this.paintPanel();
    }

    public IspravkaIzvestaja(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            BorderLayout pnlGlavniLayout1 = new BorderLayout();
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            new BorderLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.phIzborDFIzvestaja = new PzPanelHeader();
            this.pnlGlavni.add((Component)this.phIzborDFIzvestaja);
            this.phIzborDFIzvestaja.setTitle("Ispravka dnevnog fiskalnog izve\u0161taja");
            this.phIzborDFIzvestaja.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/column_chart_edit.png")));
            this.phIzborDFIzvestaja.setOpaque(false);
            this.phIzborDFIzvestaja.setPreferredSize(new Dimension(482, 91));
            this.pnlField = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlField, (Object)"South");
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{32, 25, 20};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{178, 100, 20};
            this.pnlField.setLayout((LayoutManager)plGlavniLayout);
            this.pnlField.setOpaque(false);
            this.pnlField.setPreferredSize(new Dimension(482, 96));
            this.lblBrojIzvestaja = new JLabel();
            this.pnlField.add((Component)this.lblBrojIzvestaja, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 7), 0, 0));
            this.lblBrojIzvestaja.setText("Broj izve\u0161taja");
            this.tfBrojIzvestaja = new PzTextField();
            this.pnlField.add((Component)this.tfBrojIzvestaja, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBrojIzvestaja.setFont(new Font("Tahoma", 0, 14));
            this.tfBrojIzvestaja.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    IspravkaIzvestaja.this.keyRel(evt);
                }
            });
            this.tfBrojIzvestaja.setPreferredSize(new Dimension(117, 24));
            this.pack();
            this.setSize(465, 210);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (this.tfBrojIzvestaja.getVal() == "0") {
                this.getSession().putParameter("tipDokumenta", (Object)"FISKALNI_IZVESTAJ");
                this.getSession().putParameter("radnaJedinica", (Object)radnaJedinica);
                this.showDialog(UzmiDokument.class);
            } else {
                this.getIzvestaj();
            }
            if (izvestaj != null) {
                this.dispose();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void getIzvestaj() {
        try {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT f FROM FiskalniIzvestaj f where f.oznDokumenta=:broj and f.radnajedinica=:rj and f.arhiviran = 1 and f.proknjizen = 0 ");
            q.setParameter("broj", (Object)this.tfBrojIzvestaja.getVal());
            q.setParameter("rj", (Object)radnaJedinica);
            if (q.getResultList().size() == 0) {
                JOptionPane.showMessageDialog(this.getParent(), "Ne postoji fiskalni izve\u0161taj broj " + this.tfBrojIzvestaja.getVal(), "Gre\u0161ka", 0);
                return;
            }
            izvestaj = (FiskalniIzvestaj)q.getSingleResult();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static void setIzvestaj(FiskalniIzvestaj fiskalniIzvestaj) {
        izvestaj = fiskalniIzvestaj;
    }

    public static FiskalniIzvestaj getFiskalniIzvestaj(Radnajedinica rj, PzDialogRegistrovanjeIzvestaja parent) {
        FiskalniIzvestaj res = null;
        IspravkaIzvestaja.setRJ(rj);
        parent.showDialog(IspravkaIzvestaja.class);
        res = izvestaj;
        izvestaj = null;
        return res;
    }

    public static void setRJ(Radnajedinica radnajedinica) {
        radnaJedinica = radnajedinica;
    }

    public static Object getGUIBuilderInstance() {
        return new IspravkaIzvestaja(Boolean.FALSE);
    }

    public IspravkaIzvestaja(Boolean initGUI) {
    }
}

