/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureUsluga;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Sfutaksa;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.StavkafaktureuslPK;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class DodavanjeDefinicije
extends PzDialog {
    private static final String SA_POREZOM = "Sa porezom";
    private static final String BEZ_POREZA = "Bez poreza";
    private static final String SA_PRAVOM_NA_DOBITAK = "Sa pravom na dobitak";
    private static final String BEZ_PRAVA_NA_DOBITAK = "Bez prava na dobitak";
    private static final long serialVersionUID = 5383600479442179677L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader header;
    private PzPanel pnlCenter;
    private PzCheckbox cbDevizniIznos;
    private JComboBox cbSaBezPoreza;
    private JComboBox cbSaBezPravaNaOdbitak;
    private JLabel lblifraKupca;
    private JLabel lblIznosBezPoreza;
    private JLabel lblTarifnaGrupa;
    private JLabel lblIznosSaPorezom;
    private PzTextField txtSfrKomitenta;
    private PzTextField txtNazivKomitenta;
    private PzDoubleField dblIznosBezPoreza;
    private PzTextField txtOznTarGr;
    private PzDoubleField dblProcenat;
    private PzDoubleField dblIznosSaPorezom;
    private JLabel lblPercent;
    private Boolean izmena;
    private PzTable table;
    private Fakturausluga fu;
    private Komitent komitent;
    private Tarifnagrupa tarGr;
    private PzFieldIndikator indKupac;
    private PzFieldIndikator indTarGr;
    private Komitent komitentStart;

    public DodavanjeDefinicije() {
        this.initGUI();
    }

    public DodavanjeDefinicije(PzDialog parent) {
        super(parent);
        this.izmena = (Boolean)this.getSession().getParameter("izmena");
        this.table = (PzTable)this.getSession().getParameter("table_fakture");
        this.fu = (Fakturausluga)this.table.getSelectedEntity();
        this.initGUI();
        if (this.izmena.booleanValue()) {
            this.updateGUI();
            this.setTitle("Izmena definicije");
        }
    }

    private void updateGUI() {
        this.txtSfrKomitenta.setVal((Object)this.fu.getKomitent().getSfrKomitent());
        this.txtNazivKomitenta.setVal((Object)this.fu.getKomitent().getNaziv());
        this.dblIznosBezPoreza.setVal((Object)this.fu.getVrednostUsluga().doubleValue());
        this.dblIznosSaPorezom.setVal((Object)this.fu.getIznos().doubleValue());
        this.cbDevizniIznos.setSelected("DEV".equals(this.fu.getPodTip()));
        this.komitent = this.fu.getKomitent();
        this.komitentStart = this.fu.getKomitent();
        if (this.fu.getSaPorezom() == 1) {
            this.cbSaBezPoreza.setSelectedItem(SA_POREZOM);
            this.txtOznTarGr.setVal((Object)((Stavkafaktureusl)this.fu.getStavkafaktureusls().get(0)).getTaksa("PDV").getOznTarGr());
            try {
                this.tarGr = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, (Object)((Stavkafaktureusl)this.fu.getStavkafaktureusls().get(0)).getTaksa("PDV").getOznTarGr());
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            this.dblProcenat.setVal((Object)this.tarGr.getStopa());
        } else {
            this.cbSaBezPoreza.setSelectedItem(BEZ_POREZA);
            if (this.fu.getSaPravomNaOdbitak() == 1) {
                this.cbSaBezPravaNaOdbitak.setSelectedItem(SA_PRAVOM_NA_DOBITAK);
            } else {
                this.cbSaBezPravaNaOdbitak.setSelectedItem(BEZ_PRAVA_NA_DOBITAK);
            }
        }
        this.pnlCenter.updateAllFieldsState();
    }

    private void initGUI() {
        this.setTitle("Dodavanje definicije");
        this.setBounds(0, 0, 718, 353);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        this.contentPanel.add((Component)buttonPane, (Object)"South");
        buttonPane.setLayout(new FlowLayout(1));
        JButton okButton = new JButton("Potvrdi");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DodavanjeDefinicije.this.okButtonactionPerformed(arg0);
            }
        });
        okButton.setIcon(new ImageIcon(DodavanjeDefinicije.class.getResource("/rs/pezar/prodaja/resource/img/check.png")));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.header = new PzPanelHeader();
        this.header.setOpaque(false);
        this.header.setText("Unesite parametre definicije za generisanje fakture");
        this.header.setTitle("Definicija za grupno fakturisanje");
        this.header.setIcon(new ImageIcon(DodavanjeDefinicije.class.getResource("/rs/pezar/prodaja/resource/img/grupno_fakturisanje.png")));
        this.contentPanel.add((Component)this.header, (Object)"North");
        this.pnlCenter = new PzPanel();
        GridBagLayout gbl_pnlCenter = new GridBagLayout();
        this.pnlCenter.setOpaque(false);
        this.pnlCenter.setBorder((Border)new EmptyBorder(10, 10, 10, 10));
        this.contentPanel.add((Component)this.pnlCenter, (Object)"Center");
        int[] nArray = new int[6];
        nArray[1] = 101;
        nArray[3] = 125;
        nArray[4] = 260;
        gbl_pnlCenter.columnWidths = nArray;
        gbl_pnlCenter.rowHeights = new int[5];
        gbl_pnlCenter.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlCenter.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlCenter.setLayout((LayoutManager)gbl_pnlCenter);
        this.lblifraKupca = new JLabel("\u0160ifra kupca:");
        GridBagConstraints gbc_lblifraKupca = new GridBagConstraints();
        gbc_lblifraKupca.anchor = 13;
        gbc_lblifraKupca.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraKupca.gridx = 0;
        gbc_lblifraKupca.gridy = 0;
        this.pnlCenter.add((Component)this.lblifraKupca, (Object)gbc_lblifraKupca);
        this.txtSfrKomitenta = new PzTextField();
        this.txtSfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        GridBagConstraints gbc_txtSfrKomitenta = new GridBagConstraints();
        gbc_txtSfrKomitenta.insets = new Insets(0, 0, 5, 5);
        gbc_txtSfrKomitenta.fill = 2;
        gbc_txtSfrKomitenta.gridx = 1;
        gbc_txtSfrKomitenta.gridy = 0;
        this.pnlCenter.add((Component)this.txtSfrKomitenta, (Object)gbc_txtSfrKomitenta);
        this.indKupac = new PzFieldIndikator();
        GridBagConstraints gbc_indKupac = new GridBagConstraints();
        gbc_indKupac.insets = new Insets(0, 0, 5, 5);
        gbc_indKupac.anchor = 13;
        gbc_indKupac.gridx = 2;
        gbc_indKupac.gridy = 0;
        this.pnlCenter.add((Component)this.indKupac, (Object)gbc_indKupac);
        this.txtNazivKomitenta = new PzTextField();
        this.txtNazivKomitenta.setFocusable(false);
        this.txtNazivKomitenta.setEditable(false);
        GridBagConstraints gbc_txtNazivKomitenta = new GridBagConstraints();
        gbc_txtNazivKomitenta.gridwidth = 2;
        gbc_txtNazivKomitenta.insets = new Insets(0, 0, 5, 0);
        gbc_txtNazivKomitenta.fill = 2;
        gbc_txtNazivKomitenta.gridx = 3;
        gbc_txtNazivKomitenta.gridy = 0;
        this.pnlCenter.add((Component)this.txtNazivKomitenta, (Object)new GridBagConstraints(3, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblIznosBezPoreza = new JLabel("Iznos bez poreza:");
        GridBagConstraints gbc_lblIznosBezPoreza = new GridBagConstraints();
        gbc_lblIznosBezPoreza.anchor = 13;
        gbc_lblIznosBezPoreza.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosBezPoreza.gridx = 0;
        gbc_lblIznosBezPoreza.gridy = 1;
        this.pnlCenter.add((Component)this.lblIznosBezPoreza, (Object)gbc_lblIznosBezPoreza);
        this.dblIznosBezPoreza = new PzDoubleField();
        this.dblIznosBezPoreza.setVerifyInput(true);
        GridBagConstraints gbc_dblIznosBezPoreza = new GridBagConstraints();
        gbc_dblIznosBezPoreza.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosBezPoreza.fill = 2;
        gbc_dblIznosBezPoreza.gridx = 1;
        gbc_dblIznosBezPoreza.gridy = 1;
        this.pnlCenter.add((Component)this.dblIznosBezPoreza, (Object)gbc_dblIznosBezPoreza);
        this.lblTarifnaGrupa = new JLabel("Tarifna grupa:");
        GridBagConstraints gbc_lblTarifnaGrupa = new GridBagConstraints();
        gbc_lblTarifnaGrupa.anchor = 13;
        gbc_lblTarifnaGrupa.insets = new Insets(0, 0, 5, 5);
        gbc_lblTarifnaGrupa.gridx = 0;
        gbc_lblTarifnaGrupa.gridy = 2;
        this.pnlCenter.add((Component)this.lblTarifnaGrupa, (Object)gbc_lblTarifnaGrupa);
        this.txtOznTarGr = new PzTextField();
        this.txtOznTarGr.setToUpperCase(true);
        this.txtOznTarGr.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, null);
        GridBagConstraints gbc_txtOznTarGr = new GridBagConstraints();
        gbc_txtOznTarGr.insets = new Insets(0, 0, 5, 5);
        gbc_txtOznTarGr.fill = 2;
        gbc_txtOznTarGr.gridx = 1;
        gbc_txtOznTarGr.gridy = 2;
        this.pnlCenter.add((Component)this.txtOznTarGr, (Object)gbc_txtOznTarGr);
        this.indTarGr = new PzFieldIndikator();
        GridBagConstraints gbc_indTarGr = new GridBagConstraints();
        gbc_indTarGr.insets = new Insets(0, 0, 5, 5);
        gbc_indTarGr.anchor = 13;
        gbc_indTarGr.gridx = 2;
        gbc_indTarGr.gridy = 2;
        this.pnlCenter.add((Component)this.indTarGr, (Object)gbc_indTarGr);
        this.dblProcenat = new PzDoubleField();
        this.dblProcenat.setFocusable(false);
        this.dblProcenat.setEditable(false);
        GridBagConstraints gbc_dblProcenat = new GridBagConstraints();
        gbc_dblProcenat.fill = 2;
        gbc_dblProcenat.insets = new Insets(0, 0, 5, 5);
        gbc_dblProcenat.gridx = 3;
        gbc_dblProcenat.gridy = 2;
        this.pnlCenter.add((Component)this.dblProcenat, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.lblPercent = new JLabel("%");
        GridBagConstraints gbc_lblPercent = new GridBagConstraints();
        gbc_lblPercent.anchor = 17;
        gbc_lblPercent.insets = new Insets(0, 0, 5, 0);
        gbc_lblPercent.gridx = 4;
        gbc_lblPercent.gridy = 2;
        this.pnlCenter.add((Component)this.lblPercent, (Object)gbc_lblPercent);
        this.lblIznosSaPorezom = new JLabel("Iznos sa porezom:");
        GridBagConstraints gbc_lblIznosSaPorezom = new GridBagConstraints();
        gbc_lblIznosSaPorezom.anchor = 13;
        gbc_lblIznosSaPorezom.insets = new Insets(0, 0, 0, 5);
        gbc_lblIznosSaPorezom.gridx = 0;
        gbc_lblIznosSaPorezom.gridy = 3;
        this.pnlCenter.add((Component)this.lblIznosSaPorezom, (Object)gbc_lblIznosSaPorezom);
        this.dblIznosSaPorezom = new PzDoubleField();
        this.dblIznosSaPorezom.setVerifyInput(true);
        GridBagConstraints gbc_dblIznosSaPorezom = new GridBagConstraints();
        gbc_dblIznosSaPorezom.insets = new Insets(0, 0, 0, 5);
        gbc_dblIznosSaPorezom.fill = 2;
        gbc_dblIznosSaPorezom.gridx = 1;
        gbc_dblIznosSaPorezom.gridy = 3;
        this.pnlCenter.add((Component)this.dblIznosSaPorezom, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.cbDevizniIznos = new PzCheckbox();
        this.pnlCenter.add((Component)this.cbDevizniIznos, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, -4, 0, 5), 0, 0));
        this.cbDevizniIznos.setName("cbDevizniIznos");
        this.cbDevizniIznos.setOpaque(false);
        this.cbSaBezPoreza = new PzComboBox();
        this.pnlCenter.add((Component)this.cbSaBezPoreza, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cbSaBezPoreza.addItem(SA_POREZOM);
        this.cbSaBezPoreza.addItem(BEZ_POREZA);
        this.cbSaBezPoreza.setActionCommand("sa_bez_poreza");
        this.cbSaBezPoreza.setSelectedIndex(0);
        this.cbSaBezPoreza.addActionListener((ActionListener)((Object)this));
        this.cbSaBezPravaNaOdbitak = new PzComboBox();
        this.pnlCenter.add((Component)this.cbSaBezPravaNaOdbitak, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.cbSaBezPravaNaOdbitak.addItem(SA_PRAVOM_NA_DOBITAK);
        this.cbSaBezPravaNaOdbitak.addItem(BEZ_PRAVA_NA_DOBITAK);
        this.cbSaBezPravaNaOdbitak.setActionCommand("sa_bez_prava_na_odbitak");
        this.cbSaBezPravaNaOdbitak.setSelectedIndex(0);
        this.cbSaBezPravaNaOdbitak.addActionListener((ActionListener)((Object)this));
        this.cbSaBezPravaNaOdbitak.setEnabled(false);
        this.txtSfrKomitenta.setStateIndikator(this.indKupac);
        this.txtOznTarGr.setStateIndikator(this.indTarGr);
        this.pack();
        this.setResizable(true);
        this.setRestorable(false);
        this.setSize(629, 315);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.txtSfrKomitenta.setVal((Object)this.komitent.getSfrKomitent());
            this.txtNazivKomitenta.setVal((Object)this.komitent.getNaziv());
        } else if (entity instanceof Tarifnagrupa) {
            this.tarGr = (Tarifnagrupa)entity;
            this.txtOznTarGr.setVal((Object)this.tarGr.getOznTarGr());
            this.dblProcenat.setVal((Object)this.tarGr.getStopa());
            this.dblIznosSaPorezom.setVal((Object)(this.dblIznosBezPoreza.getVal() * (1.0 + this.tarGr.getStopa() / 100.0)));
        }
    }

    protected void okButtonactionPerformed(ActionEvent arg0) {
        int rez;
        if (!this.pnlCenter.validateForm(true)) {
            return;
        }
        if (this.postojiKomitent() && (this.komitentStart == null || !this.komitent.getSfrKomitent().equals(this.komitentStart.getSfrKomitent())) && (rez = PzSwingUtility.daNeDijalog((Component)this.pnlCenter, (Object)"Ve\u0107 postoji definicija za izabranog komitenta. Da li ste sigurni do \u017eelite da dodate jo\u0161 jednu?", (String)"Pitanje", null, (boolean)false)) != 0) {
            return;
        }
        if (this.cbSaBezPoreza.getSelectedItem().equals(SA_POREZOM) && this.komitent.getDomaciKomitent() == 0) {
            rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Inostrani komitent! Obra\u010dun PDV-a?", "", 0);
            if (rez != 0) {
                return;
            }
        } else if (this.dblIznosBezPoreza.getVal() <= 0.0) {
            JOptionPane.showMessageDialog(this.getParent(), "Iznos bez poreza mora biti ve\u0107i od 0!", "Informacija", 1);
            return;
        }
        if (this.cbSaBezPoreza.getSelectedItem().equals(SA_POREZOM)) {
            this.dblIznosSaPorezom.setVal((Object)(this.dblIznosBezPoreza.getVal() * (1.0 + this.tarGr.getStopa() / 100.0)));
        } else {
            this.dblIznosSaPorezom.setVal((Object)this.dblIznosBezPoreza.getVal());
        }
        if (!this.izmena.booleanValue()) {
            this.fu = new Fakturausluga();
            this.fu.setTip("DEFINICIJA");
        }
        this.fu.setPodTip(this.cbDevizniIznos.isSelected() ? "DEV" : "DIN");
        this.fu.setKomitent(this.komitent);
        this.fu.setUserKraj(PzExtensionLoader.getLoggedUser());
        this.fu.setUserPoc(PzExtensionLoader.getLoggedUser());
        this.fu.setDatum(PzDateUtility.getCurrentDate());
        this.fu.setVrednostUsluga(this.dblIznosBezPoreza.getBigDecimal());
        this.fu.setIznos(this.dblIznosSaPorezom.getBigDecimal());
        if (this.cbSaBezPoreza.getSelectedItem().equals(SA_POREZOM)) {
            this.fu.setSaPorezom(1);
        } else {
            this.fu.setSaPorezom(0);
            if (this.cbSaBezPravaNaOdbitak.getSelectedIndex() == 0) {
                this.fu.setSaPravomNaOdbitak(1);
            } else {
                this.fu.setSaPravomNaOdbitak(0);
            }
        }
        Stavkafaktureusl stavka = null;
        if (this.izmena.booleanValue()) {
            stavka = this.fu.getStavkafaktureusls().size() > 0 ? (Stavkafaktureusl)this.fu.getStavkafaktureusls().get(0) : null;
        }
        this.fu.setStavkafaktureusls(null);
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.fu.setStavkafaktureusls(new Vector());
                em.getTransaction().begin();
                if (this.izmena.booleanValue()) {
                    em.remove(em.find(Stavkafaktureusl.class, (Object)stavka.getId()));
                    em.flush();
                    if (this.cbSaBezPoreza.getSelectedItem().equals(SA_POREZOM) && stavka.getSfutaksas().size() > 0) {
                        ((Sfutaksa)stavka.getSfutaksas().get(0)).getId().setOznTarGr(this.tarGr.getOznTarGr());
                        ((Sfutaksa)stavka.getSfutaksas().get(0)).setStopa(this.tarGr.getStopa());
                    } else if (this.tarGr != null) {
                        stavka.setSfutaksas(new Vector());
                        Sfutaksa sft = new Sfutaksa(stavka, this.tarGr);
                        stavka.getSfutaksas().add(sft);
                        sft.setStavkafaktureusl(stavka);
                    }
                } else {
                    stavka = new Stavkafaktureusl();
                    stavka.setId(new StavkafaktureuslPK(0, 1));
                    if (this.tarGr != null) {
                        stavka.setSfutaksas(new Vector());
                        Sfutaksa sft = new Sfutaksa(stavka, this.tarGr);
                        stavka.getSfutaksas().add(sft);
                        sft.setStavkafaktureusl(stavka);
                    }
                }
                stavka.setCena(this.dblIznosBezPoreza.getVal().doubleValue());
                stavka.setKolicina(1.0);
                stavka.setNaziv("");
                stavka.setFakturausluga(this.fu);
                if (this.izmena.booleanValue()) {
                    this.fu.getStavkafaktureusls().add(stavka);
                    this.table.updateSelectedEntity((PzEntity)this.fu, em);
                } else {
                    this.table.insert((PzEntity)this.fu, em);
                    em.flush();
                    this.fu.getStavkafaktureusls().add(stavka);
                }
                this.fu.adjust();
                em.getTransaction().commit();
                if (this.izmena.booleanValue()) {
                    this.table.commitUpdate();
                } else {
                    this.table.commitInsert();
                }
                this.dispose();
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private boolean postojiKomitent() {
        List list = this.table.getAllEntities();
        boolean found = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !found) {
            Fakturausluga fakturausluga = (Fakturausluga)iterator.next();
            if (!fakturausluga.getKomitent().getSfrKomitent().equals(this.txtSfrKomitenta.getText())) continue;
            found = true;
        }
        return found;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("sa_bez_poreza")) {
            if (this.cbSaBezPoreza.getSelectedItem().equals(SA_POREZOM)) {
                this.lblTarifnaGrupa.setEnabled(true);
                this.lblIznosSaPorezom.setEnabled(true);
                this.txtOznTarGr.setEnabled(true);
                this.dblIznosSaPorezom.setEnabled(true);
                this.dblProcenat.setEnabled(true);
                this.indTarGr.setEnabled(true);
                this.cbSaBezPravaNaOdbitak.setEnabled(false);
                this.txtOznTarGr.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, "Uneta tarifna grupa nije na\u0111ena!");
            } else if (this.cbSaBezPoreza.getSelectedItem().equals(BEZ_POREZA)) {
                this.lblTarifnaGrupa.setEnabled(false);
                this.lblIznosSaPorezom.setEnabled(false);
                this.txtOznTarGr.setEnabled(false);
                this.txtOznTarGr.setVal((Object)"");
                this.dblIznosSaPorezom.setEnabled(false);
                this.dblIznosSaPorezom.setVal((Object)0);
                this.dblProcenat.setVal((Object)0);
                this.dblProcenat.setEnabled(false);
                this.indTarGr.setEnabled(false);
                this.cbSaBezPravaNaOdbitak.setEnabled(true);
            }
        }
    }
}

